/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.pushtemplates;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.media.AudioAttributes;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.service.notification.StatusBarNotification;
import android.text.TextUtils;
import android.text.format.DateUtils;
import android.widget.RemoteViews;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import com.clevertap.android.pushtemplates.PTConstants;
import com.clevertap.android.pushtemplates.PTLog;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.bitmap.BitmapDownloadRequest;
import com.clevertap.android.sdk.bitmap.HttpBitmapLoader;
import com.clevertap.android.sdk.network.DownloadedBitmap;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.Task;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.json.JSONArray;
import org.json.JSONObject;

public class Utils {
    public static Bitmap getNotificationBitmap(String icoPath, boolean fallbackToAppIcon, Context context) throws NullPointerException {
        if (icoPath == null || icoPath.equals("")) {
            return fallbackToAppIcon ? Utils.getAppIcon(context) : null;
        }
        Bitmap ic = Utils.getBitmapFromURL(icoPath, context);
        return ic != null ? ic : (fallbackToAppIcon ? Utils.getAppIcon(context) : null);
    }

    private static Bitmap getAppIcon(Context context) throws NullPointerException {
        try {
            Drawable logo = context.getPackageManager().getApplicationLogo(context.getApplicationInfo());
            if (logo == null) {
                throw new Exception("Logo is null");
            }
            return Utils.drawableToBitmap(logo);
        }
        catch (Exception e) {
            return Utils.drawableToBitmap(context.getPackageManager().getApplicationIcon(context.getApplicationInfo()));
        }
    }

    static Bitmap drawableToBitmap(Drawable drawable2) throws NullPointerException {
        Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    private static Bitmap getBitmapFromURL(String srcUrl, @Nullable Context context) {
        BitmapDownloadRequest request = new BitmapDownloadRequest(srcUrl, false, context, null, -1L, -1);
        DownloadedBitmap db = HttpBitmapLoader.getHttpBitmap((HttpBitmapLoader.HttpBitmapOperation)HttpBitmapLoader.HttpBitmapOperation.DOWNLOAD_ANY_BITMAP, (BitmapDownloadRequest)request);
        if (db.getStatus() == DownloadedBitmap.Status.SUCCESS) {
            return db.getBitmap();
        }
        Logger.v((String)("network call for bitmap download failed with url : " + srcUrl + " http status: " + db.getStatus()));
        return null;
    }

    static String _getManifestStringValueForKey(Bundle manifest, String name) {
        try {
            Object o = manifest.get(name);
            return o != null ? o.toString() : null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    static int getAppIconAsIntId(Context context) {
        ApplicationInfo ai = context.getApplicationInfo();
        return ai.icon;
    }

    static ArrayList<String> getImageListFromExtras(Bundle extras) {
        ArrayList<String> imageList = new ArrayList<String>();
        for (String key : extras.keySet()) {
            if (!key.contains("pt_img")) continue;
            imageList.add(extras.getString(key));
        }
        return imageList;
    }

    static ArrayList<String> getCTAListFromExtras(Bundle extras) {
        ArrayList<String> ctaList = new ArrayList<String>();
        for (String key : extras.keySet()) {
            if (!key.contains("pt_cta")) continue;
            ctaList.add(extras.getString(key));
        }
        return ctaList;
    }

    static ArrayList<String> getDeepLinkListFromExtras(Bundle extras) {
        ArrayList<String> dlList = new ArrayList<String>();
        for (String key : extras.keySet()) {
            if (!key.contains("pt_dl")) continue;
            dlList.add(extras.getString(key));
        }
        return dlList;
    }

    static ArrayList<String> getBigTextFromExtras(Bundle extras) {
        ArrayList<String> btList = new ArrayList<String>();
        for (String key : extras.keySet()) {
            if (!key.contains("pt_bt")) continue;
            btList.add(extras.getString(key));
        }
        return btList;
    }

    static ArrayList<String> getSmallTextFromExtras(Bundle extras) {
        ArrayList<String> stList = new ArrayList<String>();
        for (String key : extras.keySet()) {
            if (!key.contains("pt_st")) continue;
            stList.add(extras.getString(key));
        }
        return stList;
    }

    static ArrayList<String> getPriceFromExtras(Bundle extras) {
        ArrayList<String> stList = new ArrayList<String>();
        for (String key : extras.keySet()) {
            if (!key.contains("pt_price") || key.contains("pt_price_list")) continue;
            stList.add(extras.getString(key));
        }
        return stList;
    }

    public static void loadImageBitmapIntoRemoteView(int imageViewID, Bitmap image, RemoteViews remoteViews) {
        remoteViews.setImageViewBitmap(imageViewID, image);
    }

    public static void loadImageURLIntoRemoteView(int imageViewID, String imageUrl, RemoteViews remoteViews, Context context) {
        long bmpDownloadStartTimeInMillis = System.currentTimeMillis();
        Bitmap image = Utils.getBitmapFromURL(imageUrl, context);
        Utils.setFallback(false);
        if (image != null) {
            remoteViews.setImageViewBitmap(imageViewID, image);
            long bmpDownloadEndTimeInMillis = System.currentTimeMillis();
            long pift = bmpDownloadEndTimeInMillis - bmpDownloadStartTimeInMillis;
            PTLog.verbose("Fetched IMAGE " + imageUrl + " in " + pift + " millis");
        } else {
            PTLog.debug("Image was not perfect. URL:" + imageUrl + " hiding image view");
            Utils.setFallback(true);
        }
    }

    public static void loadImageRidIntoRemoteView(int imageViewID, int resourceID, RemoteViews remoteViews) {
        remoteViews.setImageViewResource(imageViewID, resourceID);
    }

    public static String getTimeStamp(Context context) {
        return DateUtils.formatDateTime((Context)context, (long)System.currentTimeMillis(), (int)1);
    }

    public static String getApplicationName(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        int stringId = applicationInfo.labelRes;
        return stringId == 0 ? applicationInfo.nonLocalizedLabel.toString() : context.getString(stringId);
    }

    static Bundle fromJson(JSONObject s) {
        Bundle bundle = new Bundle();
        Iterator it = s.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            JSONArray arr = s.optJSONArray(key);
            String str = s.optString(key);
            if (arr != null && arr.length() <= 0) {
                bundle.putStringArray(key, new String[0]);
                continue;
            }
            if (arr != null && arr.optString(0) != null) {
                String[] newarr = new String[arr.length()];
                for (int i = 0; i < arr.length(); ++i) {
                    newarr[i] = arr.optString(i);
                }
                bundle.putStringArray(key, newarr);
                continue;
            }
            if (str != null) {
                bundle.putString(key, str);
                continue;
            }
            System.err.println("unable to transform json to bundle " + key);
        }
        return bundle;
    }

    static void cancelNotification(Context ctx, int notifyId) {
        NotificationManager nMgr = (NotificationManager)ctx.getSystemService("notification");
        nMgr.cancel(notifyId);
    }

    static int getTimerThreshold(Bundle extras) {
        String val = "-1";
        for (String key : extras.keySet()) {
            if (!key.contains("pt_timer_threshold")) continue;
            val = extras.getString(key);
        }
        return Integer.parseInt(val != null ? val : "-1");
    }

    static void setPackageNameFromResolveInfoList(Context context, Intent launchIntent) {
        List resolveInfoList = context.getPackageManager().queryIntentActivities(launchIntent, 0);
        String appPackageName = context.getPackageName();
        for (ResolveInfo resolveInfo : resolveInfoList) {
            if (!appPackageName.equals(resolveInfo.activityInfo.packageName)) continue;
            launchIntent.setPackage(appPackageName);
            break;
        }
    }

    static void raiseCleverTapEvent(Context context, CleverTapInstanceConfig config, Bundle extras) {
        CleverTapAPI instance = config != null ? CleverTapAPI.instanceWithConfig((Context)context, (CleverTapInstanceConfig)config) : CleverTapAPI.getDefaultInstance((Context)context);
        HashMap<String, Object> eProps = Utils.getEventPropertiesFromExtras(extras);
        String eName = Utils.getEventNameFromExtras(extras);
        if (eName != null && !eName.isEmpty()) {
            if (instance != null) {
                instance.pushEvent(eName, eProps);
            } else {
                PTLog.debug("CleverTap instance is NULL, not raising the event");
            }
        }
    }

    static void raiseCleverTapEvent(Context context, CleverTapInstanceConfig config, Bundle extras, String key) {
        CleverTapAPI instance = config != null ? CleverTapAPI.instanceWithConfig((Context)context, (CleverTapInstanceConfig)config) : CleverTapAPI.getDefaultInstance((Context)context);
        String value = extras.getString(key);
        HashMap<String, Object> eProps = Utils.getEventPropertiesFromExtras(extras, key, value);
        String eName = Utils.getEventNameFromExtras(extras);
        if (eName != null && !eName.isEmpty()) {
            if (instance != null) {
                instance.pushEvent(eName, eProps);
            } else {
                PTLog.debug("CleverTap instance is NULL, not raising the event");
            }
        }
    }

    static void raiseCleverTapEvent(Context context, CleverTapInstanceConfig config, String evtName, HashMap<String, Object> eProps) {
        CleverTapAPI instance = config != null ? CleverTapAPI.instanceWithConfig((Context)context, (CleverTapInstanceConfig)config) : CleverTapAPI.getDefaultInstance((Context)context);
        if (evtName != null && !evtName.isEmpty()) {
            if (instance != null) {
                instance.pushEvent(evtName, eProps);
            } else {
                PTLog.debug("CleverTap instance is NULL, not raising the event");
            }
        }
    }

    static HashMap<String, Object> convertRatingBundleObjectToHashMap(Bundle b) {
        b.remove("config");
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String s : b.keySet()) {
            if (!s.contains("wzrk_") && !s.equals("pt_id")) continue;
            Object o = b.get(s);
            if (o instanceof Bundle) {
                map.putAll(Utils.convertRatingBundleObjectToHashMap((Bundle)o));
                continue;
            }
            map.put(s, b.get(s));
        }
        return map;
    }

    static String getEventNameFromExtras(Bundle extras) {
        String eName = null;
        for (String key : extras.keySet()) {
            if (!key.contains("pt_event_name")) continue;
            eName = extras.getString(key);
        }
        return eName;
    }

    static HashMap<String, Object> getEventPropertiesFromExtras(Bundle extras, String pkey, String value) {
        HashMap<String, Object> eProps = new HashMap<String, Object>();
        for (String key : extras.keySet()) {
            if (!key.contains("pt_event_property")) continue;
            if (extras.getString(key) != null && !extras.getString(key).isEmpty()) {
                if (key.contains("pt_event_property_")) {
                    String[] eProp = key.split("pt_event_property_");
                    if (extras.getString(key).equalsIgnoreCase(pkey)) {
                        eProps.put(eProp[1], value);
                        continue;
                    }
                    eProps.put(eProp[1], extras.getString(key));
                    continue;
                }
                PTLog.verbose("Property " + key + " does not have the separator");
                continue;
            }
            PTLog.verbose("Property Key is Empty. Skipping Property: " + key);
        }
        return eProps;
    }

    static HashMap<String, Object> getEventPropertiesFromExtras(Bundle extras) {
        HashMap<String, Object> eProps = new HashMap<String, Object>();
        for (String key : extras.keySet()) {
            if (!key.contains("pt_event_property")) continue;
            if (extras.getString(key) != null && !extras.getString(key).isEmpty()) {
                if (key.contains("pt_event_property_")) {
                    String[] eProp = key.split("pt_event_property_");
                    eProps.put(eProp[1], extras.getString(key));
                    continue;
                }
                PTLog.verbose("Property " + key + " does not have the separator");
                continue;
            }
            PTLog.verbose("Property Key is Empty. Skipping Property: " + key);
        }
        return eProps;
    }

    public static int getTimerEnd(Bundle extras) {
        String val = "-1";
        for (String key : extras.keySet()) {
            if (!key.contains("pt_timer_end")) continue;
            val = extras.getString(key);
        }
        if (val.contains("$D_")) {
            String[] temp = val.split("\\$D_");
            val = temp[1];
        }
        long currentts = System.currentTimeMillis();
        int diff = (int)(Long.parseLong(val) - currentts / 1000L);
        if (val.equals("-1")) {
            return Integer.MIN_VALUE;
        }
        return diff;
    }

    @RequiresApi(api=23)
    public static boolean isNotificationInTray(Context context, int notificationId) {
        StatusBarNotification[] notifications;
        NotificationManager mNotificationManager = (NotificationManager)context.getSystemService("notification");
        for (StatusBarNotification notification : notifications = mNotificationManager.getActiveNotifications()) {
            if (notification.getId() != notificationId) continue;
            return true;
        }
        return false;
    }

    @RequiresApi(api=23)
    public static Notification getNotificationById(Context context, int notificationId) {
        StatusBarNotification[] notifications;
        NotificationManager mNotificationManager = (NotificationManager)context.getSystemService("notification");
        for (StatusBarNotification notification : notifications = mNotificationManager.getActiveNotifications()) {
            if (notification.getId() != notificationId) continue;
            return notification.getNotification();
        }
        return null;
    }

    public static ArrayList<Integer> getNotificationIds(Context context) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        if (Build.VERSION.SDK_INT >= 23) {
            StatusBarNotification[] notifications;
            NotificationManager mNotificationManager = (NotificationManager)context.getSystemService("notification");
            for (StatusBarNotification notification : notifications = mNotificationManager.getActiveNotifications()) {
                if (!notification.getPackageName().equalsIgnoreCase(context.getPackageName())) continue;
                ids.add(notification.getId());
            }
        }
        return ids;
    }

    static void raiseNotificationClicked(Context context, Bundle extras, CleverTapInstanceConfig config) {
        CleverTapAPI instance = config != null ? CleverTapAPI.instanceWithConfig((Context)context, (CleverTapInstanceConfig)config) : CleverTapAPI.getDefaultInstance((Context)context);
        if (instance != null) {
            instance.pushNotificationClickedEvent(extras);
        }
    }

    static JSONArray getActionKeys(Bundle extras) {
        JSONArray actions = null;
        String actionsString = extras.getString("wzrk_acts");
        if (actionsString != null) {
            try {
                actions = new JSONArray(actionsString);
            }
            catch (Throwable t) {
                PTLog.debug("error parsing notification actions: " + t.getLocalizedMessage());
            }
        }
        return actions;
    }

    static void showToast(final Context context, final String message, CleverTapInstanceConfig config) {
        if (config != null) {
            Task task = CTExecutorFactory.executors((CleverTapInstanceConfig)config).mainTask();
            task.execute("PushTemplatesUtils#showToast", (Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    if (!TextUtils.isEmpty((CharSequence)message)) {
                        Toast.makeText((Context)context, (CharSequence)message, (int)0).show();
                    }
                    return null;
                }
            });
        }
    }

    static void createSilentNotificationChannel(Context context) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (notificationManager == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 26 && (notificationManager.getNotificationChannel("pt_silent_sound_channel") == null || notificationManager.getNotificationChannel("pt_silent_sound_channel") != null && !Utils.isNotificationChannelEnabled(notificationManager.getNotificationChannel("pt_silent_sound_channel")))) {
            Uri soundUri = Uri.parse((String)("android.resource://" + context.getPackageName() + "/raw/" + "pt_silent_sound"));
            NotificationChannel notificationChannel = new NotificationChannel("pt_silent_sound_channel", PTConstants.PT_SILENT_CHANNEL_NAME, 4);
            if (soundUri != null) {
                notificationChannel.setSound(soundUri, new AudioAttributes.Builder().setUsage(5).build());
            }
            notificationChannel.setDescription("A channel to silently update notifications");
            notificationChannel.setShowBadge(false);
            notificationManager.createNotificationChannel(notificationChannel);
        }
    }

    static void deleteSilentNotificationChannel(Context context) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (notificationManager == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 26 && notificationManager.getNotificationChannel("pt_silent_sound_channel") != null && Utils.isNotificationChannelEnabled(notificationManager.getNotificationChannel("pt_silent_sound_channel"))) {
            notificationManager.deleteNotificationChannel("pt_silent_sound_channel");
        }
    }

    static boolean isNotificationChannelEnabled(NotificationChannel channel) {
        if (Build.VERSION.SDK_INT >= 26 && channel != null) {
            return channel.getImportance() != 0;
        }
        return false;
    }

    public static Bitmap setBitMapColour(Context context, int resourceID, String clr) throws NullPointerException {
        if (clr != null && !clr.isEmpty()) {
            int color = Utils.getColour(clr, "#A6A6A6");
            Drawable mDrawable = Objects.requireNonNull(ContextCompat.getDrawable((Context)context, (int)resourceID)).mutate();
            mDrawable.setColorFilter((ColorFilter)new PorterDuffColorFilter(color, PorterDuff.Mode.SRC_IN));
            return Utils.drawableToBitmap(mDrawable);
        }
        return null;
    }

    public static int getColour(String clr, String default_clr) {
        try {
            return Color.parseColor((String)clr);
        }
        catch (Exception e) {
            PTLog.debug("Can not parse colour value: " + clr + " Switching to default colour: " + default_clr);
            return Color.parseColor((String)default_clr);
        }
    }

    static void setFallback(Boolean val) {
        PTConstants.PT_FALLBACK = val;
    }

    public static boolean getFallback() {
        return PTConstants.PT_FALLBACK;
    }

    public static int getFlipInterval(Bundle extras) {
        String interval = extras.getString("pt_flip_interval");
        try {
            int t = 0;
            if (interval != null) {
                t = Integer.parseInt(interval);
                return Math.max(t, 4000);
            }
        }
        catch (Exception e) {
            PTLog.debug("Flip Interval couldn't be converted to number: " + interval + " - Defaulting to base value: " + 4000);
        }
        return 4000;
    }

    static void deleteImageFromStorage(Context context, Intent intent) {
        String pId = intent.getStringExtra("wzrk_pid");
        ContextWrapper cw = new ContextWrapper(context.getApplicationContext());
        File MyDirectory = cw.getDir("pt_dir", 0);
        String path = MyDirectory.getAbsolutePath();
        String[] fileList = MyDirectory.list();
        File fileToBeDeleted = null;
        if (fileList != null) {
            for (String fileName : fileList) {
                boolean wasDeleted;
                if (pId != null && fileName.contains(pId)) {
                    fileToBeDeleted = new File(path + "/" + fileName);
                    wasDeleted = fileToBeDeleted.delete();
                    if (wasDeleted) continue;
                    PTLog.debug("Failed to clean up the following file: " + fileName);
                    continue;
                }
                if (pId != null || !fileName.contains("null") || (wasDeleted = (fileToBeDeleted = new File(path + "/" + fileName)).delete())) continue;
                PTLog.debug("Failed to clean up the following file: " + fileName);
            }
        }
    }
}

