/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.variables;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.inapp.data.CtCacheType;
import com.clevertap.android.sdk.inapp.images.FileResourceProvider;
import com.clevertap.android.sdk.inapp.images.repo.FileResourcesRepoImpl;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.Task;
import com.clevertap.android.sdk.variables.CTVariableUtils;
import com.clevertap.android.sdk.variables.JsonUtil;
import com.clevertap.android.sdk.variables.Var;
import com.clevertap.android.sdk.variables.repo.VariablesRepo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.json.JSONArray;
import org.json.JSONObject;

public class VarCache {
    private final Map<String, Object> valuesFromClient = new HashMap<String, Object>();
    private final Map<String, Var<?>> vars = new ConcurrentHashMap();
    private final Map<String, String> defaultKinds = new HashMap<String, String>();
    private final Context variablesCtx;
    private final FileResourcesRepoImpl fileResourcesRepoImpl;
    private final CleverTapInstanceConfig instanceConfig;
    private final VariablesRepo variablesRepo;
    public Object merged = null;
    private Runnable globalCallbacksRunnable = null;
    private Map<String, Object> diffs = new HashMap<String, Object>();
    @NonNull
    private List<Map<String, Object>> abVariants = new ArrayList<Map<String, Object>>();

    public VarCache(CleverTapInstanceConfig config, Context ctx, FileResourcesRepoImpl fileResourcesRepoImpl, VariablesRepo variablesRepo) {
        this.variablesCtx = ctx;
        this.instanceConfig = config;
        this.fileResourcesRepoImpl = fileResourcesRepoImpl;
        this.variablesRepo = variablesRepo;
    }

    private static void log(String msg) {
        Logger.d("variables", msg);
    }

    private static void log(String msg, Throwable t) {
        Logger.d("variables", msg, t);
    }

    @VisibleForTesting
    void mergeVariable(@NonNull Var<?> var) {
        boolean shouldMerge;
        if (this.merged == null) {
            VarCache.log("mergeVariable() called, but `merged` member is null.");
            return;
        }
        if (!(this.merged instanceof Map)) {
            VarCache.log("mergeVariable() called, but `merged` member is not of Map type.");
            return;
        }
        String firstComponent = var.nameComponents()[0];
        Object defaultValue = this.valuesFromClient.get(firstComponent);
        Map mergedMap = (Map)JsonUtil.uncheckedCast(this.merged);
        Object mergedValue = mergedMap.get(firstComponent);
        if ("file".equals(var.kind())) {
            shouldMerge = defaultValue == null && mergedValue != null;
        } else {
            boolean bl = shouldMerge = defaultValue != null && !defaultValue.equals(mergedValue);
        }
        if (shouldMerge) {
            Object newValue = CTVariableUtils.mergeHelper(defaultValue, mergedValue);
            mergedMap.put(firstComponent, newValue);
            StringBuilder name = new StringBuilder(firstComponent);
            for (int i = 1; i < var.nameComponents().length; ++i) {
                Var<?> existing = this.vars.get(name.toString());
                if (existing != null) {
                    existing.update();
                }
                name.append('.').append(var.nameComponents()[i]);
            }
        }
    }

    public synchronized void registerVariable(@NonNull Var<?> var) {
        VarCache.log("registerVariable() called with: var = [" + var.name() + "]");
        this.vars.put(var.name(), var);
        Object defaultValue = var.defaultValue();
        if (defaultValue instanceof Map) {
            defaultValue = CTVariableUtils.deepCopyMap((Map)JsonUtil.uncheckedCast(defaultValue));
        }
        CTVariableUtils.updateValuesAndKinds(var.name(), var.nameComponents(), defaultValue, var.kind(), this.valuesFromClient, this.defaultKinds);
        this.mergeVariable(var);
    }

    public synchronized Object getMergedValue(String variableName) {
        Var<?> var = this.vars.get(variableName);
        if (var != null && "file".equals(var.kind())) {
            return this.filePathFromDisk(var.stringValue);
        }
        Object[] components = CTVariableUtils.getNameComponents(variableName);
        Object mergedValue = this.getMergedValueFromComponentArray(components);
        if (mergedValue instanceof Map) {
            return CTVariableUtils.deepCopyMap((Map)JsonUtil.uncheckedCast(mergedValue));
        }
        return mergedValue;
    }

    public synchronized <T> T getMergedValueFromComponentArray(Object[] components) {
        return this.getMergedValueFromComponentArray(components, this.merged != null ? this.merged : this.valuesFromClient);
    }

    public synchronized <T> T getMergedValueFromComponentArray(Object[] components, Object values) {
        Object mergedPtr = values;
        for (Object component : components) {
            mergedPtr = CTVariableUtils.traverse(mergedPtr, component, false);
        }
        return JsonUtil.uncheckedCast(mergedPtr);
    }

    public synchronized void loadDiffs(Function0<Unit> func) {
        this.handleVariablesData(func);
        this.handleAbVariantsData();
    }

    private void handleVariablesData(Function0<Unit> func) {
        try {
            String variablesFromCache = this.variablesRepo.loadDataFromCache();
            Map<String, Object> variablesAsMap = JsonUtil.fromJson(variablesFromCache);
            HashMap clientRegisteredVars = new HashMap(this.vars);
            this.applyVariableDiffs(variablesAsMap, clientRegisteredVars);
            this.startFilesDownload(clientRegisteredVars, func);
        }
        catch (Exception e) {
            VarCache.log("Could not load variable diffs.\n", e);
        }
    }

    private void handleAbVariantsData() {
        try {
            String variantsFromCache = this.variablesRepo.loadVariantsFromCache();
            JSONArray variants = variantsFromCache == null ? new JSONArray() : new JSONArray(variantsFromCache);
            this.abVariants = Objects.requireNonNull(JsonUtil.listFromJson(variants));
        }
        catch (Exception e) {
            VarCache.log("Could not load variants", e);
        }
    }

    public synchronized void loadDiffsAndTriggerHandlers(Function0<Unit> func) {
        this.loadDiffs(func);
        this.triggerGlobalCallbacks();
    }

    public synchronized void updateAbVariants(@NonNull List<Map<String, Object>> variants) {
        this.abVariants = variants;
    }

    public synchronized void updateDiffsAndTriggerHandlers(Map<String, Object> diffs, Function0<Unit> func) {
        HashMap clientRegisteredVars = new HashMap(this.vars);
        this.applyVariableDiffs(diffs, clientRegisteredVars);
        this.startFilesDownload(clientRegisteredVars, func);
        this.saveDiffsAsync();
        this.triggerGlobalCallbacks();
    }

    private void saveDiffsAsync() {
        Task<Void> task = CTExecutorFactory.executors(this.instanceConfig).postAsyncSafelyTask();
        task.execute("VarCache#saveDiffsAsync", () -> {
            this.saveDiffs();
            this.saveAbVariants();
            return null;
        });
    }

    @WorkerThread
    private void saveDiffs() {
        VarCache.log("saveDiffs() called");
        String variablesCipher = JsonUtil.toJson(this.diffs);
        if (variablesCipher != null) {
            this.variablesRepo.storeDataInCache(variablesCipher);
        }
    }

    @WorkerThread
    private void saveAbVariants() {
        VarCache.log("saveAbVariables() called");
        String variantsCipher = JsonUtil.toJson(this.abVariants);
        if (variantsCipher != null) {
            this.variablesRepo.storeVariantsInCache(variantsCipher);
        }
    }

    private void applyVariableDiffs(Map<String, Object> diffs, HashMap<String, Var<?>> clientRegisteredVars) {
        VarCache.log("applyVariableDiffs() called with: diffs = [" + diffs + "]");
        if (diffs != null) {
            this.diffs = diffs;
            this.merged = CTVariableUtils.mergeHelper(this.valuesFromClient, this.diffs);
            VarCache.log("applyVariableDiffs: updated value of merged=[" + this.merged + "]");
            for (Map.Entry<String, Var<?>> entry : clientRegisteredVars.entrySet()) {
                String name = entry.getKey();
                Var<?> var = this.vars.get(name);
                if (var == null) continue;
                var.update();
            }
        }
    }

    private void startFilesDownload(HashMap<String, Var<?>> clientRegisteredVars, Function0<Unit> func) {
        if (clientRegisteredVars.isEmpty()) {
            VarCache.log("There are no variables registered by the client. Not downloading files & posting global callbacks");
            return;
        }
        StringBuilder skipped = new StringBuilder();
        skipped.append("Skipped these file vars cause urls are not present :");
        skipped.append("\n");
        StringBuilder added = new StringBuilder();
        added.append("Adding these files to download :");
        added.append("\n");
        ArrayList<Pair> urls = new ArrayList<Pair>();
        for (Map.Entry<String, Var<?>> entry : clientRegisteredVars.entrySet()) {
            String name = entry.getKey();
            Var<?> var = this.vars.get(name);
            if (var == null || !var.kind().equals("file")) continue;
            String url = var.rawFileValue();
            if (url != null) {
                boolean isFileCached = FileResourceProvider.getInstance(this.variablesCtx, this.instanceConfig.getLogger()).isFileCached(url);
                if (isFileCached) continue;
                urls.add(new Pair((Object)url, (Object)CtCacheType.FILES));
                added.append(name).append(" : ").append(url);
                added.append("\n");
                continue;
            }
            skipped.append(name);
            skipped.append("\n");
        }
        VarCache.log(skipped.toString());
        VarCache.log(added.toString());
        if (urls.isEmpty()) {
            func.invoke();
            return;
        }
        this.fileResourcesRepoImpl.preloadFilesAndCache(urls, (Function1<? super Map<String, Boolean>, Unit>)((Function1)downloadAllBlock -> {
            func.invoke();
            return Unit.INSTANCE;
        }));
    }

    private synchronized void triggerGlobalCallbacks() {
        if (this.globalCallbacksRunnable != null) {
            this.globalCallbacksRunnable.run();
        }
    }

    public JSONObject getDefineVarsData() {
        return CTVariableUtils.getFlatVarsJson(this.valuesFromClient, this.defaultKinds);
    }

    public synchronized void clearUserContent() {
        VarCache.log("Clear user content in VarCache");
        HashMap clientRegisteredVars = new HashMap(this.vars);
        for (String name : clientRegisteredVars.keySet()) {
            Var<?> var = this.vars.get(name);
            if (var == null) continue;
            var.clearStartFlag();
        }
        this.applyVariableDiffs(new HashMap<String, Object>(), clientRegisteredVars);
        this.abVariants = new ArrayList<Map<String, Object>>();
        this.saveDiffsAsync();
    }

    public synchronized <T> Var<T> getVariable(String name) {
        return (Var)JsonUtil.uncheckedCast(this.vars.get(name));
    }

    @VisibleForTesting
    int getVariablesCount() {
        return this.vars.size();
    }

    public synchronized void setGlobalCallbacksRunnable(Runnable runnable) {
        this.globalCallbacksRunnable = runnable;
    }

    public String filePathFromDisk(String url) {
        return FileResourceProvider.getInstance(this.variablesCtx, this.instanceConfig.getLogger()).cachedFilePath(url);
    }

    public void fileVarUpdated(Var<String> fileVar) {
        String url = fileVar.rawFileValue();
        Task<Boolean> task = CTExecutorFactory.executors(this.instanceConfig).ioTask();
        task.addOnSuccessListener(isCached -> {
            if (isCached.booleanValue()) {
                fileVar.triggerFileIsReady();
            } else {
                ArrayList<Pair> list = new ArrayList<Pair>();
                list.add(new Pair((Object)url, (Object)CtCacheType.FILES));
                this.fileResourcesRepoImpl.preloadFilesAndCache(list, (Function1<? super Map<String, Boolean>, Unit>)((Function1)downloadAllBlock -> {
                    fileVar.triggerFileIsReady();
                    return Unit.INSTANCE;
                }));
            }
        });
        task.execute("isFileCached", () -> url == null || FileResourceProvider.getInstance(this.variablesCtx, this.instanceConfig.getLogger()).isFileCached(url));
    }

    public List<Map<String, Object>> variants() {
        return this.abVariants;
    }
}

