/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.validation.eventname;

import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.validation.DropReason;
import com.clevertap.android.sdk.validation.ValidationConfig;
import com.clevertap.android.sdk.validation.ValidationError;
import com.clevertap.android.sdk.validation.ValidationOutcome;
import com.clevertap.android.sdk.validation.ValidationResult;
import com.clevertap.android.sdk.validation.ValidationResultFactory;
import com.clevertap.android.sdk.validation.pipeline.EventNameNormalizationResult;
import com.clevertap.android.sdk.validation.pipeline.ModificationReason;
import com.clevertap.android.sdk.validation.pipeline.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016JC\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u00a2\u0006\u0002\u0010\u0017J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00102\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\rH\u0002J \u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00102\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\rH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/clevertap/android/sdk/validation/eventname/EventNameValidator;", "Lcom/clevertap/android/sdk/validation/pipeline/Validator;", "Lcom/clevertap/android/sdk/validation/pipeline/EventNameNormalizationResult;", "<init>", "()V", "validate", "Lcom/clevertap/android/sdk/validation/ValidationOutcome;", "input", "config", "Lcom/clevertap/android/sdk/validation/ValidationConfig;", "validateModifications", "", "modifications", "", "Lcom/clevertap/android/sdk/validation/pipeline/ModificationReason;", "originalName", "", "cleanedName", "maxEventNameLength", "", "errors", "", "Lcom/clevertap/android/sdk/validation/ValidationResult;", "(Ljava/util/Set;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/util/List;)V", "isRestricted", "", "restrictedEventNames", "isDiscarded", "discardedEventNames", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nEventNameValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventNameValidator.kt\ncom/clevertap/android/sdk/validation/eventname/EventNameValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n1863#2,2:141\n1755#2,3:143\n1755#2,3:146\n*S KotlinDebug\n*F\n+ 1 EventNameValidator.kt\ncom/clevertap/android/sdk/validation/eventname/EventNameValidator\n*L\n94#1:141,2\n124#1:143,3\n136#1:146,3\n*E\n"})
public final class EventNameValidator
implements Validator<EventNameNormalizationResult> {
    @Override
    @NotNull
    public ValidationOutcome validate(@NotNull EventNameNormalizationResult input, @NotNull ValidationConfig config) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        List errors = new ArrayList();
        if (input.getOriginalName() == null) {
            ValidationResult error = ValidationResultFactory.create(ValidationError.EVENT_NAME_NULL, new String[0]);
            errors.add(error);
            return new ValidationOutcome.Drop(errors, DropReason.NULL_EVENT_NAME);
        }
        this.validateModifications(input.getModifications(), input.getOriginalName(), input.getCleanedName(), config.getMaxEventNameLength(), errors);
        if (((CharSequence)input.getCleanedName()).length() == 0) {
            ValidationResult error = ValidationResultFactory.create(ValidationError.EVENT_NAME_NULL, new String[0]);
            errors.add(error);
            return new ValidationOutcome.Drop(errors, DropReason.NULL_EVENT_NAME);
        }
        if (this.isRestricted(input.getCleanedName(), config.getRestrictedEventNames())) {
            String[] stringArray = new String[]{input.getCleanedName()};
            ValidationResult error = ValidationResultFactory.create(ValidationError.RESTRICTED_EVENT_NAME, stringArray);
            errors.add(error);
            return new ValidationOutcome.Drop(errors, DropReason.RESTRICTED_EVENT_NAME);
        }
        if (this.isDiscarded(input.getCleanedName(), config.getDiscardedEventNames())) {
            String[] stringArray = new String[]{input.getCleanedName()};
            ValidationResult error = ValidationResultFactory.create(ValidationError.DISCARDED_EVENT_NAME, stringArray);
            errors.add(error);
            return new ValidationOutcome.Drop(errors, DropReason.DISCARDED_EVENT_NAME);
        }
        return errors.isEmpty() ? (ValidationOutcome)new ValidationOutcome.Success(null, 1, null) : (ValidationOutcome)new ValidationOutcome.Warning(errors);
    }

    private final void validateModifications(Set<? extends ModificationReason> modifications, String originalName, String cleanedName, Integer maxEventNameLength, List<ValidationResult> errors) {
        Iterable $this$forEach$iv = modifications;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModificationReason modification = (ModificationReason)((Object)element$iv);
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[modification.ordinal()]) {
                case 1: {
                    String[] stringArray = new String[3];
                    stringArray[0] = originalName;
                    Object object = maxEventNameLength;
                    if (object == null || (object = ((Integer)object).toString()) == null) {
                        object = "unknown";
                    }
                    stringArray[1] = object;
                    stringArray[2] = cleanedName;
                    ValidationResult error = ValidationResultFactory.create(ValidationError.EVENT_NAME_TOO_LONG, stringArray);
                    boolean bl2 = errors.add(error);
                    break;
                }
                case 2: {
                    String[] stringArray = new String[]{originalName, cleanedName};
                    ValidationResult error = ValidationResultFactory.create(ValidationError.EVENT_NAME_INVALID_CHARACTERS, stringArray);
                    boolean bl2 = errors.add(error);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    private final boolean isRestricted(String cleanedName, Set<String> restrictedEventNames) {
        boolean bl;
        block5: {
            Set<String> set = restrictedEventNames;
            if (set != null) {
                Iterable $this$any$iv = set;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String restrictedName = (String)element$iv;
                        boolean bl2 = false;
                        if (!Utils.areNamesNormalizedEqual(cleanedName, restrictedName)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isDiscarded(String cleanedName, Set<String> discardedEventNames) {
        boolean bl;
        block5: {
            Set<String> set = discardedEventNames;
            if (set != null) {
                Iterable $this$any$iv = set;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String discardedName = (String)element$iv;
                        boolean bl2 = false;
                        if (!Utils.areNamesNormalizedEqual(cleanedName, discardedName)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ModificationReason.values().length];
            try {
                nArray[ModificationReason.TRUNCATED_TO_MAX_LENGTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModificationReason.INVALID_CHARACTERS_REMOVED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

