/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.validation.eventdata;

import com.clevertap.android.sdk.validation.ValidationConfig;
import com.clevertap.android.sdk.validation.pipeline.EventDataMetrics;
import com.clevertap.android.sdk.validation.pipeline.EventDataNormalizationResult;
import com.clevertap.android.sdk.validation.pipeline.KeyModification;
import com.clevertap.android.sdk.validation.pipeline.ModificationReason;
import com.clevertap.android.sdk.validation.pipeline.Normalizer;
import com.clevertap.android.sdk.validation.pipeline.RemovalReason;
import com.clevertap.android.sdk.validation.pipeline.RemovedItem;
import com.clevertap.android.sdk.validation.pipeline.ValueModification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u0018\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0013\u001a\u00020\u00032\u0010\u0010\u0014\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002Js\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00022\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u001f2\b\u0010!\u001a\u0004\u0018\u00010 2\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\u001f2\b\u0010$\u001a\u0004\u0018\u00010\u00072\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\u001f2\b\u0010&\u001a\u0004\u0018\u00010\u00072\u0006\u0010'\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010(J$\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020 2\b\u0010+\u001a\u0004\u0018\u00010,2\b\u0010!\u001a\u0004\u0018\u00010 H\u0002J]\u0010-\u001a\u0004\u0018\u00010,2\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010.\u001a\u00020 2\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\u001f2\b\u0010$\u001a\u0004\u0018\u00010\u00072\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\u001f2\b\u0010&\u001a\u0004\u0018\u00010\u00072\u0006\u0010'\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010/J\u0010\u00100\u001a\u0002012\u0006\u0010+\u001a\u00020,H\u0002J]\u00102\u001a\u0002032\n\u00104\u001a\u0006\u0012\u0002\b\u0003052\u0006\u0010.\u001a\u00020 2\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\u001f2\b\u0010$\u001a\u0004\u0018\u00010\u00072\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\u001f2\b\u0010&\u001a\u0004\u0018\u00010\u00072\u0006\u0010'\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u00106JQ\u00107\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\u001c2\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\u001f2\b\u0010$\u001a\u0004\u0018\u00010\u00072\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\u001f2\b\u0010&\u001a\u0004\u0018\u00010\u00072\u0006\u0010'\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u00109JY\u0010:\u001a\u0002032\u0006\u0010;\u001a\u0002032\u0006\u0010.\u001a\u00020 2\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\u001f2\b\u0010$\u001a\u0004\u0018\u00010\u00072\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\u001f2\b\u0010&\u001a\u0004\u0018\u00010\u00072\u0006\u0010'\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010<J/\u0010=\u001a\u00020 2\u0006\u0010*\u001a\u00020 2\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\u001f2\b\u0010$\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010>J;\u0010?\u001a\u0004\u0018\u00010,2\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010*\u001a\u00020 2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\u001f2\b\u0010&\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010@J9\u0010A\u001a\u0004\u0018\u00010 2\u0006\u0010+\u001a\u00020 2\u0006\u0010*\u001a\u00020 2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\u001f2\b\u0010&\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010BJ\"\u0010C\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020 2\u0006\u0010D\u001a\u00020E2\b\u0010F\u001a\u0004\u0018\u00010,H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/clevertap/android/sdk/validation/eventdata/EventDataNormalizer;", "Lcom/clevertap/android/sdk/validation/pipeline/Normalizer;", "", "Lcom/clevertap/android/sdk/validation/pipeline/EventDataNormalizationResult;", "<init>", "()V", "maxDepth", "", "maxArrayKeyCount", "maxObjectKeyCount", "maxArrayLength", "maxKVPairCount", "keysModified", "", "Lcom/clevertap/android/sdk/validation/pipeline/KeyModification;", "valuesModified", "Lcom/clevertap/android/sdk/validation/pipeline/ValueModification;", "itemsRemoved", "Lcom/clevertap/android/sdk/validation/pipeline/RemovedItem;", "normalize", "input", "config", "Lcom/clevertap/android/sdk/validation/ValidationConfig;", "buildMetrics", "Lcom/clevertap/android/sdk/validation/pipeline/EventDataMetrics;", "resetTracking", "", "cleanMapInternal", "Lorg/json/JSONObject;", "map", "restrictedMultiValueFields", "", "", "deviceCountryCode", "keyCharsNotAllowed", "", "maxKeyLength", "valueCharsNotAllowed", "maxValueLength", "depth", "(Ljava/util/Map;Ljava/util/Set;Ljava/lang/String;Ljava/util/Set;Ljava/lang/Integer;Ljava/util/Set;Ljava/lang/Integer;I)Lorg/json/JSONObject;", "validatePhoneNumber", "key", "value", "", "cleanAnyValue", "parentKey", "(Ljava/lang/Object;Ljava/lang/String;Ljava/util/Set;Ljava/lang/Integer;Ljava/util/Set;Ljava/lang/Integer;I)Ljava/lang/Object;", "isEmpty", "", "cleanList", "Lorg/json/JSONArray;", "list", "", "(Ljava/util/List;Ljava/lang/String;Ljava/util/Set;Ljava/lang/Integer;Ljava/util/Set;Ljava/lang/Integer;I)Lorg/json/JSONArray;", "cleanJSONObject", "json", "(Lorg/json/JSONObject;Ljava/util/Set;Ljava/lang/Integer;Ljava/util/Set;Ljava/lang/Integer;I)Lorg/json/JSONObject;", "cleanJSONArray", "array", "(Lorg/json/JSONArray;Ljava/lang/String;Ljava/util/Set;Ljava/lang/Integer;Ljava/util/Set;Ljava/lang/Integer;I)Lorg/json/JSONArray;", "cleanKey", "(Ljava/lang/String;Ljava/util/Set;Ljava/lang/Integer;)Ljava/lang/String;", "cleanPrimitiveValue", "(Ljava/lang/Object;Ljava/lang/String;Ljava/util/Set;Ljava/lang/Integer;)Ljava/lang/Object;", "cleanStringValue", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Ljava/lang/Integer;)Ljava/lang/String;", "recordRemoval", "reason", "Lcom/clevertap/android/sdk/validation/pipeline/RemovalReason;", "originalValue", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nEventDataNormalizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventDataNormalizer.kt\ncom/clevertap/android/sdk/validation/eventdata/EventDataNormalizer\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,473:1\n488#2,11:474\n488#2,11:485\n*S KotlinDebug\n*F\n+ 1 EventDataNormalizer.kt\ncom/clevertap/android/sdk/validation/eventdata/EventDataNormalizer\n*L\n376#1:474,11\n433#1:485,11\n*E\n"})
public final class EventDataNormalizer
implements Normalizer<Map<?, ?>, EventDataNormalizationResult> {
    private int maxDepth;
    private int maxArrayKeyCount;
    private int maxObjectKeyCount;
    private int maxArrayLength;
    private int maxKVPairCount;
    @NotNull
    private final List<KeyModification> keysModified = new ArrayList();
    @NotNull
    private final List<ValueModification> valuesModified = new ArrayList();
    @NotNull
    private final List<RemovedItem> itemsRemoved = new ArrayList();

    @Override
    @NotNull
    public EventDataNormalizationResult normalize(@Nullable Map<?, ?> input, @NotNull ValidationConfig config) {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.resetTracking();
        if (input == null) {
            jSONObject = new JSONObject();
        } else {
            JSONObject jSONObject2;
            try {
                jSONObject2 = this.cleanMapInternal(input, config.getRestrictedMultiValueFields(), (String)config.getDeviceCountryCodeProvider().invoke(), config.getKeyCharsNotAllowed(), config.getMaxKeyLength(), config.getValueCharsNotAllowed(), config.getMaxValueLength(), 0);
            }
            catch (JSONException jSONException) {
                jSONObject2 = new JSONObject();
            }
            jSONObject = jSONObject2;
        }
        JSONObject cleanedData = jSONObject;
        return new EventDataNormalizationResult(cleanedData, this.buildMetrics());
    }

    private final EventDataMetrics buildMetrics() {
        return new EventDataMetrics(this.maxDepth, this.maxArrayKeyCount, this.maxObjectKeyCount, this.maxArrayLength, this.maxKVPairCount, CollectionsKt.toList((Iterable)this.keysModified), CollectionsKt.toList((Iterable)this.valuesModified), CollectionsKt.toList((Iterable)this.itemsRemoved));
    }

    private final void resetTracking() {
        this.maxDepth = 0;
        this.maxArrayKeyCount = 0;
        this.maxObjectKeyCount = 0;
        this.maxArrayLength = 0;
        this.maxKVPairCount = 0;
        this.keysModified.clear();
        this.valuesModified.clear();
        this.itemsRemoved.clear();
    }

    private final JSONObject cleanMapInternal(Map<?, ?> map, Set<String> restrictedMultiValueFields, String deviceCountryCode, Set<Character> keyCharsNotAllowed, Integer maxKeyLength, Set<Character> valueCharsNotAllowed, Integer maxValueLength, int depth) throws JSONException {
        this.maxDepth = Math.max(this.maxDepth, depth);
        JSONObject cleaned = new JSONObject();
        int arrayKeyCount = 0;
        int objectKeyCount = 0;
        int kvPairCount = 0;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object cleanedValue;
            Object isObjectOrArray2;
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null) {
                this.recordRemoval("null", RemovalReason.EMPTY_KEY, "");
                continue;
            }
            String keyStr = key.toString();
            String cleanedKey = this.cleanKey(keyStr, keyCharsNotAllowed, maxKeyLength);
            if (((CharSequence)cleanedKey).length() == 0) {
                this.recordRemoval(keyStr, RemovalReason.EMPTY_KEY, "");
                continue;
            }
            if (value == null) {
                this.recordRemoval(cleanedKey, RemovalReason.NULL_VALUE, null);
                continue;
            }
            if (depth == 0) {
                boolean bl;
                Set<String> set = restrictedMultiValueFields;
                if (set != null) {
                    String string2 = cleanedKey.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    bl = set.contains(string2);
                } else {
                    bl = false;
                }
                if (bl) {
                    boolean isObjectOrArray2;
                    Object obj = value;
                    boolean bl2 = isObjectOrArray2 = obj instanceof Map || obj instanceof JSONObject || obj instanceof List || obj instanceof Object[] || obj instanceof JSONArray;
                    if (isObjectOrArray2) {
                        this.recordRemoval(cleanedKey, RemovalReason.RESTRICTED_KEY_NESTED_VALUE, value);
                        continue;
                    }
                }
            }
            if (StringsKt.equals((String)cleanedKey, (String)"Phone", (boolean)true)) {
                this.validatePhoneNumber(cleanedKey, value, deviceCountryCode);
            }
            if ((isObjectOrArray2 = value) instanceof Map || isObjectOrArray2 instanceof JSONObject) {
                ++objectKeyCount;
            } else if (isObjectOrArray2 instanceof List || isObjectOrArray2 instanceof Object[] || isObjectOrArray2 instanceof JSONArray) {
                ++arrayKeyCount;
            }
            if ((cleanedValue = this.cleanAnyValue(value, cleanedKey, keyCharsNotAllowed, maxKeyLength, valueCharsNotAllowed, maxValueLength, depth)) == null) continue;
            cleaned.put(cleanedKey, cleanedValue);
            ++kvPairCount;
        }
        this.maxArrayKeyCount = Math.max(this.maxArrayKeyCount, arrayKeyCount);
        this.maxObjectKeyCount = Math.max(this.maxObjectKeyCount, objectKeyCount);
        this.maxKVPairCount = Math.max(this.maxKVPairCount, kvPairCount);
        return cleaned;
    }

    private final void validatePhoneNumber(String key, Object value, String deviceCountryCode) {
        if (!(value instanceof String)) {
            this.recordRemoval(key, RemovalReason.INVALID_PHONE_NUMBER, value);
            return;
        }
        String phoneValue = ((Object)StringsKt.trim((CharSequence)((String)value))).toString();
        CharSequence charSequence = deviceCountryCode;
        if ((charSequence == null || charSequence.length() == 0) && !StringsKt.startsWith$default((String)phoneValue, (String)"+", (boolean)false, (int)2, null)) {
            this.recordRemoval(key, RemovalReason.INVALID_COUNTRY_CODE, phoneValue);
        }
    }

    private final Object cleanAnyValue(Object value, String parentKey, Set<Character> keyCharsNotAllowed, Integer maxKeyLength, Set<Character> valueCharsNotAllowed, Integer maxValueLength, int depth) throws JSONException {
        JSONObject jSONObject;
        JSONObject jSONObject2;
        if (value == null || Intrinsics.areEqual((Object)value, (Object)JSONObject.NULL)) {
            return null;
        }
        Object object = value;
        if (object instanceof Map) {
            jSONObject2 = this.cleanMapInternal((Map)value, null, null, keyCharsNotAllowed, maxKeyLength, valueCharsNotAllowed, maxValueLength, depth + 1);
        } else if (object instanceof JSONObject) {
            jSONObject2 = this.cleanJSONObject((JSONObject)value, keyCharsNotAllowed, maxKeyLength, valueCharsNotAllowed, maxValueLength, depth + 1);
        } else if (object instanceof List) {
            jSONObject2 = this.cleanList((List)value, parentKey, keyCharsNotAllowed, maxKeyLength, valueCharsNotAllowed, maxValueLength, depth);
        } else if (object instanceof Object[]) {
            jSONObject2 = this.cleanList(ArraysKt.toList((Object[])((Object[])value)), parentKey, keyCharsNotAllowed, maxKeyLength, valueCharsNotAllowed, maxValueLength, depth);
        } else if (object instanceof JSONArray) {
            jSONObject2 = this.cleanJSONArray((JSONArray)value, parentKey, keyCharsNotAllowed, maxKeyLength, valueCharsNotAllowed, maxValueLength, depth);
        } else {
            return this.cleanPrimitiveValue(value, parentKey, valueCharsNotAllowed, maxValueLength);
        }
        JSONObject cleaned = jSONObject2;
        if (this.isEmpty(cleaned)) {
            this.recordRemoval(parentKey, RemovalReason.EMPTY_VALUE, "");
            jSONObject = null;
        } else {
            jSONObject = cleaned;
        }
        return jSONObject;
    }

    private final boolean isEmpty(Object value) {
        Object object = value;
        return object instanceof JSONObject ? ((JSONObject)value).length() == 0 : (object instanceof JSONArray ? ((JSONArray)value).length() == 0 : false);
    }

    private final JSONArray cleanList(List<?> list, String parentKey, Set<Character> keyCharsNotAllowed, Integer maxKeyLength, Set<Character> valueCharsNotAllowed, Integer maxValueLength, int depth) throws JSONException {
        this.maxDepth = Math.max(this.maxDepth, depth);
        this.maxArrayLength = Math.max(this.maxArrayLength, list.size());
        JSONArray cleaned = new JSONArray();
        for (Object value : list) {
            if (value == null) {
                this.recordRemoval(parentKey, RemovalReason.NULL_VALUE, null);
                continue;
            }
            Object cleanedValue = this.cleanAnyValue(value, parentKey, keyCharsNotAllowed, maxKeyLength, valueCharsNotAllowed, maxValueLength, depth);
            if (cleanedValue == null) continue;
            cleaned.put(cleanedValue);
        }
        return cleaned;
    }

    private final JSONObject cleanJSONObject(JSONObject json, Set<Character> keyCharsNotAllowed, Integer maxKeyLength, Set<Character> valueCharsNotAllowed, Integer maxValueLength, int depth) throws JSONException {
        this.maxDepth = Math.max(this.maxDepth, depth);
        JSONObject cleaned = new JSONObject();
        int arrayKeyCount = 0;
        int objectKeyCount = 0;
        int kvPairCount = 0;
        Iterator it = json.keys();
        while (it.hasNext()) {
            Object cleanedValue;
            String key = (String)it.next();
            Intrinsics.checkNotNull((Object)key);
            String cleanedKey = this.cleanKey(key, keyCharsNotAllowed, maxKeyLength);
            if (((CharSequence)cleanedKey).length() == 0) {
                this.recordRemoval(key, RemovalReason.EMPTY_KEY, "");
                continue;
            }
            Object value = json.get(key);
            if (value == null || Intrinsics.areEqual((Object)value, (Object)JSONObject.NULL)) {
                this.recordRemoval(cleanedKey, RemovalReason.NULL_VALUE, "");
                continue;
            }
            Object object = value;
            if (object instanceof JSONObject) {
                ++objectKeyCount;
            } else if (object instanceof JSONArray) {
                ++arrayKeyCount;
            }
            if ((cleanedValue = this.cleanAnyValue(value, cleanedKey, keyCharsNotAllowed, maxKeyLength, valueCharsNotAllowed, maxValueLength, depth)) == null) continue;
            cleaned.put(cleanedKey, cleanedValue);
            ++kvPairCount;
        }
        this.maxArrayKeyCount = Math.max(this.maxArrayKeyCount, arrayKeyCount);
        this.maxObjectKeyCount = Math.max(this.maxObjectKeyCount, objectKeyCount);
        this.maxKVPairCount = Math.max(this.maxKVPairCount, kvPairCount);
        return cleaned;
    }

    private final JSONArray cleanJSONArray(JSONArray array, String parentKey, Set<Character> keyCharsNotAllowed, Integer maxKeyLength, Set<Character> valueCharsNotAllowed, Integer maxValueLength, int depth) throws JSONException {
        this.maxDepth = Math.max(this.maxDepth, depth);
        this.maxArrayLength = Math.max(this.maxArrayLength, array.length());
        JSONArray cleaned = new JSONArray();
        int n = array.length();
        for (int i = 0; i < n; ++i) {
            Object value = array.get(i);
            if (value == null || Intrinsics.areEqual((Object)value, (Object)JSONObject.NULL)) {
                this.recordRemoval(parentKey, RemovalReason.NULL_VALUE, null);
                continue;
            }
            Object cleanedValue = this.cleanAnyValue(value, parentKey, keyCharsNotAllowed, maxKeyLength, valueCharsNotAllowed, maxValueLength, depth);
            if (cleanedValue == null) continue;
            cleaned.put(cleanedValue);
        }
        return cleaned;
    }

    /*
     * WARNING - void declaration
     */
    private final String cleanKey(String key, Set<Character> keyCharsNotAllowed, Integer maxKeyLength) {
        String original = key;
        String cleaned = null;
        cleaned = ((Object)StringsKt.trim((CharSequence)key)).toString();
        if (((CharSequence)cleaned).length() == 0) {
            return "";
        }
        List reasons = new ArrayList();
        Set<Character> set = keyCharsNotAllowed;
        if (set != null) {
            void $this$filterNotTo$iv$iv;
            Set<Character> notAllowed = set;
            boolean bl = false;
            String $this$filterNot$iv = cleaned;
            boolean $i$f$filterNot = false;
            CharSequence charSequence = $this$filterNot$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterNotTo = false;
            for (int i = 0; i < $this$filterNotTo$iv$iv.length(); ++i) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterNotTo$iv$iv.charAt(i);
                boolean bl2 = false;
                if (notAllowed.contains(Character.valueOf(it))) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            String string2 = ((StringBuilder)destination$iv$iv).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String filtered = string2;
            if (!Intrinsics.areEqual((Object)filtered, (Object)cleaned)) {
                cleaned = filtered;
                reasons.add(ModificationReason.INVALID_CHARACTERS_REMOVED);
            }
        }
        Integer n = maxKeyLength;
        if (n != null) {
            int maxLength = ((Number)n).intValue();
            boolean bl = false;
            if (cleaned.length() > maxLength) {
                reasons.add(ModificationReason.TRUNCATED_TO_MAX_LENGTH);
                String string3 = cleaned.substring(0, maxLength);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                cleaned = string3;
            }
        }
        String result = ((Object)StringsKt.trim((CharSequence)cleaned)).toString();
        if (!Intrinsics.areEqual((Object)result, (Object)original) && !((Collection)reasons).isEmpty()) {
            this.keysModified.add(new KeyModification(original, result, reasons));
        }
        return result;
    }

    private final Object cleanPrimitiveValue(Object value, String key, Set<Character> valueCharsNotAllowed, Integer maxValueLength) {
        Object object;
        Object object2 = value;
        if (object2 instanceof Integer || object2 instanceof Long || object2 instanceof Float || object2 instanceof Double || object2 instanceof Boolean) {
            object = value;
        } else if (object2 instanceof String) {
            object = this.cleanStringValue((String)value, key, valueCharsNotAllowed, maxValueLength);
        } else if (object2 instanceof Character) {
            object = this.cleanPrimitiveValue(String.valueOf(((Character)value).charValue()), key, valueCharsNotAllowed, maxValueLength);
        } else if (object2 instanceof Date) {
            object = "$D_" + ((Date)value).getTime() / (long)1000;
        } else {
            this.recordRemoval(key, RemovalReason.NON_PRIMITIVE_VALUE, value);
            object = null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final String cleanStringValue(String value, String key, Set<Character> valueCharsNotAllowed, Integer maxValueLength) {
        String original = value;
        String cleaned = null;
        cleaned = ((Object)StringsKt.trim((CharSequence)value)).toString();
        if (((CharSequence)cleaned).length() == 0) {
            this.recordRemoval(key, RemovalReason.EMPTY_VALUE, "");
            return null;
        }
        List reasons = new ArrayList();
        Set<Character> set = valueCharsNotAllowed;
        if (set != null) {
            void $this$filterNotTo$iv$iv;
            Set<Character> notAllowed = set;
            boolean bl = false;
            String $this$filterNot$iv = cleaned;
            boolean $i$f$filterNot = false;
            CharSequence charSequence = $this$filterNot$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterNotTo = false;
            for (int i = 0; i < $this$filterNotTo$iv$iv.length(); ++i) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterNotTo$iv$iv.charAt(i);
                boolean bl2 = false;
                if (notAllowed.contains(Character.valueOf(it))) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            String string2 = ((StringBuilder)destination$iv$iv).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String filtered = string2;
            if (!Intrinsics.areEqual((Object)filtered, (Object)cleaned)) {
                cleaned = filtered;
                reasons.add(ModificationReason.INVALID_CHARACTERS_REMOVED);
            }
        }
        Integer n = maxValueLength;
        if (n != null) {
            int maxLength = ((Number)n).intValue();
            boolean bl = false;
            if (cleaned.length() > maxLength) {
                reasons.add(ModificationReason.TRUNCATED_TO_MAX_LENGTH);
                String string3 = cleaned.substring(0, maxLength);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                cleaned = string3;
            }
        }
        String result = ((Object)StringsKt.trim((CharSequence)cleaned)).toString();
        if (!Intrinsics.areEqual((Object)result, (Object)original) && !((Collection)reasons).isEmpty()) {
            this.valuesModified.add(new ValueModification(key, original, result, reasons));
        }
        if (((CharSequence)result).length() == 0) {
            this.recordRemoval(key, RemovalReason.EMPTY_VALUE, "");
            return null;
        }
        return result;
    }

    private final void recordRemoval(String key, RemovalReason reason, Object originalValue) {
        this.itemsRemoved.add(new RemovedItem(key, reason, originalValue));
    }
}

