/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.utils;

import com.clevertap.android.sdk.utils.DataProcessingUtils;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J$\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/clevertap/android/sdk/utils/JsonFlattener;", "", "<init>", "()V", "flatten", "", "", "json", "Lorg/json/JSONObject;", "flattenInternal", "prefix", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nJsonFlattener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonFlattener.kt\ncom/clevertap/android/sdk/utils/JsonFlattener\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,51:1\n32#2,2:52\n*S KotlinDebug\n*F\n+ 1 JsonFlattener.kt\ncom/clevertap/android/sdk/utils/JsonFlattener\n*L\n23#1:52,2\n*E\n"})
public final class JsonFlattener {
    @NotNull
    public static final JsonFlattener INSTANCE = new JsonFlattener();

    private JsonFlattener() {
    }

    @JvmStatic
    @NotNull
    public static final Map<String, Object> flatten(@NotNull JSONObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return INSTANCE.flattenInternal(json, "");
    }

    private final Map<String, Object> flattenInternal(JSONObject json, String prefix) {
        Map result = new LinkedHashMap();
        Iterator iterator = json.keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"keys(...)");
        Iterator $this$forEach$iv = iterator;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            String key = (String)element$iv;
            boolean bl = false;
            Object value = json.get(key);
            String newKey = ((CharSequence)prefix).length() == 0 ? key : prefix + '.' + key;
            Object object = value;
            if (object instanceof JSONObject) {
                JSONObject jSONObject = (JSONObject)value;
                Intrinsics.checkNotNull((Object)newKey);
                result.putAll(INSTANCE.flattenInternal(jSONObject, newKey));
                continue;
            }
            if (object instanceof JSONArray) {
                result.put(newKey, DataProcessingUtils.INSTANCE.processDatePrefixes(value));
                continue;
            }
            if (Intrinsics.areEqual((Object)object, (Object)JSONObject.NULL)) continue;
            if (object instanceof String) {
                result.put(newKey, DataProcessingUtils.INSTANCE.processDatePrefixes(value));
                continue;
            }
            result.put(newKey, value);
        }
        return result;
    }
}

