/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.profile;

import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.ILogger;
import com.clevertap.android.sdk.profile.traversal.ArrayOperationHandler;
import com.clevertap.android.sdk.profile.traversal.DeleteOperationHandler;
import com.clevertap.android.sdk.profile.traversal.OperationHandler;
import com.clevertap.android.sdk.profile.traversal.ProfileChange;
import com.clevertap.android.sdk.profile.traversal.ProfileChangeTracker;
import com.clevertap.android.sdk.profile.traversal.ProfileOperation;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000  2\u00020\u0001:\u0002\u001f B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0007J>\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/clevertap/android/sdk/profile/ProfileStateTraverser;", "", "logger", "Lcom/clevertap/android/sdk/ILogger;", "<init>", "(Lcom/clevertap/android/sdk/ILogger;)V", "changeTracker", "Lcom/clevertap/android/sdk/profile/traversal/ProfileChangeTracker;", "arrayHandler", "Lcom/clevertap/android/sdk/profile/traversal/ArrayOperationHandler;", "updateHandler", "Lcom/clevertap/android/sdk/profile/traversal/OperationHandler;", "deleteHandler", "Lcom/clevertap/android/sdk/profile/traversal/DeleteOperationHandler;", "traverse", "Lcom/clevertap/android/sdk/profile/ProfileStateTraverser$ProfileTraversalResult;", "target", "Lorg/json/JSONObject;", "source", "operation", "Lcom/clevertap/android/sdk/profile/traversal/ProfileOperation;", "traverseRecursive", "", "path", "", "changes", "", "Lcom/clevertap/android/sdk/profile/traversal/ProfileChange;", "buildPath", "basePath", "key", "ProfileTraversalResult", "Companion", "clevertap-core_release"})
public final class ProfileStateTraverser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ILogger logger;
    @NotNull
    private final ProfileChangeTracker changeTracker;
    @NotNull
    private final ArrayOperationHandler arrayHandler;
    @NotNull
    private final OperationHandler updateHandler;
    @NotNull
    private final DeleteOperationHandler deleteHandler;

    public ProfileStateTraverser(@NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.changeTracker = new ProfileChangeTracker();
        this.arrayHandler = new ArrayOperationHandler(this.changeTracker);
        this.updateHandler = new OperationHandler(this.changeTracker, this.arrayHandler);
        this.deleteHandler = new DeleteOperationHandler(this.changeTracker);
    }

    @WorkerThread
    @NotNull
    public final ProfileTraversalResult traverse(@NotNull JSONObject target, @NotNull JSONObject source, @NotNull ProfileOperation operation) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        Map changes = new LinkedHashMap();
        this.traverseRecursive(target, source, "", changes, operation);
        return new ProfileTraversalResult(changes);
    }

    public static /* synthetic */ ProfileTraversalResult traverse$default(ProfileStateTraverser profileStateTraverser, JSONObject jSONObject, JSONObject jSONObject2, ProfileOperation profileOperation, int n, Object object) {
        if ((n & 4) != 0) {
            profileOperation = ProfileOperation.UPDATE;
        }
        return profileStateTraverser.traverse(jSONObject, jSONObject2, profileOperation);
    }

    private final void traverseRecursive(JSONObject target, JSONObject source, String path, Map<String, ProfileChange> changes, ProfileOperation operation) {
        if (source == null) {
            return;
        }
        Iterator keys = source.keys();
        while (keys.hasNext()) {
            String errorMsg;
            String key = (String)keys.next();
            Intrinsics.checkNotNull((Object)key);
            String currentPath = this.buildPath(path, key);
            try {
                Object newValue = source.get(key);
                if (WhenMappings.$EnumSwitchMapping$0[operation.ordinal()] == 1) {
                    Intrinsics.checkNotNull((Object)newValue);
                    this.deleteHandler.handleDelete(target, key, newValue, currentPath, changes, (Function4<? super JSONObject, ? super JSONObject, ? super String, ? super Map<String, ProfileChange>, Unit>)((Function4)(arg_0, arg_1, arg_2, arg_3) -> ProfileStateTraverser.traverseRecursive$lambda$0(this, arg_0, arg_1, arg_2, arg_3)));
                    continue;
                }
                Intrinsics.checkNotNull((Object)newValue);
                this.updateHandler.handleOperation(target, key, newValue, currentPath, changes, operation, (Function4<? super JSONObject, ? super JSONObject, ? super String, ? super Map<String, ProfileChange>, Unit>)((Function4)(arg_0, arg_1, arg_2, arg_3) -> ProfileStateTraverser.traverseRecursive$lambda$1(this, operation, arg_0, arg_1, arg_2, arg_3)));
            }
            catch (JSONException e) {
                errorMsg = "Failed to process key '" + key + "': " + e.getMessage();
                this.logger.verbose("ProfileStateTraverser", errorMsg);
            }
            catch (Exception e) {
                errorMsg = "Unexpected error processing key '" + key + "': " + e.getMessage();
                this.logger.verbose("ProfileStateTraverser", errorMsg);
            }
        }
    }

    private final String buildPath(String basePath, String key) {
        return ((CharSequence)basePath).length() == 0 ? key : basePath + '.' + key;
    }

    private static final Unit traverseRecursive$lambda$0(ProfileStateTraverser this$0, JSONObject nestedTarget, JSONObject nestedSource, String nestedPath, Map nestedChanges) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)nestedTarget, (String)"nestedTarget");
        Intrinsics.checkNotNullParameter((Object)nestedPath, (String)"nestedPath");
        Intrinsics.checkNotNullParameter((Object)nestedChanges, (String)"nestedChanges");
        this$0.traverseRecursive(nestedTarget, nestedSource, nestedPath, nestedChanges, ProfileOperation.DELETE);
        return Unit.INSTANCE;
    }

    private static final Unit traverseRecursive$lambda$1(ProfileStateTraverser this$0, ProfileOperation $operation, JSONObject nestedTarget, JSONObject nestedSource, String nestedPath, Map nestedChanges) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$operation), (String)"$operation");
        Intrinsics.checkNotNullParameter((Object)nestedTarget, (String)"nestedTarget");
        Intrinsics.checkNotNullParameter((Object)nestedPath, (String)"nestedPath");
        Intrinsics.checkNotNullParameter((Object)nestedChanges, (String)"nestedChanges");
        this$0.traverseRecursive(nestedTarget, nestedSource, nestedPath, nestedChanges, $operation);
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final Map<String, Map<String, Object>> toNestedMap(@NotNull Map<String, ProfileChange> $this$toNestedMap) {
        return Companion.toNestedMap($this$toNestedMap);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00050\u0005*\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0007\u00a8\u0006\b"}, d2={"Lcom/clevertap/android/sdk/profile/ProfileStateTraverser$Companion;", "", "<init>", "()V", "toNestedMap", "", "", "Lcom/clevertap/android/sdk/profile/traversal/ProfileChange;", "clevertap-core_release"})
    @SourceDebugExtension(value={"SMAP\nProfileStateTraverser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileStateTraverser.kt\ncom/clevertap/android/sdk/profile/ProfileStateTraverser$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n462#2:142\n412#2:143\n1246#3,4:144\n*S KotlinDebug\n*F\n+ 1 ProfileStateTraverser.kt\ncom/clevertap/android/sdk/profile/ProfileStateTraverser$Companion\n*L\n132#1:142\n132#1:143\n132#1:144,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Map<String, Map<String, Object>> toNestedMap(@NotNull Map<String, ProfileChange> $this$toNestedMap) {
            void $this$mapValuesTo$iv$iv;
            Intrinsics.checkNotNullParameter($this$toNestedMap, (String)"<this>");
            Map<String, ProfileChange> $this$mapValues$iv = $this$toNestedMap;
            boolean $i$f$mapValues = false;
            Map<String, ProfileChange> map = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl2 = false;
                ProfileChange change = (ProfileChange)entry2.getValue();
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"oldValue", (Object)change.getOldValue()), TuplesKt.to((Object)"newValue", (Object)change.getNewValue())};
                Map map4 = MapsKt.mapOf((Pair[])pairArray);
                map3.put(k, map4);
            }
            return destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/clevertap/android/sdk/profile/ProfileStateTraverser$ProfileTraversalResult;", "", "changes", "", "", "Lcom/clevertap/android/sdk/profile/traversal/ProfileChange;", "<init>", "(Ljava/util/Map;)V", "getChanges", "()Ljava/util/Map;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "clevertap-core_release"})
    public static final class ProfileTraversalResult {
        @NotNull
        private final Map<String, ProfileChange> changes;

        public ProfileTraversalResult(@NotNull Map<String, ProfileChange> changes) {
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            this.changes = changes;
        }

        @NotNull
        public final Map<String, ProfileChange> getChanges() {
            return this.changes;
        }

        @NotNull
        public final Map<String, ProfileChange> component1() {
            return this.changes;
        }

        @NotNull
        public final ProfileTraversalResult copy(@NotNull Map<String, ProfileChange> changes) {
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            return new ProfileTraversalResult(changes);
        }

        public static /* synthetic */ ProfileTraversalResult copy$default(ProfileTraversalResult profileTraversalResult, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                map = profileTraversalResult.changes;
            }
            return profileTraversalResult.copy(map);
        }

        @NotNull
        public String toString() {
            return "ProfileTraversalResult(changes=" + this.changes + ')';
        }

        public int hashCode() {
            return ((Object)this.changes).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProfileTraversalResult)) {
                return false;
            }
            ProfileTraversalResult profileTraversalResult = (ProfileTraversalResult)other;
            return Intrinsics.areEqual(this.changes, profileTraversalResult.changes);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProfileOperation.values().length];
            try {
                nArray[ProfileOperation.DELETE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

