/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.BaseCallbackManager;
import com.clevertap.android.sdk.CTXtensions;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.ILogger;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.db.BaseDatabaseManager;
import com.clevertap.android.sdk.db.QueueData;
import com.clevertap.android.sdk.events.EventGroup;
import com.clevertap.android.sdk.inapp.customtemplates.CustomTemplate;
import com.clevertap.android.sdk.interfaces.NotificationRenderedListener;
import com.clevertap.android.sdk.network.EndpointId;
import com.clevertap.android.sdk.network.NetworkEncryptionManager;
import com.clevertap.android.sdk.network.NetworkHeadersListener;
import com.clevertap.android.sdk.network.NetworkRepo;
import com.clevertap.android.sdk.network.QueueHeaderBuilder;
import com.clevertap.android.sdk.network.api.CtApi;
import com.clevertap.android.sdk.network.api.CtApiWrapper;
import com.clevertap.android.sdk.network.api.DefineTemplatesRequestBody;
import com.clevertap.android.sdk.network.api.EncryptedSendQueueRequestBody;
import com.clevertap.android.sdk.network.api.EncryptionFailure;
import com.clevertap.android.sdk.network.api.EncryptionResult;
import com.clevertap.android.sdk.network.api.EncryptionSuccess;
import com.clevertap.android.sdk.network.api.SendQueueRequestBody;
import com.clevertap.android.sdk.network.http.Response;
import com.clevertap.android.sdk.pushnotification.PushNotificationUtil;
import com.clevertap.android.sdk.response.ARPResponse;
import com.clevertap.android.sdk.response.ClevertapResponseHandler;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.Task;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u001f\b\u0000\u0018\u0000 p2\u00020\u0001:\u0001pBy\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\b\b\u0002\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020&J\u000e\u0010*\u001a\u00020(2\u0006\u0010)\u001a\u00020&J(\u0010+\u001a\u00020(2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u000201J\u0006\u00102\u001a\u00020!J\u0018\u00103\u001a\u00020(2\u0006\u0010,\u001a\u00020-2\u0006\u00104\u001a\u000205H\u0007J\u0010\u00106\u001a\u0002012\u0006\u0010,\u001a\u00020-H\u0007J\u0012\u0010:\u001a\u0004\u0018\u00010/2\u0006\u0010,\u001a\u00020-H\u0007J\u0010\u0010;\u001a\u0002012\u0006\u0010<\u001a\u00020/H\u0002J\u0014\u0010=\u001a\u0004\u0018\u00010>2\b\u0010.\u001a\u0004\u0018\u00010/H\u0002J\u0018\u0010?\u001a\u00020(2\u0006\u0010,\u001a\u00020-2\u0006\u00104\u001a\u000205H\u0007J\u0010\u0010@\u001a\u00020(2\u0006\u0010A\u001a\u00020BH\u0003J\u0010\u0010C\u001a\u0002012\u0006\u0010A\u001a\u00020BH\u0002J4\u0010D\u001a\u0002012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010,\u001a\u00020-2\b\u0010E\u001a\u0004\u0018\u00010F2\b\u0010.\u001a\u0004\u0018\u00010/2\b\b\u0002\u00100\u001a\u000201J.\u0010G\u001a\u0002012\u0006\u0010,\u001a\u00020-2\u0006\u0010H\u001a\u00020I2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020(0K2\u0006\u00100\u001a\u000201H\u0002J\u0018\u0010L\u001a\u00020(2\u0006\u0010H\u001a\u00020I2\u0006\u0010M\u001a\u00020NH\u0002J\u0016\u0010O\u001a\u0002012\f\u0010P\u001a\b\u0012\u0004\u0012\u00020R0QH\u0007J\u001a\u0010S\u001a\u00020(2\b\u0010T\u001a\u0004\u0018\u00010>2\u0006\u0010M\u001a\u00020NH\u0002J\u0012\u0010U\u001a\u0004\u0018\u00010>2\u0006\u0010V\u001a\u00020/H\u0007J\u0018\u0010W\u001a\u00020B2\u0006\u0010,\u001a\u00020-2\u0006\u0010X\u001a\u00020IH\u0003J\u0010\u0010Y\u001a\u00020B2\u0006\u0010X\u001a\u00020IH\u0002J\u0010\u0010Z\u001a\u00020B2\u0006\u0010X\u001a\u00020IH\u0002J\u0010\u0010[\u001a\u0002012\u0006\u0010A\u001a\u00020BH\u0002J\u0018\u0010\\\u001a\u00020(2\u0006\u0010A\u001a\u00020B2\u0006\u0010]\u001a\u00020/H\u0002J\u0010\u0010^\u001a\u00020(2\u0006\u0010A\u001a\u00020BH\u0002J\u0010\u0010_\u001a\u0002012\u0006\u0010A\u001a\u00020BH\u0003J.\u0010`\u001a\u0002012\u0006\u0010A\u001a\u00020B2\u0006\u0010a\u001a\u0002012\f\u0010J\u001a\b\u0012\u0004\u0012\u00020(0K2\u0006\u00100\u001a\u000201H\u0003J\u000e\u0010b\u001a\u0002012\u0006\u0010A\u001a\u00020BJ\u0010\u0010c\u001a\u00020(2\u0006\u0010A\u001a\u00020BH\u0002J\u0010\u0010d\u001a\u0002012\u0006\u0010X\u001a\u00020IH\u0002J\u0010\u0010e\u001a\u00020(2\u0006\u0010E\u001a\u00020FH\u0002J\u0010\u0010f\u001a\u00020(2\u0006\u0010g\u001a\u00020/H\u0002J\u0012\u0010h\u001a\u00020(2\b\u0010i\u001a\u0004\u0018\u00010/H\u0003J\u0010\u0010j\u001a\u00020(2\u0006\u0010k\u001a\u00020!H\u0002J\u0010\u0010l\u001a\u00020(2\u0006\u0010m\u001a\u00020/H\u0003J\u0010\u0010n\u001a\u00020(2\u0006\u0010o\u001a\u000201H\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00107\u001a\u00020!8G\u00a2\u0006\u0006\u001a\u0004\b8\u00109\u00a8\u0006q"}, d2={"Lcom/clevertap/android/sdk/network/NetworkManager;", "", "context", "Landroid/content/Context;", "config", "Lcom/clevertap/android/sdk/CleverTapInstanceConfig;", "deviceInfo", "Lcom/clevertap/android/sdk/DeviceInfo;", "coreMetaData", "Lcom/clevertap/android/sdk/CoreMetaData;", "controllerManager", "Lcom/clevertap/android/sdk/ControllerManager;", "databaseManager", "Lcom/clevertap/android/sdk/db/BaseDatabaseManager;", "callbackManager", "Lcom/clevertap/android/sdk/BaseCallbackManager;", "ctApiWrapper", "Lcom/clevertap/android/sdk/network/api/CtApiWrapper;", "encryptionManager", "Lcom/clevertap/android/sdk/network/NetworkEncryptionManager;", "arpResponse", "Lcom/clevertap/android/sdk/response/ARPResponse;", "networkRepo", "Lcom/clevertap/android/sdk/network/NetworkRepo;", "queueHeaderBuilder", "Lcom/clevertap/android/sdk/network/QueueHeaderBuilder;", "cleverTapResponseHandler", "Lcom/clevertap/android/sdk/response/ClevertapResponseHandler;", "logger", "Lcom/clevertap/android/sdk/ILogger;", "<init>", "(Landroid/content/Context;Lcom/clevertap/android/sdk/CleverTapInstanceConfig;Lcom/clevertap/android/sdk/DeviceInfo;Lcom/clevertap/android/sdk/CoreMetaData;Lcom/clevertap/android/sdk/ControllerManager;Lcom/clevertap/android/sdk/db/BaseDatabaseManager;Lcom/clevertap/android/sdk/BaseCallbackManager;Lcom/clevertap/android/sdk/network/api/CtApiWrapper;Lcom/clevertap/android/sdk/network/NetworkEncryptionManager;Lcom/clevertap/android/sdk/response/ARPResponse;Lcom/clevertap/android/sdk/network/NetworkRepo;Lcom/clevertap/android/sdk/network/QueueHeaderBuilder;Lcom/clevertap/android/sdk/response/ClevertapResponseHandler;Lcom/clevertap/android/sdk/ILogger;)V", "responseFailureCount", "", "networkRetryCount", "minDelayFrequency", "mNetworkHeadersListeners", "", "Lcom/clevertap/android/sdk/network/NetworkHeadersListener;", "addNetworkHeadersListener", "", "listener", "removeNetworkHeadersListener", "flushDBQueue", "eventGroup", "Lcom/clevertap/android/sdk/events/EventGroup;", "caller", "", "isUserSwitchFlush", "", "getDelayFrequency", "initHandshake", "handshakeSuccessCallback", "Ljava/lang/Runnable;", "needsHandshakeForDomain", "currentRequestTimestamp", "getCurrentRequestTimestamp", "()I", "getDomain", "hasDomainChanged", "newDomain", "getQueueHeader", "Lorg/json/JSONObject;", "performHandshakeForDomain", "saveDomainChanges", "response", "Lcom/clevertap/android/sdk/network/http/Response;", "shouldMuteSdk", "sendQueue", "queue", "Lorg/json/JSONArray;", "networkCall", "requestBody", "Lcom/clevertap/android/sdk/network/api/SendQueueRequestBody;", "notifyNetworkHeaderListeners", "Lkotlin/Function0;", "notifyHeaderListeners", "endpointId", "Lcom/clevertap/android/sdk/network/EndpointId;", "defineTemplates", "templates", "", "Lcom/clevertap/android/sdk/inapp/customtemplates/CustomTemplate;", "applyQueueHeaderListeners", "queueHeader", "fetchInAppPreviewPayloadFromUrl", "url", "callApiForEventGroup", "body", "sendQueueApi", "sendImpressionsApi", "handleVariablesResponse", "handleVarsOrTemplatesResponseError", "logTag", "handleTemplateResponseSuccess", "handlePushImpressionsResponse", "handleSendQueueResponse", "isFullResponse", "abortDueToDomainChange", "handleSendQueueResponseError", "doesBodyContainAppLaunchedOrFetchEvents", "notifyListenersForPushImpressionSentToServer", "notifyListenerForPushImpressionSentToServer", "listenerKey", "setDomain", "domainName", "setFirstRequestTimestampIfNeeded", "ts", "setSpikyDomain", "spikyDomainName", "setMuted", "mute", "Companion", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nNetworkManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkManager.kt\ncom/clevertap/android/sdk/network/NetworkManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,780:1\n1#2:781\n*E\n"})
public final class NetworkManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final CleverTapInstanceConfig config;
    @NotNull
    private final DeviceInfo deviceInfo;
    @NotNull
    private final CoreMetaData coreMetaData;
    @NotNull
    private final ControllerManager controllerManager;
    @NotNull
    private final BaseDatabaseManager databaseManager;
    @NotNull
    private final BaseCallbackManager callbackManager;
    @NotNull
    private final CtApiWrapper ctApiWrapper;
    @NotNull
    private final NetworkEncryptionManager encryptionManager;
    @NotNull
    private final ARPResponse arpResponse;
    @NotNull
    private final NetworkRepo networkRepo;
    @NotNull
    private final QueueHeaderBuilder queueHeaderBuilder;
    @NotNull
    private final ClevertapResponseHandler cleverTapResponseHandler;
    @NotNull
    private final ILogger logger;
    private int responseFailureCount;
    private int networkRetryCount;
    private int minDelayFrequency;
    @NotNull
    private final List<NetworkHeadersListener> mNetworkHeadersListeners;
    private static final int BATCH_SIZE = 50;

    public NetworkManager(@NotNull Context context, @NotNull CleverTapInstanceConfig config, @NotNull DeviceInfo deviceInfo, @NotNull CoreMetaData coreMetaData, @NotNull ControllerManager controllerManager, @NotNull BaseDatabaseManager databaseManager2, @NotNull BaseCallbackManager callbackManager, @NotNull CtApiWrapper ctApiWrapper, @NotNull NetworkEncryptionManager encryptionManager, @NotNull ARPResponse arpResponse, @NotNull NetworkRepo networkRepo, @NotNull QueueHeaderBuilder queueHeaderBuilder2, @NotNull ClevertapResponseHandler cleverTapResponseHandler, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)deviceInfo, (String)"deviceInfo");
        Intrinsics.checkNotNullParameter((Object)coreMetaData, (String)"coreMetaData");
        Intrinsics.checkNotNullParameter((Object)controllerManager, (String)"controllerManager");
        Intrinsics.checkNotNullParameter((Object)databaseManager2, (String)"databaseManager");
        Intrinsics.checkNotNullParameter((Object)callbackManager, (String)"callbackManager");
        Intrinsics.checkNotNullParameter((Object)ctApiWrapper, (String)"ctApiWrapper");
        Intrinsics.checkNotNullParameter((Object)encryptionManager, (String)"encryptionManager");
        Intrinsics.checkNotNullParameter((Object)arpResponse, (String)"arpResponse");
        Intrinsics.checkNotNullParameter((Object)networkRepo, (String)"networkRepo");
        Intrinsics.checkNotNullParameter((Object)queueHeaderBuilder2, (String)"queueHeaderBuilder");
        Intrinsics.checkNotNullParameter((Object)cleverTapResponseHandler, (String)"cleverTapResponseHandler");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.context = context;
        this.config = config;
        this.deviceInfo = deviceInfo;
        this.coreMetaData = coreMetaData;
        this.controllerManager = controllerManager;
        this.databaseManager = databaseManager2;
        this.callbackManager = callbackManager;
        this.ctApiWrapper = ctApiWrapper;
        this.encryptionManager = encryptionManager;
        this.arpResponse = arpResponse;
        this.networkRepo = networkRepo;
        this.queueHeaderBuilder = queueHeaderBuilder2;
        this.cleverTapResponseHandler = cleverTapResponseHandler;
        this.logger = logger;
        this.mNetworkHeadersListeners = new ArrayList();
    }

    public /* synthetic */ NetworkManager(Context context, CleverTapInstanceConfig cleverTapInstanceConfig, DeviceInfo deviceInfo, CoreMetaData coreMetaData, ControllerManager controllerManager, BaseDatabaseManager baseDatabaseManager, BaseCallbackManager baseCallbackManager, CtApiWrapper ctApiWrapper, NetworkEncryptionManager networkEncryptionManager, ARPResponse aRPResponse, NetworkRepo networkRepo, QueueHeaderBuilder queueHeaderBuilder2, ClevertapResponseHandler clevertapResponseHandler, ILogger iLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x2000) != 0) {
            iLogger = cleverTapInstanceConfig.getLogger();
        }
        this(context, cleverTapInstanceConfig, deviceInfo, coreMetaData, controllerManager, baseDatabaseManager, baseCallbackManager, ctApiWrapper, networkEncryptionManager, aRPResponse, networkRepo, queueHeaderBuilder2, clevertapResponseHandler, iLogger);
    }

    public final void addNetworkHeadersListener(@NotNull NetworkHeadersListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.mNetworkHeadersListeners.add(listener);
    }

    public final void removeNetworkHeadersListener(@NotNull NetworkHeadersListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.mNetworkHeadersListeners.remove(listener);
    }

    public final void flushDBQueue(@NotNull Context context, @NotNull EventGroup eventGroup, @Nullable String caller, boolean isUserSwitchFlush) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)eventGroup), (String)"eventGroup");
        this.config.getLogger().verbose(this.config.getAccountId(), "Starting queue flush to CleverTap servers");
        boolean continueProcessing = true;
        int totalEventsSent = 0;
        while (continueProcessing) {
            QueueData queueData = this.databaseManager.getQueuedEvents(context, 50, eventGroup);
            if (queueData.isEmpty$clevertap_core_release()) {
                this.config.getLogger().verbose(this.config.getAccountId(), "No more events in queue");
                break;
            }
            JSONArray queue = queueData.getData$clevertap_core_release();
            int batchSize = queue.length();
            this.config.getLogger().verbose(this.config.getAccountId(), "Processing batch of " + batchSize + " events (" + queueData.getEventIds$clevertap_core_release().size() + " from events, " + queueData.getProfileEventIds$clevertap_core_release().size() + " from profile)");
            boolean networkCallSuccess = this.sendQueue(context, eventGroup, queue, caller, isUserSwitchFlush);
            if (!networkCallSuccess) {
                this.config.getLogger().verbose(this.config.getAccountId(), "Failed to send batch - will retry later");
                this.controllerManager.invokeCallbacksForNetworkError();
                this.controllerManager.invokeBatchListener(queue, false);
                break;
            }
            this.controllerManager.invokeBatchListener(queue, true);
            totalEventsSent += batchSize;
            if (eventGroup == EventGroup.PUSH_NOTIFICATION_VIEWED) {
                this.databaseManager.cleanupPushNotificationEvents(context, queueData.getEventIds$clevertap_core_release());
                this.notifyListenersForPushImpressionSentToServer(queueData.getData$clevertap_core_release());
            } else {
                this.databaseManager.cleanupSentEvents(context, queueData.getEventIds$clevertap_core_release(), queueData.getProfileEventIds$clevertap_core_release());
            }
            continueProcessing = queueData.getHasMore$clevertap_core_release();
        }
        this.config.getLogger().verbose(this.config.getAccountId(), "Queue flush completed. Total events sent: " + totalEventsSent);
    }

    public final int getDelayFrequency() {
        this.minDelayFrequency = this.networkRepo.getMinDelayFrequency(this.minDelayFrequency, this.networkRetryCount);
        this.logger.debug(this.config.getAccountId(), "Setting delay frequency to " + this.minDelayFrequency);
        return this.minDelayFrequency;
    }

    @WorkerThread
    public final void initHandshake(@NotNull EventGroup eventGroup, @NotNull Runnable handshakeSuccessCallback) {
        Intrinsics.checkNotNullParameter((Object)((Object)eventGroup), (String)"eventGroup");
        Intrinsics.checkNotNullParameter((Object)handshakeSuccessCallback, (String)"handshakeSuccessCallback");
        this.responseFailureCount = 0;
        this.performHandshakeForDomain(eventGroup, handshakeSuccessCallback);
    }

    @WorkerThread
    public final boolean needsHandshakeForDomain(@NotNull EventGroup eventGroup) {
        boolean needHandshakeDueToFailure;
        Intrinsics.checkNotNullParameter((Object)((Object)eventGroup), (String)"eventGroup");
        boolean needsHandshake = this.ctApiWrapper.needsHandshake(eventGroup == EventGroup.PUSH_NOTIFICATION_VIEWED);
        boolean bl = needHandshakeDueToFailure = this.responseFailureCount > 5;
        if (needHandshakeDueToFailure) {
            this.setDomain(null);
        }
        return needsHandshake || needHandshakeDueToFailure;
    }

    @WorkerThread
    public final int getCurrentRequestTimestamp() {
        return this.ctApiWrapper.getCtApi().getCurrentRequestTimestampSeconds();
    }

    @WorkerThread
    @Nullable
    public final String getDomain(@NotNull EventGroup eventGroup) {
        Intrinsics.checkNotNullParameter((Object)((Object)eventGroup), (String)"eventGroup");
        return this.ctApiWrapper.getCtApi().getActualDomain(eventGroup == EventGroup.PUSH_NOTIFICATION_VIEWED);
    }

    private final boolean hasDomainChanged(String newDomain) {
        String oldDomain = this.networkRepo.getDomain();
        return !Intrinsics.areEqual((Object)newDomain, (Object)oldDomain);
    }

    private final JSONObject getQueueHeader(String caller) {
        return this.queueHeaderBuilder.buildHeader(caller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void performHandshakeForDomain(@NotNull EventGroup eventGroup, @NotNull Runnable handshakeSuccessCallback) {
        Intrinsics.checkNotNullParameter((Object)((Object)eventGroup), (String)"eventGroup");
        Intrinsics.checkNotNullParameter((Object)handshakeSuccessCallback, (String)"handshakeSuccessCallback");
        try {
            Closeable closeable = this.ctApiWrapper.getCtApi().performHandshakeForDomain(eventGroup == EventGroup.PUSH_NOTIFICATION_VIEWED);
            Throwable throwable = null;
            try {
                Response response = (Response)closeable;
                boolean bl = false;
                if (response.isSuccess()) {
                    this.logger.verbose(this.config.getAccountId(), "Received success from handshake :)");
                    if (this.shouldMuteSdk(response)) {
                        return;
                    }
                    this.saveDomainChanges(response);
                    this.logger.verbose(this.config.getAccountId(), "We are not muted");
                    handshakeSuccessCallback.run();
                } else {
                    this.logger.verbose(this.config.getAccountId(), "Invalid HTTP status code received for handshake - " + response.getCode());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            this.logger.verbose(this.config.getAccountId(), "Failed to perform handshake!", e);
        }
    }

    @WorkerThread
    private final void saveDomainChanges(Response response) {
        String domainName = response.getHeaderValue("X-WZRK-RD");
        Logger.v("Getting domain from header - " + domainName);
        CharSequence charSequence = domainName;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        String spikyDomainName = response.getHeaderValue("X-WZRK-SPIKY-RD");
        Logger.v("Getting spiky domain from header - " + spikyDomainName);
        this.setMuted(false);
        this.setDomain(domainName);
        Logger.v("Setting spiky domain from header as -" + spikyDomainName);
        if (spikyDomainName == null) {
            this.setSpikyDomain(domainName);
        } else {
            this.setSpikyDomain(spikyDomainName);
        }
    }

    private final boolean shouldMuteSdk(Response response) {
        block2: {
            String string2;
            String string3;
            String string4;
            String string5 = response.getHeaderValue("X-WZRK-MUTE");
            if (string5 == null || (string4 = ((Object)StringsKt.trim((CharSequence)string5)).toString()) == null) break block2;
            String it = string3 = string4;
            boolean bl = false;
            String string6 = string2 = ((CharSequence)it).length() > 0 ? string3 : null;
            if (string2 != null) {
                String muteCommand = string2;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)muteCommand, (Object)"true")) {
                    this.setMuted(true);
                    return true;
                }
                this.setMuted(false);
            }
        }
        return false;
    }

    public final boolean sendQueue(@NotNull Context context, @NotNull EventGroup eventGroup, @Nullable JSONArray queue, @Nullable String caller, boolean isUserSwitchFlush) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)eventGroup), (String)"eventGroup");
        if (queue == null || queue.length() <= 0) {
            return false;
        }
        if (this.deviceInfo.getDeviceID() == null) {
            this.logger.debug(this.config.getAccountId(), "CleverTap Id not finalized, unable to send queue");
            return false;
        }
        EndpointId endpointId = EndpointId.Companion.fromEventGroup(eventGroup);
        JSONObject queueHeader = this.getQueueHeader(caller);
        this.applyQueueHeaderListeners(queueHeader, endpointId);
        SendQueueRequestBody requestBody = new SendQueueRequestBody(queueHeader, queue);
        this.logger.debug(this.config.getAccountId(), "Send queue contains " + queue.length() + " items: " + requestBody);
        try {
            Function0 headersDoneListener = () -> NetworkManager.sendQueue$lambda$3(this, requestBody, endpointId);
            return this.networkCall(eventGroup, requestBody, (Function0<Unit>)headersDoneListener, isUserSwitchFlush);
        }
        catch (Exception e) {
            int n = this.networkRetryCount;
            this.networkRetryCount = n + 1;
            n = this.responseFailureCount;
            this.responseFailureCount = n + 1;
            this.logger.debug(this.config.getAccountId(), "An exception occurred while sending the queue, will retry: ", e);
            if (this.callbackManager.getFailureFlushListener() != null) {
                this.callbackManager.getFailureFlushListener().failureFlush(context);
            }
            return false;
        }
    }

    public static /* synthetic */ boolean sendQueue$default(NetworkManager networkManager, Context context, EventGroup eventGroup, JSONArray jSONArray, String string2, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return networkManager.sendQueue(context, eventGroup, jSONArray, string2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean networkCall(EventGroup eventGroup, SendQueueRequestBody requestBody, Function0<Unit> notifyNetworkHeaderListeners, boolean isUserSwitchFlush) {
        Closeable closeable = this.callApiForEventGroup(eventGroup, requestBody);
        Throwable throwable = null;
        try {
            boolean bl;
            Response response = (Response)closeable;
            boolean bl2 = false;
            this.networkRetryCount = 0;
            switch (WhenMappings.$EnumSwitchMapping$0[eventGroup.ordinal()]) {
                case 1: {
                    bl = this.handleVariablesResponse(response);
                    break;
                }
                case 2: {
                    boolean bl3;
                    boolean isProcessed = bl3 = this.handleSendQueueResponse(response, this.doesBodyContainAppLaunchedOrFetchEvents(requestBody), notifyNetworkHeaderListeners, isUserSwitchFlush);
                    boolean bl4 = false;
                    this.responseFailureCount = isProcessed ? 0 : this.responseFailureCount + 1;
                    bl = bl3;
                    break;
                }
                case 3: {
                    boolean bl3;
                    boolean isProcessed = bl3 = this.handlePushImpressionsResponse(response);
                    boolean bl5 = false;
                    this.responseFailureCount = isProcessed ? 0 : this.responseFailureCount + 1;
                    bl = bl3;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            boolean bl6 = bl;
            return bl6;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void notifyHeaderListeners(SendQueueRequestBody requestBody, EndpointId endpointId) {
        if (requestBody.getQueueHeader() != null) {
            for (NetworkHeadersListener listener : this.mNetworkHeadersListeners) {
                listener.onSentHeaders(requestBody.getQueueHeader(), endpointId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final boolean defineTemplates(@NotNull Collection<CustomTemplate> templates) {
        Intrinsics.checkNotNullParameter(templates, (String)"templates");
        JSONObject jSONObject = this.getQueueHeader(null);
        if (jSONObject == null) {
            return false;
        }
        JSONObject header = jSONObject;
        DefineTemplatesRequestBody body = new DefineTemplatesRequestBody(header, templates);
        this.logger.debug(this.config.getAccountId(), "Will define templates: " + body);
        try {
            Closeable closeable = this.ctApiWrapper.getCtApi().defineTemplates(body);
            Throwable throwable = null;
            try {
                Response response = (Response)closeable;
                boolean bl = false;
                if (response.isSuccess()) {
                    this.handleTemplateResponseSuccess(response);
                    boolean bl2 = true;
                    return bl2;
                }
                this.handleVarsOrTemplatesResponseError(response, "CustomTemplates");
                boolean bl3 = false;
                return bl3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            this.logger.debug(this.config.getAccountId(), "An exception occurred while defining templates.", e);
            return false;
        }
    }

    private final void applyQueueHeaderListeners(JSONObject queueHeader, EndpointId endpointId) {
        if (queueHeader != null) {
            for (NetworkHeadersListener listener : this.mNetworkHeadersListeners) {
                JSONObject headersToAttach = listener.onAttachHeaders(endpointId);
                if (headersToAttach == null) continue;
                CTXtensions.copyFrom(queueHeader, headersToAttach);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @Nullable
    public final JSONObject fetchInAppPreviewPayloadFromUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            Closeable closeable = this.ctApiWrapper.getCtApi().fetchFromUrl(url);
            Throwable throwable = null;
            try {
                Response response = (Response)closeable;
                boolean bl = false;
                if (response.isSuccess()) {
                    JSONObject bodyJson;
                    String bodyString = response.readBody();
                    JSONObject jSONObject = bodyJson = CTXtensions.toJsonOrNull(bodyString);
                    return jSONObject;
                }
                this.logger.debug(this.config.getAccountId(), "Failed to fetch inapp payload. Response code: " + response.getCode());
                JSONObject jSONObject = null;
                return jSONObject;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            this.logger.debug(this.config.getAccountId(), "An exception occurred while fetching the inapp payload from URL", e);
            return null;
        }
    }

    @WorkerThread
    private final Response callApiForEventGroup(EventGroup eventGroup, SendQueueRequestBody body) {
        Response response;
        switch (WhenMappings.$EnumSwitchMapping$0[eventGroup.ordinal()]) {
            case 1: {
                response = this.ctApiWrapper.getCtApi().defineVars(body);
                break;
            }
            case 2: {
                response = this.sendQueueApi(body);
                break;
            }
            case 3: {
                response = this.sendImpressionsApi(body);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return response;
    }

    private final Response sendQueueApi(SendQueueRequestBody body) {
        if (this.config.isEncryptionInTransitEnabled() && !this.coreMetaData.isRelaxNetwork()) {
            EncryptionResult encryptionResult = this.encryptionManager.encryptResponse(body.toString());
            String sessionEncryptionKey = this.encryptionManager.sessionEncryptionKey();
            if (encryptionResult instanceof EncryptionSuccess) {
                String string2 = ((EncryptionSuccess)encryptionResult).getData();
                Intrinsics.checkNotNull((Object)sessionEncryptionKey);
                String bodyEnc = new EncryptedSendQueueRequestBody(string2, sessionEncryptionKey, ((EncryptionSuccess)encryptionResult).getIv()).toJsonString();
                this.logger.verbose("Encrypted Request = " + bodyEnc);
                return this.ctApiWrapper.getCtApi().sendQueue(bodyEnc, true);
            }
            this.logger.verbose("Normal Request cause encryption failed = " + body);
        }
        return CtApi.sendQueue$default(this.ctApiWrapper.getCtApi(), body.toString(), false, 2, null);
    }

    private final Response sendImpressionsApi(SendQueueRequestBody body) {
        return this.ctApiWrapper.getCtApi().sendImpressions(body.toString());
    }

    private final boolean handleVariablesResponse(Response response) {
        if (response.isSuccess()) {
            String bodyString = response.readBody();
            JSONObject bodyJson = CTXtensions.toJsonOrNull(bodyString);
            this.logger.verbose(this.config.getAccountId(), "Processing variables response : " + bodyJson);
            this.arpResponse.processResponse(bodyJson, bodyString, this.context);
            return true;
        }
        this.handleVarsOrTemplatesResponseError(response, "Variables");
        return false;
    }

    private final void handleVarsOrTemplatesResponseError(Response response, String logTag) {
        switch (response.getCode()) {
            case 400: {
                JSONObject errorStreamJson = CTXtensions.toJsonOrNull(response.readBody());
                if (errorStreamJson != null && !TextUtils.isEmpty((CharSequence)errorStreamJson.optString("error"))) {
                    String errorMessage = errorStreamJson.optString("error");
                    this.logger.info(logTag, "Error while syncing: " + errorMessage);
                } else {
                    this.logger.info(logTag, "Error while syncing.");
                }
                return;
            }
            case 401: {
                this.logger.info(logTag, "Unauthorized access from a non-test profile. Please mark this profile as a test profile from the CleverTap dashboard.");
                return;
            }
        }
        this.logger.info(logTag, "Response code " + response.getCode() + " while syncing.");
    }

    private final void handleTemplateResponseSuccess(Response response) {
        String warnings;
        this.logger.info(this.config.getAccountId(), "Custom templates defined successfully.");
        JSONObject body = CTXtensions.toJsonOrNull(response.readBody());
        if (body != null && !TextUtils.isEmpty((CharSequence)(warnings = body.optString("error")))) {
            this.logger.info(this.config.getAccountId(), "Custom templates warnings: " + warnings);
        }
    }

    @WorkerThread
    private final boolean handlePushImpressionsResponse(Response response) {
        if (!response.isSuccess()) {
            this.logger.info("Received error response code: " + response.getCode());
            return false;
        }
        if (this.abortDueToDomainChange(response) || this.shouldMuteSdk(response)) {
            return false;
        }
        this.saveDomainChanges(response);
        this.logger.debug(this.config.getAccountId(), "Push Impressions sent successfully");
        this.networkRepo.setLastRequestTs(this.getCurrentRequestTimestamp());
        this.setFirstRequestTimestampIfNeeded(this.getCurrentRequestTimestamp());
        this.logger.verbose(this.config.getAccountId(), "Processing response : " + CTXtensions.toJsonOrNull(response.readBody()));
        return true;
    }

    @WorkerThread
    private final boolean handleSendQueueResponse(Response response, boolean isFullResponse, Function0<Unit> notifyNetworkHeaderListeners, boolean isUserSwitchFlush) {
        if (!response.isSuccess()) {
            this.handleSendQueueResponseError(response);
            return false;
        }
        if (this.abortDueToDomainChange(response) || this.shouldMuteSdk(response)) {
            return false;
        }
        this.coreMetaData.setFreshAppLaunchSent();
        this.saveDomainChanges(response);
        notifyNetworkHeaderListeners.invoke();
        this.logger.debug(this.config.getAccountId(), "Queue sent successfully");
        this.networkRepo.setLastRequestTs(this.getCurrentRequestTimestamp());
        this.setFirstRequestTimestampIfNeeded(this.getCurrentRequestTimestamp());
        String bodyString = response.readBody();
        JSONObject bodyJson = CTXtensions.toJsonOrNull(bodyString);
        this.logger.verbose(this.config.getAccountId(), "Processing response : " + bodyJson);
        CharSequence charSequence = bodyString;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || bodyJson == null) {
            return true;
        }
        boolean isEncryptedResponse = Boolean.parseBoolean(response.getHeaderValue("X-CleverTap-Encryption-Enabled"));
        if (isEncryptedResponse) {
            EncryptionResult decryptResponse = this.encryptionManager.decryptResponse(bodyString);
            if (decryptResponse instanceof EncryptionFailure) {
                this.logger.verbose(this.config.getAccountId(), "Failed to decrypt response");
                return false;
            }
            if (decryptResponse instanceof EncryptionSuccess) {
                bodyString = ((EncryptionSuccess)decryptResponse).getData();
                bodyJson = CTXtensions.toJsonOrNull(bodyString);
                this.logger.verbose("Decrypted response = " + bodyString);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.cleverTapResponseHandler.handleResponse(isFullResponse, bodyJson, bodyString, isUserSwitchFlush);
        return true;
    }

    public final boolean abortDueToDomainChange(@NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String newDomain = response.getHeaderValue("X-WZRK-RD");
        if (CTXtensions.isNotNullAndBlank(newDomain) && this.hasDomainChanged(newDomain)) {
            this.setDomain(newDomain);
            this.logger.debug(this.config.getAccountId(), "The domain has changed to " + newDomain + ". The request will be retried shortly.");
            return true;
        }
        return false;
    }

    private final void handleSendQueueResponseError(Response response) {
        this.logger.info("Received error response code: " + response.getCode());
        switch (response.getCode()) {
            case 419: {
                this.logger.verbose("There is decryption failure on backend, disabling encrypted requests.");
                this.coreMetaData.setRelaxNetwork(true);
                break;
            }
            case 402: {
                this.logger.verbose("Encryption in transit feature on not enabled for your account, please contact Clevertap support.");
                this.coreMetaData.setRelaxNetwork(true);
            }
        }
    }

    private final boolean doesBodyContainAppLaunchedOrFetchEvents(SendQueueRequestBody body) {
        int n = body.getQueue().length();
        for (int index = 0; index < n; ++index) {
            try {
                String evtName;
                JSONObject event = body.getQueue().getJSONObject(index);
                String eventType = event.getString("type");
                if (!Intrinsics.areEqual((Object)"event", (Object)eventType) || !Intrinsics.areEqual((Object)"App Launched", (Object)(evtName = event.getString("evtName"))) && !Intrinsics.areEqual((Object)"wzrk_fetch", (Object)evtName)) continue;
                return true;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return false;
    }

    private final void notifyListenersForPushImpressionSentToServer(JSONArray queue) throws JSONException {
        int n = queue.length();
        for (int i = 0; i < n; ++i) {
            try {
                JSONObject notif = queue.getJSONObject(i).optJSONObject("evtData");
                if (notif == null) continue;
                String pushId = notif.optString("wzrk_pid");
                String pushAccountId = notif.optString("wzrk_acct_id");
                String string2 = PushNotificationUtil.buildPushNotificationRenderedListenerKey(pushAccountId, pushId);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"buildPushNotificationRenderedListenerKey(...)");
                this.notifyListenerForPushImpressionSentToServer(string2);
                continue;
            }
            catch (JSONException e) {
                this.logger.verbose(this.config.getAccountId(), "Encountered an exception while parsing the push notification viewed event queue");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.logger.verbose(this.config.getAccountId(), "push notification viewed event sent successfully");
    }

    private final void notifyListenerForPushImpressionSentToServer(String listenerKey) {
        NotificationRenderedListener notificationRenderedListener = CleverTapAPI.getNotificationRenderedListener(listenerKey);
        if (notificationRenderedListener != null) {
            this.logger.verbose(this.config.getAccountId(), "notifying listener " + listenerKey + ", that push impression sent successfully");
            notificationRenderedListener.onNotificationRendered(true);
        }
    }

    @WorkerThread
    private final void setDomain(String domainName) {
        this.logger.verbose(this.config.getAccountId(), "Setting domain to " + domainName);
        this.networkRepo.setDomain(domainName);
        this.ctApiWrapper.getCtApi().setCachedDomain(domainName);
        if (this.callbackManager.getSCDomainListener() != null) {
            if (domainName != null) {
                this.callbackManager.getSCDomainListener().onSCDomainAvailable(Utils.getSCDomain(domainName));
            } else {
                this.callbackManager.getSCDomainListener().onSCDomainUnavailable();
            }
        }
    }

    private final void setFirstRequestTimestampIfNeeded(int ts) {
        if (this.networkRepo.getFirstRequestTs() > 0) {
            return;
        }
        this.networkRepo.setFirstRequestTs(ts);
    }

    @WorkerThread
    private final void setSpikyDomain(String spikyDomainName) {
        this.logger.verbose(this.config.getAccountId(), "Setting spiky domain to " + spikyDomainName);
        this.networkRepo.setSpikyDomain(spikyDomainName);
        this.ctApiWrapper.getCtApi().setCachedSpikyDomain(spikyDomainName);
    }

    @WorkerThread
    private final void setMuted(boolean mute) {
        if (mute) {
            this.networkRepo.setMuted(true);
            this.networkRepo.setDomain(null);
            Task<Unit> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
            task.execute("CommsManager#setMuted", () -> NetworkManager.setMuted$lambda$9(this));
        } else {
            this.networkRepo.setMuted(false);
        }
    }

    private static final Unit sendQueue$lambda$3(NetworkManager this$0, SendQueueRequestBody $requestBody, EndpointId $endpointId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$requestBody, (String)"$requestBody");
        Intrinsics.checkNotNullParameter((Object)((Object)$endpointId), (String)"$endpointId");
        this$0.notifyHeaderListeners($requestBody, $endpointId);
        return Unit.INSTANCE;
    }

    private static final Unit setMuted$lambda$9(NetworkManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.databaseManager.clearQueues(this$0.context);
        return Unit.INSTANCE;
    }

    @JvmStatic
    public static final boolean isNetworkOnline(@NotNull Context context) {
        return Companion.isNetworkOnline(context);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/clevertap/android/sdk/network/NetworkManager$Companion;", "", "<init>", "()V", "BATCH_SIZE", "", "isNetworkOnline", "", "context", "Landroid/content/Context;", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isNetworkOnline(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            try {
                Object object = context.getSystemService("connectivity");
                ConnectivityManager connectivityManager = object instanceof ConnectivityManager ? (ConnectivityManager)object : null;
                if (connectivityManager == null) {
                    return true;
                }
                ConnectivityManager cm = connectivityManager;
                NetworkInfo netInfo = cm.getActiveNetworkInfo();
                return netInfo != null && netInfo.isConnected();
            }
            catch (Exception ignore) {
                return true;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EventGroup.values().length];
            try {
                nArray[EventGroup.VARIABLES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventGroup.REGULAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventGroup.PUSH_NOTIFICATION_VIEWED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

