/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.login;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.RestrictTo;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.cryption.EncryptionLevel;
import com.clevertap.android.sdk.cryption.ICryptHandler;
import com.clevertap.android.sdk.utils.CTJsonConverter;
import java.util.Iterator;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class LoginInfoProvider {
    private final CleverTapInstanceConfig config;
    private final Context context;
    private ICryptHandler cryptHandler;

    public LoginInfoProvider(Context context, CleverTapInstanceConfig config, ICryptHandler cryptHandler) {
        this.context = context;
        this.config = config;
        this.cryptHandler = cryptHandler;
    }

    public LoginInfoProvider(Context context, CleverTapInstanceConfig config) {
        this.context = context;
        this.config = config;
    }

    public void cacheGUIDForIdentifier(String guid, String key, String identifier) {
        if (guid == null || key == null || identifier == null) {
            return;
        }
        String cacheKey = key + "_" + identifier;
        JSONObject cache = this.getDecryptedCachedGUIDs();
        if (cache.optString(cacheKey).equals(guid)) {
            return;
        }
        try {
            cache.put(cacheKey, (Object)guid);
            this.setCachedGUIDsAndLength(cache.toString(), cache.length());
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Error caching guid: " + t);
        }
    }

    public void removeValueFromCachedGUIDForIdentifier(String guid, String key) {
        if (guid == null || key == null) {
            return;
        }
        JSONObject cachedGuidJsonObj = this.getDecryptedCachedGUIDs();
        try {
            Iterator i = cachedGuidJsonObj.keys();
            while (i.hasNext()) {
                String nextJSONObjKey = (String)i.next();
                String actualKeyInLowerCase = nextJSONObjKey.toLowerCase();
                if (!actualKeyInLowerCase.contains(key.toLowerCase()) || !cachedGuidJsonObj.getString(nextJSONObjKey).equals(guid)) continue;
                cachedGuidJsonObj.remove(nextJSONObjKey);
                this.setCachedGUIDsAndLength(cachedGuidJsonObj.toString(), cachedGuidJsonObj.length());
            }
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Error removing cached key: " + t);
        }
    }

    public boolean deviceIsMultiUser() {
        int cgkLength = this.getCachedGuidsLength();
        boolean deviceIsMultiUser = cgkLength > 1;
        this.config.log("ON_USER_LOGIN", "deviceIsMultiUser:[" + deviceIsMultiUser + "]");
        return deviceIsMultiUser;
    }

    private String getCachedGUIDStringFromPrefs() {
        String json = StorageHelper.getStringFromPrefs(this.context, this.config.getAccountId(), "cachedGUIDsKey", null);
        this.config.log("ON_USER_LOGIN", "getCachedGUIDs:[" + json + "]");
        return json;
    }

    public JSONObject getDecryptedCachedGUIDs() {
        String json = this.getCachedGUIDStringFromPrefs();
        if (json != null) {
            json = this.cryptHandler.decryptSafe(json);
        }
        return CTJsonConverter.toJsonObject(json, this.config.getLogger(), this.config.getAccountId());
    }

    public void setCachedGUIDsAndLength(String cachedGUIDs, int cgkLength) {
        if (cachedGUIDs == null) {
            return;
        }
        String saveString = null;
        if (EncryptionLevel.fromInt(this.config.getEncryptionLevel()) != EncryptionLevel.NONE && (saveString = this.cryptHandler.encryptSafe(cachedGUIDs)) == null) {
            this.cryptHandler.updateMigrationFailureCount(false);
        }
        if (saveString == null) {
            saveString = cachedGUIDs;
        }
        StorageHelper.putInt(this.context, this.config.getAccountId(), "cachedGUIDsLengthKey", cgkLength);
        this.config.log("ON_USER_LOGIN", "Storing size of cachedGUIDs: " + cgkLength);
        if (cgkLength == 0) {
            this.removeCachedGuidFromSharedPrefs();
            return;
        }
        StorageHelper.putString(this.context, this.config.getAccountId(), "cachedGUIDsKey", saveString);
        this.config.log("ON_USER_LOGIN", "setCachedGUIDs:[" + cachedGUIDs + "]");
    }

    private int getCachedGuidsLength() {
        int cgkLength = StorageHelper.getIntFromPrefs(this.context, this.config.getAccountId(), "cachedGUIDsLengthKey", 0);
        this.config.log("ON_USER_LOGIN", "Retrieved size of cachedGUIDs: " + cgkLength);
        return cgkLength;
    }

    public void removeCachedGuidFromSharedPrefs() {
        try {
            StorageHelper.remove(this.context, this.config.getAccountId(), "cachedGUIDsKey");
            this.config.log("ON_USER_LOGIN", "removeCachedGUIDs:[]");
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Error removing guid cache: " + t);
        }
    }

    public String getCachedIdentityKeysForAccount() {
        String cachedKeys = StorageHelper.getStringFromPrefs(this.context, this.config.getAccountId(), "SP_KEY_PROFILE_IDENTITIES", "");
        this.config.log("ON_USER_LOGIN", "getCachedIdentityKeysForAccount:" + cachedKeys);
        return cachedKeys;
    }

    public String getGUIDForIdentifier(String key, String identifier) {
        if (key == null || identifier == null) {
            return null;
        }
        String cacheKey = key + "_" + identifier;
        JSONObject cache = this.getDecryptedCachedGUIDs();
        try {
            String cachedGuid = cache.getString(cacheKey);
            this.config.log("ON_USER_LOGIN", "getGUIDForIdentifier:[Key:" + key + ", value:" + cachedGuid + "]");
            return cachedGuid;
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Error reading guid cache: " + t);
            return null;
        }
    }

    public boolean isAnonymousDevice() {
        int cgkLength = this.getCachedGuidsLength();
        boolean isAnonymousDevice = cgkLength == 0;
        this.config.log("ON_USER_LOGIN", "isAnonymousDevice:[" + isAnonymousDevice + "]");
        return isAnonymousDevice;
    }

    public boolean isLegacyProfileLoggedIn() {
        int cgkLength = this.getCachedGuidsLength();
        boolean isLoggedIn = cgkLength > 0 && TextUtils.isEmpty((CharSequence)this.getCachedIdentityKeysForAccount());
        this.config.log("ON_USER_LOGIN", "isLegacyProfileLoggedIn:" + isLoggedIn);
        return isLoggedIn;
    }

    public void saveIdentityKeysForAccount(String valueCommaSeparated) {
        StorageHelper.putString(this.context, this.config.getAccountId(), "SP_KEY_PROFILE_IDENTITIES", valueCommaSeparated);
        this.config.log("ON_USER_LOGIN", "saveIdentityKeysForAccount:" + valueCommaSeparated);
    }
}

