/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp.delay;

import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.ILogger;
import com.clevertap.android.sdk.inapp.delay.InAppDataExtractor;
import com.clevertap.android.sdk.inapp.delay.InAppScheduler;
import com.clevertap.android.sdk.inapp.delay.InAppSchedulingStrategy;
import com.clevertap.android.sdk.inapp.delay.InAppTimerManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u0000  *\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001 B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ*\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00120\u0017H\u0007J,\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00120\u0017H\u0003J\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u0012H\u0086@\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/clevertap/android/sdk/inapp/delay/InAppScheduler;", "T", "", "timerManager", "Lcom/clevertap/android/sdk/inapp/delay/InAppTimerManager;", "storageStrategy", "Lcom/clevertap/android/sdk/inapp/delay/InAppSchedulingStrategy;", "dataExtractor", "Lcom/clevertap/android/sdk/inapp/delay/InAppDataExtractor;", "logger", "Lcom/clevertap/android/sdk/ILogger;", "accountId", "", "<init>", "(Lcom/clevertap/android/sdk/inapp/delay/InAppTimerManager;Lcom/clevertap/android/sdk/inapp/delay/InAppSchedulingStrategy;Lcom/clevertap/android/sdk/inapp/delay/InAppDataExtractor;Lcom/clevertap/android/sdk/ILogger;Ljava/lang/String;)V", "getStorageStrategy$clevertap_core_release", "()Lcom/clevertap/android/sdk/inapp/delay/InAppSchedulingStrategy;", "schedule", "", "inApps", "", "Lorg/json/JSONObject;", "onComplete", "Lkotlin/Function1;", "scheduleWithTimer", "id", "delayInMs", "", "getActiveCount", "", "cancelAllScheduling", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nInAppScheduler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InAppScheduler.kt\ncom/clevertap/android/sdk/inapp/delay/InAppScheduler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n774#2:116\n865#2,2:117\n1863#2,2:119\n1863#2,2:121\n*S KotlinDebug\n*F\n+ 1 InAppScheduler.kt\ncom/clevertap/android/sdk/inapp/delay/InAppScheduler\n*L\n36#1:116\n36#1:117,2\n45#1:119,2\n53#1:121,2\n*E\n"})
public final class InAppScheduler<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InAppTimerManager timerManager;
    @NotNull
    private final InAppSchedulingStrategy storageStrategy;
    @NotNull
    private final InAppDataExtractor<T> dataExtractor;
    @NotNull
    private final ILogger logger;
    @NotNull
    private final String accountId;
    @NotNull
    private static final String TAG = "[InAppScheduler]:";

    public InAppScheduler(@NotNull InAppTimerManager timerManager, @NotNull InAppSchedulingStrategy storageStrategy, @NotNull InAppDataExtractor<T> dataExtractor, @NotNull ILogger logger, @NotNull String accountId) {
        Intrinsics.checkNotNullParameter((Object)timerManager, (String)"timerManager");
        Intrinsics.checkNotNullParameter((Object)storageStrategy, (String)"storageStrategy");
        Intrinsics.checkNotNullParameter(dataExtractor, (String)"dataExtractor");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        this.timerManager = timerManager;
        this.storageStrategy = storageStrategy;
        this.dataExtractor = dataExtractor;
        this.logger = logger;
        this.accountId = accountId;
    }

    @NotNull
    public final InAppSchedulingStrategy getStorageStrategy$clevertap_core_release() {
        return this.storageStrategy;
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public final void schedule(@NotNull List<? extends JSONObject> inApps, @NotNull Function1<? super T, Unit> onComplete) {
        String id2;
        JSONObject it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(inApps, (String)"inApps");
        Intrinsics.checkNotNullParameter(onComplete, (String)"onComplete");
        this.logger.verbose(this.accountId, "[InAppScheduler]: Scheduling " + inApps.size() + " in-apps");
        Iterable $this$filter$iv = inApps;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JSONObject jsonObject = (JSONObject)element$iv$iv;
            boolean bl = false;
            String id3 = jsonObject.optString("ti");
            Intrinsics.checkNotNull((Object)id3);
            if (!(!this.timerManager.isTimerScheduled(id3))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List newInApps = (List)destination$iv$iv;
        boolean prepared = this.storageStrategy.prepareForScheduling(newInApps);
        if (!prepared) {
            this.logger.verbose(this.accountId, "[InAppScheduler]: Failed to prepare in-apps for scheduling");
            Iterable $this$forEach$iv = newInApps;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (JSONObject)element$iv;
                boolean bl = false;
                id2 = it.optString("ti");
                Intrinsics.checkNotNull((Object)id2);
                onComplete.invoke(this.dataExtractor.createErrorResult(id2, "Preparation failed"));
            }
            return;
        }
        Iterable $this$forEach$iv = newInApps;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (JSONObject)element$iv;
            boolean bl = false;
            id2 = it.optString("ti");
            long delayInMs = this.dataExtractor.extractDelay(it);
            if (delayInMs <= 0L) continue;
            Intrinsics.checkNotNull((Object)id2);
            this.scheduleWithTimer(id2, delayInMs, onComplete);
        }
    }

    @WorkerThread
    private final void scheduleWithTimer(String id2, long delayInMs, Function1<? super T, Unit> onComplete) {
        this.timerManager.scheduleTimer(id2, delayInMs, (Function1<? super InAppTimerManager.TimerResult, Unit>)((Function1)arg_0 -> InAppScheduler.scheduleWithTimer$lambda$3(this, id2, onComplete, arg_0)));
    }

    public final int getActiveCount() {
        return this.timerManager.getActiveTimerCount();
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object cancelAllScheduling(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof cancelAllScheduling.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ InAppScheduler<T> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.cancelAllScheduling((Continuation<Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.timerManager.cleanup$clevertap_core_release((Continuation<? super Unit>)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (InAppScheduler)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                this.storageStrategy.clearAll();
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final Unit scheduleWithTimer$lambda$3(InAppScheduler this$0, String $id, Function1 $onComplete, InAppTimerManager.TimerResult timerResult) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
        Intrinsics.checkNotNullParameter((Object)$onComplete, (String)"$onComplete");
        Intrinsics.checkNotNullParameter((Object)timerResult, (String)"timerResult");
        InAppTimerManager.TimerResult timerResult2 = timerResult;
        if (timerResult2 instanceof InAppTimerManager.TimerResult.Completed) {
            JSONObject data = this$0.storageStrategy.retrieveAfterTimer($id);
            Object result = data != null ? this$0.dataExtractor.createSuccessResult($id, data) : this$0.dataExtractor.createErrorResult($id, "Data not found");
            $onComplete.invoke(result);
            this$0.storageStrategy.clear($id);
        } else if (timerResult2 instanceof InAppTimerManager.TimerResult.Error) {
            InAppDataExtractor inAppDataExtractor = this$0.dataExtractor;
            String string2 = ((InAppTimerManager.TimerResult.Error)timerResult).getException().getMessage();
            if (string2 == null) {
                string2 = "Unknown error";
            }
            $onComplete.invoke(inAppDataExtractor.createErrorResult($id, string2));
            this$0.storageStrategy.clear($id);
        } else if (timerResult2 instanceof InAppTimerManager.TimerResult.Discarded) {
            $onComplete.invoke(this$0.dataExtractor.createDiscardedResult($id));
            this$0.storageStrategy.clear($id);
            this$0.logger.verbose(this$0.accountId, "[InAppScheduler]: Timer discarded, cleaned up: " + $id);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/clevertap/android/sdk/inapp/delay/InAppScheduler$Companion;", "", "<init>", "()V", "TAG", "", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

