/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp;

import android.content.Context;
import android.os.Bundle;
import com.clevertap.android.sdk.CTXtensions;
import com.clevertap.android.sdk.ILogger;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.network.NetworkManager;
import com.clevertap.android.sdk.response.InAppResponse;
import com.clevertap.android.sdk.task.CTExecutors;
import com.clevertap.android.sdk.task.Task;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\u0013H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/clevertap/android/sdk/inapp/InAppPreviewHandler;", "", "executors", "Lcom/clevertap/android/sdk/task/CTExecutors;", "networkManager", "Lcom/clevertap/android/sdk/network/NetworkManager;", "inAppResponse", "Lcom/clevertap/android/sdk/response/InAppResponse;", "context", "Landroid/content/Context;", "logger", "Lcom/clevertap/android/sdk/ILogger;", "<init>", "(Lcom/clevertap/android/sdk/task/CTExecutors;Lcom/clevertap/android/sdk/network/NetworkManager;Lcom/clevertap/android/sdk/response/InAppResponse;Landroid/content/Context;Lcom/clevertap/android/sdk/ILogger;)V", "handleInAppPreview", "", "extras", "Landroid/os/Bundle;", "getPreviewPayload", "Lorg/json/JSONObject;", "shouldUseHalfInterstitial", "", "getHalfInterstitialInApp", "inapp", "wrapImageInterstitialContent", "", "content", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nInAppPreviewHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InAppPreviewHandler.kt\ncom/clevertap/android/sdk/inapp/InAppPreviewHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1#2:108\n*E\n"})
public final class InAppPreviewHandler {
    @NotNull
    private final CTExecutors executors;
    @NotNull
    private final NetworkManager networkManager;
    @NotNull
    private final InAppResponse inAppResponse;
    @NotNull
    private final Context context;
    @NotNull
    private final ILogger logger;

    public InAppPreviewHandler(@NotNull CTExecutors executors, @NotNull NetworkManager networkManager, @NotNull InAppResponse inAppResponse, @NotNull Context context, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)executors, (String)"executors");
        Intrinsics.checkNotNullParameter((Object)networkManager, (String)"networkManager");
        Intrinsics.checkNotNullParameter((Object)inAppResponse, (String)"inAppResponse");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.executors = executors;
        this.networkManager = networkManager;
        this.inAppResponse = inAppResponse;
        this.context = context;
        this.logger = logger;
    }

    public final void handleInAppPreview(@NotNull Bundle extras) {
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
        Task<Unit> task = this.executors.postAsyncSafelyTask();
        Intrinsics.checkNotNullExpressionValue(task, (String)"postAsyncSafelyTask(...)");
        Task<Unit> task2 = task;
        task2.execute("testInappNotification", () -> InAppPreviewHandler.handleInAppPreview$lambda$2(this, extras));
    }

    private final JSONObject getPreviewPayload(Bundle extras) {
        JSONObject jSONObject;
        JSONObject jSONObject2;
        String s3Url = extras.getString("wzrk_inapp_s3_url");
        if (CTXtensions.isNotNullAndBlank(s3Url) && (jSONObject2 = this.networkManager.fetchInAppPreviewPayloadFromUrl(s3Url)) != null) {
            JSONObject it = jSONObject2;
            boolean bl = false;
            return it;
        }
        String string2 = extras.getString("wzrk_inapp");
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            jSONObject = new JSONObject(it);
        } else {
            jSONObject = null;
        }
        return jSONObject;
    }

    private final boolean shouldUseHalfInterstitial(Bundle extras) {
        String type = extras.getString("wzrk_inapp_type");
        return Intrinsics.areEqual((Object)type, (Object)"image-interstitial") || Intrinsics.areEqual((Object)type, (Object)"advanced-builder");
    }

    private final JSONObject getHalfInterstitialInApp(JSONObject inapp) throws JSONException {
        String inAppConfig = inapp.optString("imageInterstitialConfig");
        Intrinsics.checkNotNull((Object)inAppConfig);
        String string2 = this.wrapImageInterstitialContent(inAppConfig);
        if (string2 == null) {
            InAppPreviewHandler $this$getHalfInterstitialInApp_u24lambda_u245 = this;
            boolean bl = false;
            $this$getHalfInterstitialInApp_u24lambda_u245.logger.debug("Failed to parse the image-interstitial notification");
            return null;
        }
        String htmlContent = string2;
        inapp.put("type", (Object)"custom-html");
        Object data = inapp.opt("d");
        JSONObject dataObject = data instanceof JSONObject ? new JSONObject(((JSONObject)data).toString()) : new JSONObject();
        dataObject.put("html", (Object)htmlContent);
        inapp.put("d", (Object)dataObject);
        return inapp;
    }

    private final String wrapImageInterstitialContent(String content) {
        String string2;
        if (StringsKt.isBlank((CharSequence)content)) {
            return null;
        }
        try {
            String string3 = Utils.readAssetFile(this.context, "image_interstitial.html");
            if (string3 == null) {
                return null;
            }
            String html = string3;
            String[] stringArray = new String[]{"\"##Vars##\""};
            List parts = StringsKt.split$default((CharSequence)html, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            string2 = parts.size() == 2 ? (String)parts.get(0) + content + (String)parts.get(1) : null;
        }
        catch (IOException e) {
            this.logger.debug("Failed to read the image-interstitial HTML file", e);
            string2 = null;
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit handleInAppPreview$lambda$2(InAppPreviewHandler this$0, Bundle $extras) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$extras, (String)"$extras");
        try {
            JSONObject jSONObject;
            JSONObject jSONObject2;
            JSONObject jSONObject3 = this$0.getPreviewPayload($extras);
            if (jSONObject3 == null) {
                return Unit.INSTANCE;
            }
            JSONObject inappPreviewPayload = jSONObject3;
            JSONArray jSONArray = new JSONArray();
            if (this$0.shouldUseHalfInterstitial($extras)) {
                jSONObject2 = this$0.getHalfInterstitialInApp(inappPreviewPayload);
                if (jSONObject2 == null) {
                    void $this$handleInAppPreview_u24lambda_u242_u24lambda_u240;
                    InAppPreviewHandler inAppPreviewHandler = this$0;
                    boolean bl = false;
                    $this$handleInAppPreview_u24lambda_u242_u24lambda_u240.logger.debug("Failed to parse the image-interstitial notification. Aborting preview display");
                    return Unit.INSTANCE;
                }
            } else {
                jSONObject2 = inappPreviewPayload;
            }
            JSONArray inappNotifs = jSONArray.put((Object)jSONObject2);
            JSONObject $this$handleInAppPreview_u24lambda_u242_u24lambda_u241 = jSONObject = new JSONObject();
            boolean bl = false;
            $this$handleInAppPreview_u24lambda_u242_u24lambda_u241.put("inapp_notifs", (Object)inappNotifs);
            JSONObject inAppResponseJson = jSONObject;
            this$0.inAppResponse.processResponse(inAppResponseJson, null, this$0.context);
        }
        catch (Throwable t) {
            this$0.logger.verbose("Failed to display inapp notification from push notification payload", t);
        }
        return Unit.INSTANCE;
    }
}

