/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.events;

import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Constants;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.network.NetworkRepo;
import com.clevertap.android.sdk.validation.ValidationConfig;
import com.clevertap.android.sdk.variables.JsonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class EventMediator {
    private final CoreMetaData cleverTapMetaData;
    private final CleverTapInstanceConfig config;
    private final NetworkRepo networkRepo;

    public EventMediator(CleverTapInstanceConfig config, CoreMetaData coreMetaData, NetworkRepo networkRepo) {
        this.config = config;
        this.networkRepo = networkRepo;
        this.cleverTapMetaData = coreMetaData;
    }

    public boolean shouldDeferProcessingEvent(JSONObject event, int eventType) {
        if (eventType == 8) {
            return false;
        }
        if (this.config.isCreatedPostAppLaunch()) {
            return false;
        }
        if (event.has("evtName")) {
            try {
                if (Arrays.asList(Constants.SYSTEM_EVENTS).contains(event.getString("evtName"))) {
                    return false;
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return eventType == 4 && !this.cleverTapMetaData.isAppLaunchPushed();
    }

    public boolean shouldDropEvent(JSONObject event, int eventType) {
        boolean dropEvent;
        if (eventType == 7 || eventType == 8) {
            return false;
        }
        if (this.networkRepo.isMuted()) {
            this.config.getLogger().verbose(this.config.getAccountId(), "CleverTap is muted, dropping event - " + event.toString());
            return true;
        }
        if (!this.cleverTapMetaData.isCurrentUserOptedOut()) {
            return false;
        }
        if (!this.cleverTapMetaData.getEnabledSystemEvents()) {
            this.config.getLogger().debug(this.config.getAccountId(), "Current user is opted out dropping event: " + event);
            return true;
        }
        if (eventType != 4 && eventType != 6) {
            this.config.getLogger().debug(this.config.getAccountId(), "This is not RAISED_EVENT or NV_EVENT, not dropping event: " + event);
            return false;
        }
        String eName = event != null ? this.getEventName(event) : null;
        boolean isSystemEvent = ValidationConfig.DEFAULT_RESTRICTED_EVENT_NAMES.contains(eName);
        boolean bl = dropEvent = !isSystemEvent;
        if (dropEvent) {
            this.config.getLogger().debug(this.config.getAccountId(), "Current user is opted out dropping event: " + event);
        } else {
            this.config.getLogger().debug(this.config.getAccountId(), "This is a system event, not dropping event: " + event);
        }
        return dropEvent;
    }

    public boolean isAppLaunchedEvent(JSONObject event) {
        try {
            return event.has("evtName") && event.getString("evtName").equals("App Launched");
        }
        catch (JSONException e) {
            return false;
        }
    }

    public boolean isEvent(JSONObject event) {
        return event.has("evtName");
    }

    public String getEventName(JSONObject event) {
        try {
            return event.getString("evtName");
        }
        catch (JSONException e) {
            return null;
        }
    }

    public boolean isChargedEvent(JSONObject event) {
        try {
            return event.has("evtName") && event.getString("evtName").equals("Charged");
        }
        catch (JSONException e) {
            return false;
        }
    }

    public List<Map<String, Object>> getChargedEventItemDetails(JSONObject event) {
        try {
            return JsonUtil.listFromJson(event.getJSONObject("evtData").getJSONArray("Items"));
        }
        catch (JSONException e) {
            return new ArrayList<Map<String, Object>>();
        }
    }

    public Map<String, Object> getChargedEventDetails(JSONObject event) {
        try {
            Object items = event.getJSONObject("evtData").remove("Items");
            Map<String, Object> chargedDetails = JsonUtil.mapFromJson(event.getJSONObject("evtData"));
            event.getJSONObject("evtData").put("Items", items);
            return chargedDetails;
        }
        catch (JSONException e) {
            return new HashMap<String, Object>();
        }
    }
}

