/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.db;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.ILogger;
import com.clevertap.android.sdk.db.DatabaseHelper;
import com.clevertap.android.sdk.db.DelayedLegacyInAppDAO;
import com.clevertap.android.sdk.db.DelayedLegacyInAppData;
import com.clevertap.android.sdk.db.Table;
import com.clevertap.android.sdk.utils.Clock;
import java.io.Closeable;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0017J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\b\u0010\u0015\u001a\u00020\rH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/clevertap/android/sdk/db/DelayedLegacyInAppDAOImpl;", "Lcom/clevertap/android/sdk/db/DelayedLegacyInAppDAO;", "db", "Lcom/clevertap/android/sdk/db/DatabaseHelper;", "logger", "Lcom/clevertap/android/sdk/ILogger;", "table", "Lcom/clevertap/android/sdk/db/Table;", "clock", "Lcom/clevertap/android/sdk/utils/Clock;", "<init>", "(Lcom/clevertap/android/sdk/db/DatabaseHelper;Lcom/clevertap/android/sdk/ILogger;Lcom/clevertap/android/sdk/db/Table;Lcom/clevertap/android/sdk/utils/Clock;)V", "insertBatch", "", "delayedInApps", "", "Lcom/clevertap/android/sdk/db/DelayedLegacyInAppData;", "remove", "inAppId", "", "fetchSingleInApp", "clearAll", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nDelayedLegacyInAppDAO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DelayedLegacyInAppDAO.kt\ncom/clevertap/android/sdk/db/DelayedLegacyInAppDAOImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n1863#2,2:176\n*S KotlinDebug\n*F\n+ 1 DelayedLegacyInAppDAO.kt\ncom/clevertap/android/sdk/db/DelayedLegacyInAppDAOImpl\n*L\n87#1:176,2\n*E\n"})
public final class DelayedLegacyInAppDAOImpl
implements DelayedLegacyInAppDAO {
    @NotNull
    private final DatabaseHelper db;
    @NotNull
    private final ILogger logger;
    @NotNull
    private final Table table;
    @NotNull
    private final Clock clock;

    public DelayedLegacyInAppDAOImpl(@NotNull DatabaseHelper db, @NotNull ILogger logger, @NotNull Table table, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)((Object)db), (String)"db");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.db = db;
        this.logger = logger;
        this.table = table;
        this.clock = clock;
    }

    public /* synthetic */ DelayedLegacyInAppDAOImpl(DatabaseHelper databaseHelper, ILogger iLogger, Table table, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            clock = Clock.SYSTEM;
        }
        this(databaseHelper, iLogger, table, clock);
    }

    @Override
    @WorkerThread
    public boolean insertBatch(@NotNull List<DelayedLegacyInAppData> delayedInApps) {
        boolean bl;
        Intrinsics.checkNotNullParameter(delayedInApps, (String)"delayedInApps");
        if (delayedInApps.isEmpty()) {
            this.logger.verbose("DelayedLegacyInAppDAO: Empty batch insert list");
            return true;
        }
        if (!this.db.belowMemThreshold()) {
            this.logger.verbose("There is not enough space left on the device to store data, data discarded");
            return false;
        }
        String tableName = this.table.getTableName();
        this.logger.verbose("DelayedLegacyInAppDAO: Batch insert for " + delayedInApps.size() + " delayed legacy in-apps");
        try {
            this.db.getWritableDatabase().beginTransaction();
            long now = this.clock.currentTimeMillis();
            Iterable $this$forEach$iv = delayedInApps;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ContentValues contentValues;
                DelayedLegacyInAppData delayedInApp = (DelayedLegacyInAppData)element$iv;
                boolean bl2 = false;
                this.logger.verbose("DelayedLegacyInAppDAO: Batch inserting " + delayedInApp.getInAppId());
                ContentValues $this$insertBatch_u24lambda_u241_u24lambda_u240 = contentValues = new ContentValues();
                boolean bl3 = false;
                $this$insertBatch_u24lambda_u241_u24lambda_u240.put("inAppId", delayedInApp.getInAppId());
                $this$insertBatch_u24lambda_u241_u24lambda_u240.put("delay", Integer.valueOf(delayedInApp.getDelay()));
                $this$insertBatch_u24lambda_u241_u24lambda_u240.put("data", delayedInApp.getInAppData());
                $this$insertBatch_u24lambda_u241_u24lambda_u240.put("created_at", Long.valueOf(now));
                ContentValues values = contentValues;
                this.db.getWritableDatabase().insertWithOnConflict(tableName, null, values, 5);
            }
            this.db.getWritableDatabase().setTransactionSuccessful();
            this.db.getWritableDatabase().endTransaction();
            this.logger.verbose("DelayedLegacyInAppDAO: Batch insert completed successfully for " + delayedInApps.size() + " items");
            bl = true;
        }
        catch (Exception e) {
            this.logger.verbose("Failed to perform batch insert on table " + tableName, e);
            try {
                this.db.getWritableDatabase().endTransaction();
            }
            catch (Exception e2) {
                this.logger.verbose("Failed to end transaction on table " + tableName, e2);
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @WorkerThread
    public boolean remove(@NotNull String inAppId) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)inAppId, (String)"inAppId");
        String tableName = this.table.getTableName();
        try {
            this.logger.verbose("Removing delayed legacy in-app: " + inAppId + " from " + tableName);
            String[] stringArray = new String[]{inAppId};
            int rowsDeleted = this.db.getWritableDatabase().delete(tableName, "inAppId = ?", stringArray);
            bl = rowsDeleted > 0;
        }
        catch (SQLiteException e) {
            this.logger.verbose("Could not remove delayed legacy in-app from database " + tableName + '.', e);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    @Nullable
    public String fetchSingleInApp(@NotNull String inAppId) {
        Intrinsics.checkNotNullParameter((Object)inAppId, (String)"inAppId");
        String tableName = this.table.getTableName();
        String selection = "inAppId = ?";
        String[] stringArray = new String[]{inAppId};
        String[] selectionArgs = stringArray;
        Object object = new String[]{"data"};
        String[] projection = object;
        try {
            String string2;
            object = (Closeable)this.db.getReadableDatabase().query(tableName, projection, selection, selectionArgs, null, null, null, null);
            Throwable throwable = null;
            try {
                Cursor cursor = (Cursor)object;
                boolean bl = false;
                string2 = cursor.moveToFirst() ? cursor.getString(cursor.getColumnIndexOrThrow("data")) : null;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = string2;
        }
        catch (Exception e) {
            this.logger.verbose("Could not fetch delayed legacy in-app from database " + tableName + '.', e);
            object = null;
        }
        return object;
    }

    @Override
    @WorkerThread
    public boolean clearAll() {
        boolean bl;
        String tableName = this.table.getTableName();
        try {
            this.logger.verbose("Clearing all delayed legacy in-apps from " + tableName);
            this.db.getWritableDatabase().delete(tableName, null, null);
            this.logger.verbose("Successfully cleared all delayed legacy in-apps from " + tableName);
            bl = true;
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error clearing all delayed legacy in-apps from table " + tableName + '.', e);
            bl = false;
        }
        return bl;
    }
}

