/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.cryption;

import com.clevertap.android.sdk.cryption.Crypt;
import com.clevertap.android.sdk.cryption.CryptFactory;
import com.clevertap.android.sdk.cryption.CryptRepository;
import com.clevertap.android.sdk.cryption.ICryptHandler;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0002\u0016\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\tH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/clevertap/android/sdk/cryption/CryptHandler;", "Lcom/clevertap/android/sdk/cryption/ICryptHandler;", "repository", "Lcom/clevertap/android/sdk/cryption/CryptRepository;", "cryptFactory", "Lcom/clevertap/android/sdk/cryption/CryptFactory;", "<init>", "(Lcom/clevertap/android/sdk/cryption/CryptRepository;Lcom/clevertap/android/sdk/cryption/CryptFactory;)V", "encryptSafe", "", "plainText", "decryptSafe", "cipherText", "encrypt", "decrypt", "decryptWithAlgorithm", "algorithm", "Lcom/clevertap/android/sdk/cryption/CryptHandler$EncryptionAlgorithm;", "updateMigrationFailureCount", "", "migrationSuccessful", "", "EncryptionAlgorithm", "Companion", "clevertap-core_release"})
public final class CryptHandler
implements ICryptHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CryptRepository repository;
    @NotNull
    private final CryptFactory cryptFactory;
    @NotNull
    private static final EncryptionAlgorithm DEFAULT_ALGORITHM = EncryptionAlgorithm.AES_GCM;

    public CryptHandler(@NotNull CryptRepository repository, @NotNull CryptFactory cryptFactory) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)cryptFactory, (String)"cryptFactory");
        this.repository = repository;
        this.cryptFactory = cryptFactory;
    }

    @Override
    @Nullable
    public String encryptSafe(@NotNull String plainText) {
        Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
        if (Companion.isTextAESGCMEncrypted(plainText)) {
            return plainText;
        }
        Crypt crypt = this.cryptFactory.getCryptInstance(DEFAULT_ALGORITHM);
        return crypt.encryptInternal(plainText);
    }

    @Override
    @Nullable
    public String decryptSafe(@NotNull String cipherText) {
        Intrinsics.checkNotNullParameter((Object)cipherText, (String)"cipherText");
        if (!Companion.isTextAESGCMEncrypted(cipherText)) {
            return cipherText;
        }
        return this.cryptFactory.getCryptInstance(DEFAULT_ALGORITHM).decryptInternal(cipherText);
    }

    @Override
    @Nullable
    public String encrypt(@NotNull String plainText) {
        Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
        Crypt crypt = this.cryptFactory.getCryptInstance(DEFAULT_ALGORITHM);
        return crypt.encryptInternal(plainText);
    }

    @Override
    @Nullable
    public String decrypt(@NotNull String cipherText) {
        Intrinsics.checkNotNullParameter((Object)cipherText, (String)"cipherText");
        Crypt crypt = this.cryptFactory.getCryptInstance(DEFAULT_ALGORITHM);
        return crypt.decryptInternal(cipherText);
    }

    @Override
    @Nullable
    public String decryptWithAlgorithm(@NotNull String cipherText, @NotNull EncryptionAlgorithm algorithm) {
        Intrinsics.checkNotNullParameter((Object)cipherText, (String)"cipherText");
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        Crypt crypt = this.cryptFactory.getCryptInstance(algorithm);
        return crypt.decryptInternal(cipherText);
    }

    @Override
    public void updateMigrationFailureCount(boolean migrationSuccessful) {
        this.repository.updateMigrationFailureCount(migrationSuccessful);
    }

    @JvmStatic
    public static final boolean isTextEncrypted(@NotNull String plainText) {
        return Companion.isTextEncrypted(plainText);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/clevertap/android/sdk/cryption/CryptHandler$Companion;", "", "<init>", "()V", "DEFAULT_ALGORITHM", "Lcom/clevertap/android/sdk/cryption/CryptHandler$EncryptionAlgorithm;", "getDEFAULT_ALGORITHM", "()Lcom/clevertap/android/sdk/cryption/CryptHandler$EncryptionAlgorithm;", "isTextEncrypted", "", "plainText", "", "isTextAESEncrypted", "isTextAESGCMEncrypted", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EncryptionAlgorithm getDEFAULT_ALGORITHM() {
            return DEFAULT_ALGORITHM;
        }

        @JvmStatic
        public final boolean isTextEncrypted(@NotNull String plainText) {
            Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
            return this.isTextAESEncrypted(plainText) || this.isTextAESGCMEncrypted(plainText);
        }

        public final boolean isTextAESEncrypted(@NotNull String plainText) {
            Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
            return StringsKt.startsWith$default((String)plainText, (String)"[", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)plainText, (String)"]", (boolean)false, (int)2, null);
        }

        public final boolean isTextAESGCMEncrypted(@NotNull String plainText) {
            Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
            return StringsKt.startsWith$default((String)plainText, (String)"<ct<", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)plainText, (String)">ct>", (boolean)false, (int)2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/clevertap/android/sdk/cryption/CryptHandler$EncryptionAlgorithm;", "", "value", "", "<init>", "(Ljava/lang/String;II)V", "getValue", "()I", "AES", "AES_GCM", "clevertap-core_release"})
    public static final class EncryptionAlgorithm
    extends Enum<EncryptionAlgorithm> {
        private final int value;
        public static final /* enum */ EncryptionAlgorithm AES = new EncryptionAlgorithm(0);
        public static final /* enum */ EncryptionAlgorithm AES_GCM = new EncryptionAlgorithm(1);
        private static final /* synthetic */ EncryptionAlgorithm[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private EncryptionAlgorithm(int value) {
            this.value = value;
        }

        public final int getValue() {
            return this.value;
        }

        public static EncryptionAlgorithm[] values() {
            return (EncryptionAlgorithm[])$VALUES.clone();
        }

        public static EncryptionAlgorithm valueOf(String value) {
            return Enum.valueOf(EncryptionAlgorithm.class, value);
        }

        @NotNull
        public static EnumEntries<EncryptionAlgorithm> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = encryptionAlgorithmArray = new EncryptionAlgorithm[]{EncryptionAlgorithm.AES, EncryptionAlgorithm.AES_GCM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

