/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.db;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ILogger;
import com.clevertap.android.sdk.db.DBEncryptionHandler;
import com.clevertap.android.sdk.db.DatabaseHelper;
import com.clevertap.android.sdk.db.DelayedLegacyInAppDAO;
import com.clevertap.android.sdk.db.DelayedLegacyInAppDAOImpl;
import com.clevertap.android.sdk.db.QueueData;
import com.clevertap.android.sdk.db.Table;
import com.clevertap.android.sdk.db.dao.EventDAO;
import com.clevertap.android.sdk.db.dao.EventDAOImpl;
import com.clevertap.android.sdk.db.dao.InboxMessageDAO;
import com.clevertap.android.sdk.db.dao.InboxMessageDAOImpl;
import com.clevertap.android.sdk.db.dao.PushNotificationDAO;
import com.clevertap.android.sdk.db.dao.PushNotificationDAOImpl;
import com.clevertap.android.sdk.db.dao.UninstallTimestampDAO;
import com.clevertap.android.sdk.db.dao.UninstallTimestampDAOImpl;
import com.clevertap.android.sdk.db.dao.UserProfileDAO;
import com.clevertap.android.sdk.db.dao.UserProfileDAOImpl;
import com.clevertap.android.sdk.inbox.CTMessageDAO;
import com.clevertap.android.sdk.usereventlogs.UserEventLogDAO;
import com.clevertap.android.sdk.usereventlogs.UserEventLogDAOImpl;
import com.clevertap.android.sdk.utils.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u000e\b\u0000\u0018\u0000 g2\u00020\u0001:\u0001gB9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0007J\u0018\u00105\u001a\u0002062\u0006\u00103\u001a\u0002042\u0006\u00107\u001a\u000208H\u0007J\u0010\u00109\u001a\u0002062\u0006\u0010:\u001a\u000208H\u0007J\u0018\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u00052\u0006\u00103\u001a\u000204H\u0007J\u000e\u0010>\u001a\u00020<2\u0006\u00103\u001a\u000204J\u000e\u0010?\u001a\u00020<2\u0006\u00103\u001a\u000204J\u000e\u0010@\u001a\u0002082\u0006\u00103\u001a\u000204J%\u0010A\u001a\u0012\u0012\u0004\u0012\u00020C0Dj\b\u0012\u0004\u0012\u00020C`B2\u0006\u0010E\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010FJ\u0016\u0010G\u001a\u00020<2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020C0IH\u0007J\u001c\u0010J\u001a\u00020K2\b\u0010L\u001a\u0004\u0018\u00010\u00052\b\u0010E\u001a\u0004\u0018\u00010\u0005H\u0007J$\u0010M\u001a\u00020K2\u0010\u0010N\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010I2\b\u0010E\u001a\u0004\u0018\u00010\u0005H\u0007J\u001c\u0010O\u001a\u00020K2\b\u0010L\u001a\u0004\u0018\u00010\u00052\b\u0010E\u001a\u0004\u0018\u00010\u0005H\u0007J$\u0010P\u001a\u00020K2\u0010\u0010N\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010I2\b\u0010E\u001a\u0004\u0018\u00010\u0005H\u0007J$\u0010Q\u001a\u0002002\b\u0010R\u001a\u0004\u0018\u00010\u00052\b\u0010S\u001a\u0004\u0018\u00010\u00052\u0006\u00101\u001a\u000202H\u0007J\u001c\u0010T\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002020U2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005J\u001c\u0010V\u001a\u0004\u0018\u0001022\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010S\u001a\u0004\u0018\u00010\u0005J\u0016\u0010W\u001a\u00020<2\u0006\u0010R\u001a\u00020\u00052\u0006\u0010X\u001a\u000200J\u0011\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u00050Z\u00a2\u0006\u0002\u0010[J\u000e\u0010\\\u001a\u00020K2\u0006\u0010R\u001a\u00020\u0005J\u001b\u0010]\u001a\u00020<2\f\u0010^\u001a\b\u0012\u0004\u0012\u00020\u00050ZH\u0007\u00a2\u0006\u0002\u0010_J\u0006\u0010`\u001a\u00020<J\u0006\u0010a\u001a\u00020<J\u0006\u0010b\u001a\u000200J\b\u0010c\u001a\u00020,H\u0007J\b\u0010d\u001a\u00020.H\u0007J\r\u0010e\u001a\u00020<H\u0001\u00a2\u0006\u0002\bfR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0017\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0016\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u0016\u001a\u0004\b\u001e\u0010\u001fR\u001b\u0010!\u001a\u00020\"8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u0016\u001a\u0004\b#\u0010$R\u001b\u0010&\u001a\u00020'8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010\u0016\u001a\u0004\b(\u0010)R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006h"}, d2={"Lcom/clevertap/android/sdk/db/DBAdapter;", "", "context", "Landroid/content/Context;", "databaseName", "", "accountId", "logger", "Lcom/clevertap/android/sdk/ILogger;", "dbEncryptionHandler", "Lcom/clevertap/android/sdk/db/DBEncryptionHandler;", "clock", "Lcom/clevertap/android/sdk/utils/Clock;", "<init>", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;Lcom/clevertap/android/sdk/ILogger;Lcom/clevertap/android/sdk/db/DBEncryptionHandler;Lcom/clevertap/android/sdk/utils/Clock;)V", "dbHelper", "Lcom/clevertap/android/sdk/db/DatabaseHelper;", "eventDAO", "Lcom/clevertap/android/sdk/db/dao/EventDAO;", "getEventDAO", "()Lcom/clevertap/android/sdk/db/dao/EventDAO;", "eventDAO$delegate", "Lkotlin/Lazy;", "inboxMessageDAO", "Lcom/clevertap/android/sdk/db/dao/InboxMessageDAO;", "getInboxMessageDAO", "()Lcom/clevertap/android/sdk/db/dao/InboxMessageDAO;", "inboxMessageDAO$delegate", "userProfileDAO", "Lcom/clevertap/android/sdk/db/dao/UserProfileDAO;", "getUserProfileDAO", "()Lcom/clevertap/android/sdk/db/dao/UserProfileDAO;", "userProfileDAO$delegate", "pushNotificationDAO", "Lcom/clevertap/android/sdk/db/dao/PushNotificationDAO;", "getPushNotificationDAO", "()Lcom/clevertap/android/sdk/db/dao/PushNotificationDAO;", "pushNotificationDAO$delegate", "uninstallTimestampDAO", "Lcom/clevertap/android/sdk/db/dao/UninstallTimestampDAO;", "getUninstallTimestampDAO", "()Lcom/clevertap/android/sdk/db/dao/UninstallTimestampDAO;", "uninstallTimestampDAO$delegate", "userEventLogDao", "Lcom/clevertap/android/sdk/usereventlogs/UserEventLogDAO;", "delayedLegacyInAppDao", "Lcom/clevertap/android/sdk/db/DelayedLegacyInAppDAO;", "storeObject", "", "obj", "Lorg/json/JSONObject;", "table", "Lcom/clevertap/android/sdk/db/Table;", "fetchEvents", "Lcom/clevertap/android/sdk/db/QueueData;", "limit", "", "fetchCombinedEvents", "batchSize", "cleanupEventsFromLastId", "", "lastId", "cleanupStaleEvents", "removeEvents", "migrateEventsData", "getMessages", "Lkotlin/collections/ArrayList;", "Lcom/clevertap/android/sdk/inbox/CTMessageDAO;", "Ljava/util/ArrayList;", "userId", "(Ljava/lang/String;)Ljava/util/ArrayList;", "upsertMessages", "inboxMessages", "", "deleteMessageForId", "", "messageId", "deleteMessagesForIDs", "messageIDs", "markReadMessageForId", "markReadMessagesForIds", "storeUserProfile", "id", "deviceId", "fetchUserProfilesByAccountId", "", "fetchUserProfileByAccountIdAndDeviceID", "storePushNotificationId", "ttlInSeconds", "fetchPushNotificationIds", "", "()[Ljava/lang/String;", "doesPushNotificationIdExist", "updatePushNotificationIds", "ids", "([Ljava/lang/String;)V", "cleanUpPushNotifications", "storeUninstallTimestamp", "getLastUninstallTimestamp", "userEventLogDAO", "delayedLegacyInAppDAO", "deleteDB", "deleteDB$clevertap_core_release", "Companion", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nDBAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DBAdapter.kt\ncom/clevertap/android/sdk/db/DBAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,225:1\n1#2:226\n*E\n"})
public final class DBAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String accountId;
    @NotNull
    private final ILogger logger;
    @NotNull
    private final DBEncryptionHandler dbEncryptionHandler;
    @NotNull
    private final Clock clock;
    @NotNull
    private final DatabaseHelper dbHelper;
    @NotNull
    private final Lazy eventDAO$delegate;
    @NotNull
    private final Lazy inboxMessageDAO$delegate;
    @NotNull
    private final Lazy userProfileDAO$delegate;
    @NotNull
    private final Lazy pushNotificationDAO$delegate;
    @NotNull
    private final Lazy uninstallTimestampDAO$delegate;
    @Nullable
    private volatile UserEventLogDAO userEventLogDao;
    @Nullable
    private volatile DelayedLegacyInAppDAO delayedLegacyInAppDao;
    public static final long DB_UPDATE_ERROR = -1L;
    public static final long DB_OUT_OF_MEMORY_ERROR = -2L;
    @NotNull
    public static final String NOT_ENOUGH_SPACE_LOG = "There is not enough space left on the device to store data, data discarded";
    @NotNull
    private static final String DATABASE_NAME = "clevertap";

    public DBAdapter(@NotNull Context context, @NotNull String databaseName, @NotNull String accountId, @NotNull ILogger logger, @NotNull DBEncryptionHandler dbEncryptionHandler, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)dbEncryptionHandler, (String)"dbEncryptionHandler");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.accountId = accountId;
        this.logger = logger;
        this.dbEncryptionHandler = dbEncryptionHandler;
        this.clock = clock;
        this.dbHelper = new DatabaseHelper(context, this.accountId, databaseName, this.logger);
        this.eventDAO$delegate = LazyKt.lazy(() -> DBAdapter.eventDAO_delegate$lambda$0(this));
        this.inboxMessageDAO$delegate = LazyKt.lazy(() -> DBAdapter.inboxMessageDAO_delegate$lambda$1(this));
        this.userProfileDAO$delegate = LazyKt.lazy(() -> DBAdapter.userProfileDAO_delegate$lambda$2(this));
        this.pushNotificationDAO$delegate = LazyKt.lazy(() -> DBAdapter.pushNotificationDAO_delegate$lambda$3(this));
        this.uninstallTimestampDAO$delegate = LazyKt.lazy(() -> DBAdapter.uninstallTimestampDAO_delegate$lambda$4(this));
    }

    public /* synthetic */ DBAdapter(Context context, String string2, String string3, ILogger iLogger, DBEncryptionHandler dBEncryptionHandler, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            clock = Clock.SYSTEM;
        }
        this(context, string2, string3, iLogger, dBEncryptionHandler, clock);
    }

    private final EventDAO getEventDAO() {
        Lazy lazy = this.eventDAO$delegate;
        return (EventDAO)lazy.getValue();
    }

    private final InboxMessageDAO getInboxMessageDAO() {
        Lazy lazy = this.inboxMessageDAO$delegate;
        return (InboxMessageDAO)lazy.getValue();
    }

    private final UserProfileDAO getUserProfileDAO() {
        Lazy lazy = this.userProfileDAO$delegate;
        return (UserProfileDAO)lazy.getValue();
    }

    private final PushNotificationDAO getPushNotificationDAO() {
        Lazy lazy = this.pushNotificationDAO$delegate;
        return (PushNotificationDAO)lazy.getValue();
    }

    private final UninstallTimestampDAO getUninstallTimestampDAO() {
        Lazy lazy = this.uninstallTimestampDAO$delegate;
        return (UninstallTimestampDAO)lazy.getValue();
    }

    @WorkerThread
    public final synchronized long storeObject(@NotNull JSONObject obj, @NotNull Table table) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        return this.getEventDAO().storeEvent(obj, table);
    }

    @WorkerThread
    @NotNull
    public final synchronized QueueData fetchEvents(@NotNull Table table, int limit) {
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        return this.getEventDAO().fetchEvents(table, limit);
    }

    @WorkerThread
    @NotNull
    public final synchronized QueueData fetchCombinedEvents(int batchSize) {
        return this.getEventDAO().fetchCombinedEvents(batchSize);
    }

    @WorkerThread
    public final synchronized void cleanupEventsFromLastId(@NotNull String lastId, @NotNull Table table) {
        Intrinsics.checkNotNullParameter((Object)lastId, (String)"lastId");
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        this.getEventDAO().cleanupEventsFromLastId(lastId, table);
    }

    public final synchronized void cleanupStaleEvents(@NotNull Table table) {
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        this.getEventDAO().cleanupStaleEvents(table);
    }

    public final synchronized void removeEvents(@NotNull Table table) {
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        this.getEventDAO().removeAllEvents(table);
    }

    public final int migrateEventsData(@NotNull Table table) {
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        return this.getEventDAO().updateAllEvents(table);
    }

    @WorkerThread
    @NotNull
    public final synchronized ArrayList<CTMessageDAO> getMessages(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return this.getInboxMessageDAO().getMessages(userId);
    }

    @WorkerThread
    public final synchronized void upsertMessages(@NotNull List<? extends CTMessageDAO> inboxMessages) {
        Intrinsics.checkNotNullParameter(inboxMessages, (String)"inboxMessages");
        this.getInboxMessageDAO().upsertMessages(inboxMessages);
    }

    @WorkerThread
    public final synchronized boolean deleteMessageForId(@Nullable String messageId, @Nullable String userId) {
        return messageId != null && userId != null ? this.getInboxMessageDAO().deleteMessage(messageId, userId) : false;
    }

    @WorkerThread
    public final synchronized boolean deleteMessagesForIDs(@Nullable List<String> messageIDs, @Nullable String userId) {
        List validIds;
        return messageIDs != null && userId != null ? (!((Collection)(validIds = CollectionsKt.filterNotNull((Iterable)messageIDs))).isEmpty() ? this.getInboxMessageDAO().deleteMessages(validIds, userId) : false) : false;
    }

    @WorkerThread
    public final synchronized boolean markReadMessageForId(@Nullable String messageId, @Nullable String userId) {
        return messageId != null && userId != null ? this.getInboxMessageDAO().markMessageAsRead(messageId, userId) : false;
    }

    @WorkerThread
    public final synchronized boolean markReadMessagesForIds(@Nullable List<String> messageIDs, @Nullable String userId) {
        List validIds;
        return messageIDs != null && userId != null ? (!((Collection)(validIds = CollectionsKt.filterNotNull((Iterable)messageIDs))).isEmpty() ? this.getInboxMessageDAO().markMessagesAsRead(validIds, userId) : false) : false;
    }

    @WorkerThread
    public final synchronized long storeUserProfile(@Nullable String id2, @Nullable String deviceId, @NotNull JSONObject obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return id2 != null && deviceId != null ? this.getUserProfileDAO().storeUserProfile(id2, deviceId, obj) : -1L;
    }

    @NotNull
    public final synchronized Map<String, JSONObject> fetchUserProfilesByAccountId(@Nullable String accountId) {
        return accountId != null ? this.getUserProfileDAO().fetchUserProfilesByAccountId(accountId) : MapsKt.emptyMap();
    }

    @Nullable
    public final synchronized JSONObject fetchUserProfileByAccountIdAndDeviceID(@Nullable String accountId, @Nullable String deviceId) {
        return accountId != null && deviceId != null ? this.getUserProfileDAO().fetchUserProfile(accountId, deviceId) : null;
    }

    public final synchronized void storePushNotificationId(@NotNull String id2, long ttlInSeconds) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        this.getPushNotificationDAO().storePushNotificationId(id2, ttlInSeconds);
    }

    @NotNull
    public final synchronized String[] fetchPushNotificationIds() {
        return this.getPushNotificationDAO().fetchPushNotificationIds();
    }

    public final synchronized boolean doesPushNotificationIdExist(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        return this.getPushNotificationDAO().doesPushNotificationIdExist(id2);
    }

    @WorkerThread
    public final synchronized void updatePushNotificationIds(@NotNull String[] ids) {
        Intrinsics.checkNotNullParameter((Object)ids, (String)"ids");
        this.getPushNotificationDAO().updatePushNotificationIds(ids);
    }

    public final synchronized void cleanUpPushNotifications() {
        this.getPushNotificationDAO().cleanUpPushNotifications();
    }

    public final synchronized void storeUninstallTimestamp() {
        this.getUninstallTimestampDAO().storeUninstallTimestamp();
    }

    public final synchronized long getLastUninstallTimestamp() {
        return this.getUninstallTimestampDAO().getLastUninstallTimestamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @NotNull
    public final UserEventLogDAO userEventLogDAO() {
        UserEventLogDAO userEventLogDAO = this.userEventLogDao;
        if (userEventLogDAO == null) {
            DBAdapter dBAdapter = this;
            synchronized (dBAdapter) {
                boolean bl = false;
                UserEventLogDAO userEventLogDAO2 = this.userEventLogDao;
                if (userEventLogDAO2 == null) {
                    UserEventLogDAOImpl userEventLogDAOImpl;
                    UserEventLogDAOImpl it = userEventLogDAOImpl = new UserEventLogDAOImpl(this.dbHelper, this.logger, Table.USER_EVENT_LOGS_TABLE);
                    boolean bl2 = false;
                    this.userEventLogDao = it;
                    userEventLogDAO2 = userEventLogDAOImpl;
                }
                UserEventLogDAO userEventLogDAO3 = userEventLogDAO2;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl16 : MonitorExitStatement: MONITOREXIT : var1_1
                userEventLogDAO = userEventLogDAO3;
            }
        }
        return userEventLogDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @NotNull
    public final DelayedLegacyInAppDAO delayedLegacyInAppDAO() {
        DelayedLegacyInAppDAO delayedLegacyInAppDAO = this.delayedLegacyInAppDao;
        if (delayedLegacyInAppDAO == null) {
            DBAdapter dBAdapter = this;
            synchronized (dBAdapter) {
                boolean bl = false;
                DelayedLegacyInAppDAO delayedLegacyInAppDAO2 = this.delayedLegacyInAppDao;
                if (delayedLegacyInAppDAO2 == null) {
                    DelayedLegacyInAppDAOImpl delayedLegacyInAppDAOImpl;
                    DelayedLegacyInAppDAOImpl it = delayedLegacyInAppDAOImpl = new DelayedLegacyInAppDAOImpl(this.dbHelper, this.logger, Table.DELAYED_LEGACY_INAPPS, null, 8, null);
                    boolean bl2 = false;
                    this.delayedLegacyInAppDao = it;
                    delayedLegacyInAppDAO2 = delayedLegacyInAppDAOImpl;
                }
                DelayedLegacyInAppDAO delayedLegacyInAppDAO3 = delayedLegacyInAppDAO2;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl16 : MonitorExitStatement: MONITOREXIT : var1_1
                delayedLegacyInAppDAO = delayedLegacyInAppDAO3;
            }
        }
        return delayedLegacyInAppDAO;
    }

    @VisibleForTesting
    public final void deleteDB$clevertap_core_release() {
        this.dbHelper.deleteDatabase();
    }

    private static final EventDAOImpl eventDAO_delegate$lambda$0(DBAdapter this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new EventDAOImpl(this$0.dbHelper, this$0.logger, this$0.dbEncryptionHandler, this$0.clock);
    }

    private static final InboxMessageDAOImpl inboxMessageDAO_delegate$lambda$1(DBAdapter this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new InboxMessageDAOImpl(this$0.dbHelper, this$0.logger, this$0.dbEncryptionHandler);
    }

    private static final UserProfileDAOImpl userProfileDAO_delegate$lambda$2(DBAdapter this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new UserProfileDAOImpl(this$0.dbHelper, this$0.logger, this$0.dbEncryptionHandler);
    }

    private static final PushNotificationDAOImpl pushNotificationDAO_delegate$lambda$3(DBAdapter this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new PushNotificationDAOImpl(this$0.dbHelper, this$0.logger, this$0.clock);
    }

    private static final UninstallTimestampDAOImpl uninstallTimestampDAO_delegate$lambda$4(DBAdapter this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new UninstallTimestampDAOImpl(this$0.dbHelper, this$0.logger, null, 4, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/clevertap/android/sdk/db/DBAdapter$Companion;", "", "<init>", "()V", "DB_UPDATE_ERROR", "", "DB_OUT_OF_MEMORY_ERROR", "NOT_ENOUGH_SPACE_LOG", "", "DATABASE_NAME", "getDatabaseName", "config", "Lcom/clevertap/android/sdk/CleverTapInstanceConfig;", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDatabaseName(@NotNull CleverTapInstanceConfig config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return config.isDefaultInstance() ? DBAdapter.DATABASE_NAME : "clevertap_" + config.getAccountId();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

