/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.video.inbox;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.media3.common.MediaItem;
import androidx.media3.common.Player;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DefaultDataSource;
import androidx.media3.datasource.DefaultHttpDataSource;
import androidx.media3.datasource.TransferListener;
import androidx.media3.exoplayer.ExoPlayer;
import androidx.media3.exoplayer.hls.HlsMediaSource;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.trackselection.AdaptiveTrackSelection;
import androidx.media3.exoplayer.trackselection.DefaultTrackSelector;
import androidx.media3.exoplayer.trackselection.ExoTrackSelection;
import androidx.media3.exoplayer.trackselection.TrackSelector;
import androidx.media3.exoplayer.upstream.DefaultBandwidthMeter;
import androidx.media3.ui.PlayerView;
import com.clevertap.android.sdk.video.InboxVideoPlayerHandle;
import com.clevertap.android.sdk.video.inbox.Media3PlayerListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\tH\u0016J \u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\rH\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\tH\u0016J(\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0013H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/clevertap/android/sdk/video/inbox/Media3Handle;", "Lcom/clevertap/android/sdk/video/InboxVideoPlayerHandle;", "<init>", "()V", "videoSurfaceView", "Landroidx/media3/ui/PlayerView;", "player", "Landroidx/media3/exoplayer/ExoPlayer;", "initExoplayer", "", "context", "Landroid/content/Context;", "buffering", "Lkotlin/Function0;", "playerReady", "videoSurface", "Landroid/view/View;", "setPlayWhenReady", "play", "", "pause", "initPlayerView", "artworkAsset", "Landroid/graphics/drawable/Drawable;", "playerVolume", "", "handleMute", "startPlaying", "ctx", "uriString", "", "isMediaAudio", "isMediaVideo", "clevertap-core_release"})
@UnstableApi
@SourceDebugExtension(value={"SMAP\nMedia3Handle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Media3Handle.kt\ncom/clevertap/android/sdk/video/inbox/Media3Handle\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1#2:164\n*E\n"})
public final class Media3Handle
implements InboxVideoPlayerHandle {
    @Nullable
    private PlayerView videoSurfaceView;
    @Nullable
    private ExoPlayer player;

    /*
     * WARNING - void declaration
     */
    @Override
    public void initExoplayer(@NotNull Context context, @NotNull Function0<Unit> buffering, @NotNull Function0<Unit> playerReady) {
        void $this$initExoplayer_u24lambda_u240;
        ExoPlayer exoPlayer;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(buffering, (String)"buffering");
        Intrinsics.checkNotNullParameter(playerReady, (String)"playerReady");
        if (this.player != null) {
            return;
        }
        ExoTrackSelection.Factory videoTrackSelectionFactory = (ExoTrackSelection.Factory)new AdaptiveTrackSelection.Factory();
        TrackSelector trackSelector = (TrackSelector)new DefaultTrackSelector(context, videoTrackSelectionFactory);
        ExoPlayer exoPlayer2 = exoPlayer = new ExoPlayer.Builder(context).setTrackSelector(trackSelector).build();
        Media3Handle media3Handle = this;
        boolean bl = false;
        $this$initExoplayer_u24lambda_u240.setVolume(0.0f);
        $this$initExoplayer_u24lambda_u240.addListener((Player.Listener)new Media3PlayerListener(buffering, this, (ExoPlayer)$this$initExoplayer_u24lambda_u240, playerReady){
            final /* synthetic */ Function0<Unit> $buffering;
            final /* synthetic */ Media3Handle this$0;
            final /* synthetic */ ExoPlayer $this_apply;
            final /* synthetic */ Function0<Unit> $playerReady;
            {
                this.$buffering = $buffering;
                this.this$0 = $receiver;
                this.$this_apply = $receiver2;
                this.$playerReady = $playerReady;
            }

            public void onPlaybackStateChanged(int playbackState) {
                switch (playbackState) {
                    case 2: {
                        this.$buffering.invoke();
                        break;
                    }
                    case 4: {
                        if (Media3Handle.access$getPlayer$p(this.this$0) == null) break;
                        this.$this_apply.seekTo(0L);
                        this.$this_apply.setPlayWhenReady(false);
                        PlayerView playerView = Media3Handle.access$getVideoSurfaceView$p(this.this$0);
                        if (playerView != null) {
                            playerView.showController();
                        }
                        break;
                    }
                    case 3: {
                        this.$playerReady.invoke();
                    }
                }
            }
        });
        media3Handle.player = exoPlayer;
    }

    @Override
    @NotNull
    public View videoSurface() {
        PlayerView playerView = this.videoSurfaceView;
        Intrinsics.checkNotNull((Object)playerView);
        return (View)playerView;
    }

    @Override
    public void setPlayWhenReady(boolean play) {
        block0: {
            ExoPlayer exoPlayer = this.player;
            if (exoPlayer == null) break block0;
            ExoPlayer ep = exoPlayer;
            boolean bl = false;
            ep.setPlayWhenReady(play);
        }
    }

    @Override
    public void pause() {
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer != null) {
            ExoPlayer ep = exoPlayer;
            boolean bl = false;
            ep.stop();
            ep.release();
        }
        this.player = null;
        this.videoSurfaceView = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initPlayerView(@NotNull Context context, @NotNull Function0<? extends Drawable> artworkAsset) {
        void $this$initPlayerView_u24lambda_u243;
        PlayerView playerView;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(artworkAsset, (String)"artworkAsset");
        if (this.videoSurfaceView != null) {
            return;
        }
        PlayerView playerView2 = playerView = new PlayerView(context);
        Media3Handle media3Handle = this;
        boolean bl = false;
        $this$initPlayerView_u24lambda_u243.setBackgroundColor(0);
        $this$initPlayerView_u24lambda_u243.setResizeMode(context.getResources().getConfiguration().orientation == 2 ? 3 : 0);
        $this$initPlayerView_u24lambda_u243.setUseArtwork(true);
        $this$initPlayerView_u24lambda_u243.setDefaultArtwork((Drawable)artworkAsset.invoke());
        $this$initPlayerView_u24lambda_u243.setUseController(true);
        $this$initPlayerView_u24lambda_u243.setControllerAutoShow(false);
        $this$initPlayerView_u24lambda_u243.setPlayer((Player)this.player);
        media3Handle.videoSurfaceView = playerView;
    }

    @Override
    public float playerVolume() {
        float f;
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer != null) {
            ExoPlayer ep = exoPlayer;
            boolean bl = false;
            f = ep.getVolume();
        } else {
            f = 0.0f;
        }
        return f;
    }

    @Override
    public void handleMute() {
        block0: {
            float playerVolume;
            ExoPlayer ep;
            block1: {
                ExoPlayer exoPlayer = this.player;
                if (exoPlayer == null) break block0;
                ep = exoPlayer;
                boolean bl = false;
                playerVolume = this.playerVolume();
                if (!(playerVolume > 0.0f)) break block1;
                ep.setVolume(0.0f);
                break block0;
            }
            if (!(playerVolume == 0.0f)) break block0;
            ep.setVolume(1.0f);
        }
    }

    @Override
    public void startPlaying(@NotNull Context ctx, @NotNull String uriString, boolean isMediaAudio, boolean isMediaVideo) {
        block2: {
            ExoPlayer ep;
            block3: {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
                PlayerView playerView = this.videoSurfaceView;
                if (playerView != null) {
                    PlayerView spv = playerView;
                    boolean bl = false;
                    spv.requestFocus();
                    spv.setShowBuffering(0);
                }
                ExoPlayer exoPlayer = this.player;
                if (exoPlayer == null) break block2;
                ep = exoPlayer;
                boolean bl = false;
                DefaultBandwidthMeter defaultBandwidthMeter = new DefaultBandwidthMeter.Builder(ctx).build();
                Intrinsics.checkNotNullExpressionValue((Object)defaultBandwidthMeter, (String)"build(...)");
                DefaultBandwidthMeter defaultBandwidthMeter2 = defaultBandwidthMeter;
                String string2 = Util.getUserAgent((Context)ctx, (String)ctx.getPackageName());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUserAgent(...)");
                String userAgent = string2;
                MediaItem mediaItem = MediaItem.fromUri((String)uriString);
                Intrinsics.checkNotNullExpressionValue((Object)mediaItem, (String)"fromUri(...)");
                MediaItem mediaItem2 = mediaItem;
                DefaultHttpDataSource.Factory factory = new DefaultHttpDataSource.Factory().setUserAgent(userAgent).setTransferListener((TransferListener)defaultBandwidthMeter2);
                Intrinsics.checkNotNullExpressionValue((Object)factory, (String)"setTransferListener(...)");
                DefaultHttpDataSource.Factory dsf = factory;
                DataSource.Factory dataSourceFactory = (DataSource.Factory)new DefaultDataSource.Factory(ctx, (DataSource.Factory)dsf);
                HlsMediaSource hlsMediaSource = new HlsMediaSource.Factory(dataSourceFactory).createMediaSource(mediaItem2);
                Intrinsics.checkNotNullExpressionValue((Object)hlsMediaSource, (String)"createMediaSource(...)");
                HlsMediaSource hlsMediaSource2 = hlsMediaSource;
                ep.setMediaSource((MediaSource)hlsMediaSource2);
                ep.prepare();
                if (!isMediaAudio) break block3;
                PlayerView playerView2 = this.videoSurfaceView;
                if (playerView2 != null) {
                    playerView2.showController();
                }
                ep.setPlayWhenReady(false);
                ep.setVolume(1.0f);
                break block2;
            }
            if (!isMediaVideo) break block2;
            ep.setPlayWhenReady(true);
            ep.setVolume(this.playerVolume());
        }
    }

    public static final /* synthetic */ ExoPlayer access$getPlayer$p(Media3Handle $this) {
        return $this.player;
    }

    public static final /* synthetic */ PlayerView access$getVideoSurfaceView$p(Media3Handle $this) {
        return $this.videoSurfaceView;
    }
}

