/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.response;

import android.content.Context;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.network.IJRepo;
import com.clevertap.android.sdk.response.CleverTapResponseDecorator;
import org.json.JSONObject;

public class MetadataResponse
extends CleverTapResponseDecorator {
    private final CleverTapInstanceConfig config;
    private final DeviceInfo deviceInfo;
    private final Logger logger;
    private final IJRepo ijRepo;

    public MetadataResponse(CleverTapInstanceConfig config, DeviceInfo deviceInfo, IJRepo ijRepo) {
        this.config = config;
        this.logger = this.config.getLogger();
        this.deviceInfo = deviceInfo;
        this.ijRepo = ijRepo;
    }

    @Override
    public void processResponse(JSONObject response, String stringBody, Context context) {
        try {
            if (response.has("g")) {
                String deviceID = response.getString("g");
                this.deviceInfo.forceUpdateDeviceId(deviceID);
                this.logger.verbose(this.config.getAccountId(), "Got a new device ID: " + deviceID);
            }
        }
        catch (Throwable t) {
            this.logger.verbose(this.config.getAccountId(), "Failed to update device ID!", t);
        }
        try {
            if (response.has("_i")) {
                long i = response.getLong("_i");
                this.ijRepo.setI(context, i);
            }
        }
        catch (Throwable i) {
            // empty catch block
        }
        try {
            if (response.has("_j")) {
                long j = response.getLong("_j");
                this.ijRepo.setJ(context, j);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

