/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inbox;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.viewpager.widget.PagerAdapter;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.R;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.inbox.CTInboxImageData;
import com.clevertap.android.sdk.inbox.CTInboxListViewFragment;
import com.clevertap.android.sdk.inbox.CTInboxMessage;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class CTCarouselViewPagerAdapter
extends PagerAdapter {
    private final ArrayList<CTInboxImageData> carouselImagesData;
    private final Context context;
    private final CTInboxMessage inboxMessage;
    private LayoutInflater layoutInflater;
    private final LinearLayout.LayoutParams layoutParams;
    private final WeakReference<CTInboxListViewFragment> parentWeakReference;
    private final int row;
    private View view;

    CTCarouselViewPagerAdapter(Context context, CTInboxListViewFragment parent, CTInboxMessage inboxMessage, LinearLayout.LayoutParams layoutParams, int row) {
        this.context = context;
        this.parentWeakReference = new WeakReference<CTInboxListViewFragment>(parent);
        this.carouselImagesData = inboxMessage.getCarouselImagesData();
        this.layoutParams = layoutParams;
        this.inboxMessage = inboxMessage;
        this.row = row;
    }

    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        View view = (View)object;
        container.removeView(view);
    }

    public int getCount() {
        return this.carouselImagesData.size();
    }

    @NonNull
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        this.layoutInflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
        this.view = this.layoutInflater.inflate(R.layout.inbox_carousel_image_layout, container, false);
        try {
            if (this.inboxMessage.getOrientation().equalsIgnoreCase("l")) {
                ImageView imageView = (ImageView)this.view.findViewById(R.id.imageView);
                this.addImageAndSetClick(imageView, this.view, position, container);
            } else if (this.inboxMessage.getOrientation().equalsIgnoreCase("p")) {
                ImageView imageView = (ImageView)this.view.findViewById(R.id.squareImageView);
                this.addImageAndSetClick(imageView, this.view, position, container);
            }
        }
        catch (NoClassDefFoundError error) {
            Logger.d("CleverTap SDK requires Glide dependency. Please refer CleverTap Documentation for more info");
        }
        return this.view;
    }

    public boolean isViewFromObject(@NonNull View view, @NonNull Object o) {
        return view == o;
    }

    void addImageAndSetClick(ImageView imageView, View view, final int position, ViewGroup container) {
        imageView.setVisibility(0);
        String contentDescription = this.carouselImagesData.get(position).getContentDescription();
        if (contentDescription.isEmpty()) {
            contentDescription = this.context.getString(R.string.ct_inbox_image_content_description) + (position + 1);
        }
        imageView.setContentDescription((CharSequence)contentDescription);
        try {
            Glide.with((Context)imageView.getContext()).load(this.carouselImagesData.get(position).getUrl()).apply(((RequestOptions)new RequestOptions().placeholder(Utils.getThumbnailImage(this.context, "ct_image"))).error(Utils.getThumbnailImage(this.context, "ct_image"))).into(imageView);
        }
        catch (NoSuchMethodError error) {
            Logger.d("CleverTap SDK requires Glide v4.9.0 or above. Please refer CleverTap Documentation for more info");
            Glide.with((Context)imageView.getContext()).load(this.carouselImagesData.get(position).getUrl()).into(imageView);
        }
        container.addView(view, (ViewGroup.LayoutParams)this.layoutParams);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CTInboxListViewFragment parent = CTCarouselViewPagerAdapter.this.getParent();
                if (parent != null) {
                    parent.handleViewPagerClick(CTCarouselViewPagerAdapter.this.row, position);
                }
            }
        });
    }

    CTInboxListViewFragment getParent() {
        return (CTInboxListViewFragment)((Object)this.parentWeakReference.get());
    }
}

