/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteStatement;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.db.DatabaseHelper;
import com.clevertap.android.sdk.db.QueueData;
import com.clevertap.android.sdk.db.Table;
import com.clevertap.android.sdk.inbox.CTMessageDAO;
import com.clevertap.android.sdk.usereventlogs.UserEventLogDAO;
import com.clevertap.android.sdk.usereventlogs.UserEventLogDAOImpl;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0017\b\u0000\u0018\u0000 S2\u00020\u0001:\u0001SB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0007J$\u0010\u0016\u001a\u00020\u00112\u0010\u0010\u0017\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0018\u00010\u00182\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0007J\u000e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0014J\u0013\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u001c\u00a2\u0006\u0002\u0010\u001dJ\u001c\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020 0\u001f2\b\u0010!\u001a\u0004\u0018\u00010\u0014J\u001c\u0010\"\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\u00142\b\u0010#\u001a\u0004\u0018\u00010\u0014J\u0006\u0010$\u001a\u00020%J%\u0010&\u001a\u0012\u0012\u0004\u0012\u00020(0)j\b\u0012\u0004\u0012\u00020(`'2\u0006\u0010\u0015\u001a\u00020\u0014H\u0007\u00a2\u0006\u0002\u0010*J\u001c\u0010+\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0007J$\u0010,\u001a\u00020\u00112\u0010\u0010\u0017\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0018\u00010\u00182\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0007J\u0010\u0010-\u001a\u00020.2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0014J\u0006\u0010/\u001a\u00020.J$\u00100\u001a\u00020%2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00142\b\u0010#\u001a\u0004\u0018\u00010\u00142\u0006\u00101\u001a\u00020 H\u0007J\u0016\u00102\u001a\u00020.2\f\u00103\u001a\b\u0012\u0004\u0012\u00020(0\u0018H\u0007J\u0006\u00104\u001a\u00020.J\u0018\u00105\u001a\u00020.2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00142\u0006\u00106\u001a\u00020%J\u000e\u00107\u001a\u00020.2\u0006\u00108\u001a\u000209J\u0016\u0010:\u001a\u00020;2\u0006\u00108\u001a\u0002092\u0006\u0010<\u001a\u00020=J\u000e\u0010>\u001a\u00020;2\u0006\u0010?\u001a\u00020=J\u0018\u0010@\u001a\u00020.2\u0006\u0010A\u001a\u00020\u00142\u0006\u00108\u001a\u000209H\u0007J\u001e\u0010B\u001a\u00020.2\u0006\u00108\u001a\u0002092\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00140\u0018H\u0007J\u001d\u0010D\u001a\u00020.2\u000e\u0010E\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u001cH\u0007\u00a2\u0006\u0002\u0010FJ\u0018\u0010G\u001a\u00020%2\u0006\u00101\u001a\u00020 2\u0006\u00108\u001a\u000209H\u0007J\u000e\u0010H\u001a\u00020.2\u0006\u00108\u001a\u000209J\b\u0010I\u001a\u00020\tH\u0007J\b\u0010J\u001a\u00020\u0011H\u0003J\u0018\u0010K\u001a\u00020.2\u0006\u00108\u001a\u0002092\u0006\u0010L\u001a\u00020%H\u0002J\r\u0010M\u001a\u00020.H\u0001\u00a2\u0006\u0002\bNJ\u0010\u0010O\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\u0010\u0010P\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010Q\u001a\u00020\u00142\u0006\u0010R\u001a\u00020=H\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lcom/clevertap/android/sdk/db/DBAdapter;", "", "context", "Landroid/content/Context;", "config", "Lcom/clevertap/android/sdk/CleverTapInstanceConfig;", "<init>", "(Landroid/content/Context;Lcom/clevertap/android/sdk/CleverTapInstanceConfig;)V", "userEventLogDao", "Lcom/clevertap/android/sdk/usereventlogs/UserEventLogDAO;", "logger", "Lcom/clevertap/android/sdk/Logger;", "kotlin.jvm.PlatformType", "Lcom/clevertap/android/sdk/Logger;", "dbHelper", "Lcom/clevertap/android/sdk/db/DatabaseHelper;", "rtlDirtyFlag", "", "deleteMessageForId", "messageId", "", "userId", "deleteMessagesForIDs", "messageIDs", "", "doesPushNotificationIdExist", "id", "fetchPushNotificationIds", "", "()[Ljava/lang/String;", "fetchUserProfilesByAccountId", "", "Lorg/json/JSONObject;", "accountId", "fetchUserProfileByAccountIdAndDeviceID", "deviceId", "getLastUninstallTimestamp", "", "getMessages", "Lkotlin/collections/ArrayList;", "Lcom/clevertap/android/sdk/inbox/CTMessageDAO;", "Ljava/util/ArrayList;", "(Ljava/lang/String;)Ljava/util/ArrayList;", "markReadMessageForId", "markReadMessagesForIds", "removeUserProfilesForAccountId", "", "storeUninstallTimestamp", "storeUserProfile", "obj", "upsertMessages", "inboxMessages", "cleanUpPushNotifications", "storePushNotificationId", "ttl", "cleanupStaleEvents", "table", "Lcom/clevertap/android/sdk/db/Table;", "fetchEvents", "Lcom/clevertap/android/sdk/db/QueueData;", "limit", "", "fetchCombinedEvents", "batchSize", "cleanupEventsFromLastId", "lastId", "cleanupEventsByIds", "events", "updatePushNotificationIds", "ids", "([Ljava/lang/String;)V", "storeObject", "removeEvents", "userEventLogDAO", "belowMemThreshold", "cleanInternal", "expiration", "deleteDB", "deleteDB$clevertap_core_release", "fetchPushNotificationId", "getDatabaseName", "getTemplateMarkersList", "count", "Companion", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nDBAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DBAdapter.kt\ncom/clevertap/android/sdk/db/DBAdapter\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,785:1\n37#2,2:786\n37#2,2:788\n37#2,2:790\n37#2,2:793\n1863#3:792\n1864#3:795\n1#4:796\n*S KotlinDebug\n*F\n+ 1 DBAdapter.kt\ncom/clevertap/android/sdk/db/DBAdapter\n*L\n98#1:786,2\n136#1:788,2\n331#1:790,2\n635#1:793,2\n630#1:792\n630#1:795\n*E\n"})
public final class DBAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private volatile UserEventLogDAO userEventLogDao;
    private final Logger logger;
    @NotNull
    private final DatabaseHelper dbHelper;
    private boolean rtlDirtyFlag;
    private static final long DATA_EXPIRATION = 432000000L;
    public static final long DB_UPDATE_ERROR = -1L;
    public static final long DB_OUT_OF_MEMORY_ERROR = -2L;
    private static final long DB_UNDEFINED_CODE = -3L;
    @NotNull
    private static final String DATABASE_NAME = "clevertap";
    @NotNull
    public static final String NOT_ENOUGH_SPACE_LOG = "There is not enough space left on the device to store data, data discarded";

    public DBAdapter(@NotNull Context context, @NotNull CleverTapInstanceConfig config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.logger = config.getLogger();
        String string2 = this.getDatabaseName(config);
        Logger logger = this.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        this.dbHelper = new DatabaseHelper(context, config, string2, logger);
        this.rtlDirtyFlag = true;
    }

    @WorkerThread
    public final synchronized boolean deleteMessageForId(@Nullable String messageId, @Nullable String userId) {
        boolean bl;
        if (messageId == null || userId == null) {
            return false;
        }
        String tName = Table.INBOX_MESSAGES.getTableName();
        try {
            String[] stringArray = new String[]{messageId, userId};
            this.dbHelper.getWritableDatabase().delete(tName, "_id = ? AND messageUser = ?", stringArray);
            bl = true;
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error removing stale records from " + tName, e);
            bl = false;
        }
        return bl;
    }

    @WorkerThread
    public final synchronized boolean deleteMessagesForIDs(@Nullable List<String> messageIDs, @Nullable String userId) {
        boolean bl;
        if (messageIDs == null || userId == null) {
            return false;
        }
        String tName = Table.INBOX_MESSAGES.getTableName();
        String idsTemplateGroup = this.getTemplateMarkersList(messageIDs.size());
        List whereArgs = CollectionsKt.toMutableList((Collection)messageIDs);
        whereArgs.add(userId);
        try {
            Collection $this$toTypedArray$iv = whereArgs;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            this.dbHelper.getWritableDatabase().delete(tName, "_id IN (" + idsTemplateGroup + ") AND messageUser = ?", thisCollection$iv.toArray(new String[0]));
            bl = true;
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error removing stale records from " + tName, e);
            bl = false;
        }
        return bl;
    }

    public final synchronized boolean doesPushNotificationIdExist(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        return Intrinsics.areEqual((Object)id2, (Object)this.fetchPushNotificationId(id2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final synchronized String[] fetchPushNotificationIds() {
        List pushIds;
        block9: {
            if (!this.rtlDirtyFlag) {
                return new String[0];
            }
            String tName = Table.PUSH_NOTIFICATIONS.getTableName();
            pushIds = new ArrayList();
            try {
                Cursor cursor = this.dbHelper.getReadableDatabase().query(tName, null, "isRead = 0", null, null, null, null);
                if (cursor == null) break block9;
                Closeable closeable = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Cursor cursor2 = (Cursor)closeable;
                    boolean bl = false;
                    while (cursor2.moveToNext()) {
                        int dataIndex = cursor2.getColumnIndex("data");
                        if (dataIndex < 0) continue;
                        String data = cursor2.getString(dataIndex);
                        this.logger.verbose("Fetching PID - " + data);
                        pushIds.add(data);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (SQLiteException e) {
                this.logger.verbose("Could not fetch records out of database " + tName + '.', e);
            }
        }
        Collection $this$toTypedArray$iv = pushIds;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final synchronized Map<String, JSONObject> fetchUserProfilesByAccountId(@Nullable String accountId) {
        Map profiles;
        block13: {
            if (accountId == null) {
                return MapsKt.emptyMap();
            }
            profiles = new LinkedHashMap();
            String tName = Table.USER_PROFILES.getTableName();
            try {
                Object object = new String[]{accountId};
                Cursor cursor = this.dbHelper.getReadableDatabase().query(tName, null, "_id = ?", object, null, null, null);
                if (cursor == null) break block13;
                object = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Cursor cursor2 = (Cursor)object;
                    boolean bl = false;
                    int dataIndex = cursor2.getColumnIndex("data");
                    int deviceId = cursor2.getColumnIndex("deviceID");
                    if (dataIndex >= 0) {
                        while (cursor2.moveToNext()) {
                            String profileString = cursor2.getString(dataIndex);
                            String deviceIdString = cursor2.getString(deviceId);
                            if (profileString != null) {
                                Unit unit;
                                boolean bl2 = false;
                                try {
                                    String it;
                                    JSONObject jsonObject = new JSONObject(it);
                                    Intrinsics.checkNotNull((Object)deviceIdString);
                                    unit = profiles.put(deviceIdString, jsonObject);
                                }
                                catch (JSONException e) {
                                    this.logger.verbose("Error parsing JSON for profile", e);
                                    unit = Unit.INSTANCE;
                                }
                            }
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            catch (SQLiteException e) {
                this.logger.verbose("Could not fetch records out of database " + tName + '.', e);
            }
        }
        return profiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final synchronized JSONObject fetchUserProfileByAccountIdAndDeviceID(@Nullable String accountId, @Nullable String deviceId) {
        JSONObject jSONObject;
        String profileString;
        block13: {
            if (accountId == null || deviceId == null) {
                return null;
            }
            String tName = Table.USER_PROFILES.getTableName();
            profileString = null;
            try {
                Object object = new String[]{accountId, deviceId};
                Cursor cursor = this.dbHelper.getReadableDatabase().query(tName, null, "_id = ? AND deviceID = ?", object, null, null, null);
                if (cursor == null) break block13;
                object = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    int dataIndex;
                    Cursor cursor2 = (Cursor)object;
                    boolean bl = false;
                    if (cursor2.moveToFirst() && (dataIndex = cursor2.getColumnIndex("data")) >= 0) {
                        profileString = cursor2.getString(dataIndex);
                    }
                    cursor2 = Unit.INSTANCE;
                }
                catch (Throwable cursor2) {
                    throwable = cursor2;
                    throw cursor2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            catch (SQLiteException e) {
                this.logger.verbose("Could not fetch records out of database " + tName + '.', e);
            }
        }
        String string2 = profileString;
        if (string2 != null) {
            JSONObject jSONObject2;
            String it = string2;
            boolean bl = false;
            try {
                jSONObject2 = new JSONObject(it);
            }
            catch (JSONException e) {
                jSONObject2 = null;
            }
            jSONObject = jSONObject2;
        } else {
            jSONObject = null;
        }
        return jSONObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized long getLastUninstallTimestamp() {
        long timestamp;
        block8: {
            String tName = Table.UNINSTALL_TS.getTableName();
            timestamp = 0L;
            try {
                Cursor cursor = this.dbHelper.getReadableDatabase().query(tName, null, null, null, null, null, "created_at DESC", "1");
                if (cursor == null) break block8;
                Closeable closeable = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Cursor cursor2 = (Cursor)closeable;
                    boolean bl = false;
                    if (cursor2.moveToFirst()) {
                        timestamp = cursor2.getLong(cursor2.getColumnIndexOrThrow("created_at"));
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                this.logger.verbose("Could not fetch records out of database " + tName + '.', e);
            }
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @NotNull
    public final synchronized ArrayList<CTMessageDAO> getMessages(@NotNull String userId) {
        ArrayList<CTMessageDAO> messageDAOArrayList;
        block8: {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            String tName = Table.INBOX_MESSAGES.getTableName();
            messageDAOArrayList = new ArrayList<CTMessageDAO>();
            try {
                Object object = new String[]{userId};
                Cursor cursor = this.dbHelper.getReadableDatabase().query(tName, null, "messageUser = ?", object, null, null, "created_at DESC");
                if (cursor == null) break block8;
                object = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Cursor cursor2 = (Cursor)object;
                    boolean bl = false;
                    while (cursor2.moveToNext()) {
                        CTMessageDAO ctMessageDAO = new CTMessageDAO();
                        ctMessageDAO.setId(cursor2.getString(cursor2.getColumnIndexOrThrow("_id")));
                        ctMessageDAO.setJsonData(new JSONObject(cursor2.getString(cursor2.getColumnIndexOrThrow("data"))));
                        ctMessageDAO.setWzrkParams(new JSONObject(cursor2.getString(cursor2.getColumnIndexOrThrow("wzrkParams"))));
                        ctMessageDAO.setDate(cursor2.getLong(cursor2.getColumnIndexOrThrow("created_at")));
                        ctMessageDAO.setExpires(cursor2.getLong(cursor2.getColumnIndexOrThrow("expires")));
                        ctMessageDAO.setRead(cursor2.getInt(cursor2.getColumnIndexOrThrow("isRead")));
                        ctMessageDAO.setUserId(cursor2.getString(cursor2.getColumnIndexOrThrow("messageUser")));
                        ctMessageDAO.setTags(cursor2.getString(cursor2.getColumnIndexOrThrow("tags")));
                        ctMessageDAO.setCampaignId(cursor2.getString(cursor2.getColumnIndexOrThrow("campaignId")));
                        messageDAOArrayList.add(ctMessageDAO);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                this.logger.verbose("Error retrieving records from " + tName, e);
            }
        }
        return messageDAOArrayList;
    }

    @WorkerThread
    public final synchronized boolean markReadMessageForId(@Nullable String messageId, @Nullable String userId) {
        boolean bl;
        if (messageId == null || userId == null) {
            return false;
        }
        String tName = Table.INBOX_MESSAGES.getTableName();
        ContentValues cv = new ContentValues();
        cv.put("isRead", Integer.valueOf(1));
        try {
            String[] stringArray = new String[]{messageId, userId};
            this.dbHelper.getWritableDatabase().update(Table.INBOX_MESSAGES.getTableName(), cv, "_id = ? AND messageUser = ?", stringArray);
            bl = true;
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error removing stale records from " + tName, e);
            bl = false;
        }
        return bl;
    }

    @WorkerThread
    public final synchronized boolean markReadMessagesForIds(@Nullable List<String> messageIDs, @Nullable String userId) {
        boolean bl;
        if (messageIDs == null || userId == null) {
            return false;
        }
        String tName = Table.INBOX_MESSAGES.getTableName();
        String idsTemplateGroup = this.getTemplateMarkersList(messageIDs.size());
        List whereArgs = CollectionsKt.toMutableList((Collection)messageIDs);
        whereArgs.add(userId);
        ContentValues cv = new ContentValues();
        cv.put("isRead", Integer.valueOf(1));
        try {
            Collection $this$toTypedArray$iv = whereArgs;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            this.dbHelper.getWritableDatabase().update(Table.INBOX_MESSAGES.getTableName(), cv, "_id IN (" + idsTemplateGroup + ") AND messageUser = ?", thisCollection$iv.toArray(new String[0]));
            bl = true;
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error removing stale records from " + tName, e);
            bl = false;
        }
        return bl;
    }

    public final synchronized void removeUserProfilesForAccountId(@Nullable String id2) {
        if (id2 == null) {
            return;
        }
        String tableName = Table.USER_PROFILES.getTableName();
        try {
            String[] stringArray = new String[]{id2};
            this.dbHelper.getWritableDatabase().delete(tableName, "_id = ?", stringArray);
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error removing user profile from " + tableName + " Recreating DB");
            this.deleteDB$clevertap_core_release();
        }
    }

    public final synchronized void storeUninstallTimestamp() {
        if (!this.belowMemThreshold()) {
            this.logger.verbose(NOT_ENOUGH_SPACE_LOG);
            return;
        }
        String tableName = Table.UNINSTALL_TS.getTableName();
        ContentValues cv = new ContentValues();
        cv.put("created_at", Long.valueOf(System.currentTimeMillis()));
        try {
            this.dbHelper.getWritableDatabase().insert(tableName, null, cv);
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error adding data to table " + tableName + " Recreating DB");
            this.deleteDB$clevertap_core_release();
        }
    }

    @WorkerThread
    public final synchronized long storeUserProfile(@Nullable String id2, @Nullable String deviceId, @NotNull JSONObject obj) {
        long l;
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        if (id2 == null || deviceId == null) {
            return -1L;
        }
        if (!this.belowMemThreshold()) {
            this.logger.verbose(NOT_ENOUGH_SPACE_LOG);
            return -2L;
        }
        String tableName = Table.USER_PROFILES.getTableName();
        this.logger.verbose("Inserting or updating userProfile for accountID = " + id2 + " + deviceID = " + deviceId);
        ContentValues cv = new ContentValues();
        cv.put("data", obj.toString());
        cv.put("_id", id2);
        cv.put("deviceID", deviceId);
        try {
            l = this.dbHelper.getWritableDatabase().insertWithOnConflict(tableName, null, cv, 5);
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error adding data to table " + tableName + " Recreating DB");
            this.deleteDB$clevertap_core_release();
            l = -1L;
        }
        return l;
    }

    @WorkerThread
    public final synchronized void upsertMessages(@NotNull List<? extends CTMessageDAO> inboxMessages) {
        Intrinsics.checkNotNullParameter(inboxMessages, (String)"inboxMessages");
        if (!this.belowMemThreshold()) {
            this.logger.verbose(NOT_ENOUGH_SPACE_LOG);
            return;
        }
        for (CTMessageDAO cTMessageDAO : inboxMessages) {
            Long l;
            ContentValues cv = new ContentValues();
            cv.put("_id", cTMessageDAO.getId());
            cv.put("data", cTMessageDAO.getJsonData().toString());
            cv.put("wzrkParams", cTMessageDAO.getWzrkParams().toString());
            cv.put("campaignId", cTMessageDAO.getCampaignId());
            cv.put("tags", cTMessageDAO.getTags());
            cv.put("isRead", Integer.valueOf(cTMessageDAO.isRead()));
            cv.put("expires", Long.valueOf(cTMessageDAO.getExpires()));
            cv.put("created_at", Long.valueOf(cTMessageDAO.getDate()));
            cv.put("messageUser", cTMessageDAO.getUserId());
            try {
                l = this.dbHelper.getWritableDatabase().insertWithOnConflict(Table.INBOX_MESSAGES.getTableName(), null, cv, 5);
            }
            catch (SQLiteException e) {
                this.logger.verbose("Error adding data to table " + Table.INBOX_MESSAGES.getTableName());
                l = Unit.INSTANCE;
            }
        }
    }

    public final synchronized void cleanUpPushNotifications() {
        this.cleanInternal(Table.PUSH_NOTIFICATIONS, 0L);
    }

    public final synchronized void storePushNotificationId(@Nullable String id2, long ttl) {
        if (id2 == null) {
            return;
        }
        if (!this.belowMemThreshold()) {
            this.logger.verbose(NOT_ENOUGH_SPACE_LOG);
            return;
        }
        String tableName = Table.PUSH_NOTIFICATIONS.getTableName();
        long createdAtTime = ttl > 0L ? ttl : System.currentTimeMillis() + 345600000L;
        ContentValues cv = new ContentValues();
        cv.put("data", id2);
        cv.put("created_at", Long.valueOf(createdAtTime));
        cv.put("isRead", Integer.valueOf(0));
        try {
            this.dbHelper.getWritableDatabase().insert(tableName, null, cv);
            this.rtlDirtyFlag = true;
            this.logger.verbose("Stored PN - " + id2 + " with TTL - " + createdAtTime);
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error adding data to table " + tableName + " Recreating DB");
            this.deleteDB$clevertap_core_release();
        }
    }

    public final synchronized void cleanupStaleEvents(@NotNull Table table) {
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        this.cleanInternal(table, 432000000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final synchronized QueueData fetchEvents(@NotNull Table table, int limit) {
        String tName;
        QueueData queueData;
        block11: {
            Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
            queueData = new QueueData();
            tName = table.getTableName();
            try {
                Object object = new String[]{"_id", "data", "created_at"};
                Cursor cursor = this.dbHelper.getReadableDatabase().query(tName, object, null, null, null, null, "created_at ASC", String.valueOf(limit + 1));
                if (cursor == null) break block11;
                object = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Cursor cursor2 = (Cursor)object;
                    boolean bl = false;
                    int rowCount = cursor2.getCount();
                    queueData.setHasMore$clevertap_core_release(rowCount > limit);
                    for (int pos = 0; cursor2.moveToNext() && pos != limit; ++pos) {
                        String id2 = cursor2.getString(cursor2.getColumnIndexOrThrow("_id"));
                        String eventData = cursor2.getString(cursor2.getColumnIndexOrThrow("data"));
                        try {
                            boolean bl2;
                            JSONObject jsonEvent = new JSONObject(eventData);
                            queueData.getData$clevertap_core_release().put((Object)jsonEvent);
                            if (table == Table.PROFILE_EVENTS) {
                                List<String> list = queueData.getProfileEventIds$clevertap_core_release();
                                Intrinsics.checkNotNull((Object)id2);
                                bl2 = list.add(id2);
                                continue;
                            }
                            List<String> list = queueData.getEventIds$clevertap_core_release();
                            Intrinsics.checkNotNull((Object)id2);
                            bl2 = list.add(id2);
                            continue;
                        }
                        catch (JSONException e) {
                            this.logger.verbose("Error parsing event data for id: " + id2 + " from table: " + tName, e);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                this.logger.verbose("Could not fetch records from table " + tName, e);
            }
        }
        int size = table == Table.PROFILE_EVENTS ? queueData.getProfileEventIds$clevertap_core_release().size() : queueData.getEventIds$clevertap_core_release().size();
        this.logger.verbose("Fetched " + size + " events from " + tName);
        return queueData;
    }

    @NotNull
    public final synchronized QueueData fetchCombinedEvents(int batchSize) {
        QueueData combinedQueueData = new QueueData();
        QueueData profileData = this.fetchEvents(Table.PROFILE_EVENTS, batchSize);
        int n = profileData.getData$clevertap_core_release().length();
        for (int i = 0; i < n; ++i) {
            combinedQueueData.getData$clevertap_core_release().put((Object)profileData.getData$clevertap_core_release().getJSONObject(i));
        }
        combinedQueueData.getProfileEventIds$clevertap_core_release().addAll((Collection<String>)profileData.getProfileEventIds$clevertap_core_release());
        combinedQueueData.setHasMore$clevertap_core_release(profileData.getHasMore$clevertap_core_release());
        int eventsNeeded = batchSize - combinedQueueData.getProfileEventIds$clevertap_core_release().size();
        if (eventsNeeded > 0 || !combinedQueueData.getHasMore$clevertap_core_release()) {
            QueueData eventsData = this.fetchEvents(Table.EVENTS, eventsNeeded);
            int n2 = eventsData.getData$clevertap_core_release().length();
            for (int i = 0; i < n2; ++i) {
                combinedQueueData.getData$clevertap_core_release().put((Object)eventsData.getData$clevertap_core_release().getJSONObject(i));
            }
            combinedQueueData.getEventIds$clevertap_core_release().addAll((Collection<String>)eventsData.getEventIds$clevertap_core_release());
            combinedQueueData.setHasMore$clevertap_core_release(eventsData.getHasMore$clevertap_core_release());
        }
        this.logger.verbose("Fetched combined batch: " + combinedQueueData.getProfileEventIds$clevertap_core_release().size() + " profile events, " + combinedQueueData.getEventIds$clevertap_core_release().size() + " events");
        return combinedQueueData;
    }

    @WorkerThread
    public final synchronized void cleanupEventsFromLastId(@NotNull String lastId, @NotNull Table table) {
        Intrinsics.checkNotNullParameter((Object)lastId, (String)"lastId");
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        String tName = table.getTableName();
        try {
            String[] stringArray = new String[]{lastId};
            this.dbHelper.getWritableDatabase().delete(tName, "_id <= ?", stringArray);
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error removing sent data from table " + tName + " Recreating DB");
            this.deleteDB$clevertap_core_release();
        }
    }

    @WorkerThread
    public final synchronized void cleanupEventsByIds(@NotNull Table table, @NotNull List<String> events) {
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        Intrinsics.checkNotNullParameter(events, (String)"events");
        if (events.isEmpty()) {
            return;
        }
        String tName = table.getTableName();
        try {
            int chunkSize = 100;
            Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)events, (int)chunkSize);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List chunk = (List)element$iv;
                boolean bl = false;
                String placeholders = CollectionsKt.joinToString$default((Iterable)chunk, (CharSequence)",", null, null, (int)0, null, DBAdapter::cleanupEventsByIds$lambda$9$lambda$8, (int)30, null);
                Collection $this$toTypedArray$iv = chunk;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                int deletedCount = this.dbHelper.getWritableDatabase().delete(tName, "_id IN (" + placeholders + ')', thisCollection$iv.toArray(new String[0]));
                this.logger.verbose("Deleted " + deletedCount + " events from " + tName);
            }
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error removing events from " + tName, e);
            this.deleteDB$clevertap_core_release();
        }
    }

    @WorkerThread
    public final synchronized void updatePushNotificationIds(@NotNull String[] ids) {
        Intrinsics.checkNotNullParameter((Object)ids, (String)"ids");
        if (ids.length == 0) {
            return;
        }
        if (!this.belowMemThreshold()) {
            this.logger.verbose(NOT_ENOUGH_SPACE_LOG);
            return;
        }
        String tableName = Table.PUSH_NOTIFICATIONS.getTableName();
        ContentValues cv = new ContentValues();
        cv.put("isRead", Integer.valueOf(1));
        String idsTemplateGroup = this.getTemplateMarkersList(ids.length);
        try {
            this.dbHelper.getWritableDatabase().update(tableName, cv, "data IN (" + idsTemplateGroup + ')', ids);
            this.rtlDirtyFlag = false;
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error adding data to table " + tableName + " Recreating DB");
            this.deleteDB$clevertap_core_release();
        }
    }

    @WorkerThread
    public final synchronized long storeObject(@NotNull JSONObject obj, @NotNull Table table) {
        long l;
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        if (!this.belowMemThreshold()) {
            this.logger.verbose(NOT_ENOUGH_SPACE_LOG);
            return -2L;
        }
        String tableName = table.getTableName();
        ContentValues cv = new ContentValues();
        cv.put("data", obj.toString());
        cv.put("created_at", Long.valueOf(System.currentTimeMillis()));
        try {
            this.dbHelper.getWritableDatabase().insert(tableName, null, cv);
            String sql = "SELECT COUNT(*) FROM " + tableName;
            SQLiteStatement statement = this.dbHelper.getWritableDatabase().compileStatement(sql);
            l = statement.simpleQueryForLong();
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error adding data to table " + tableName + " Recreating DB");
            this.deleteDB$clevertap_core_release();
            l = -1L;
        }
        return l;
    }

    public final synchronized void removeEvents(@NotNull Table table) {
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        String tName = table.getTableName();
        try {
            this.dbHelper.getWritableDatabase().delete(tName, null, null);
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error removing all events from table " + tName + " Recreating DB");
            this.deleteDB$clevertap_core_release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @NotNull
    public final UserEventLogDAO userEventLogDAO() {
        UserEventLogDAO userEventLogDAO = this.userEventLogDao;
        if (userEventLogDAO == null) {
            DBAdapter dBAdapter = this;
            synchronized (dBAdapter) {
                boolean bl = false;
                UserEventLogDAO userEventLogDAO2 = this.userEventLogDao;
                if (userEventLogDAO2 == null) {
                    UserEventLogDAOImpl userEventLogDAOImpl;
                    Logger logger = this.logger;
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
                    UserEventLogDAOImpl it = userEventLogDAOImpl = new UserEventLogDAOImpl(this.dbHelper, logger, Table.USER_EVENT_LOGS_TABLE);
                    boolean bl2 = false;
                    this.userEventLogDao = it;
                    userEventLogDAO2 = userEventLogDAOImpl;
                }
                UserEventLogDAO userEventLogDAO3 = userEventLogDAO2;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl18 : MonitorExitStatement: MONITOREXIT : var1_1
                userEventLogDAO = userEventLogDAO3;
            }
        }
        return userEventLogDAO;
    }

    @WorkerThread
    private final boolean belowMemThreshold() {
        return this.dbHelper.belowMemThreshold();
    }

    private final void cleanInternal(Table table, long expiration) {
        long time = (System.currentTimeMillis() - expiration) / (long)1000;
        String tName = table.getTableName();
        try {
            this.dbHelper.getWritableDatabase().delete(tName, "created_at <= " + time, null);
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error removing stale event records from " + tName + ". Recreating DB.", e);
            this.deleteDB$clevertap_core_release();
        }
    }

    @VisibleForTesting
    public final void deleteDB$clevertap_core_release() {
        this.dbHelper.deleteDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String fetchPushNotificationId(String id2) {
        String pushId;
        block8: {
            String tName = Table.PUSH_NOTIFICATIONS.getTableName();
            pushId = null;
            pushId = "";
            try {
                Object object = new String[]{id2};
                Cursor cursor = this.dbHelper.getReadableDatabase().query(tName, null, "data =?", object, null, null, null);
                if (cursor == null) break block8;
                object = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Cursor cursor2 = (Cursor)object;
                    boolean bl = false;
                    if (cursor2.moveToFirst()) {
                        pushId = cursor2.getString(cursor2.getColumnIndexOrThrow("data"));
                    }
                    this.logger.verbose("Fetching PID for check - " + pushId);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                this.logger.verbose("Could not fetch records out of database " + tName + '.', e);
            }
        }
        return pushId;
    }

    private final String getDatabaseName(CleverTapInstanceConfig config) {
        return config.isDefaultInstance() ? DATABASE_NAME : "clevertap_" + config.getAccountId();
    }

    private final String getTemplateMarkersList(int count) {
        StringBuilder stringBuilder;
        StringBuilder $this$getTemplateMarkersList_u24lambda_u2414 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (count > 0) {
            $this$getTemplateMarkersList_u24lambda_u2414.append("?");
            int n = count - 1;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl2 = false;
                $this$getTemplateMarkersList_u24lambda_u2414.append(", ?");
            }
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private static final CharSequence cleanupEventsByIds$lambda$9$lambda$8(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "?";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0003R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/clevertap/android/sdk/db/DBAdapter$Companion;", "", "<init>", "()V", "DATA_EXPIRATION", "", "DB_UPDATE_ERROR", "DB_OUT_OF_MEMORY_ERROR", "DB_UNDEFINED_CODE", "getDB_UNDEFINED_CODE$annotations", "DATABASE_NAME", "", "NOT_ENOUGH_SPACE_LOG", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getDB_UNDEFINED_CODE$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

