/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp.fragment;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;
import androidx.fragment.app.FragmentActivity;
import com.clevertap.android.sdk.CTWebInterface;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.R;
import com.clevertap.android.sdk.customviews.CloseImageView;
import com.clevertap.android.sdk.inapp.CTInAppWebView;
import com.clevertap.android.sdk.inapp.InAppWebViewClient;
import com.clevertap.android.sdk.inapp.fragment.CTInAppBaseFullFragment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b \u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u001a\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u001c\u0010!\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0003J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u001eH\u0002J\b\u0010$\u001a\u00020\u000bH\u0002J\b\u0010%\u001a\u00020\u000bH\u0002J\b\u0010&\u001a\u00020\u0017H\u0002J\b\u0010'\u001a\u00020\u0017H\u0002J\b\u0010(\u001a\u00020\u0017H\u0002R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006)"}, d2={"Lcom/clevertap/android/sdk/inapp/fragment/CTInAppBaseFullHtmlFragment;", "Lcom/clevertap/android/sdk/inapp/fragment/CTInAppBaseFullFragment;", "<init>", "()V", "webView", "Lcom/clevertap/android/sdk/inapp/CTInAppWebView;", "getWebView", "()Lcom/clevertap/android/sdk/inapp/CTInAppWebView;", "setWebView", "(Lcom/clevertap/android/sdk/inapp/CTInAppWebView;)V", "value", "", "isFullscreen", "()Z", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "savedInstanceState", "Landroid/os/Bundle;", "onDestroyView", "", "onViewCreated", "view", "onConfigurationChanged", "newConfig", "Landroid/content/res/Configuration;", "getLayoutParamsForCloseButton", "Landroid/widget/RelativeLayout$LayoutParams;", "webViewId", "", "displayHTMLView", "initWebViewLayoutParams", "params", "isCloseButtonEnabled", "isDarkenEnabled", "reDrawInApp", "cleanupWebView", "updateFullscreenInfo", "clevertap-core_release"})
public abstract class CTInAppBaseFullHtmlFragment
extends CTInAppBaseFullFragment {
    @Nullable
    private CTInAppWebView webView;
    private boolean isFullscreen;

    @Nullable
    protected final CTInAppWebView getWebView() {
        return this.webView;
    }

    protected final void setWebView(@Nullable CTInAppWebView cTInAppWebView) {
        this.webView = cTInAppWebView;
    }

    protected final boolean isFullscreen() {
        return this.isFullscreen;
    }

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        this.updateFullscreenInfo();
        return this.displayHTMLView(inflater, container);
    }

    public void onDestroyView() {
        this.cleanupWebView();
        super.onDestroyView();
    }

    @Override
    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        this.reDrawInApp();
    }

    public void onConfigurationChanged(@NotNull Configuration newConfig) {
        Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
        super.onConfigurationChanged(newConfig);
        this.updateFullscreenInfo();
        this.reDrawInApp();
    }

    @NotNull
    protected RelativeLayout.LayoutParams getLayoutParamsForCloseButton(int webViewId) {
        RelativeLayout.LayoutParams closeIvLp = new RelativeLayout.LayoutParams(-1, -1);
        closeIvLp.addRule(2, webViewId);
        closeIvLp.addRule(1, webViewId);
        int sub = this.getScaledPixels(40) / 2;
        closeIvLp.setMargins(-sub, 0, 0, -sub);
        return closeIvLp;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private final View displayHTMLView(LayoutInflater inflater, ViewGroup container) {
        View inAppView = null;
        try {
            inAppView = inflater.inflate(R.layout.inapp_html_full, container, false);
            RelativeLayout rl = (RelativeLayout)inAppView.findViewById(R.id.inapp_html_full_relative_layout);
            RelativeLayout.LayoutParams webViewLp = new RelativeLayout.LayoutParams(-1, -1);
            webViewLp.addRule(13);
            this.initWebViewLayoutParams(webViewLp);
            Context context = this.requireContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext(...)");
            CTInAppWebView webView = new CTInAppWebView(context, this.getInAppNotification().getWidth$clevertap_core_release(), this.getInAppNotification().getHeight$clevertap_core_release(), this.getInAppNotification().getWidthPercentage$clevertap_core_release(), this.getInAppNotification().getHeightPercentage$clevertap_core_release());
            webView.setFullscreen(this.isFullscreen);
            this.webView = webView;
            InAppWebViewClient webViewClient = new InAppWebViewClient(this);
            webView.setWebViewClient(webViewClient);
            if (this.getInAppNotification().isJsEnabled$clevertap_core_release()) {
                CleverTapAPI instance = CleverTapAPI.instanceWithConfig((Context)this.getActivity(), this.getConfig());
                CTWebInterface ctWebInterface = new CTWebInterface(instance, this);
                webView.setJavaScriptInterface(ctWebInterface);
            }
            if (this.isDarkenEnabled()) {
                rl.setBackground((Drawable)new ColorDrawable(-1157627904));
            } else {
                rl.setBackground((Drawable)new ColorDrawable(0));
            }
            rl.addView((View)webView, (ViewGroup.LayoutParams)webViewLp);
            if (this.isCloseButtonEnabled()) {
                Context context2 = inflater.getContext();
                CloseImageView closeImageView = new CloseImageView(context2);
                RelativeLayout.LayoutParams closeIvLp = this.getLayoutParamsForCloseButton(webView.getId());
                closeImageView.setOnClickListener(arg_0 -> CTInAppBaseFullHtmlFragment.displayHTMLView$lambda$0(this, arg_0));
                closeImageView.setContentDescription(context2.getString(R.string.ct_inapp_close_btn));
                this.setCloseImageView(closeImageView);
                rl.addView((View)closeImageView, (ViewGroup.LayoutParams)closeIvLp);
            }
        }
        catch (Throwable t) {
            this.getConfig().getLogger().verbose(this.getConfig().getAccountId(), "Fragment view not created", t);
            return null;
        }
        return inAppView;
    }

    private final void initWebViewLayoutParams(RelativeLayout.LayoutParams params) {
        char pos = this.getInAppNotification().getPosition$clevertap_core_release();
        char c = pos;
        if (c == 't') {
            params.addRule(10);
        } else if (c == 'l') {
            params.addRule(9);
        } else if (c == 'b') {
            params.addRule(12);
        } else if (c == 'r') {
            params.addRule(11);
        } else if (c == 'c') {
            params.addRule(13);
        }
        params.setMargins(0, 0, 0, 0);
    }

    private final boolean isCloseButtonEnabled() {
        return this.getInAppNotification().isShowClose$clevertap_core_release();
    }

    private final boolean isDarkenEnabled() {
        return this.getInAppNotification().isDarkenScreen$clevertap_core_release();
    }

    private final void reDrawInApp() {
        CTInAppWebView cTInAppWebView = this.webView;
        if (cTInAppWebView == null) {
            return;
        }
        CTInAppWebView webView = cTInAppWebView;
        webView.setFullscreen(this.isFullscreen);
        webView.updateDimension();
        String customUrl = this.getInAppNotification().getCustomInAppUrl$clevertap_core_release();
        CharSequence charSequence = customUrl;
        if (charSequence == null || charSequence.length() == 0) {
            int mHeight = webView.dim.y;
            int mWidth = webView.dim.x;
            float d = this.getResources().getDisplayMetrics().density;
            mHeight = (int)((float)mHeight / d);
            mWidth = (int)((float)mWidth / d);
            String string2 = this.getInAppNotification().getHtml$clevertap_core_release();
            if (string2 == null) {
                return;
            }
            String html = string2;
            String style2 = "<style>body{width: " + mWidth + "px; height: " + mHeight + "px; margin: 0; padding:0;}</style>";
            CharSequence charSequence2 = html;
            Regex regex = new Regex("<head>");
            String string3 = "<head>" + style2;
            html = regex.replaceFirst(charSequence2, string3);
            Logger.v("Density appears to be " + d);
            webView.setInitialScale((int)(d * (float)100));
            webView.loadDataWithBaseURL(null, html, "text/html", "utf-8", null);
        } else {
            webView.setWebViewClient(new WebViewClient());
            webView.loadUrl(customUrl);
        }
    }

    private final void cleanupWebView() {
        try {
            CTInAppWebView cTInAppWebView = this.webView;
            if (cTInAppWebView != null) {
                cTInAppWebView.cleanup(this.getInAppNotification().isJsEnabled$clevertap_core_release());
            }
            this.webView = null;
        }
        catch (Exception e) {
            this.getConfig().getLogger().verbose("cleanupWebView -> there was a crash in cleanup", e);
        }
    }

    private final void updateFullscreenInfo() {
        FragmentActivity fragmentActivity = this.getActivity();
        this.isFullscreen = (fragmentActivity != null && (fragmentActivity = fragmentActivity.getWindow()) != null && (fragmentActivity = fragmentActivity.getAttributes()) != null ? fragmentActivity.flags & 0x400 : 0) != 0;
    }

    private static final void displayHTMLView$lambda$0(CTInAppBaseFullHtmlFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.didDismiss(null);
    }
}

