/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Constants;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestInfo;
import com.clevertap.android.sdk.cryption.EncryptionLevel;
import com.clevertap.android.sdk.pushnotification.PushConstants;
import com.clevertap.android.sdk.pushnotification.PushNotificationUtil;
import com.clevertap.android.sdk.pushnotification.PushType;
import com.clevertap.android.sdk.utils.CTJsonConverter;
import java.util.ArrayList;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CleverTapInstanceConfig
implements Parcelable {
    public static final Parcelable.Creator<CleverTapInstanceConfig> CREATOR = new Parcelable.Creator<CleverTapInstanceConfig>(){

        public CleverTapInstanceConfig createFromParcel(Parcel in) {
            return new CleverTapInstanceConfig(in);
        }

        public CleverTapInstanceConfig[] newArray(int size) {
            return new CleverTapInstanceConfig[size];
        }
    };
    private String accountId;
    private String accountRegion;
    private String accountToken;
    private String proxyDomain;
    private String spikyProxyDomain;
    private String customHandshakeDomain;
    @NonNull
    private final ArrayList<PushType> pushTypes = PushNotificationUtil.getDefaultPushTypes();
    private boolean analyticsOnly;
    private boolean backgroundSync;
    private boolean beta;
    private boolean createdPostAppLaunch;
    private int debugLevel;
    private boolean disableAppLaunchedEvent;
    private boolean enableCustomCleverTapId;
    private String fcmSenderId;
    private boolean isDefaultInstance;
    private Logger logger;
    private String packageName;
    private boolean personalization;
    private String[] identityKeys = Constants.NULL_STRING_ARRAY;
    private boolean sslPinning;
    private boolean useGoogleAdId;
    private int encryptionLevel;
    private String encryptionInTransit;
    private static final String KEY_ACCOUNT_ID = "accountId";
    private static final String KEY_ACCOUNT_TOKEN = "accountToken";
    private static final String KEY_ACCOUNT_REGION = "accountRegion";
    private static final String KEY_PROXY_DOMAIN = "proxyDomain";
    private static final String KEY_SPIKY_PROXY_DOMAIN = "spikyProxyDomain";
    private static final String KEY_CUSTOM_HANDSHAKE_DOMAIN = "customHandshakeDomain";
    private static final String KEY_FCM_SENDER_ID = "fcmSenderId";
    private static final String KEY_ANALYTICS_ONLY = "analyticsOnly";
    private static final String KEY_DEFAULT_INSTANCE = "isDefaultInstance";
    private static final String KEY_USE_GOOGLE_AD_ID = "useGoogleAdId";
    private static final String KEY_DISABLE_APP_LAUNCHED = "disableAppLaunchedEvent";
    private static final String KEY_PERSONALIZATION = "personalization";
    private static final String KEY_DEBUG_LEVEL = "debugLevel";
    private static final String KEY_CREATED_POST_APP_LAUNCH = "createdPostAppLaunch";
    private static final String KEY_SSL_PINNING = "sslPinning";
    private static final String KEY_BACKGROUND_SYNC = "backgroundSync";
    private static final String KEY_ENABLE_CUSTOM_CT_ID = "getEnableCustomCleverTapId";
    private static final String KEY_BETA = "beta";
    private static final String KEY_IDENTITY_TYPES = "identityTypes";
    private static final String KEY_PACKAGE_NAME = "packageName";
    public static final String KEY_ENCRYPTION_LEVEL = "encryptionLevel";
    private static final String KEY_PUSH_TYPES = "allowedPushTypes";
    private static final String KEY_ENCRYPTION_IN_TRANSIT = "encryptionInTransit";

    public static CleverTapInstanceConfig getDefaultInstance(Context context) {
        ManifestInfo info = ManifestInfo.getInstance(context);
        return CleverTapInstanceConfig.createInstanceWithManifest(info, info.getAccountId(), info.getAccountToken(), info.getAccountRegion(), true);
    }

    public static CleverTapInstanceConfig createInstance(Context context, @NonNull String accountId, @NonNull String accountToken) {
        return CleverTapInstanceConfig.createInstance(context, accountId, accountToken, null);
    }

    public static CleverTapInstanceConfig createInstance(@NonNull Context context, @NonNull String accountId, @NonNull String accountToken, @Nullable String accountRegion) {
        if (accountId == null || accountToken == null) {
            Logger.i("CleverTap accountId and accountToken cannot be null");
            return null;
        }
        ManifestInfo manifestInfo = ManifestInfo.getInstance(context);
        return CleverTapInstanceConfig.createInstanceWithManifest(manifestInfo, accountId, accountToken, accountRegion, false);
    }

    protected static CleverTapInstanceConfig createDefaultInstance(@NonNull Context context, @NonNull String accountId, @NonNull String accountToken, @Nullable String accountRegion) {
        ManifestInfo manifestInfo = ManifestInfo.getInstance(context);
        return CleverTapInstanceConfig.createInstanceWithManifest(manifestInfo, accountId, accountToken, accountRegion, true);
    }

    static CleverTapInstanceConfig createInstanceWithManifest(@NonNull ManifestInfo manifest, @NonNull String accountId, @NonNull String accountToken, @Nullable String accountRegion, boolean isDefaultInstance) {
        return new CleverTapInstanceConfig(manifest, accountId, accountToken, accountRegion, isDefaultInstance);
    }

    @Nullable
    protected static CleverTapInstanceConfig createInstance(@NonNull String jsonString) {
        try {
            return new CleverTapInstanceConfig(jsonString);
        }
        catch (Throwable t) {
            return null;
        }
    }

    CleverTapInstanceConfig(CleverTapInstanceConfig config) {
        this.accountId = config.accountId;
        this.accountToken = config.accountToken;
        this.accountRegion = config.accountRegion;
        this.proxyDomain = config.proxyDomain;
        this.spikyProxyDomain = config.spikyProxyDomain;
        this.customHandshakeDomain = config.customHandshakeDomain;
        this.isDefaultInstance = config.isDefaultInstance;
        this.analyticsOnly = config.analyticsOnly;
        this.personalization = config.personalization;
        this.debugLevel = config.debugLevel;
        this.logger = config.logger;
        this.useGoogleAdId = config.useGoogleAdId;
        this.disableAppLaunchedEvent = config.disableAppLaunchedEvent;
        this.createdPostAppLaunch = config.createdPostAppLaunch;
        this.sslPinning = config.sslPinning;
        this.backgroundSync = config.backgroundSync;
        this.enableCustomCleverTapId = config.enableCustomCleverTapId;
        this.fcmSenderId = config.fcmSenderId;
        this.packageName = config.packageName;
        this.beta = config.beta;
        this.identityKeys = config.identityKeys;
        this.encryptionLevel = config.encryptionLevel;
        for (PushType pushType : config.pushTypes) {
            this.addPushType(pushType);
        }
        this.encryptionInTransit = config.encryptionInTransit;
    }

    private CleverTapInstanceConfig(ManifestInfo manifest, String accountId, String accountToken, String accountRegion, boolean isDefault) {
        this.accountId = accountId;
        this.accountToken = accountToken;
        this.accountRegion = accountRegion;
        this.isDefaultInstance = isDefault;
        this.analyticsOnly = false;
        this.personalization = true;
        this.debugLevel = CleverTapAPI.LogLevel.INFO.intValue();
        this.logger = new Logger(this.debugLevel);
        this.createdPostAppLaunch = false;
        this.useGoogleAdId = manifest.useGoogleAdId();
        this.disableAppLaunchedEvent = manifest.isAppLaunchedDisabled();
        this.sslPinning = manifest.isSSLPinningEnabled();
        this.backgroundSync = manifest.isBackgroundSync();
        this.fcmSenderId = manifest.getFCMSenderId();
        this.packageName = manifest.getPackageName();
        this.enableCustomCleverTapId = manifest.useCustomId();
        this.beta = manifest.enableBeta();
        if (this.isDefaultInstance) {
            this.encryptionLevel = manifest.getEncryptionLevel();
            this.identityKeys = manifest.getProfileKeys();
            this.log("ON_USER_LOGIN", "Setting Profile Keys from Manifest: " + Arrays.toString(this.identityKeys));
        } else {
            this.encryptionLevel = 0;
        }
        this.buildPushProvidersFromManifest(manifest);
        String fromManifest = manifest.getEncryptionInTransit();
        this.encryptionInTransit = fromManifest != null ? fromManifest : "0";
    }

    private void buildPushProvidersFromManifest(ManifestInfo manifest) {
        try {
            String[] splits;
            String provider2;
            String[] splits2;
            String provider1 = manifest.getVendorOneProvider();
            if (provider1 != null && (splits2 = provider1.split(",")) != null && splits2.length == 4) {
                PushType pushType = new PushType(splits2[0].trim(), splits2[1].trim(), splits2[2].trim(), splits2[3].trim());
                this.addPushType(pushType);
            }
            if ((provider2 = manifest.getVendorTwoProvider()) != null && (splits = provider2.split(",")) != null && splits.length == 4) {
                PushType pushType = new PushType(splits[0].trim(), splits[1].trim(), splits[2].trim(), splits[3].trim());
                this.addPushType(pushType);
            }
        }
        catch (Exception e) {
            Logger.v("There was some problem in loading push providers from manifest");
        }
    }

    private CleverTapInstanceConfig(String jsonString) throws Throwable {
        try {
            JSONObject configJsonObject = new JSONObject(jsonString);
            if (configJsonObject.has(KEY_ACCOUNT_ID)) {
                this.accountId = configJsonObject.getString(KEY_ACCOUNT_ID);
            }
            if (configJsonObject.has(KEY_ACCOUNT_TOKEN)) {
                this.accountToken = configJsonObject.getString(KEY_ACCOUNT_TOKEN);
            }
            if (configJsonObject.has(KEY_PROXY_DOMAIN)) {
                this.proxyDomain = configJsonObject.getString(KEY_PROXY_DOMAIN);
            }
            if (configJsonObject.has(KEY_SPIKY_PROXY_DOMAIN)) {
                this.spikyProxyDomain = configJsonObject.getString(KEY_SPIKY_PROXY_DOMAIN);
            }
            if (configJsonObject.has(KEY_CUSTOM_HANDSHAKE_DOMAIN)) {
                this.customHandshakeDomain = configJsonObject.optString(KEY_CUSTOM_HANDSHAKE_DOMAIN, null);
            }
            if (configJsonObject.has(KEY_ACCOUNT_REGION)) {
                this.accountRegion = configJsonObject.getString(KEY_ACCOUNT_REGION);
            }
            if (configJsonObject.has(KEY_ANALYTICS_ONLY)) {
                this.analyticsOnly = configJsonObject.getBoolean(KEY_ANALYTICS_ONLY);
            }
            if (configJsonObject.has(KEY_DEFAULT_INSTANCE)) {
                this.isDefaultInstance = configJsonObject.getBoolean(KEY_DEFAULT_INSTANCE);
            }
            if (configJsonObject.has(KEY_USE_GOOGLE_AD_ID)) {
                this.useGoogleAdId = configJsonObject.getBoolean(KEY_USE_GOOGLE_AD_ID);
            }
            if (configJsonObject.has(KEY_DISABLE_APP_LAUNCHED)) {
                this.disableAppLaunchedEvent = configJsonObject.getBoolean(KEY_DISABLE_APP_LAUNCHED);
            }
            if (configJsonObject.has(KEY_PERSONALIZATION)) {
                this.personalization = configJsonObject.getBoolean(KEY_PERSONALIZATION);
            }
            if (configJsonObject.has(KEY_DEBUG_LEVEL)) {
                this.debugLevel = configJsonObject.getInt(KEY_DEBUG_LEVEL);
            }
            this.logger = new Logger(this.debugLevel);
            if (configJsonObject.has(KEY_PACKAGE_NAME)) {
                this.packageName = configJsonObject.getString(KEY_PACKAGE_NAME);
            }
            if (configJsonObject.has(KEY_CREATED_POST_APP_LAUNCH)) {
                this.createdPostAppLaunch = configJsonObject.getBoolean(KEY_CREATED_POST_APP_LAUNCH);
            }
            if (configJsonObject.has(KEY_SSL_PINNING)) {
                this.sslPinning = configJsonObject.getBoolean(KEY_SSL_PINNING);
            }
            if (configJsonObject.has(KEY_BACKGROUND_SYNC)) {
                this.backgroundSync = configJsonObject.getBoolean(KEY_BACKGROUND_SYNC);
            }
            if (configJsonObject.has(KEY_ENABLE_CUSTOM_CT_ID)) {
                this.enableCustomCleverTapId = configJsonObject.getBoolean(KEY_ENABLE_CUSTOM_CT_ID);
            }
            if (configJsonObject.has(KEY_FCM_SENDER_ID)) {
                this.fcmSenderId = configJsonObject.getString(KEY_FCM_SENDER_ID);
            }
            if (configJsonObject.has(KEY_BETA)) {
                this.beta = configJsonObject.getBoolean(KEY_BETA);
            }
            if (configJsonObject.has(KEY_IDENTITY_TYPES)) {
                this.identityKeys = (String[])CTJsonConverter.toArray(configJsonObject.getJSONArray(KEY_IDENTITY_TYPES));
            }
            if (configJsonObject.has(KEY_ENCRYPTION_LEVEL)) {
                this.encryptionLevel = configJsonObject.getInt(KEY_ENCRYPTION_LEVEL);
            }
            if (configJsonObject.has(KEY_PUSH_TYPES)) {
                JSONArray pushTypesArray = configJsonObject.getJSONArray(KEY_PUSH_TYPES);
                for (int i = 0; i < pushTypesArray.length(); ++i) {
                    JSONObject pushTypeJo = pushTypesArray.getJSONObject(i);
                    PushType pushType = PushType.fromJSONObject(pushTypeJo);
                    if (pushType == null) continue;
                    this.addPushType(pushType);
                }
            }
            this.encryptionInTransit = configJsonObject.optString(KEY_ENCRYPTION_IN_TRANSIT, "0");
        }
        catch (Throwable t) {
            Logger.v("Error constructing CleverTapInstanceConfig from JSON: " + jsonString + ": ", t.getCause());
            throw t;
        }
    }

    private CleverTapInstanceConfig(Parcel in) {
        this.accountId = in.readString();
        this.accountToken = in.readString();
        this.accountRegion = in.readString();
        this.proxyDomain = in.readString();
        this.spikyProxyDomain = in.readString();
        this.customHandshakeDomain = in.readString();
        this.analyticsOnly = in.readByte() != 0;
        this.isDefaultInstance = in.readByte() != 0;
        this.useGoogleAdId = in.readByte() != 0;
        this.disableAppLaunchedEvent = in.readByte() != 0;
        this.personalization = in.readByte() != 0;
        this.debugLevel = in.readInt();
        this.createdPostAppLaunch = in.readByte() != 0;
        this.sslPinning = in.readByte() != 0;
        this.backgroundSync = in.readByte() != 0;
        this.enableCustomCleverTapId = in.readByte() != 0;
        this.fcmSenderId = in.readString();
        this.packageName = in.readString();
        this.logger = new Logger(this.debugLevel);
        this.beta = in.readByte() != 0;
        this.identityKeys = in.createStringArray();
        this.encryptionLevel = in.readInt();
        this.encryptionInTransit = in.readString();
        try {
            JSONArray allowedTypesJsonArray = new JSONArray(in.readString());
            for (int i = 0; i < allowedTypesJsonArray.length(); ++i) {
                PushType pushType = PushType.fromJSONObject(allowedTypesJsonArray.getJSONObject(i));
                if (pushType == null) continue;
                this.addPushType(pushType);
            }
        }
        catch (JSONException e) {
            Logger.v("Error in loading push providers from parcel, using firebase");
        }
    }

    public int describeContents() {
        return 0;
    }

    public void enablePersonalization(boolean enablePersonalization) {
        this.personalization = enablePersonalization;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getAccountRegion() {
        return this.accountRegion;
    }

    public String getAccountToken() {
        return this.accountToken;
    }

    @NonNull
    public ArrayList<PushType> getPushTypes() {
        return this.pushTypes;
    }

    public void addPushType(@NonNull PushType allowedPushType) {
        if (!this.pushTypes.contains(allowedPushType)) {
            this.pushTypes.add(allowedPushType);
        }
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public String getProxyDomain() {
        return this.proxyDomain;
    }

    public void setProxyDomain(String proxyDomain) {
        this.proxyDomain = proxyDomain;
    }

    public String getSpikyProxyDomain() {
        return this.spikyProxyDomain;
    }

    public void setSpikyProxyDomain(String spikyProxyDomain) {
        this.spikyProxyDomain = spikyProxyDomain;
    }

    public String getCustomHandshakeDomain() {
        return this.customHandshakeDomain;
    }

    public void setCustomHandshakeDomain(String handshakeDomain) {
        this.customHandshakeDomain = handshakeDomain;
    }

    public void setDebugLevel(CleverTapAPI.LogLevel debugLevel) {
        this.setDebugLevel(debugLevel.intValue());
    }

    public void setDebugLevel(int debugLevel) {
        this.debugLevel = debugLevel;
        if (this.logger != null) {
            this.logger.setDebugLevel(debugLevel);
        }
    }

    public String getFcmSenderId() {
        return this.fcmSenderId;
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger(this.debugLevel);
        }
        return this.logger;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String[] getIdentityKeys() {
        return this.identityKeys;
    }

    public boolean isAnalyticsOnly() {
        return this.analyticsOnly;
    }

    public void setAnalyticsOnly(boolean analyticsOnly) {
        this.analyticsOnly = analyticsOnly;
    }

    public boolean isBeta() {
        return this.beta;
    }

    public boolean isDefaultInstance() {
        return this.isDefaultInstance;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void log(@NonNull String tag, @NonNull String message) {
        this.logger.verbose(this.getDefaultSuffix(tag), message);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void log(@NonNull String tag, @NonNull String message, Throwable throwable) {
        this.logger.verbose(this.getDefaultSuffix(tag), message, throwable);
    }

    public void setIdentityKeys(String ... identityKeys) {
        if (!this.isDefaultInstance) {
            this.identityKeys = identityKeys;
            this.log("ON_USER_LOGIN", "Setting Profile Keys via setter: " + Arrays.toString(this.identityKeys));
        }
    }

    public void useGoogleAdId(boolean value) {
        this.useGoogleAdId = value;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.accountId);
        dest.writeString(this.accountToken);
        dest.writeString(this.accountRegion);
        dest.writeString(this.proxyDomain);
        dest.writeString(this.spikyProxyDomain);
        dest.writeString(this.customHandshakeDomain);
        dest.writeByte((byte)(this.analyticsOnly ? 1 : 0));
        dest.writeByte((byte)(this.isDefaultInstance ? 1 : 0));
        dest.writeByte((byte)(this.useGoogleAdId ? 1 : 0));
        dest.writeByte((byte)(this.disableAppLaunchedEvent ? 1 : 0));
        dest.writeByte((byte)(this.personalization ? 1 : 0));
        dest.writeInt(this.debugLevel);
        dest.writeByte((byte)(this.createdPostAppLaunch ? 1 : 0));
        dest.writeByte((byte)(this.sslPinning ? 1 : 0));
        dest.writeByte((byte)(this.backgroundSync ? 1 : 0));
        dest.writeByte((byte)(this.enableCustomCleverTapId ? 1 : 0));
        dest.writeString(this.fcmSenderId);
        dest.writeString(this.packageName);
        dest.writeByte((byte)(this.beta ? 1 : 0));
        dest.writeStringArray(this.identityKeys);
        dest.writeInt(this.encryptionLevel);
        dest.writeString(this.encryptionInTransit);
        String allowTypesString = this.getPushTypesArray().toString();
        dest.writeString(allowTypesString);
    }

    public boolean getEnableCustomCleverTapId() {
        return this.enableCustomCleverTapId;
    }

    public void setEnableCustomCleverTapId(boolean enableCustomCleverTapId) {
        this.enableCustomCleverTapId = enableCustomCleverTapId;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public boolean isBackgroundSync() {
        return this.backgroundSync;
    }

    public void setBackgroundSync(boolean backgroundSync) {
        this.backgroundSync = backgroundSync;
    }

    public boolean isCreatedPostAppLaunch() {
        return this.createdPostAppLaunch;
    }

    boolean isDisableAppLaunchedEvent() {
        return this.disableAppLaunchedEvent;
    }

    public void setDisableAppLaunchedEvent(boolean disableAppLaunchedEvent) {
        this.disableAppLaunchedEvent = disableAppLaunchedEvent;
    }

    boolean isPersonalizationEnabled() {
        return this.personalization;
    }

    public boolean isSslPinningEnabled() {
        return this.sslPinning;
    }

    boolean isUseGoogleAdId() {
        return this.useGoogleAdId;
    }

    void setCreatedPostAppLaunch() {
        this.createdPostAppLaunch = true;
    }

    public void setEncryptionLevel(EncryptionLevel encryptionLevel) {
        this.encryptionLevel = encryptionLevel.intValue();
    }

    public int getEncryptionLevel() {
        return this.encryptionLevel;
    }

    public void setEncryptionInTransit(boolean encryptionInTransit) {
        this.encryptionInTransit = encryptionInTransit ? "1" : "0";
    }

    public boolean isEncryptionInTransitEnabled() {
        try {
            return Integer.parseInt(this.encryptionInTransit) > 0;
        }
        catch (NumberFormatException e) {
            Logger.v("Invalid value passed in manifest for encryption in transit");
            return false;
        }
    }

    String toJSONString() {
        JSONObject configJsonObject = new JSONObject();
        try {
            configJsonObject.put(KEY_ACCOUNT_ID, (Object)this.getAccountId());
            configJsonObject.put(KEY_ACCOUNT_TOKEN, (Object)this.getAccountToken());
            configJsonObject.put(KEY_ACCOUNT_REGION, (Object)this.getAccountRegion());
            configJsonObject.put(KEY_PROXY_DOMAIN, (Object)this.getProxyDomain());
            configJsonObject.put(KEY_SPIKY_PROXY_DOMAIN, (Object)this.getSpikyProxyDomain());
            configJsonObject.put(KEY_CUSTOM_HANDSHAKE_DOMAIN, (Object)this.getCustomHandshakeDomain());
            configJsonObject.put(KEY_FCM_SENDER_ID, (Object)this.getFcmSenderId());
            configJsonObject.put(KEY_ANALYTICS_ONLY, this.isAnalyticsOnly());
            configJsonObject.put(KEY_DEFAULT_INSTANCE, this.isDefaultInstance());
            configJsonObject.put(KEY_USE_GOOGLE_AD_ID, this.isUseGoogleAdId());
            configJsonObject.put(KEY_DISABLE_APP_LAUNCHED, this.isDisableAppLaunchedEvent());
            configJsonObject.put(KEY_PERSONALIZATION, this.isPersonalizationEnabled());
            configJsonObject.put(KEY_DEBUG_LEVEL, this.getDebugLevel());
            configJsonObject.put(KEY_CREATED_POST_APP_LAUNCH, this.isCreatedPostAppLaunch());
            configJsonObject.put(KEY_SSL_PINNING, this.isSslPinningEnabled());
            configJsonObject.put(KEY_BACKGROUND_SYNC, this.isBackgroundSync());
            configJsonObject.put(KEY_ENABLE_CUSTOM_CT_ID, this.getEnableCustomCleverTapId());
            configJsonObject.put(KEY_PACKAGE_NAME, (Object)this.getPackageName());
            configJsonObject.put(KEY_BETA, this.isBeta());
            configJsonObject.put(KEY_ENCRYPTION_LEVEL, this.getEncryptionLevel());
            configJsonObject.put(KEY_ENCRYPTION_IN_TRANSIT, (Object)this.encryptionInTransit);
            JSONArray pushTypesArray = this.getPushTypesArray();
            configJsonObject.put(KEY_PUSH_TYPES, (Object)pushTypesArray);
            return configJsonObject.toString();
        }
        catch (Throwable e) {
            Logger.v("Unable to convert config to JSON : ", e.getCause());
            return null;
        }
    }

    @NonNull
    private JSONArray getPushTypesArray() {
        JSONArray pushTypesArray = new JSONArray();
        for (PushType pushType : this.getPushTypes()) {
            if (pushType == PushConstants.FCM) continue;
            pushTypesArray.put((Object)pushType.toJSONObject());
        }
        return pushTypesArray;
    }

    private String getDefaultSuffix(@NonNull String tag) {
        return "[" + (!TextUtils.isEmpty((CharSequence)tag) ? ":" + tag : "") + ":" + this.accountId + "]";
    }
}

