/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.utils;

import android.content.Context;
import android.content.pm.PackageManager;
import androidx.annotation.NonNull;
import com.google.android.gms.common.GoogleApiAvailabilityLight;

public class PackageUtils {
    private static final String GOOGLE_PLAY_STORE_PACKAGE_OLD = "com.google.market";
    private static final String GOOGLE_PLAY_STORE_PACKAGE = "com.android.vending";

    public static boolean isGooglePlayServicesAvailable(@NonNull Context context) {
        try {
            Class.forName("com.google.android.gms.common.GooglePlayServicesUtil");
            int status = GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(context);
            return status == 0;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isGooglePlayStoreAvailable(@NonNull Context context) {
        return PackageUtils.isPackageAvailable(context, GOOGLE_PLAY_STORE_PACKAGE) || PackageUtils.isPackageAvailable(context, GOOGLE_PLAY_STORE_PACKAGE_OLD);
    }

    private static boolean isPackageAvailable(Context context, String packageName) {
        try {
            context.getPackageManager().getPackageInfo(packageName, 0);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }
}

