/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.TranslateAnimation;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.clevertap.android.sdk.CTWebInterface;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.inapp.CTInAppAction;
import com.clevertap.android.sdk.inapp.CTInAppBasePartialFragment;
import com.clevertap.android.sdk.inapp.CTInAppWebView;
import com.clevertap.android.sdk.inapp.InAppWebViewClient;

public abstract class CTInAppBasePartialHtmlFragment
extends CTInAppBasePartialFragment
implements View.OnTouchListener,
View.OnLongClickListener {
    private static final String CTA_SWIPE_DISMISS = "swipe-dismiss";
    private final GestureDetector gd = new GestureDetector((GestureDetector.OnGestureListener)new GestureListener());
    private CTInAppWebView webView;

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        return this.displayHTMLView(inflater, container);
    }

    public void onDestroyView() {
        this.cleanupWebView();
        super.onDestroyView();
    }

    private void cleanupWebView() {
        try {
            if (this.webView != null) {
                this.webView.cleanup(this.inAppNotification.isJsEnabled());
                this.webView = null;
            }
        }
        catch (Exception e) {
            this.config.getLogger().verbose("cleanupWebView -> there was some crash in cleanup", e);
        }
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.reDrawInApp();
    }

    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.reDrawInApp();
    }

    public boolean onLongClick(View v) {
        return true;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouch(View v, MotionEvent event) {
        return this.gd.onTouchEvent(event) || event.getAction() == 2;
    }

    abstract ViewGroup getLayout(View var1);

    abstract View getView(LayoutInflater var1, ViewGroup var2);

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private View displayHTMLView(LayoutInflater inflater, ViewGroup container) {
        View inAppView;
        try {
            inAppView = this.getView(inflater, container);
            ViewGroup layout2 = this.getLayout(inAppView);
            this.webView = new CTInAppWebView(this.context, this.inAppNotification.getWidth(), this.inAppNotification.getHeight(), this.inAppNotification.getWidthPercentage(), this.inAppNotification.getHeightPercentage(), this.inAppNotification.getAspectRatio());
            InAppWebViewClient webViewClient = new InAppWebViewClient(this);
            this.webView.setWebViewClient(webViewClient);
            this.webView.setOnTouchListener(this);
            this.webView.setOnLongClickListener(this);
            if (this.inAppNotification.isJsEnabled()) {
                CleverTapAPI instance = CleverTapAPI.instanceWithConfig((Context)this.getActivity(), this.config);
                CTWebInterface ctWebInterface = new CTWebInterface(instance, this);
                this.webView.setJavaScriptInterface(ctWebInterface);
            }
            if (layout2 != null) {
                layout2.addView((View)this.webView);
            }
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Fragment view not created", t);
            return null;
        }
        return inAppView;
    }

    private void reDrawInApp() {
        this.webView.updateDimension();
        int mHeight = this.webView.dim.y;
        int mWidth = this.webView.dim.x;
        float d = this.getResources().getDisplayMetrics().density;
        mHeight = (int)((float)mHeight / d);
        mWidth = (int)((float)mWidth / d);
        String html = this.inAppNotification.getHtml();
        String style2 = "<style>body{width:" + mWidth + "px; height: " + mHeight + "px; margin: 0; padding:0;}</style>";
        html = html.replaceFirst("<head>", "<head>" + style2);
        Logger.v("Density appears to be " + d);
        this.webView.setInitialScale((int)(d * 100.0f));
        this.webView.loadDataWithBaseURL(null, html, "text/html", "utf-8", null);
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private final int SWIPE_MIN_DISTANCE = 120;
        private final int SWIPE_THRESHOLD_VELOCITY = 200;

        private GestureListener() {
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (e1 != null && e2 != null) {
                if (e1.getX() - e2.getX() > 120.0f && Math.abs(velocityX) > 200.0f) {
                    return this.remove(false);
                }
                if (e2.getX() - e1.getX() > 120.0f && Math.abs(velocityX) > 200.0f) {
                    return this.remove(true);
                }
            }
            return false;
        }

        private boolean remove(boolean ltr) {
            AnimationSet animSet = new AnimationSet(true);
            TranslateAnimation anim2 = ltr ? new TranslateAnimation(0.0f, (float)CTInAppBasePartialHtmlFragment.this.getScaledPixels(50), 0.0f, 0.0f) : new TranslateAnimation(0.0f, (float)(-CTInAppBasePartialHtmlFragment.this.getScaledPixels(50)), 0.0f, 0.0f);
            animSet.addAnimation((Animation)anim2);
            animSet.addAnimation((Animation)new AlphaAnimation(1.0f, 0.0f));
            animSet.setDuration(300L);
            animSet.setFillAfter(true);
            animSet.setFillEnabled(true);
            animSet.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationEnd(Animation animation) {
                    CTInAppBasePartialHtmlFragment.this.triggerAction(CTInAppAction.createCloseAction(), CTInAppBasePartialHtmlFragment.CTA_SWIPE_DISMISS, null);
                    CTInAppBasePartialHtmlFragment.this.didDismiss(null);
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationStart(Animation animation) {
                }
            });
            CTInAppBasePartialHtmlFragment.this.webView.startAnimation((Animation)animSet);
            return true;
        }
    }
}

