/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Constants;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.cryption.CryptHandler;
import com.clevertap.android.sdk.db.BaseDatabaseManager;
import com.clevertap.android.sdk.db.DBAdapter;
import com.clevertap.android.sdk.events.EventDetail;
import com.clevertap.android.sdk.usereventlogs.UserEventLog;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class LocalDataStore {
    private static long EXECUTOR_THREAD_ID = 0L;
    private final HashMap<String, Object> PROFILE_FIELDS_IN_THIS_SESSION = new HashMap();
    private final CleverTapInstanceConfig config;
    private final Context context;
    private final CryptHandler cryptHandler;
    private final BaseDatabaseManager baseDatabaseManager;
    private final ExecutorService es;
    private final String eventNamespace = "local_events";
    private final DeviceInfo deviceInfo;
    private final Set<String> userNormalizedEventLogKeys = Collections.synchronizedSet(new HashSet());
    private final Map<String, String> normalizedEventNames = new HashMap<String, String>();

    LocalDataStore(Context context, CleverTapInstanceConfig config, CryptHandler cryptHandler, DeviceInfo deviceInfo, BaseDatabaseManager baseDatabaseManager) {
        this.context = context;
        this.config = config;
        this.es = Executors.newFixedThreadPool(1);
        this.cryptHandler = cryptHandler;
        this.deviceInfo = deviceInfo;
        this.baseDatabaseManager = baseDatabaseManager;
    }

    @WorkerThread
    public void changeUser() {
        this.userNormalizedEventLogKeys.clear();
        this.resetLocalProfileSync();
    }

    @Deprecated(since="7.1.0")
    EventDetail getEventDetail(String eventName) {
        try {
            if (!this.isPersonalisationEnabled()) {
                return null;
            }
            String namespace = !this.config.isDefaultInstance() ? "local_events:" + this.config.getAccountId() : "local_events";
            return this.decodeEventDetails(eventName, this.getStringFromPrefs(eventName, null, namespace));
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getConfigAccountId(), "Failed to retrieve local event detail", t);
            return null;
        }
    }

    @Deprecated(since="7.1.0")
    Map<String, EventDetail> getEventHistory(Context context) {
        try {
            String namespace = !this.config.isDefaultInstance() ? "local_events:" + this.config.getAccountId() : "local_events";
            SharedPreferences prefs = StorageHelper.getPreferences(context, namespace);
            Map all = prefs.getAll();
            HashMap<String, EventDetail> out = new HashMap<String, EventDetail>();
            for (String eventName : all.keySet()) {
                out.put(eventName, this.decodeEventDetails(eventName, all.get(eventName).toString()));
            }
            return out;
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getConfigAccountId(), "Failed to retrieve local event history", t);
            return null;
        }
    }

    @Deprecated(since="7.1.0")
    @WorkerThread
    public void persistEvent(Context context, JSONObject event, int type) {
        if (event == null) {
            return;
        }
        try {
            if (type == 4) {
                this.persistEvent(context, event);
            }
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getConfigAccountId(), "Failed to sync with upstream", t);
        }
    }

    @WorkerThread
    public boolean persistUserEventLogsInBulk(Set<String> eventNames) {
        HashSet<Pair<String, String>> setOfActualAndNormalizedEventNamePair = new HashSet<Pair<String, String>>();
        CollectionsKt.mapTo(eventNames, setOfActualAndNormalizedEventNamePair, actualEventName -> new Pair(actualEventName, (Object)this.getOrPutNormalizedEventName((String)actualEventName)));
        return this.upsertUserEventLogsInBulk(setOfActualAndNormalizedEventNamePair);
    }

    @WorkerThread
    public boolean persistUserEventLog(String eventName) {
        if (eventName == null) {
            return false;
        }
        Logger logger = this.config.getLogger();
        String accountId = this.config.getAccountId();
        try {
            logger.verbose(accountId, "UserEventLog: Persisting EventLog for event " + eventName);
            if (this.isUserEventLogExists(eventName)) {
                logger.verbose(accountId, "UserEventLog: Updating EventLog for event " + eventName);
                return this.updateUserEventLog(eventName);
            }
            logger.verbose(accountId, "UserEventLog: Inserting EventLog for event " + eventName);
            return this.insertUserEventLog(eventName);
        }
        catch (Throwable t) {
            logger.verbose(accountId, "UserEventLog: Failed to insert user event log: for event" + eventName, t);
            return false;
        }
    }

    @WorkerThread
    private boolean updateEventByDeviceIdAndNormalizedEventName(String deviceID, String normalizedEventName) {
        DBAdapter dbAdapter = this.baseDatabaseManager.loadDBAdapter(this.context);
        boolean updatedEventByDeviceID = dbAdapter.userEventLogDAO().updateEventByDeviceIdAndNormalizedEventName(deviceID, normalizedEventName);
        this.getConfigLogger().verbose("updatedEventByDeviceID = " + updatedEventByDeviceID);
        return updatedEventByDeviceID;
    }

    @WorkerThread
    public boolean updateUserEventLog(String eventName) {
        String deviceID = this.deviceInfo.getDeviceID();
        String normalizedEventName = this.getOrPutNormalizedEventName(eventName);
        return this.updateEventByDeviceIdAndNormalizedEventName(deviceID, normalizedEventName);
    }

    @WorkerThread
    private boolean upsertUserEventLogsInBulk(Set<Pair<String, String>> setOfActualAndNormalizedEventNamePair) {
        String deviceID = this.deviceInfo.getDeviceID();
        DBAdapter dbAdapter = this.baseDatabaseManager.loadDBAdapter(this.context);
        boolean upsertEventByDeviceID = dbAdapter.userEventLogDAO().upsertEventsByDeviceIdAndNormalizedEventName(deviceID, setOfActualAndNormalizedEventNamePair);
        this.getConfigLogger().verbose("upsertEventByDeviceID = " + upsertEventByDeviceID);
        return upsertEventByDeviceID;
    }

    @WorkerThread
    private long insertEvent(String deviceID, String actualEventName, String normalizedEventName) {
        DBAdapter dbAdapter = this.baseDatabaseManager.loadDBAdapter(this.context);
        long rowId = dbAdapter.userEventLogDAO().insertEvent(deviceID, actualEventName, normalizedEventName);
        this.getConfigLogger().verbose("inserted rowId = " + rowId);
        return rowId;
    }

    private String getOrPutNormalizedEventName(String actualEventName) {
        return (String)MapsKt.getOrPut(this.normalizedEventNames, (Object)actualEventName, () -> Utils.getNormalizedName(actualEventName));
    }

    @WorkerThread
    public boolean insertUserEventLog(String eventName) {
        String normalizedEventName;
        String deviceID = this.deviceInfo.getDeviceID();
        long rowId = this.insertEvent(deviceID, eventName, normalizedEventName = this.getOrPutNormalizedEventName(eventName));
        return rowId >= 0L;
    }

    @WorkerThread
    private boolean eventExistsByDeviceIdAndNormalizedEventName(String deviceID, String normalizedEventName) {
        DBAdapter dbAdapter = this.baseDatabaseManager.loadDBAdapter(this.context);
        boolean eventExists = dbAdapter.userEventLogDAO().eventExistsByDeviceIdAndNormalizedEventName(deviceID, normalizedEventName);
        this.getConfigLogger().verbose("eventExists = " + eventExists);
        return eventExists;
    }

    @WorkerThread
    public boolean isUserEventLogExists(String eventName) {
        String deviceID = this.deviceInfo.getDeviceID();
        String normalizedEventName = this.getOrPutNormalizedEventName(eventName);
        return this.eventExistsByDeviceIdAndNormalizedEventName(deviceID, normalizedEventName);
    }

    @WorkerThread
    private boolean eventExistsByDeviceIdAndNormalizedEventNameAndCount(String deviceID, String normalizedEventName, int count) {
        DBAdapter dbAdapter = this.baseDatabaseManager.loadDBAdapter(this.context);
        boolean eventExistsByDeviceIDAndCount = dbAdapter.userEventLogDAO().eventExistsByDeviceIdAndNormalizedEventNameAndCount(deviceID, normalizedEventName, count);
        this.getConfigLogger().verbose("eventExistsByDeviceIDAndCount = " + eventExistsByDeviceIDAndCount);
        return eventExistsByDeviceIDAndCount;
    }

    @WorkerThread
    public boolean isUserEventLogFirstTime(String eventName) {
        String normalizedEventName = this.getOrPutNormalizedEventName(eventName);
        if (this.userNormalizedEventLogKeys.contains(normalizedEventName)) {
            return false;
        }
        String deviceID = this.deviceInfo.getDeviceID();
        int count = this.readEventCountByDeviceIdAndNormalizedEventName(deviceID, normalizedEventName);
        if (count > 1) {
            this.userNormalizedEventLogKeys.add(normalizedEventName);
        }
        return count == 1;
    }

    @WorkerThread
    public boolean cleanUpExtraEvents(int threshold, int numberOfRowsToCleanup) {
        DBAdapter dbAdapter = this.baseDatabaseManager.loadDBAdapter(this.context);
        boolean cleanUpExtraEvents = dbAdapter.userEventLogDAO().cleanUpExtraEvents(threshold, numberOfRowsToCleanup);
        this.getConfigLogger().verbose("cleanUpExtraEvents boolean= " + cleanUpExtraEvents);
        return cleanUpExtraEvents;
    }

    @WorkerThread
    private UserEventLog readEventByDeviceIdAndNormalizedEventName(String deviceID, String normalizedEventName) {
        DBAdapter dbAdapter = this.baseDatabaseManager.loadDBAdapter(this.context);
        return dbAdapter.userEventLogDAO().readEventByDeviceIdAndNormalizedEventName(deviceID, normalizedEventName);
    }

    @WorkerThread
    public UserEventLog readUserEventLog(String eventName) {
        String deviceID = this.deviceInfo.getDeviceID();
        String normalizedEventName = this.getOrPutNormalizedEventName(eventName);
        return this.readEventByDeviceIdAndNormalizedEventName(deviceID, normalizedEventName);
    }

    @WorkerThread
    private int readEventCountByDeviceIdAndNormalizedEventName(String deviceID, String normalizedEventName) {
        DBAdapter dbAdapter = this.baseDatabaseManager.loadDBAdapter(this.context);
        return dbAdapter.userEventLogDAO().readEventCountByDeviceIdAndNormalizedEventName(deviceID, normalizedEventName);
    }

    @WorkerThread
    public int readUserEventLogCount(String eventName) {
        String deviceID = this.deviceInfo.getDeviceID();
        String normalizedEventName = this.getOrPutNormalizedEventName(eventName);
        return this.readEventCountByDeviceIdAndNormalizedEventName(deviceID, normalizedEventName);
    }

    @WorkerThread
    private List<UserEventLog> allEventsByDeviceID(String deviceID) {
        DBAdapter dbAdapter = this.baseDatabaseManager.loadDBAdapter(this.context);
        return dbAdapter.userEventLogDAO().allEventsByDeviceID(deviceID);
    }

    @WorkerThread
    public List<UserEventLog> readUserEventLogs() {
        String deviceID = this.deviceInfo.getDeviceID();
        return this.allEventsByDeviceID(deviceID);
    }

    @WorkerThread
    public List<UserEventLog> readEventLogsForAllUsers() {
        DBAdapter dbAdapter = this.baseDatabaseManager.loadDBAdapter(this.context);
        return dbAdapter.userEventLogDAO().allEvents();
    }

    @WorkerThread
    public void setDataSyncFlag(JSONObject event) {
        try {
            String evtName;
            boolean enablePersonalisation = this.config.isPersonalizationEnabled();
            if (!enablePersonalisation) {
                event.put("dsync", false);
                return;
            }
            String eventType = event.getString("type");
            if ("event".equals(eventType) && "App Launched".equals(evtName = event.getString("evtName"))) {
                this.getConfigLogger().verbose(this.getConfigAccountId(), "Local cache needs to be updated (triggered by App Launched)");
                event.put("dsync", true);
                return;
            }
            if ("profile".equals(eventType)) {
                event.put("dsync", true);
                this.getConfigLogger().verbose(this.getConfigAccountId(), "Local cache needs to be updated (profile event)");
                return;
            }
            int now = (int)(System.currentTimeMillis() / 1000L);
            int expiresIn = this.getLocalCacheExpiryInterval(1200);
            int lastUpdate = this.getIntFromPrefs("local_cache_last_update", now);
            if (lastUpdate + expiresIn < now) {
                event.put("dsync", true);
                this.getConfigLogger().verbose(this.getConfigAccountId(), "Local cache needs to be updated");
            } else {
                event.put("dsync", false);
                this.getConfigLogger().verbose(this.getConfigAccountId(), "Local cache doesn't need to be updated");
            }
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getConfigAccountId(), "Failed to sync with upstream", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProfileProperty(String key) {
        if (key == null) {
            return null;
        }
        HashMap<String, Object> hashMap = this.PROFILE_FIELDS_IN_THIS_SESSION;
        synchronized (hashMap) {
            try {
                Object property = this.PROFILE_FIELDS_IN_THIS_SESSION.get(key);
                if (property instanceof String && CryptHandler.isTextEncrypted((String)property)) {
                    this.getConfigLogger().verbose(this.getConfigAccountId(), "Failed to retrieve local profile property because it wasn't decrypted");
                    return null;
                }
                return this.PROFILE_FIELDS_IN_THIS_SESSION.get(key);
            }
            catch (Throwable t) {
                this.getConfigLogger().verbose(this.getConfigAccountId(), "Failed to retrieve local profile property", t);
                return null;
            }
        }
    }

    @Deprecated(since="7.1.0")
    private EventDetail decodeEventDetails(String name, String encoded) {
        if (encoded == null) {
            return null;
        }
        String[] parts = encoded.split("\\|");
        return new EventDetail(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), name);
    }

    @Deprecated(since="7.1.0")
    private String encodeEventDetails(int first, int last, int count) {
        return count + "|" + first + "|" + last;
    }

    private String getConfigAccountId() {
        return this.config.getAccountId();
    }

    private Logger getConfigLogger() {
        return this.config.getLogger();
    }

    private int getIntFromPrefs(String rawKey, int defaultValue) {
        if (this.config.isDefaultInstance()) {
            int dummy = -1000;
            int _new = StorageHelper.getInt(this.context, this.storageKeyWithSuffix(rawKey), dummy);
            return _new != dummy ? _new : StorageHelper.getInt(this.context, rawKey, defaultValue);
        }
        return StorageHelper.getInt(this.context, this.storageKeyWithSuffix(rawKey), defaultValue);
    }

    private int getLocalCacheExpiryInterval(int defaultInterval) {
        return this.getIntFromPrefs("local_cache_expires_in", defaultInterval);
    }

    @Deprecated(since="7.1.0")
    private String getStringFromPrefs(String rawKey, String defaultValue, String nameSpace) {
        if (this.config.isDefaultInstance()) {
            String _new = StorageHelper.getString(this.context, nameSpace, this.storageKeyWithSuffix(rawKey), defaultValue);
            return _new != null ? _new : StorageHelper.getString(this.context, nameSpace, rawKey, defaultValue);
        }
        return StorageHelper.getString(this.context, nameSpace, this.storageKeyWithSuffix(rawKey), defaultValue);
    }

    private String getUserProfileID() {
        return this.config.getAccountId();
    }

    void inflateLocalProfileAsync(final Context context) {
        final String accountID = this.config.getAccountId();
        this.postAsyncSafely("LocalDataStore#inflateLocalProfileAsync", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DBAdapter dbAdapter = LocalDataStore.this.baseDatabaseManager.loadDBAdapter(context);
                HashMap hashMap = LocalDataStore.this.PROFILE_FIELDS_IN_THIS_SESSION;
                synchronized (hashMap) {
                    try {
                        JSONObject profile = dbAdapter.fetchUserProfileByAccountIdAndDeviceID(accountID, LocalDataStore.this.deviceInfo.getDeviceID());
                        if (profile == null) {
                            return;
                        }
                        Iterator keys = profile.keys();
                        while (keys.hasNext()) {
                            try {
                                String key = (String)keys.next();
                                Object value = profile.get(key);
                                if (value instanceof JSONObject) {
                                    JSONObject jsonObject = profile.getJSONObject(key);
                                    LocalDataStore.this.PROFILE_FIELDS_IN_THIS_SESSION.put(key, jsonObject);
                                    continue;
                                }
                                if (value instanceof JSONArray) {
                                    JSONArray jsonArray = profile.getJSONArray(key);
                                    LocalDataStore.this.PROFILE_FIELDS_IN_THIS_SESSION.put(key, jsonArray);
                                    continue;
                                }
                                Object decrypted = value;
                                if (value instanceof String && (decrypted = LocalDataStore.this.cryptHandler.decrypt((String)value, key, CryptHandler.EncryptionAlgorithm.AES_GCM)) == null) {
                                    decrypted = value;
                                }
                                LocalDataStore.this.PROFILE_FIELDS_IN_THIS_SESSION.put(key, decrypted);
                            }
                            catch (JSONException jSONException) {}
                        }
                        LocalDataStore.this.getConfigLogger().verbose(LocalDataStore.this.getConfigAccountId(), "Local Data Store - Inflated local profile " + LocalDataStore.this.PROFILE_FIELDS_IN_THIS_SESSION);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private boolean isPersonalisationEnabled() {
        return this.config.isPersonalizationEnabled();
    }

    @Deprecated(since="7.1.0")
    @SuppressLint(value={"CommitPrefEdits"})
    private void persistEvent(Context context, JSONObject event) {
        try {
            String evtName = event.getString("evtName");
            if (evtName == null) {
                return;
            }
            String namespace = !this.config.isDefaultInstance() ? "local_events:" + this.config.getAccountId() : "local_events";
            SharedPreferences prefs = StorageHelper.getPreferences(context, namespace);
            int now = (int)(System.currentTimeMillis() / 1000L);
            String encoded = this.getStringFromPrefs(evtName, this.encodeEventDetails(now, now, 0), namespace);
            EventDetail ed = this.decodeEventDetails(evtName, encoded);
            String updateEncoded = this.encodeEventDetails(ed.getFirstTime(), now, ed.getCount() + 1);
            SharedPreferences.Editor editor = prefs.edit();
            editor.putString(this.storageKeyWithSuffix(evtName), updateEncoded);
            StorageHelper.persist(editor);
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getConfigAccountId(), "Failed to persist event locally", t);
        }
    }

    private void persistLocalProfileAsync() {
        final String profileID = this.config.getAccountId();
        this.postAsyncSafely("LocalDataStore#persistLocalProfileAsync", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashMap hashMap = LocalDataStore.this.PROFILE_FIELDS_IN_THIS_SESSION;
                synchronized (hashMap) {
                    HashMap<String, String> profile = new HashMap<String, String>(LocalDataStore.this.PROFILE_FIELDS_IN_THIS_SESSION);
                    boolean passFlag = true;
                    for (String piiKey : Constants.piiDBKeys) {
                        Object value;
                        if (profile.get(piiKey) == null || !((value = profile.get(piiKey)) instanceof String)) continue;
                        String encrypted = LocalDataStore.this.cryptHandler.encrypt((String)value, piiKey, CryptHandler.EncryptionAlgorithm.AES_GCM);
                        if (encrypted == null) {
                            passFlag = false;
                            continue;
                        }
                        profile.put(piiKey, encrypted);
                    }
                    JSONObject jsonObjectEncrypted = new JSONObject(profile);
                    if (!passFlag) {
                        LocalDataStore.this.cryptHandler.updateMigrationFailureCount(false);
                    }
                    DBAdapter dbAdapter = LocalDataStore.this.baseDatabaseManager.loadDBAdapter(LocalDataStore.this.context);
                    long status = dbAdapter.storeUserProfile(profileID, LocalDataStore.this.deviceInfo.getDeviceID(), jsonObjectEncrypted);
                    LocalDataStore.this.getConfigLogger().verbose(LocalDataStore.this.getConfigAccountId(), "Persist Local Profile complete with status " + status + " for id " + profileID);
                }
            }
        });
    }

    private void postAsyncSafely(final String name, final Runnable runnable) {
        try {
            boolean executeSync;
            boolean bl = executeSync = Thread.currentThread().getId() == EXECUTOR_THREAD_ID;
            if (executeSync) {
                runnable.run();
            } else {
                this.es.submit(new Runnable(){

                    @Override
                    public void run() {
                        EXECUTOR_THREAD_ID = Thread.currentThread().getId();
                        try {
                            LocalDataStore.this.getConfigLogger().verbose(LocalDataStore.this.getConfigAccountId(), "Local Data Store Executor service: Starting task - " + name);
                            runnable.run();
                        }
                        catch (Throwable t) {
                            LocalDataStore.this.getConfigLogger().verbose(LocalDataStore.this.getConfigAccountId(), "Executor service: Failed to complete the scheduled task", t);
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getConfigAccountId(), "Failed to submit task to the executor service", t);
        }
    }

    private boolean profileValueIsEmpty(Object value) {
        if (value == null) {
            return true;
        }
        boolean isEmpty = false;
        if (value instanceof String) {
            boolean bl = isEmpty = ((String)value).trim().length() == 0;
        }
        if (value instanceof JSONArray) {
            isEmpty = ((JSONArray)value).length() <= 0;
        }
        return isEmpty;
    }

    private Boolean profileValuesAreEqual(Object value1, Object value2) {
        return this.stringify(value1).equals(this.stringify(value2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetLocalProfileSync() {
        HashMap<String, Object> hashMap = this.PROFILE_FIELDS_IN_THIS_SESSION;
        synchronized (hashMap) {
            this.PROFILE_FIELDS_IN_THIS_SESSION.clear();
        }
        this.inflateLocalProfileAsync(this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _removeProfileField(String key) {
        HashMap<String, Object> hashMap = this.PROFILE_FIELDS_IN_THIS_SESSION;
        synchronized (hashMap) {
            try {
                this.PROFILE_FIELDS_IN_THIS_SESSION.remove(key);
            }
            catch (Throwable t) {
                this.getConfigLogger().verbose(this.getConfigAccountId(), "Failed to remove local profile value for key " + key, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setProfileField(String key, Object value) {
        if (value == null) {
            return;
        }
        try {
            HashMap<String, Object> hashMap = this.PROFILE_FIELDS_IN_THIS_SESSION;
            synchronized (hashMap) {
                this.PROFILE_FIELDS_IN_THIS_SESSION.put(key, value);
            }
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getConfigAccountId(), "Failed to set local profile value for key " + key, t);
        }
    }

    public void updateProfileFields(Map<String, Object> fields) {
        if (fields.isEmpty()) {
            return;
        }
        long start = System.nanoTime();
        this.persistUserEventLogsInBulk(fields.keySet());
        long end = System.nanoTime();
        this.config.getLogger().verbose(this.config.getAccountId(), "UserEventLog: persistUserEventLog execution time = " + (end - start) + " nano seconds");
        for (Map.Entry<String, Object> entry : fields.entrySet()) {
            String key = entry.getKey();
            Object newValue = entry.getValue();
            if (newValue == null) {
                this._removeProfileField(key);
            }
            this._setProfileField(key, newValue);
        }
        this.persistLocalProfileAsync();
    }

    private String storageKeyWithSuffix(String key) {
        return key + ":" + this.config.getAccountId();
    }

    private String stringify(Object value) {
        return value == null ? "" : value.toString();
    }
}

