/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Insets;
import android.graphics.Point;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.WindowMetrics;
import android.webkit.WebView;
import androidx.annotation.Px;
import androidx.annotation.RequiresApi;

@SuppressLint(value={"ViewConstructor"})
class CTInAppWebView
extends WebView {
    final Point dim = new Point();
    private final Context context;
    private final int heightDp;
    private final int heightPercentage;
    private final int widthDp;
    private final int widthPercentage;

    @SuppressLint(value={"ResourceType"})
    public CTInAppWebView(Context context, int widthDp, int heightDp, int widthPercentage, int heightPercentage) {
        super(context);
        this.context = context;
        this.widthDp = widthDp;
        this.heightDp = heightDp;
        this.widthPercentage = widthPercentage;
        this.heightPercentage = heightPercentage;
        this.setHorizontalScrollBarEnabled(false);
        this.setVerticalScrollBarEnabled(false);
        this.setHorizontalFadingEdgeEnabled(false);
        this.setVerticalFadingEdgeEnabled(false);
        this.setOverScrollMode(2);
        this.setBackgroundColor(0);
        this.getSettings().setTextZoom(100);
        this.setId(188293);
    }

    public boolean performClick() {
        return super.performClick();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.updateDimension();
        this.setMeasuredDimension(this.dim.x, this.dim.y);
    }

    void updateDimension() {
        this.dim.x = this.calculateWidth();
        this.dim.y = this.calculateHeight();
    }

    @Px
    private int calculateWidth() {
        if (this.widthDp > 0) {
            return this.dpToPx(this.widthDp);
        }
        return this.calculatePercentageWidth();
    }

    @Px
    private int calculateHeight() {
        if (this.heightDp > 0) {
            return this.dpToPx(this.heightDp);
        }
        return this.calculatePercentageHeight();
    }

    @Px
    private int dpToPx(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    @Px
    private int calculatePercentageWidth() {
        if (Build.VERSION.SDK_INT >= 30) {
            return this.calculateWidthWithWindowMetrics();
        }
        return this.calculateWidthWithDisplayMetrics();
    }

    @Px
    private int calculatePercentageHeight() {
        if (Build.VERSION.SDK_INT >= 30) {
            return this.calculateHeightWithWindowMetrics();
        }
        return this.calculateHeightWithDisplayMetrics();
    }

    @RequiresApi(api=30)
    @Px
    private int calculateWidthWithWindowMetrics() {
        WindowManager windowManager = (WindowManager)this.context.getSystemService("window");
        if (windowManager == null) {
            return this.calculateWidthWithDisplayMetrics();
        }
        WindowMetrics metrics = windowManager.getCurrentWindowMetrics();
        Insets insets = metrics.getWindowInsets().getInsetsIgnoringVisibility(WindowInsets.Type.systemBars() | WindowInsets.Type.displayCutout());
        int availableWidth = metrics.getBounds().width() - insets.left - insets.right;
        return (int)((float)(availableWidth * this.widthPercentage) / 100.0f);
    }

    @RequiresApi(api=30)
    @Px
    private int calculateHeightWithWindowMetrics() {
        WindowManager windowManager = (WindowManager)this.context.getSystemService("window");
        if (windowManager == null) {
            return this.calculateHeightWithDisplayMetrics();
        }
        WindowMetrics metrics = windowManager.getCurrentWindowMetrics();
        Insets insets = metrics.getWindowInsets().getInsetsIgnoringVisibility(WindowInsets.Type.systemBars() | WindowInsets.Type.displayCutout());
        int availableHeight = metrics.getBounds().height() - insets.top - insets.bottom;
        return (int)((float)(availableHeight * this.heightPercentage) / 100.0f);
    }

    @Px
    private int calculateWidthWithDisplayMetrics() {
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        return (int)((float)(metrics.widthPixels * this.widthPercentage) / 100.0f);
    }

    @Px
    private int calculateHeightWithDisplayMetrics() {
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        return (int)((float)(metrics.heightPixels * this.heightPercentage) / 100.0f);
    }
}

