/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.cryption;

import android.content.Context;
import android.content.SharedPreferences;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.cryption.IDataMigrationRepository;
import com.clevertap.android.sdk.db.DBAdapter;
import com.clevertap.android.sdk.utils.CTJsonConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\rH\u0016J,\u0010\u001b\u001a\u00020\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001d2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/clevertap/android/sdk/cryption/DataMigrationRepository;", "Lcom/clevertap/android/sdk/cryption/IDataMigrationRepository;", "context", "Landroid/content/Context;", "config", "Lcom/clevertap/android/sdk/CleverTapInstanceConfig;", "dbAdapter", "Lcom/clevertap/android/sdk/db/DBAdapter;", "<init>", "(Landroid/content/Context;Lcom/clevertap/android/sdk/CleverTapInstanceConfig;Lcom/clevertap/android/sdk/db/DBAdapter;)V", "cachedGuidString", "", "cachedGuidJsonObject", "Lorg/json/JSONObject;", "saveCachedGuidJson", "", "json", "removeCachedGuidJson", "saveCachedGuidJsonLength", "length", "", "userProfilesInAccount", "", "saveUserProfile", "", "deviceID", "profile", "inAppDataFiles", "keysToMigrate", "", "migrate", "Lkotlin/Function1;", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nDataMigrationRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataMigrationRepository.kt\ncom/clevertap/android/sdk/cryption/DataMigrationRepository\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n11102#2:92\n11437#2,3:93\n1863#3:96\n1863#3,2:97\n1864#3:99\n*S KotlinDebug\n*F\n+ 1 DataMigrationRepository.kt\ncom/clevertap/android/sdk/cryption/DataMigrationRepository\n*L\n79#1:92\n79#1:93,3\n82#1:96\n83#1:97,2\n82#1:99\n*E\n"})
public final class DataMigrationRepository
implements IDataMigrationRepository {
    @NotNull
    private final Context context;
    @NotNull
    private final CleverTapInstanceConfig config;
    @NotNull
    private final DBAdapter dbAdapter;

    public DataMigrationRepository(@NotNull Context context, @NotNull CleverTapInstanceConfig config, @NotNull DBAdapter dbAdapter) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)dbAdapter, (String)"dbAdapter");
        this.context = context;
        this.config = config;
        this.dbAdapter = dbAdapter;
    }

    @Override
    @Nullable
    public String cachedGuidString() {
        return StorageHelper.getStringFromPrefs(this.context, this.config, "cachedGUIDsKey", null);
    }

    @Override
    @NotNull
    public JSONObject cachedGuidJsonObject() {
        String json = this.cachedGuidString();
        JSONObject jSONObject = CTJsonConverter.toJsonObject(json, this.config.getLogger(), this.config.getAccountId());
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"toJsonObject(...)");
        JSONObject cachedGuidJsonObj = jSONObject;
        return cachedGuidJsonObj;
    }

    @Override
    public void saveCachedGuidJson(@Nullable String json) {
        StorageHelper.putString(this.context, StorageHelper.storageKeyWithSuffix(this.config.getAccountId(), "cachedGUIDsKey"), json);
    }

    @Override
    public void removeCachedGuidJson() {
        StorageHelper.remove(this.context, StorageHelper.storageKeyWithSuffix(this.config.getAccountId(), "cachedGUIDsKey"));
    }

    @Override
    public void saveCachedGuidJsonLength(int length) {
        StorageHelper.putInt(this.context, StorageHelper.storageKeyWithSuffix(this.config.getAccountId(), "cachedGUIDsLengthKey"), length);
    }

    @Override
    @NotNull
    public Map<String, JSONObject> userProfilesInAccount() {
        return this.dbAdapter.fetchUserProfilesByAccountId(this.config.getAccountId());
    }

    @Override
    public long saveUserProfile(@NotNull String deviceID, @NotNull JSONObject profile) {
        Intrinsics.checkNotNullParameter((Object)deviceID, (String)"deviceID");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return this.dbAdapter.storeUserProfile(this.config.getAccountId(), deviceID, profile);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void inAppDataFiles(@NotNull List<String> keysToMigrate, @NotNull Function1<? super String, String> migrate) {
        Intrinsics.checkNotNullParameter(keysToMigrate, (String)"keysToMigrate");
        Intrinsics.checkNotNullParameter(migrate, (String)"migrate");
        File[] fileArray = new File(this.context.getApplicationInfo().dataDir, "shared_prefs").listFiles((arg_0, arg_1) -> DataMigrationRepository.inAppDataFiles$lambda$0(this, arg_0, arg_1));
        if (fileArray != null) {
            void $this$forEach$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            File[] fileArray2 = fileArray;
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void file;
                Iterator iterator2 = item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)file);
                String prefName = FilesKt.getNameWithoutExtension((File)file);
                collection.add(this.context.getSharedPreferences(prefName, 0));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SharedPreferences sp = (SharedPreferences)element$iv;
                boolean bl = false;
                Iterable $this$forEach$iv2 = keysToMigrate;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String data;
                    String key = (String)element$iv2;
                    boolean bl2 = false;
                    if (sp.getString(key, null) == null) continue;
                    boolean bl3 = false;
                    String encryptedData = (String)migrate.invoke((Object)data);
                    sp.edit().putString(key, encryptedData).apply();
                }
            }
        }
    }

    private static final boolean inAppDataFiles$lambda$0(DataMigrationRepository this$0, File file, String name) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)name);
        return StringsKt.startsWith$default((String)name, (String)"inApp", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)name, (String)(this$0.config.getAccountId() + ".xml"), (boolean)false, (int)2, null);
    }
}

