/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.pushnotification;

import android.content.Context;
import android.os.Bundle;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.interfaces.ActionButtonClickHandler;
import com.clevertap.android.sdk.interfaces.NotificationHandler;
import com.clevertap.android.sdk.pushnotification.CoreNotificationRenderer;
import com.clevertap.android.sdk.pushnotification.NotificationInfo;
import com.clevertap.android.sdk.pushnotification.PushConstants;
import com.clevertap.android.sdk.pushnotification.PushNotificationUtil;

public class PushNotificationHandler
implements ActionButtonClickHandler {
    public static NotificationHandler getPushNotificationHandler() {
        return SingletonNotificationHandler.INSTANCE;
    }

    public static boolean isForPushTemplates(Bundle extras) {
        if (extras == null) {
            return false;
        }
        String pt_id = extras.getString("pt_id");
        return !"0".equals(pt_id) && pt_id != null && !pt_id.isEmpty();
    }

    private boolean isForSignedCall(Bundle extras) {
        if (extras == null) {
            return false;
        }
        String source = extras.getString("source");
        return "signedcall".equals(source);
    }

    private PushNotificationHandler() {
    }

    @Override
    public boolean onActionButtonClick(Context context, Bundle extras, int notificationId) {
        return false;
    }

    @Override
    public synchronized boolean onMessageReceived(Context applicationContext, Bundle message, String pushType) {
        message.putLong("omr_invoke_time_in_millis", System.currentTimeMillis());
        CleverTapAPI cleverTapAPI = CleverTapAPI.getGlobalInstance(applicationContext, PushNotificationUtil.getAccountIdFromNotificationBundle(message));
        NotificationInfo info = CleverTapAPI.getNotificationInfo(message);
        if (info.fromCleverTap) {
            if (cleverTapAPI != null) {
                cleverTapAPI.getCoreState().getConfig().log("PushProvider", pushType + "received notification from CleverTap: " + message.toString());
                if (PushNotificationHandler.isForPushTemplates(message) && CleverTapAPI.getNotificationHandler() != null) {
                    CleverTapAPI.getNotificationHandler().onMessageReceived(applicationContext, message, pushType);
                } else if (this.isForSignedCall(message) && CleverTapAPI.getSignedCallNotificationHandler() != null) {
                    CleverTapAPI.getSignedCallNotificationHandler().onMessageReceived(applicationContext, message, pushType);
                } else {
                    cleverTapAPI.renderPushNotificationOnCallerThread(new CoreNotificationRenderer(), applicationContext, message);
                }
            } else {
                Logger.d("PushProvider", pushType + "received notification from CleverTap: " + message.toString());
                Logger.d("PushProvider", pushType + " not renderning since cleverTapAPI is null");
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onNewToken(Context applicationContext, String token, String pushType) {
        if (pushType.equals(PushConstants.PushType.FCM.getType())) {
            CleverTapAPI.tokenRefresh(applicationContext, token, PushConstants.PushType.FCM);
        } else if (pushType.equals(PushConstants.PushType.HPS.getType())) {
            CleverTapAPI.tokenRefresh(applicationContext, token, PushConstants.PushType.HPS);
        }
        return true;
    }

    private static class SingletonNotificationHandler {
        private static final PushNotificationHandler INSTANCE = new PushNotificationHandler();

        private SingletonNotificationHandler() {
        }
    }
}

