/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp.customtemplates;

import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.inapp.CTInAppNotification;
import com.clevertap.android.sdk.inapp.InAppListener;
import com.clevertap.android.sdk.inapp.customtemplates.CustomTemplate;
import com.clevertap.android.sdk.inapp.customtemplates.CustomTemplateContext;
import com.clevertap.android.sdk.inapp.customtemplates.CustomTemplateException;
import com.clevertap.android.sdk.inapp.customtemplates.CustomTemplateInAppData;
import com.clevertap.android.sdk.inapp.customtemplates.CustomTemplatePresenter;
import com.clevertap.android.sdk.inapp.customtemplates.FunctionPresenter;
import com.clevertap.android.sdk.inapp.customtemplates.TemplatePresenter;
import com.clevertap.android.sdk.inapp.customtemplates.TemplateProducer;
import com.clevertap.android.sdk.inapp.images.FileResourceProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\"\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\nJ\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\nJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\nJ\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J\u001e\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/clevertap/android/sdk/inapp/customtemplates/TemplatesManager;", "Lcom/clevertap/android/sdk/inapp/customtemplates/CustomTemplateContext$ContextDismissListener;", "templates", "", "Lcom/clevertap/android/sdk/inapp/customtemplates/CustomTemplate;", "logger", "Lcom/clevertap/android/sdk/Logger;", "(Ljava/util/Collection;Lcom/clevertap/android/sdk/Logger;)V", "activeContexts", "", "", "Lcom/clevertap/android/sdk/inapp/customtemplates/CustomTemplateContext;", "customTemplates", "", "closeTemplate", "", "notification", "Lcom/clevertap/android/sdk/inapp/CTInAppNotification;", "createContextFromInApp", "inAppListener", "Lcom/clevertap/android/sdk/inapp/InAppListener;", "resourceProvider", "Lcom/clevertap/android/sdk/inapp/images/FileResourceProvider;", "getActiveContextForTemplate", "templateName", "getAllRegisteredTemplates", "getTemplate", "isTemplateRegistered", "", "onDismissContext", "context", "presentTemplate", "Companion", "clevertap-core_release"})
public final class TemplatesManager
implements CustomTemplateContext.ContextDismissListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final Map<String, CustomTemplate> customTemplates;
    @NotNull
    private final Map<String, CustomTemplateContext> activeContexts;
    @NotNull
    private static final List<TemplateProducer> templateProducers = new ArrayList();

    /*
     * WARNING - void declaration
     */
    public TemplatesManager(@NotNull Collection<CustomTemplate> templates, @NotNull Logger logger) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter(templates, (String)"templates");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        Iterable iterable = templates;
        TemplatesManager templatesManager = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var6_7 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void template;
            CustomTemplate customTemplate = (CustomTemplate)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(template.getName(), element$iv$iv);
        }
        templatesManager.customTemplates = destination$iv$iv;
        this.activeContexts = new LinkedHashMap();
    }

    public final boolean isTemplateRegistered(@NotNull String templateName) {
        Intrinsics.checkNotNullParameter((Object)templateName, (String)"templateName");
        return this.customTemplates.containsKey(templateName);
    }

    @NotNull
    public final Collection<CustomTemplate> getAllRegisteredTemplates() {
        return this.customTemplates.values();
    }

    @Nullable
    public final CustomTemplate getTemplate(@NotNull String templateName) {
        Intrinsics.checkNotNullParameter((Object)templateName, (String)"templateName");
        return this.customTemplates.get(templateName);
    }

    @Nullable
    public final CustomTemplateContext getActiveContextForTemplate(@NotNull String templateName) {
        Intrinsics.checkNotNullParameter((Object)templateName, (String)"templateName");
        return this.activeContexts.get(templateName);
    }

    public final void presentTemplate(@NotNull CTInAppNotification notification, @NotNull InAppListener inAppListener, @NotNull FileResourceProvider resourceProvider) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        Intrinsics.checkNotNullParameter((Object)inAppListener, (String)"inAppListener");
        Intrinsics.checkNotNullParameter((Object)resourceProvider, (String)"resourceProvider");
        CustomTemplateContext customTemplateContext = this.createContextFromInApp(notification, inAppListener, resourceProvider);
        if (customTemplateContext == null) {
            return;
        }
        CustomTemplateContext context = customTemplateContext;
        CustomTemplate template = this.customTemplates.get(context.getTemplateName());
        if (template == null) {
            this.logger.info("CustomTemplates", "Cannot find template with name " + context.getTemplateName());
            return;
        }
        CustomTemplatePresenter<?> presenter = template.getPresenter();
        if (presenter instanceof TemplatePresenter) {
            if (context instanceof CustomTemplateContext.TemplateContext) {
                this.activeContexts.put(template.getName(), context);
                ((TemplatePresenter)presenter).onPresent(context);
            }
        } else if (presenter instanceof FunctionPresenter && context instanceof CustomTemplateContext.FunctionContext) {
            this.activeContexts.put(template.getName(), context);
            ((FunctionPresenter)presenter).onPresent(context);
        }
    }

    public final void closeTemplate(@NotNull CTInAppNotification notification) {
        String templateName;
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        CustomTemplateInAppData customTemplateInAppData = notification.getCustomTemplateData();
        String string2 = templateName = customTemplateInAppData != null ? customTemplateInAppData.getTemplateName() : null;
        if (templateName == null) {
            this.logger.debug("CustomTemplates", "Cannot close custom template from notification without template name");
            return;
        }
        CustomTemplateContext context = this.activeContexts.get(templateName);
        if (context == null) {
            this.logger.debug("CustomTemplates", "Cannot close custom template without active context");
            return;
        }
        CustomTemplate template = this.customTemplates.get(templateName);
        if (template == null) {
            this.logger.info("CustomTemplates", "Cannot find template with name " + templateName);
            return;
        }
        CustomTemplatePresenter<?> presenter = template.getPresenter();
        if (presenter instanceof TemplatePresenter && context instanceof CustomTemplateContext.TemplateContext) {
            ((TemplatePresenter)presenter).onClose((CustomTemplateContext.TemplateContext)context);
        }
    }

    @Override
    public void onDismissContext(@NotNull CustomTemplateContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.activeContexts.remove(context.getTemplateName());
    }

    private final CustomTemplateContext createContextFromInApp(CTInAppNotification notification, InAppListener inAppListener, FileResourceProvider resourceProvider) {
        String templateName;
        CustomTemplateInAppData customTemplateInAppData = notification.getCustomTemplateData();
        String string2 = templateName = customTemplateInAppData != null ? customTemplateInAppData.getTemplateName() : null;
        if (templateName == null) {
            this.logger.debug("CustomTemplates", "Cannot create TemplateContext from notification without template name");
            return null;
        }
        CustomTemplate template = this.customTemplates.get(templateName);
        if (template == null) {
            this.logger.debug("CustomTemplates", "Cannot create TemplateContext for non-registered template: " + templateName);
            return null;
        }
        return CustomTemplateContext.Factory.createContext$clevertap_core_release(template, notification, inAppListener, resourceProvider, this, this.logger);
    }

    @JvmStatic
    public static final void register(@NotNull TemplateProducer templateProducer) {
        Companion.register(templateProducer);
    }

    @JvmStatic
    @NotNull
    public static final TemplatesManager createInstance(@NotNull CleverTapInstanceConfig ctInstanceConfig) {
        return Companion.createInstance(ctInstanceConfig);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0005H\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/clevertap/android/sdk/inapp/customtemplates/TemplatesManager$Companion;", "", "()V", "templateProducers", "", "Lcom/clevertap/android/sdk/inapp/customtemplates/TemplateProducer;", "clearRegisteredProducers", "", "createInstance", "Lcom/clevertap/android/sdk/inapp/customtemplates/TemplatesManager;", "ctInstanceConfig", "Lcom/clevertap/android/sdk/CleverTapInstanceConfig;", "register", "templateProducer", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void register(@NotNull TemplateProducer templateProducer) {
            Intrinsics.checkNotNullParameter((Object)templateProducer, (String)"templateProducer");
            templateProducers.add(templateProducer);
        }

        @JvmStatic
        @NotNull
        public final TemplatesManager createInstance(@NotNull CleverTapInstanceConfig ctInstanceConfig) {
            Intrinsics.checkNotNullParameter((Object)ctInstanceConfig, (String)"ctInstanceConfig");
            Set templates = new LinkedHashSet();
            for (TemplateProducer producer : templateProducers) {
                for (CustomTemplate producedTemplate : producer.defineTemplates(ctInstanceConfig)) {
                    if (templates.contains(producedTemplate)) {
                        throw new CustomTemplateException("CustomTemplate with a name \"" + producedTemplate.getName() + "\" is already registered", null, 2, null);
                    }
                    templates.add(producedTemplate);
                }
            }
            Collection collection = templates;
            Logger logger = ctInstanceConfig.getLogger();
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"ctInstanceConfig.logger");
            return new TemplatesManager(collection, logger);
        }

        public final void clearRegisteredProducers() {
            templateProducers.clear();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

