/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.bitmap;

import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.bitmap.HttpUrlConnectionParams;
import com.clevertap.android.sdk.bitmap.IBitmapInputStreamReader;
import com.clevertap.android.sdk.network.DownloadedBitmap;
import com.clevertap.android.sdk.network.DownloadedBitmapFactory;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/clevertap/android/sdk/bitmap/BitmapDownloader;", "", "httpUrlConnectionParams", "Lcom/clevertap/android/sdk/bitmap/HttpUrlConnectionParams;", "bitmapInputStreamReader", "Lcom/clevertap/android/sdk/bitmap/IBitmapInputStreamReader;", "sizeConstrainedPair", "Lkotlin/Pair;", "", "", "(Lcom/clevertap/android/sdk/bitmap/HttpUrlConnectionParams;Lcom/clevertap/android/sdk/bitmap/IBitmapInputStreamReader;Lkotlin/Pair;)V", "connection", "Ljava/net/HttpURLConnection;", "downloadStartTimeInMilliseconds", "", "srcUrl", "", "createConnection", "url", "Ljava/net/URL;", "downloadBitmap", "Lcom/clevertap/android/sdk/network/DownloadedBitmap;", "clevertap-core_release"})
public final class BitmapDownloader {
    @NotNull
    private final HttpUrlConnectionParams httpUrlConnectionParams;
    @NotNull
    private final IBitmapInputStreamReader bitmapInputStreamReader;
    @NotNull
    private final Pair<Boolean, Integer> sizeConstrainedPair;
    private long downloadStartTimeInMilliseconds;
    private HttpURLConnection connection;
    private String srcUrl;

    public BitmapDownloader(@NotNull HttpUrlConnectionParams httpUrlConnectionParams, @NotNull IBitmapInputStreamReader bitmapInputStreamReader, @NotNull Pair<Boolean, Integer> sizeConstrainedPair) {
        Intrinsics.checkNotNullParameter((Object)httpUrlConnectionParams, (String)"httpUrlConnectionParams");
        Intrinsics.checkNotNullParameter((Object)bitmapInputStreamReader, (String)"bitmapInputStreamReader");
        Intrinsics.checkNotNullParameter(sizeConstrainedPair, (String)"sizeConstrainedPair");
        this.httpUrlConnectionParams = httpUrlConnectionParams;
        this.bitmapInputStreamReader = bitmapInputStreamReader;
        this.sizeConstrainedPair = sizeConstrainedPair;
    }

    public /* synthetic */ BitmapDownloader(HttpUrlConnectionParams httpUrlConnectionParams, IBitmapInputStreamReader iBitmapInputStreamReader, Pair pair, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            pair = new Pair((Object)false, (Object)0);
        }
        this(httpUrlConnectionParams, iBitmapInputStreamReader, (Pair<Boolean, Integer>)pair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final DownloadedBitmap downloadBitmap(@NotNull String srcUrl) {
        DownloadedBitmap downloadedBitmap;
        Object $this$downloadBitmap_u24lambda_u241;
        block17: {
            block16: {
                void $this$downloadBitmap_u24lambda_u240;
                Intrinsics.checkNotNullParameter((Object)srcUrl, (String)"srcUrl");
                Logger.v("initiating bitmap download in BitmapDownloader....");
                this.srcUrl = srcUrl;
                this.downloadStartTimeInMilliseconds = Utils.getNowInMillis();
                URL uRL = new URL(srcUrl);
                BitmapDownloader bitmapDownloader = this;
                boolean bl = false;
                bitmapDownloader.connection = this.createConnection((URL)$this$downloadBitmap_u24lambda_u240);
                HttpURLConnection httpURLConnection = this.connection;
                if (httpURLConnection == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                    httpURLConnection = null;
                }
                $this$downloadBitmap_u24lambda_u241 = httpURLConnection;
                boolean bl2 = false;
                ((URLConnection)$this$downloadBitmap_u24lambda_u241).connect();
                if (((HttpURLConnection)$this$downloadBitmap_u24lambda_u241).getResponseCode() == 200) break block16;
                Logger.d("File not loaded completely not going forward. URL was: " + srcUrl);
                DownloadedBitmap downloadedBitmap2 = DownloadedBitmapFactory.INSTANCE.nullBitmapWithStatus(DownloadedBitmap.Status.DOWNLOAD_FAILED);
                HttpURLConnection httpURLConnection2 = this.connection;
                if (httpURLConnection2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                    httpURLConnection2 = null;
                }
                httpURLConnection2.disconnect();
                return downloadedBitmap2;
            }
            Logger.v("Downloading " + srcUrl + "....");
            int fileLength = ((URLConnection)$this$downloadBitmap_u24lambda_u241).getContentLength();
            Pair<Boolean, Integer> pair = this.sizeConstrainedPair;
            boolean isSizeConstrained = (Boolean)pair.component1();
            int size = ((Number)pair.component2()).intValue();
            if (!isSizeConstrained || fileLength <= size) break block17;
            Logger.v("Image size is larger than " + size + " bytes. Cancelling download!");
            DownloadedBitmap downloadedBitmap3 = DownloadedBitmapFactory.INSTANCE.nullBitmapWithStatus(DownloadedBitmap.Status.SIZE_LIMIT_EXCEEDED);
            HttpURLConnection httpURLConnection = this.connection;
            if (httpURLConnection == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                httpURLConnection = null;
            }
            httpURLConnection.disconnect();
            return downloadedBitmap3;
        }
        try {
            InputStream inputStream = ((URLConnection)$this$downloadBitmap_u24lambda_u241).getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
            downloadedBitmap = this.bitmapInputStreamReader.readInputStream(inputStream, (HttpURLConnection)$this$downloadBitmap_u24lambda_u241, this.downloadStartTimeInMilliseconds);
        }
        catch (Throwable e) {
            try {
                Logger.v("Couldn't download the notification icon. URL was: " + srcUrl);
                e.printStackTrace();
                $this$downloadBitmap_u24lambda_u241 = DownloadedBitmapFactory.INSTANCE.nullBitmapWithStatus(DownloadedBitmap.Status.DOWNLOAD_FAILED);
            }
            catch (Throwable throwable) {
                try {
                    HttpURLConnection httpURLConnection = this.connection;
                    if (httpURLConnection == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                        httpURLConnection = null;
                    }
                    httpURLConnection.disconnect();
                }
                catch (Throwable t) {
                    Logger.v("Couldn't close connection!", t);
                }
                throw throwable;
            }
            try {
                HttpURLConnection httpURLConnection = this.connection;
                if (httpURLConnection == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                    httpURLConnection = null;
                }
                httpURLConnection.disconnect();
            }
            catch (Throwable t) {
                Logger.v("Couldn't close connection!", t);
            }
            return $this$downloadBitmap_u24lambda_u241;
        }
        HttpURLConnection httpURLConnection = this.connection;
        if (httpURLConnection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
            httpURLConnection = null;
        }
        httpURLConnection.disconnect();
        return downloadedBitmap;
    }

    private final HttpURLConnection createConnection(URL url) {
        HttpURLConnection httpURLConnection;
        URLConnection uRLConnection = url.openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection $this$createConnection_u24lambda_u243 = httpURLConnection = (HttpURLConnection)uRLConnection;
        boolean bl = false;
        $this$createConnection_u24lambda_u243.setConnectTimeout(this.httpUrlConnectionParams.getConnectTimeout());
        $this$createConnection_u24lambda_u243.setReadTimeout(this.httpUrlConnectionParams.getReadTimeout());
        $this$createConnection_u24lambda_u243.setUseCaches(this.httpUrlConnectionParams.getUseCaches());
        $this$createConnection_u24lambda_u243.setDoInput(this.httpUrlConnectionParams.getDoInput());
        Map<String, String> $this$forEach$iv = this.httpUrlConnectionParams.getRequestMap();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl2 = false;
            String k = entry.getKey();
            String v = entry.getValue();
            $this$createConnection_u24lambda_u243.addRequestProperty(k, v);
        }
        return httpURLConnection;
    }
}

