/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.utils;

import android.os.Parcel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a-\u0010\u0000\u001a\u00020\u0001*\u00020\u00012!\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003\u001a\u0014\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\n\u001a\u0012\u0010\u000b\u001a\u00020\f*\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e\u001a+\u0010\u000f\u001a\u00020\f*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\n2\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\u0003\u00a2\u0006\u0002\b\u0011\u001a\f\u0010\u0012\u001a\u0004\u0018\u00010\u0004*\u00020\u0013\u001a\u0014\u0010\u0014\u001a\u00020\f*\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\u0016"}, d2={"filterObjects", "Lorg/json/JSONArray;", "predicate", "Lkotlin/Function1;", "Lorg/json/JSONObject;", "Lkotlin/ParameterName;", "name", "element", "", "getStringOrNull", "", "prepend", "", "value", "", "putObject", "init", "Lkotlin/ExtensionFunctionType;", "readJson", "Landroid/os/Parcel;", "writeJson", "json", "clevertap-core_release"})
public final class JsonUtilsKt {
    public static final void putObject(@NotNull JSONObject $this$putObject, @NotNull String name, @NotNull Function1<? super JSONObject, Unit> init) {
        Intrinsics.checkNotNullParameter((Object)$this$putObject, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        JSONObject obj = new JSONObject();
        init.invoke((Object)obj);
        $this$putObject.put(name, (Object)obj);
    }

    @Nullable
    public static final String getStringOrNull(@NotNull JSONObject $this$getStringOrNull, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$getStringOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return $this$getStringOrNull.has(name) ? $this$getStringOrNull.getString(name) : (String)null;
    }

    public static final void prepend(@NotNull JSONArray $this$prepend, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)$this$prepend, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object shiftItem = value;
        for (int index = 0; index < $this$prepend.length(); ++index) {
            Object currentItem = $this$prepend.get(index);
            $this$prepend.put(index, shiftItem);
            Intrinsics.checkNotNullExpressionValue((Object)currentItem, (String)"currentItem");
            shiftItem = currentItem;
        }
        $this$prepend.put(shiftItem);
    }

    @Nullable
    public static final JSONObject readJson(@NotNull Parcel $this$readJson) {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)$this$readJson, (String)"<this>");
        try {
            JSONObject jSONObject2;
            String string2 = $this$readJson.readString();
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                jSONObject2 = new JSONObject(it);
            } else {
                jSONObject2 = null;
            }
            jSONObject = jSONObject2;
        }
        catch (JSONException je) {
            jSONObject = null;
        }
        return jSONObject;
    }

    public static final void writeJson(@NotNull Parcel $this$writeJson, @Nullable JSONObject json) {
        Intrinsics.checkNotNullParameter((Object)$this$writeJson, (String)"<this>");
        JSONObject jSONObject = json;
        $this$writeJson.writeString(jSONObject != null ? jSONObject.toString() : null);
    }

    @NotNull
    public static final JSONArray filterObjects(@NotNull JSONArray $this$filterObjects, @NotNull Function1<? super JSONObject, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)$this$filterObjects, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        JSONArray filteredArray = new JSONArray();
        int n = $this$filterObjects.length();
        for (int i = 0; i < n; ++i) {
            JSONObject element = $this$filterObjects.optJSONObject(i);
            if (element == null || !((Boolean)predicate.invoke((Object)element)).booleanValue()) continue;
            filteredArray.put((Object)element);
        }
        return filteredArray;
    }
}

