/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.video.inapps;

import android.content.Context;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.core.content.res.ResourcesCompat;
import com.clevertap.android.sdk.R;
import com.clevertap.android.sdk.video.InAppVideoPlayerHandle;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.hls.HlsMediaSource;
import com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.ui.StyledPlayerView;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultDataSource;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSource;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Util;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u000eH\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0016J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u001b\u001a\u00020\u000eH\u0016J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u0015H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/clevertap/android/sdk/video/inapps/ExoplayerHandle;", "Lcom/clevertap/android/sdk/video/InAppVideoPlayerHandle;", "()V", "mediaPosition", "", "player", "Lcom/google/android/exoplayer2/ExoPlayer;", "playerView", "Lcom/google/android/exoplayer2/ui/StyledPlayerView;", "playerViewLayoutParamsFullScreen", "Landroid/widget/FrameLayout$LayoutParams;", "playerViewLayoutParamsNormal", "Landroid/view/ViewGroup$LayoutParams;", "initExoplayer", "", "context", "Landroid/content/Context;", "url", "", "initPlayerView", "isTablet", "", "pause", "play", "playerHeight", "", "playerWidth", "savePosition", "switchToFullScreen", "isFullScreen", "videoSurface", "Landroid/view/View;", "clevertap-core_release"})
public final class ExoplayerHandle
implements InAppVideoPlayerHandle {
    @Nullable
    private ExoPlayer player;
    @Nullable
    private StyledPlayerView playerView;
    @Nullable
    private ViewGroup.LayoutParams playerViewLayoutParamsNormal;
    @NotNull
    private FrameLayout.LayoutParams playerViewLayoutParamsFullScreen = new FrameLayout.LayoutParams(-1, -1);
    private long mediaPosition;

    /*
     * WARNING - void declaration
     */
    @Override
    public void initExoplayer(@NotNull Context context, @NotNull String url) {
        void $this$initExoplayer_u24lambda_u240;
        ExoPlayer exoPlayer;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (this.player != null) {
            return;
        }
        DefaultBandwidthMeter defaultBandwidthMeter = new DefaultBandwidthMeter.Builder(context).build();
        Intrinsics.checkNotNullExpressionValue((Object)defaultBandwidthMeter, (String)"Builder(context).build()");
        BandwidthMeter bandwidthMeter = (BandwidthMeter)defaultBandwidthMeter;
        ExoTrackSelection.Factory videoTrackSelectionFactory = (ExoTrackSelection.Factory)new AdaptiveTrackSelection.Factory();
        TrackSelector trackSelector = (TrackSelector)new DefaultTrackSelector(context, videoTrackSelectionFactory);
        String string2 = Util.getUserAgent((Context)context, (String)context.getPackageName());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUserAgent(context, context.packageName)");
        String userAgent = string2;
        TransferListener listener = bandwidthMeter.getTransferListener();
        DefaultHttpDataSource.Factory factory = new DefaultHttpDataSource.Factory().setUserAgent(userAgent).setTransferListener(listener);
        Intrinsics.checkNotNullExpressionValue((Object)factory, (String)"Factory().setUserAgent(u\u2026ransferListener(listener)");
        DefaultHttpDataSource.Factory dsf = factory;
        DataSource.Factory dataSourceFactory = (DataSource.Factory)new DefaultDataSource.Factory(context, (DataSource.Factory)dsf);
        MediaItem mediaItem = MediaItem.fromUri((String)url);
        Intrinsics.checkNotNullExpressionValue((Object)mediaItem, (String)"fromUri(url)");
        MediaItem mediaItem2 = mediaItem;
        HlsMediaSource hlsMediaSource = new HlsMediaSource.Factory(dataSourceFactory).createMediaSource(mediaItem2);
        Intrinsics.checkNotNullExpressionValue((Object)hlsMediaSource, (String)"Factory(dataSourceFactor\u2026ateMediaSource(mediaItem)");
        HlsMediaSource hlsMediaSource2 = hlsMediaSource;
        ExoPlayer exoPlayer2 = exoPlayer = new ExoPlayer.Builder(context).setTrackSelector(trackSelector).build();
        ExoplayerHandle exoplayerHandle = this;
        boolean bl = false;
        $this$initExoplayer_u24lambda_u240.setMediaSource((MediaSource)hlsMediaSource2);
        $this$initExoplayer_u24lambda_u240.prepare();
        $this$initExoplayer_u24lambda_u240.setRepeatMode(1);
        $this$initExoplayer_u24lambda_u240.seekTo(this.mediaPosition);
        exoplayerHandle.player = exoPlayer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initPlayerView(@NotNull Context context, boolean isTablet) {
        void $this$initPlayerView_u24lambda_u241;
        StyledPlayerView styledPlayerView;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.playerView != null) {
            return;
        }
        int playerWidth = this.playerWidth(context, isTablet);
        int playerHeight = this.playerHeight(context, isTablet);
        StyledPlayerView styledPlayerView2 = styledPlayerView = new StyledPlayerView(context);
        ExoplayerHandle exoplayerHandle = this;
        boolean bl = false;
        this.playerViewLayoutParamsNormal = (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(playerWidth, playerHeight);
        $this$initPlayerView_u24lambda_u241.setLayoutParams(this.playerViewLayoutParamsNormal);
        $this$initPlayerView_u24lambda_u241.setShowBuffering(1);
        $this$initPlayerView_u24lambda_u241.setUseArtwork(true);
        $this$initPlayerView_u24lambda_u241.setControllerAutoShow(false);
        $this$initPlayerView_u24lambda_u241.setDefaultArtwork(ResourcesCompat.getDrawable((Resources)context.getResources(), (int)R.drawable.ct_audio, null));
        exoplayerHandle.playerView = styledPlayerView;
    }

    @Override
    public void play() {
        block1: {
            StyledPlayerView styledPlayerView = this.playerView;
            if (styledPlayerView != null) {
                StyledPlayerView pv = styledPlayerView;
                boolean bl = false;
                pv.requestFocus();
                pv.setVisibility(0);
                pv.setPlayer((Player)this.player);
            }
            ExoPlayer exoPlayer = this.player;
            if (exoPlayer == null) break block1;
            ExoPlayer it = exoPlayer;
            boolean bl = false;
            it.setPlayWhenReady(true);
        }
    }

    @Override
    public void pause() {
        block0: {
            ExoPlayer exoPlayer = this.player;
            if (exoPlayer == null) break block0;
            ExoPlayer ep = exoPlayer;
            boolean bl = false;
            ep.stop();
            ep.release();
            this.player = null;
        }
    }

    @Override
    public void savePosition() {
        if (this.player != null) {
            ExoPlayer exoPlayer = this.player;
            Intrinsics.checkNotNull((Object)exoPlayer);
            this.mediaPosition = exoPlayer.getCurrentPosition();
        }
    }

    @Override
    public void switchToFullScreen(boolean isFullScreen) {
        if (isFullScreen) {
            StyledPlayerView styledPlayerView = this.playerView;
            Intrinsics.checkNotNull((Object)styledPlayerView);
            this.playerViewLayoutParamsNormal = styledPlayerView.getLayoutParams();
            StyledPlayerView styledPlayerView2 = this.playerView;
            Intrinsics.checkNotNull((Object)styledPlayerView2);
            styledPlayerView2.setLayoutParams((ViewGroup.LayoutParams)this.playerViewLayoutParamsFullScreen);
        } else {
            StyledPlayerView styledPlayerView = this.playerView;
            Intrinsics.checkNotNull((Object)styledPlayerView);
            styledPlayerView.setLayoutParams(this.playerViewLayoutParamsNormal);
        }
    }

    @Override
    @NotNull
    public View videoSurface() {
        StyledPlayerView styledPlayerView = this.playerView;
        Intrinsics.checkNotNull((Object)styledPlayerView);
        return (View)styledPlayerView;
    }

    public final int playerWidth(@NotNull Context context, boolean isTablet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (int)TypedValue.applyDimension((int)1, (float)(isTablet ? 408.0f : 240.0f), (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public final int playerHeight(@NotNull Context context, boolean isTablet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (int)TypedValue.applyDimension((int)1, (float)(isTablet ? 299.0f : 134.0f), (DisplayMetrics)context.getResources().getDisplayMetrics());
    }
}

