/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp.store.preference;

import com.clevertap.android.sdk.StoreProvider;
import com.clevertap.android.sdk.cryption.CryptHandler;
import com.clevertap.android.sdk.login.ChangeUserCallback;
import com.clevertap.android.sdk.store.preference.ICTPreference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0013\u0018\u0000 '2\u00020\u0001:\u0001'B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0016J\u0006\u0010\u0018\u001a\u00020\bJ\u0006\u0010\u0019\u001a\u00020\u0012J\u0006\u0010\u001a\u001a\u00020\bJ\u0006\u0010\u001b\u001a\u00020\bJ\u0006\u0010\u001c\u001a\u00020\u0012J\b\u0010\u001d\u001a\u00020\u0015H\u0002J\b\u0010\u001e\u001a\u00020\u0015H\u0002J\u000e\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0012J\u000e\u0010\"\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\bJ\u000e\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\bJ\u000e\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u0012R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/clevertap/android/sdk/inapp/store/preference/InAppStore;", "Lcom/clevertap/android/sdk/login/ChangeUserCallback;", "ctPreference", "Lcom/clevertap/android/sdk/store/preference/ICTPreference;", "cryptHandler", "Lcom/clevertap/android/sdk/cryption/CryptHandler;", "(Lcom/clevertap/android/sdk/store/preference/ICTPreference;Lcom/clevertap/android/sdk/cryption/CryptHandler;)V", "clientSideInApps", "Lorg/json/JSONArray;", "value", "", "mode", "getMode", "()Ljava/lang/String;", "setMode", "(Ljava/lang/String;)V", "serverSideInApps", "migrateInAppHeaderPrefsForEventType", "Lorg/json/JSONObject;", "inAppIds", "onChangeUser", "", "deviceId", "accountId", "readClientSideInApps", "readEvaluatedServerSideInAppIds", "readServerSideInApps", "readServerSideInAppsMetaData", "readSuppressedClientSideInAppIds", "removeClientSideInApps", "removeServerSideInAppsMetaData", "storeClientSideInApps", "storeEvaluatedServerSideInAppIds", "evaluatedServerSideInAppIds", "storeServerSideInApps", "storeServerSideInAppsMetaData", "serverSideInAppsMetaData", "storeSuppressedClientSideInAppIds", "suppressedClientSideInAppIds", "Companion", "clevertap-core_release"})
public final class InAppStore
implements ChangeUserCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ICTPreference ctPreference;
    @NotNull
    private final CryptHandler cryptHandler;
    @Nullable
    private JSONArray clientSideInApps;
    @Nullable
    private JSONArray serverSideInApps;
    @Nullable
    private String mode;
    @NotNull
    public static final String CLIENT_SIDE_MODE = "CS";
    @NotNull
    public static final String SERVER_SIDE_MODE = "SS";
    @NotNull
    public static final String NO_MODE = "NO_MODE";

    public InAppStore(@NotNull ICTPreference ctPreference, @NotNull CryptHandler cryptHandler) {
        Intrinsics.checkNotNullParameter((Object)ctPreference, (String)"ctPreference");
        Intrinsics.checkNotNullParameter((Object)cryptHandler, (String)"cryptHandler");
        this.ctPreference = ctPreference;
        this.cryptHandler = cryptHandler;
    }

    @Nullable
    public final String getMode() {
        return this.mode;
    }

    public final void setMode(@Nullable String value) {
        block14: {
            if (Intrinsics.areEqual((Object)this.mode, (Object)value)) {
                return;
            }
            this.mode = value;
            String string2 = value;
            if (string2 == null) break block14;
            int n = -1;
            switch (string2.hashCode()) {
                case 2160: {
                    if (string2.equals(CLIENT_SIDE_MODE)) {
                        n = 1;
                    }
                    break;
                }
                case 2656: {
                    if (string2.equals(SERVER_SIDE_MODE)) {
                        n = 2;
                    }
                    break;
                }
                case -1437347487: {
                    if (string2.equals(NO_MODE)) {
                        n = 3;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    this.removeServerSideInAppsMetaData();
                    break;
                }
                case 2: {
                    this.removeClientSideInApps();
                    break;
                }
                case 3: {
                    this.removeServerSideInAppsMetaData();
                    this.removeClientSideInApps();
                }
            }
        }
    }

    private final void removeClientSideInApps() {
        this.ctPreference.remove("inapp_notifs_cs");
        this.clientSideInApps = null;
    }

    private final void removeServerSideInAppsMetaData() {
        this.ctPreference.remove("inapp_notifs_ss");
    }

    public final void storeClientSideInApps(@NotNull JSONArray clientSideInApps) {
        block0: {
            String string2;
            String encryptedString;
            Intrinsics.checkNotNullParameter((Object)clientSideInApps, (String)"clientSideInApps");
            this.clientSideInApps = clientSideInApps;
            String string3 = clientSideInApps.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"clientSideInApps.toString()");
            String string4 = encryptedString = this.cryptHandler.encrypt(string3);
            if (string4 == null) break block0;
            String $this$storeClientSideInApps_u24lambda_u240 = string2 = string4;
            boolean bl = false;
            this.ctPreference.writeString("inapp_notifs_cs", $this$storeClientSideInApps_u24lambda_u240);
        }
    }

    public final void storeServerSideInAppsMetaData(@NotNull JSONArray serverSideInAppsMetaData) {
        Intrinsics.checkNotNullParameter((Object)serverSideInAppsMetaData, (String)"serverSideInAppsMetaData");
        String string2 = serverSideInAppsMetaData.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"serverSideInAppsMetaData.toString()");
        this.ctPreference.writeString("inapp_notifs_ss", string2);
    }

    public final void storeServerSideInApps(@NotNull JSONArray serverSideInApps) {
        block0: {
            String string2;
            String encryptedString;
            Intrinsics.checkNotNullParameter((Object)serverSideInApps, (String)"serverSideInApps");
            this.serverSideInApps = serverSideInApps;
            String string3 = serverSideInApps.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"serverSideInApps.toString()");
            String string4 = encryptedString = this.cryptHandler.encrypt(string3);
            if (string4 == null) break block0;
            String $this$storeServerSideInApps_u24lambda_u241 = string2 = string4;
            boolean bl = false;
            this.ctPreference.writeString("inApp", $this$storeServerSideInApps_u24lambda_u241);
        }
    }

    public final void storeEvaluatedServerSideInAppIds(@NotNull JSONObject evaluatedServerSideInAppIds) {
        Intrinsics.checkNotNullParameter((Object)evaluatedServerSideInAppIds, (String)"evaluatedServerSideInAppIds");
        String string2 = evaluatedServerSideInAppIds.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"evaluatedServerSideInAppIds.toString()");
        this.ctPreference.writeString("evaluated_ss", string2);
    }

    public final void storeSuppressedClientSideInAppIds(@NotNull JSONObject suppressedClientSideInAppIds) {
        Intrinsics.checkNotNullParameter((Object)suppressedClientSideInAppIds, (String)"suppressedClientSideInAppIds");
        String string2 = suppressedClientSideInAppIds.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"suppressedClientSideInAppIds.toString()");
        this.ctPreference.writeString("suppressed_ss", string2);
    }

    @NotNull
    public final JSONArray readClientSideInApps() {
        if (this.clientSideInApps != null) {
            JSONArray jSONArray = this.clientSideInApps;
            Intrinsics.checkNotNull((Object)jSONArray, (String)"null cannot be cast to non-null type org.json.JSONArray");
            return jSONArray;
        }
        String csInAppsEncrypted = this.ctPreference.readString("inapp_notifs_cs", "");
        CharSequence charSequence = csInAppsEncrypted;
        JSONArray jSONArray = this.clientSideInApps = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? new JSONArray() : new JSONArray(this.cryptHandler.decrypt(csInAppsEncrypted));
        Intrinsics.checkNotNull((Object)jSONArray, (String)"null cannot be cast to non-null type org.json.JSONArray");
        return jSONArray;
    }

    @NotNull
    public final JSONArray readServerSideInAppsMetaData() {
        String ssInAppsMetaData = this.ctPreference.readString("inapp_notifs_ss", "");
        CharSequence charSequence = ssInAppsMetaData;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return new JSONArray();
        }
        return new JSONArray(ssInAppsMetaData);
    }

    @NotNull
    public final JSONObject readEvaluatedServerSideInAppIds() {
        String evaluatedServerSideInAppIds = this.ctPreference.readString("evaluated_ss", "");
        CharSequence charSequence = evaluatedServerSideInAppIds;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return new JSONObject();
        }
        try {
            charSequence = new JSONObject(evaluatedServerSideInAppIds);
        }
        catch (JSONException jsonException) {
            charSequence = this.migrateInAppHeaderPrefsForEventType(evaluatedServerSideInAppIds);
        }
        return charSequence;
    }

    @NotNull
    public final JSONObject readSuppressedClientSideInAppIds() {
        String suppressedClientSideInAppIds = this.ctPreference.readString("suppressed_ss", "");
        CharSequence charSequence = suppressedClientSideInAppIds;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return new JSONObject();
        }
        try {
            charSequence = new JSONObject(suppressedClientSideInAppIds);
        }
        catch (JSONException jsonException) {
            charSequence = this.migrateInAppHeaderPrefsForEventType(suppressedClientSideInAppIds);
        }
        return charSequence;
    }

    private final JSONObject migrateInAppHeaderPrefsForEventType(String inAppIds) {
        JSONArray jsonArray = new JSONArray(inAppIds);
        JSONObject jSONObject = new JSONObject().put("raised", (Object)jsonArray);
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"JSONObject().put(Constants.RAISED, jsonArray)");
        return jSONObject;
    }

    @NotNull
    public final JSONArray readServerSideInApps() {
        if (this.serverSideInApps != null) {
            JSONArray jSONArray = this.serverSideInApps;
            Intrinsics.checkNotNull((Object)jSONArray, (String)"null cannot be cast to non-null type org.json.JSONArray");
            return jSONArray;
        }
        String ssEncryptedInApps = this.ctPreference.readString("inApp", "");
        CharSequence charSequence = ssEncryptedInApps;
        JSONArray jSONArray = this.serverSideInApps = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? new JSONArray() : new JSONArray(this.cryptHandler.decrypt(ssEncryptedInApps));
        Intrinsics.checkNotNull((Object)jSONArray, (String)"null cannot be cast to non-null type org.json.JSONArray");
        return jSONArray;
    }

    @Override
    public void onChangeUser(@NotNull String deviceId, @NotNull String accountId) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        String newPrefName = StoreProvider.Companion.getInstance().constructStorePreferenceName(1, deviceId, accountId);
        this.ctPreference.changePreferenceName(newPrefName);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/clevertap/android/sdk/inapp/store/preference/InAppStore$Companion;", "", "()V", "CLIENT_SIDE_MODE", "", "NO_MODE", "SERVER_SIDE_MODE", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

