/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.bitmap;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.bitmap.IBitmapInputStreamReader;
import com.clevertap.android.sdk.network.DownloadedBitmap;
import com.clevertap.android.sdk.network.DownloadedBitmapFactory;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0016\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/clevertap/android/sdk/bitmap/BitmapInputStreamDecoder;", "Lcom/clevertap/android/sdk/bitmap/IBitmapInputStreamReader;", "saveBytes", "", "saveBitmap", "logger", "Lcom/clevertap/android/sdk/Logger;", "(ZZLcom/clevertap/android/sdk/Logger;)V", "getLogger", "()Lcom/clevertap/android/sdk/Logger;", "getSaveBitmap", "()Z", "getSaveBytes", "readInputStream", "Lcom/clevertap/android/sdk/network/DownloadedBitmap;", "inputStream", "Ljava/io/InputStream;", "connection", "Ljava/net/HttpURLConnection;", "downloadStartTimeInMilliseconds", "", "clevertap-core_release"})
public class BitmapInputStreamDecoder
implements IBitmapInputStreamReader {
    private final boolean saveBytes;
    private final boolean saveBitmap;
    @Nullable
    private final Logger logger;

    public BitmapInputStreamDecoder(boolean saveBytes, boolean saveBitmap, @Nullable Logger logger) {
        this.saveBytes = saveBytes;
        this.saveBitmap = saveBitmap;
        this.logger = logger;
    }

    public /* synthetic */ BitmapInputStreamDecoder(boolean bl, boolean bl2, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        if ((n & 4) != 0) {
            logger = null;
        }
        this(bl, bl2, logger);
    }

    public final boolean getSaveBytes() {
        return this.saveBytes;
    }

    public final boolean getSaveBitmap() {
        return this.saveBitmap;
    }

    @Nullable
    public final Logger getLogger() {
        return this.logger;
    }

    @Override
    @NotNull
    public DownloadedBitmap readInputStream(@NotNull InputStream inputStream, @NotNull HttpURLConnection connection, long downloadStartTimeInMilliseconds) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Logger logger = this.logger;
        if (logger != null) {
            logger.verbose("reading bitmap input stream in BitmapInputStreamDecoder....");
        }
        byte[] bufferForHttpInputStream = new byte[16384];
        ByteArrayOutputStream finalDataFromHttpInputStream = new ByteArrayOutputStream();
        int totalBytesRead = 0;
        int bytesRead = 0;
        while (true) {
            int n;
            int it = n = inputStream.read(bufferForHttpInputStream);
            boolean bl = false;
            bytesRead = it;
            if (n == -1) break;
            totalBytesRead += bytesRead;
            finalDataFromHttpInputStream.write(bufferForHttpInputStream, 0, bytesRead);
            Logger logger2 = this.logger;
            if (logger2 == null) continue;
            logger2.verbose("Downloaded " + totalBytesRead + " bytes");
        }
        Logger logger3 = this.logger;
        if (logger3 != null) {
            logger3.verbose("Total download size for bitmap = " + totalBytesRead);
        }
        byte[] dataReadFromStreamInByteArray = finalDataFromHttpInputStream.toByteArray();
        int fileLength = connection.getContentLength();
        if (fileLength != -1 && fileLength != totalBytesRead) {
            Logger logger4 = this.logger;
            if (logger4 != null) {
                logger4.debug("File not loaded completely not going forward. URL was: " + connection.getURL());
            }
            return DownloadedBitmapFactory.INSTANCE.nullBitmapWithStatus(DownloadedBitmap.Status.DOWNLOAD_FAILED);
        }
        DownloadedBitmap downloadedBitmap = null;
        if (this.saveBitmap) {
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])dataReadFromStreamInByteArray, (int)0, (int)dataReadFromStreamInByteArray.length);
            downloadedBitmap = bitmap != null ? DownloadedBitmapFactory.INSTANCE.successBitmap(bitmap, Utils.getNowInMillis() - downloadStartTimeInMilliseconds, this.saveBytes ? dataReadFromStreamInByteArray : (byte[])null) : DownloadedBitmapFactory.INSTANCE.nullBitmapWithStatus(DownloadedBitmap.Status.DOWNLOAD_FAILED);
        } else {
            long l = Utils.getNowInMillis() - downloadStartTimeInMilliseconds;
            Intrinsics.checkNotNullExpressionValue((Object)dataReadFromStreamInByteArray, (String)"dataReadFromStreamInByteArray");
            downloadedBitmap = DownloadedBitmapFactory.INSTANCE.successBytes(l, dataReadFromStreamInByteArray);
        }
        return downloadedBitmap;
    }

    public BitmapInputStreamDecoder() {
        this(false, false, null, 7, null);
    }
}

