/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import com.clevertap.android.sdk.cryption.CryptHandler;
import com.clevertap.android.sdk.inapp.store.preference.FileStore;
import com.clevertap.android.sdk.inapp.store.preference.ImpressionStore;
import com.clevertap.android.sdk.inapp.store.preference.InAppAssetsStore;
import com.clevertap.android.sdk.inapp.store.preference.InAppStore;
import com.clevertap.android.sdk.inapp.store.preference.LegacyInAppStore;
import com.clevertap.android.sdk.store.preference.CTPreference;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0007J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0004J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0004J&\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\u001b"}, d2={"Lcom/clevertap/android/sdk/StoreProvider;", "", "()V", "constructStorePreferenceName", "", "storeType", "", "deviceId", "accountId", "getCTPreference", "Lcom/clevertap/android/sdk/store/preference/CTPreference;", "context", "Landroid/content/Context;", "prefName", "provideFileStore", "Lcom/clevertap/android/sdk/inapp/store/preference/FileStore;", "provideImpressionStore", "Lcom/clevertap/android/sdk/inapp/store/preference/ImpressionStore;", "provideInAppAssetsStore", "Lcom/clevertap/android/sdk/inapp/store/preference/InAppAssetsStore;", "provideInAppStore", "Lcom/clevertap/android/sdk/inapp/store/preference/InAppStore;", "cryptHandler", "Lcom/clevertap/android/sdk/cryption/CryptHandler;", "provideLegacyInAppStore", "Lcom/clevertap/android/sdk/inapp/store/preference/LegacyInAppStore;", "Companion", "clevertap-core_release"})
public final class StoreProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private static volatile StoreProvider INSTANCE;
    @NotNull
    private static final String ASSET_STORE_PREFIX = "inapp_assets";
    @NotNull
    private static final String FILE_STORE_PREFIX = "ct_files";

    @NotNull
    public final InAppAssetsStore provideInAppAssetsStore(@NotNull Context context, @NotNull String accountId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        String prefName = StoreProvider.constructStorePreferenceName$default(this, 4, null, accountId, 2, null);
        return new InAppAssetsStore(this.getCTPreference(context, prefName));
    }

    @NotNull
    public final FileStore provideFileStore(@NotNull Context context, @NotNull String accountId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        String prefName = StoreProvider.constructStorePreferenceName$default(this, 5, null, accountId, 2, null);
        return new FileStore(this.getCTPreference(context, prefName));
    }

    @NotNull
    public final InAppStore provideInAppStore(@NotNull Context context, @NotNull CryptHandler cryptHandler, @NotNull String deviceId, @NotNull String accountId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cryptHandler, (String)"cryptHandler");
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        String prefName = this.constructStorePreferenceName(1, deviceId, accountId);
        return new InAppStore(this.getCTPreference(context, prefName), cryptHandler);
    }

    @NotNull
    public final ImpressionStore provideImpressionStore(@NotNull Context context, @NotNull String deviceId, @NotNull String accountId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        String prefName = this.constructStorePreferenceName(2, deviceId, accountId);
        return new ImpressionStore(this.getCTPreference(context, prefName));
    }

    @NotNull
    public final LegacyInAppStore provideLegacyInAppStore(@NotNull Context context, @NotNull String accountId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        String prefName = StoreProvider.constructStorePreferenceName$default(this, 3, null, null, 6, null);
        return new LegacyInAppStore(this.getCTPreference(context, prefName), accountId);
    }

    @VisibleForTesting
    @NotNull
    public final CTPreference getCTPreference(@NotNull Context context, @NotNull String prefName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)prefName, (String)"prefName");
        return new CTPreference(context, prefName);
    }

    @NotNull
    public final String constructStorePreferenceName(int storeType, @NotNull String deviceId, @NotNull String accountId) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        switch (storeType) {
            case 4: {
                string2 = "inapp_assets:" + accountId;
                break;
            }
            case 5: {
                string2 = "ct_files:" + accountId;
                break;
            }
            case 1: {
                string2 = "inApp:" + deviceId + ':' + accountId;
                break;
            }
            case 2: {
                string2 = "counts_per_inapp:" + deviceId + ':' + accountId;
                break;
            }
            case 3: {
                string2 = "WizRocket";
                break;
            }
            default: {
                string2 = "WizRocket";
            }
        }
        return string2;
    }

    public static /* synthetic */ String constructStorePreferenceName$default(StoreProvider storeProvider, int n, String string2, String string3, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string2 = "";
        }
        if ((n2 & 4) != 0) {
            string3 = "";
        }
        return storeProvider.constructStorePreferenceName(n, string2, string3);
    }

    @JvmStatic
    @NotNull
    public static final StoreProvider getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\u0007H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/clevertap/android/sdk/StoreProvider$Companion;", "", "()V", "ASSET_STORE_PREFIX", "", "FILE_STORE_PREFIX", "INSTANCE", "Lcom/clevertap/android/sdk/StoreProvider;", "getInstance", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final StoreProvider getInstance() {
            StoreProvider storeProvider = INSTANCE;
            if (storeProvider == null) {
                Companion companion = this;
                synchronized (companion) {
                    boolean bl = false;
                    StoreProvider storeProvider2 = INSTANCE;
                    if (storeProvider2 == null) {
                        StoreProvider storeProvider3;
                        StoreProvider it = storeProvider3 = new StoreProvider();
                        boolean bl2 = false;
                        INSTANCE = it;
                        storeProvider2 = storeProvider3;
                    }
                    StoreProvider storeProvider4 = storeProvider2;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl17 : MonitorExitStatement: MONITOREXIT : var1_1
                    storeProvider = storeProvider4;
                }
            }
            return storeProvider;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

