/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.login;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.RestrictTo;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.cryption.CryptHandler;
import com.clevertap.android.sdk.cryption.CryptUtils;
import com.clevertap.android.sdk.utils.CTJsonConverter;
import java.util.Iterator;
import java.util.Objects;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class LoginInfoProvider {
    private final CleverTapInstanceConfig config;
    private final Context context;
    private final DeviceInfo deviceInfo;
    private CryptHandler cryptHandler;

    public LoginInfoProvider(Context context, CleverTapInstanceConfig config, DeviceInfo deviceInfo) {
        this.context = context;
        this.config = config;
        this.deviceInfo = deviceInfo;
    }

    public LoginInfoProvider(Context context, CleverTapInstanceConfig config, DeviceInfo deviceInfo, CryptHandler cryptHandler) {
        this.context = context;
        this.config = config;
        this.deviceInfo = deviceInfo;
        this.cryptHandler = cryptHandler;
    }

    public void cacheGUIDForIdentifier(String guid, String key, String identifier) {
        if (this.isErrorDeviceId() || guid == null || key == null || identifier == null) {
            return;
        }
        String encryptedIdentifier = this.cryptHandler.encrypt(identifier, key);
        if (encryptedIdentifier == null) {
            encryptedIdentifier = identifier;
            CryptUtils.updateEncryptionFlagOnFailure(this.context, this.config, 1, this.cryptHandler);
        }
        String cacheKey = key + "_" + encryptedIdentifier;
        JSONObject cache = this.getCachedGUIDs();
        try {
            cache.put(cacheKey, (Object)guid);
            this.setCachedGUIDs(cache);
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Error caching guid: " + t);
        }
    }

    public void removeValueFromCachedGUIDForIdentifier(String guid, String key) {
        if (this.isErrorDeviceId() || guid == null || key == null) {
            return;
        }
        JSONObject cachedGuidJsonObj = this.getCachedGUIDs();
        try {
            Iterator i = cachedGuidJsonObj.keys();
            while (i.hasNext()) {
                String nextJSONObjKey = (String)i.next();
                String actualKeyInLowerCase = nextJSONObjKey.toLowerCase();
                if (!actualKeyInLowerCase.contains(key.toLowerCase()) || !cachedGuidJsonObj.getString(nextJSONObjKey).equals(guid)) continue;
                cachedGuidJsonObj.remove(nextJSONObjKey);
                if (cachedGuidJsonObj.length() == 0) {
                    this.removeCachedGuidFromSharedPrefs();
                    continue;
                }
                this.setCachedGUIDs(cachedGuidJsonObj);
            }
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Error removing cached key: " + t);
        }
    }

    public boolean deviceIsMultiUser() {
        JSONObject cachedGUIDs = this.getCachedGUIDs();
        boolean deviceIsMultiUser = cachedGUIDs.length() > 1;
        this.config.log("ON_USER_LOGIN", "deviceIsMultiUser:[" + deviceIsMultiUser + "]");
        return deviceIsMultiUser;
    }

    public JSONObject getCachedGUIDs() {
        String json = StorageHelper.getStringFromPrefs(this.context, this.config, "cachedGUIDsKey", null);
        this.config.log("ON_USER_LOGIN", "getCachedGUIDs:[" + json + "]");
        return CTJsonConverter.toJsonObject(json, this.config.getLogger(), this.config.getAccountId());
    }

    public void setCachedGUIDs(JSONObject cachedGUIDs) {
        if (cachedGUIDs == null) {
            return;
        }
        try {
            String cachedGuid = cachedGUIDs.toString();
            StorageHelper.putString(this.context, StorageHelper.storageKeyWithSuffix(this.config, "cachedGUIDsKey"), cachedGuid);
            this.config.log("ON_USER_LOGIN", "setCachedGUIDs:[" + cachedGuid + "]");
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Error persisting guid cache: " + t);
        }
    }

    public void removeCachedGuidFromSharedPrefs() {
        try {
            StorageHelper.remove(this.context, StorageHelper.storageKeyWithSuffix(this.config, "cachedGUIDsKey"));
            this.config.log("ON_USER_LOGIN", "removeCachedGUIDs:[]");
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Error removing guid cache: " + t);
        }
    }

    public String getCachedIdentityKeysForAccount() {
        String cachedKeys = StorageHelper.getStringFromPrefs(this.context, this.config, "SP_KEY_PROFILE_IDENTITIES", "");
        this.config.log("ON_USER_LOGIN", "getCachedIdentityKeysForAccount:" + cachedKeys);
        return cachedKeys;
    }

    public String getGUIDForIdentifier(String key, String identifier) {
        if (key == null || identifier == null) {
            return null;
        }
        String encryptedIdentifier = this.cryptHandler.encrypt(identifier, key);
        String cacheKey = key + "_" + encryptedIdentifier;
        JSONObject cache = this.getCachedGUIDs();
        try {
            String cachedGuid = cache.getString(cacheKey);
            this.config.log("ON_USER_LOGIN", "getGUIDForIdentifier:[Key:" + key + ", value:" + cachedGuid + "]");
            return cachedGuid;
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Error reading guid cache: " + t);
            if (Objects.equals(encryptedIdentifier, identifier)) {
                return null;
            }
            try {
                cacheKey = key + "_" + identifier;
                String cachedGuid = cache.getString(cacheKey);
                this.config.log("ON_USER_LOGIN", "getGUIDForIdentifier:[Key:" + key + ", value:" + cachedGuid + "] after retry");
                return cachedGuid;
            }
            catch (Throwable t2) {
                this.config.getLogger().verbose(this.config.getAccountId(), "Error reading guid cache after retry: " + t2);
                return null;
            }
        }
    }

    public boolean isAnonymousDevice() {
        JSONObject cachedGUIDs = this.getCachedGUIDs();
        boolean isAnonymousDevice = cachedGUIDs.length() <= 0;
        this.config.log("ON_USER_LOGIN", "isAnonymousDevice:[" + isAnonymousDevice + "]");
        return isAnonymousDevice;
    }

    public boolean isLegacyProfileLoggedIn() {
        JSONObject jsonObject = this.getCachedGUIDs();
        boolean isLoggedIn = jsonObject != null && jsonObject.length() > 0 && TextUtils.isEmpty((CharSequence)this.getCachedIdentityKeysForAccount());
        this.config.log("ON_USER_LOGIN", "isLegacyProfileLoggedIn:" + isLoggedIn);
        return isLoggedIn;
    }

    public void saveIdentityKeysForAccount(String valueCommaSeparated) {
        StorageHelper.putString(this.context, this.config, "SP_KEY_PROFILE_IDENTITIES", valueCommaSeparated);
        this.config.log("ON_USER_LOGIN", "saveIdentityKeysForAccount:" + valueCommaSeparated);
    }

    private boolean isErrorDeviceId() {
        boolean isErrorDeviceId = this.deviceInfo.isErrorDeviceId();
        this.config.log("ON_USER_LOGIN", "isErrorDeviceId:[" + isErrorDeviceId + "]");
        return isErrorDeviceId;
    }
}

