/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp.images.repo;

import com.clevertap.android.sdk.inapp.images.cleanup.InAppCleanupStrategy;
import com.clevertap.android.sdk.inapp.images.preload.InAppImagePreloaderStrategy;
import com.clevertap.android.sdk.inapp.images.repo.InAppResourcesRepo;
import com.clevertap.android.sdk.inapp.store.preference.InAppAssetsStore;
import com.clevertap.android.sdk.inapp.store.preference.LegacyInAppStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000f\u001a\u00020\u00102\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0007J\u0016\u0010\u0014\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\"\u0010\u0016\u001a\u00020\u00102\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0007J\u0016\u0010\u0019\u001a\u00020\u00102\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0016\u0010\u001b\u001a\u00020\u00102\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/clevertap/android/sdk/inapp/images/repo/InAppImageRepoImpl;", "Lcom/clevertap/android/sdk/inapp/images/repo/InAppResourcesRepo;", "cleanupStrategy", "Lcom/clevertap/android/sdk/inapp/images/cleanup/InAppCleanupStrategy;", "preloaderStrategy", "Lcom/clevertap/android/sdk/inapp/images/preload/InAppImagePreloaderStrategy;", "inAppAssetsStore", "Lcom/clevertap/android/sdk/inapp/store/preference/InAppAssetsStore;", "legacyInAppsStore", "Lcom/clevertap/android/sdk/inapp/store/preference/LegacyInAppStore;", "(Lcom/clevertap/android/sdk/inapp/images/cleanup/InAppCleanupStrategy;Lcom/clevertap/android/sdk/inapp/images/preload/InAppImagePreloaderStrategy;Lcom/clevertap/android/sdk/inapp/store/preference/InAppAssetsStore;Lcom/clevertap/android/sdk/inapp/store/preference/LegacyInAppStore;)V", "getCleanupStrategy", "()Lcom/clevertap/android/sdk/inapp/images/cleanup/InAppCleanupStrategy;", "getPreloaderStrategy", "()Lcom/clevertap/android/sdk/inapp/images/preload/InAppImagePreloaderStrategy;", "cleanupAllImages", "", "cleanupUrls", "", "", "cleanupStaleImages", "validUrls", "cleanupStaleImagesNow", "currentTime", "", "fetchAllGifs", "urls", "fetchAllImages", "Companion", "clevertap-core_release"})
public final class InAppImageRepoImpl
implements InAppResourcesRepo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InAppCleanupStrategy cleanupStrategy;
    @NotNull
    private final InAppImagePreloaderStrategy preloaderStrategy;
    @NotNull
    private final InAppAssetsStore inAppAssetsStore;
    @NotNull
    private final LegacyInAppStore legacyInAppsStore;
    public static final int DAY_IN_MILLIS = 86400000;
    private static final int DAYS_FOR_EXPIRY = 14;
    public static final int EXPIRY_OFFSET_MILLIS = 1209600000;

    public InAppImageRepoImpl(@NotNull InAppCleanupStrategy cleanupStrategy, @NotNull InAppImagePreloaderStrategy preloaderStrategy, @NotNull InAppAssetsStore inAppAssetsStore, @NotNull LegacyInAppStore legacyInAppsStore) {
        Intrinsics.checkNotNullParameter((Object)cleanupStrategy, (String)"cleanupStrategy");
        Intrinsics.checkNotNullParameter((Object)preloaderStrategy, (String)"preloaderStrategy");
        Intrinsics.checkNotNullParameter((Object)inAppAssetsStore, (String)"inAppAssetsStore");
        Intrinsics.checkNotNullParameter((Object)legacyInAppsStore, (String)"legacyInAppsStore");
        this.cleanupStrategy = cleanupStrategy;
        this.preloaderStrategy = preloaderStrategy;
        this.inAppAssetsStore = inAppAssetsStore;
        this.legacyInAppsStore = legacyInAppsStore;
    }

    @Override
    @NotNull
    public InAppCleanupStrategy getCleanupStrategy() {
        return this.cleanupStrategy;
    }

    @Override
    @NotNull
    public InAppImagePreloaderStrategy getPreloaderStrategy() {
        return this.preloaderStrategy;
    }

    @Override
    public void fetchAllImages(@NotNull List<String> urls) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        Function1 successBlock2 = (Function1)new Function1<String, Unit>(this){
            final /* synthetic */ InAppImageRepoImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                long expiry = System.currentTimeMillis() + (long)1209600000;
                InAppImageRepoImpl.access$getInAppAssetsStore$p(this.this$0).saveAssetUrl(url, expiry);
            }
        };
        this.getPreloaderStrategy().preloadImages(urls, (Function1<? super String, Unit>)successBlock2);
    }

    @Override
    public void fetchAllGifs(@NotNull List<String> urls) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        Function1 successBlock2 = (Function1)new Function1<String, Unit>(this){
            final /* synthetic */ InAppImageRepoImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                long expiry = System.currentTimeMillis() + (long)1209600000;
                InAppImageRepoImpl.access$getInAppAssetsStore$p(this.this$0).saveAssetUrl(url, expiry);
            }
        };
        this.getPreloaderStrategy().preloadGifs(urls, (Function1<? super String, Unit>)successBlock2);
    }

    @Override
    public void cleanupStaleImages(@NotNull List<String> validUrls) {
        Intrinsics.checkNotNullParameter(validUrls, (String)"validUrls");
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.legacyInAppsStore.lastCleanupTs() < 1209600000L) {
            return;
        }
        this.cleanupStaleImagesNow(validUrls, currentTime);
        this.legacyInAppsStore.updateAssetCleanupTs(currentTime);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final void cleanupStaleImagesNow(@NotNull List<String> validUrls, long currentTime) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(validUrls, (String)"validUrls");
        Iterable $this$associateWith$iv = validUrls;
        boolean $i$f$associateWith = false;
        Object result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo22 = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            String string2 = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = (Map)result$iv;
            boolean bl = false;
            void var18_19 = it;
            map.put(t, var18_19);
        }
        Map valid = (Map)result$iv;
        Set<String> allAssetUrls = this.inAppAssetsStore.getAllAssetUrls();
        result$iv = CollectionsKt.toMutableSet((Iterable)allAssetUrls);
        boolean $i$f$filter = false;
        void $i$f$associateWithTo22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String key = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !valid.containsKey(key) && currentTime > this.inAppAssetsStore.expiryForUrl(key);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List cleanupUrls = (List)destination$iv$iv;
        this.cleanupAllImages(cleanupUrls);
    }

    public static /* synthetic */ void cleanupStaleImagesNow$default(InAppImageRepoImpl inAppImageRepoImpl, List list, long l, int n, Object object) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            l = System.currentTimeMillis();
        }
        inAppImageRepoImpl.cleanupStaleImagesNow(list, l);
    }

    @JvmOverloads
    public final void cleanupAllImages(@NotNull List<String> cleanupUrls) {
        Intrinsics.checkNotNullParameter(cleanupUrls, (String)"cleanupUrls");
        Function1 successBlock2 = (Function1)new Function1<String, Unit>(this){
            final /* synthetic */ InAppImageRepoImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                InAppImageRepoImpl.access$getInAppAssetsStore$p(this.this$0).clearAssetUrl(url);
            }
        };
        this.getCleanupStrategy().clearAssets(cleanupUrls, (Function1<? super String, Unit>)successBlock2);
    }

    public static /* synthetic */ void cleanupAllImages$default(InAppImageRepoImpl inAppImageRepoImpl, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = CollectionsKt.toList((Iterable)inAppImageRepoImpl.inAppAssetsStore.getAllAssetUrls());
        }
        inAppImageRepoImpl.cleanupAllImages(list);
    }

    @JvmOverloads
    public final void cleanupStaleImagesNow(@NotNull List<String> validUrls) {
        Intrinsics.checkNotNullParameter(validUrls, (String)"validUrls");
        InAppImageRepoImpl.cleanupStaleImagesNow$default(this, validUrls, 0L, 2, null);
    }

    @JvmOverloads
    public final void cleanupStaleImagesNow() {
        InAppImageRepoImpl.cleanupStaleImagesNow$default(this, null, 0L, 3, null);
    }

    @JvmOverloads
    public final void cleanupAllImages() {
        InAppImageRepoImpl.cleanupAllImages$default(this, null, 1, null);
    }

    public static final /* synthetic */ InAppAssetsStore access$getInAppAssetsStore$p(InAppImageRepoImpl $this) {
        return $this.inAppAssetsStore;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/clevertap/android/sdk/inapp/images/repo/InAppImageRepoImpl$Companion;", "", "()V", "DAYS_FOR_EXPIRY", "", "DAY_IN_MILLIS", "EXPIRY_OFFSET_MILLIS", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

