/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.response;

import android.content.Context;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.inapp.TriggerManager;
import com.clevertap.android.sdk.inapp.data.InAppResponseAdapter;
import com.clevertap.android.sdk.inapp.images.InAppResourceProvider;
import com.clevertap.android.sdk.inapp.images.cleanup.InAppCleanupStrategyExecutors;
import com.clevertap.android.sdk.inapp.images.preload.InAppImagePreloaderExecutors;
import com.clevertap.android.sdk.inapp.images.repo.InAppImageRepoImpl;
import com.clevertap.android.sdk.inapp.store.preference.ImpressionStore;
import com.clevertap.android.sdk.inapp.store.preference.InAppAssetsStore;
import com.clevertap.android.sdk.inapp.store.preference.InAppStore;
import com.clevertap.android.sdk.inapp.store.preference.LegacyInAppStore;
import com.clevertap.android.sdk.inapp.store.preference.StoreRegistry;
import com.clevertap.android.sdk.response.CleverTapResponseDecorator;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.Task;
import java.util.concurrent.Callable;
import kotlin.Pair;
import org.json.JSONArray;
import org.json.JSONObject;

public class InAppResponse
extends CleverTapResponseDecorator {
    private final CleverTapInstanceConfig config;
    private final ControllerManager controllerManager;
    private final boolean isSendTest;
    private final Logger logger;
    private final StoreRegistry storeRegistry;
    private final TriggerManager triggerManager;
    private final CoreMetaData coreMetaData;

    public InAppResponse(CleverTapInstanceConfig config, ControllerManager controllerManager, boolean isSendTest, StoreRegistry storeRegistry, TriggerManager triggerManager, CoreMetaData coreMetaData) {
        this.config = config;
        this.logger = this.config.getLogger();
        this.controllerManager = controllerManager;
        this.isSendTest = isSendTest;
        this.storeRegistry = storeRegistry;
        this.triggerManager = triggerManager;
        this.coreMetaData = coreMetaData;
    }

    @Override
    public void processResponse(JSONObject response, String stringBody, Context context) {
        try {
            Pair<Boolean, JSONArray> ssInApps;
            Pair<Boolean, JSONArray> csInApps;
            Pair<Boolean, JSONArray> appLaunchInApps;
            Pair<Boolean, JSONArray> legacyInApps;
            InAppResponseAdapter res = new InAppResponseAdapter(response);
            ImpressionStore impressionStore = this.storeRegistry.getImpressionStore();
            InAppStore inAppStore = this.storeRegistry.getInAppStore();
            InAppAssetsStore inAppAssetStore = this.storeRegistry.getInAppAssetsStore();
            LegacyInAppStore legacyInAppStore = this.storeRegistry.getLegacyInAppStore();
            if (impressionStore == null || inAppStore == null || inAppAssetStore == null || legacyInAppStore == null) {
                this.logger.verbose(this.config.getAccountId(), "Stores are not initialised, ignoring inapps!!!!");
                return;
            }
            if (this.config.isAnalyticsOnly()) {
                this.logger.verbose(this.config.getAccountId(), "CleverTap instance is configured to analytics only, not processing inapp messages");
                return;
            }
            this.logger.verbose(this.config.getAccountId(), "InApp: Processing response");
            int perSession = res.getInAppsPerSession();
            int perDay = res.getInAppsPerDay();
            if (!this.isSendTest && this.controllerManager.getInAppFCManager() != null) {
                Logger.v("Updating InAppFC Limits");
                this.controllerManager.getInAppFCManager().updateLimits(context, perDay, perSession);
                this.controllerManager.getInAppFCManager().processResponse(context, response);
            } else {
                this.logger.verbose(this.config.getAccountId(), "controllerManager.getInAppFCManager() is NULL, not Updating InAppFC Limits");
            }
            Pair<Boolean, JSONArray> inappStaleList = res.getStaleInApps();
            if (((Boolean)inappStaleList.getFirst()).booleanValue()) {
                this.clearStaleInAppCache((JSONArray)inappStaleList.getSecond(), impressionStore, this.triggerManager);
            }
            if (((Boolean)(legacyInApps = res.getLegacyInApps()).getFirst()).booleanValue()) {
                this.displayInApp((JSONArray)legacyInApps.getSecond());
            }
            if (((Boolean)(appLaunchInApps = res.getAppLaunchServerSideInApps()).getFirst()).booleanValue()) {
                this.handleAppLaunchServerSide((JSONArray)appLaunchInApps.getSecond());
            }
            if (((Boolean)(csInApps = res.getClientSideInApps()).getFirst()).booleanValue()) {
                inAppStore.storeClientSideInApps((JSONArray)csInApps.getSecond());
            }
            if (((Boolean)(ssInApps = res.getServerSideInApps()).getFirst()).booleanValue()) {
                inAppStore.storeServerSideInAppsMetaData((JSONArray)ssInApps.getSecond());
            }
            InAppResourceProvider inAppResourceProvider = new InAppResourceProvider(context, this.logger);
            InAppImagePreloaderExecutors preloadStrategy = new InAppImagePreloaderExecutors(inAppResourceProvider, this.logger);
            InAppCleanupStrategyExecutors cleanupStrategy = new InAppCleanupStrategyExecutors(inAppResourceProvider);
            InAppImageRepoImpl assetRepo = new InAppImageRepoImpl(cleanupStrategy, preloadStrategy, inAppAssetStore, legacyInAppStore);
            assetRepo.fetchAllImages(res.getPreloadImages());
            assetRepo.fetchAllGifs(res.getPreloadGifs());
            if (this.isFullResponse) {
                this.logger.verbose(this.config.getAccountId(), "Handling cache eviction");
                assetRepo.cleanupStaleImages(res.getPreloadAssets());
            } else {
                this.logger.verbose(this.config.getAccountId(), "Ignoring cache eviction");
            }
            String mode = res.getInAppMode();
            if (!mode.isEmpty()) {
                inAppStore.setMode(mode);
            }
        }
        catch (Throwable t) {
            Logger.v("InAppManager: Failed to parse response", t);
        }
    }

    private void clearStaleInAppCache(JSONArray inappStaleList, ImpressionStore impressionStore, TriggerManager triggerManager) {
        for (int i = 0; i < inappStaleList.length(); ++i) {
            String inappStaleId = inappStaleList.optString(i);
            impressionStore.clear(inappStaleId);
            triggerManager.removeTriggers(inappStaleId);
        }
    }

    private void handleAppLaunchServerSide(JSONArray inappNotifsApplaunched) {
        try {
            this.controllerManager.getInAppController().onAppLaunchServerSideInAppsResponse(inappNotifsApplaunched, this.coreMetaData.getLocationFromUser());
        }
        catch (Throwable e) {
            this.logger.verbose(this.config.getAccountId(), "InAppManager: Malformed AppLaunched ServerSide inApps");
            this.logger.verbose(this.config.getAccountId(), "InAppManager: Reason: " + e.getMessage(), e);
        }
    }

    private void displayInApp(final JSONArray inappNotifsArray) {
        Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask("TAG_FEATURE_IN_APPS");
        task.execute("InAppResponse#processResponse", new Callable<Void>(){

            @Override
            public Void call() {
                InAppResponse.this.controllerManager.getInAppController().addInAppNotificationsToQueue(inappNotifsArray);
                return null;
            }
        });
    }
}

