/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.network.http;

import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.network.http.CtHttpClient;
import com.clevertap.android.sdk.network.http.Request;
import com.clevertap.android.sdk.network.http.Response;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010 \u001a\u0004\u0018\u00010\u0016H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020$H\u0002R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0002\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001d\u0010\u0015\u001a\u0004\u0018\u00010\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u001b\u001a\u0004\u0018\u00010\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u001a\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006'"}, d2={"Lcom/clevertap/android/sdk/network/http/UrlConnectionHttpClient;", "Lcom/clevertap/android/sdk/network/http/CtHttpClient;", "isSslPinningEnabled", "", "logger", "Lcom/clevertap/android/sdk/Logger;", "logTag", "", "(ZLcom/clevertap/android/sdk/Logger;Ljava/lang/String;)V", "connectTimeout", "", "getConnectTimeout", "()I", "setConnectTimeout", "(I)V", "()Z", "setSslPinningEnabled", "(Z)V", "readTimeout", "getReadTimeout", "setReadTimeout", "sslContext", "Ljavax/net/ssl/SSLContext;", "getSslContext", "()Ljavax/net/ssl/SSLContext;", "sslContext$delegate", "Lkotlin/Lazy;", "sslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "getSslSocketFactory", "()Ljavax/net/ssl/SSLSocketFactory;", "sslSocketFactory$delegate", "createSslContext", "execute", "Lcom/clevertap/android/sdk/network/http/Response;", "request", "Lcom/clevertap/android/sdk/network/http/Request;", "openHttpsURLConnection", "Ljavax/net/ssl/HttpsURLConnection;", "clevertap-core_release"})
public final class UrlConnectionHttpClient
implements CtHttpClient {
    private boolean isSslPinningEnabled;
    @NotNull
    private final Logger logger;
    @NotNull
    private final String logTag;
    private int readTimeout;
    private int connectTimeout;
    @NotNull
    private final Lazy sslSocketFactory$delegate;
    @NotNull
    private final Lazy sslContext$delegate;

    public UrlConnectionHttpClient(boolean isSslPinningEnabled, @NotNull Logger logger, @NotNull String logTag) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)logTag, (String)"logTag");
        this.isSslPinningEnabled = isSslPinningEnabled;
        this.logger = logger;
        this.logTag = logTag;
        this.readTimeout = 10000;
        this.connectTimeout = 10000;
        this.sslSocketFactory$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SSLSocketFactory>(this){
            final /* synthetic */ UrlConnectionHttpClient this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final SSLSocketFactory invoke() {
                SSLSocketFactory sSLSocketFactory;
                try {
                    Logger.d("Pinning SSL session to DigiCertGlobalRoot CA certificate");
                    SSLContext sSLContext = UrlConnectionHttpClient.access$getSslContext(this.this$0);
                    sSLSocketFactory = sSLContext != null ? sSLContext.getSocketFactory() : null;
                }
                catch (Exception e) {
                    Logger.d("Issue in pinning SSL,", e);
                    sSLSocketFactory = null;
                }
                return sSLSocketFactory;
            }
        }));
        this.sslContext$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SSLContext>(this){
            final /* synthetic */ UrlConnectionHttpClient this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final SSLContext invoke() {
                return UrlConnectionHttpClient.access$createSslContext(this.this$0);
            }
        }));
    }

    public final boolean isSslPinningEnabled() {
        return this.isSslPinningEnabled;
    }

    public final void setSslPinningEnabled(boolean bl) {
        this.isSslPinningEnabled = bl;
    }

    public final int getReadTimeout() {
        return this.readTimeout;
    }

    public final void setReadTimeout(int n) {
        this.readTimeout = n;
    }

    public final int getConnectTimeout() {
        return this.connectTimeout;
    }

    public final void setConnectTimeout(int n) {
        this.connectTimeout = n;
    }

    private final SSLSocketFactory getSslSocketFactory() {
        Lazy lazy = this.sslSocketFactory$delegate;
        return (SSLSocketFactory)lazy.getValue();
    }

    private final SSLContext getSslContext() {
        Lazy lazy = this.sslContext$delegate;
        return (SSLContext)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Response execute(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Ref.ObjectRef connection = new Ref.ObjectRef();
        try {
            Response response;
            connection.element = this.openHttpsURLConnection(request);
            if (request.getBody() != null) {
                ((HttpsURLConnection)connection.element).setDoOutput(true);
                Closeable closeable = ((HttpsURLConnection)connection.element).getOutputStream();
                Throwable throwable = null;
                try {
                    OutputStream it = (OutputStream)closeable;
                    boolean bl = false;
                    byte[] byArray = request.getBody().getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                    it.write(byArray);
                    it = Unit.INSTANCE;
                }
                catch (Throwable it) {
                    throwable = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            this.logger.debug(this.logTag, "Sending request to: " + request.getUrl());
            int responseCode = ((HttpsURLConnection)connection.element).getResponseCode();
            Map<String, List<String>> headers = ((HttpsURLConnection)connection.element).getHeaderFields();
            Function0 disconnectConnection2 = (Function0)new Function0<Unit>((Ref.ObjectRef<HttpsURLConnection>)connection){
                final /* synthetic */ Ref.ObjectRef<HttpsURLConnection> $connection;
                {
                    this.$connection = $connection;
                    super(0);
                }

                public final void invoke() {
                    ((HttpsURLConnection)this.$connection.element).disconnect();
                }
            };
            if (responseCode == 200) {
                Intrinsics.checkNotNullExpressionValue(headers, (String)"headers");
                response = new Response(request, responseCode, headers, ((HttpsURLConnection)connection.element).getInputStream(), (Function0<Unit>)disconnectConnection2);
            } else {
                Intrinsics.checkNotNullExpressionValue(headers, (String)"headers");
                response = new Response(request, responseCode, headers, ((HttpsURLConnection)connection.element).getErrorStream(), (Function0<Unit>)disconnectConnection2);
            }
            return response;
        }
        catch (Exception e) {
            block11: {
                HttpsURLConnection httpsURLConnection = (HttpsURLConnection)connection.element;
                if (httpsURLConnection == null) break block11;
                httpsURLConnection.disconnect();
            }
            throw e;
        }
    }

    private final HttpsURLConnection openHttpsURLConnection(Request request) {
        URL url = new URL(request.getUrl().toString());
        URLConnection uRLConnection = url.openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
        HttpsURLConnection connection = (HttpsURLConnection)uRLConnection;
        connection.setConnectTimeout(this.connectTimeout);
        connection.setReadTimeout(this.readTimeout);
        for (Map.Entry<String, String> header : request.getHeaders().entrySet()) {
            connection.setRequestProperty(header.getKey(), header.getValue());
        }
        connection.setInstanceFollowRedirects(false);
        if (this.isSslPinningEnabled && this.getSslContext() != null) {
            connection.setSSLSocketFactory(this.getSslSocketFactory());
        }
        return connection;
    }

    private final SSLContext createSslContext() {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            ClassLoader classLoader = this.getClass().getClassLoader();
            InputStream inputStream = new BufferedInputStream(classLoader != null ? classLoader.getResourceAsStream("com/clevertap/android/sdk/certificates/AmazonRootCA1.cer") : null);
            Certificate certificate = certificateFactory.generateCertificate(inputStream);
            Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
            X509Certificate x509Certificate3 = (X509Certificate)certificate;
            keyStore.setCertificateEntry("AmazonRootCA1", x509Certificate3);
            trustManagerFactory.init(keyStore);
            SSLContext sslContext2 = SSLContext.getInstance("TLS");
            sslContext2.init(null, trustManagerFactory.getTrustManagers(), null);
            Logger.d("SSL Context built");
            return sslContext2;
        }
        catch (Exception e) {
            Logger.i("Error building SSL Context", e);
            return null;
        }
    }

    public static final /* synthetic */ SSLContext access$getSslContext(UrlConnectionHttpClient $this) {
        return $this.getSslContext();
    }

    public static final /* synthetic */ SSLContext access$createSslContext(UrlConnectionHttpClient $this) {
        return $this.createSslContext();
    }
}

