/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.response;

import android.content.Context;
import com.clevertap.android.sdk.BaseCallbackManager;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.displayunits.CTDisplayUnitController;
import com.clevertap.android.sdk.displayunits.model.CleverTapDisplayUnit;
import com.clevertap.android.sdk.response.CleverTapResponseDecorator;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class DisplayUnitResponse
extends CleverTapResponseDecorator {
    private final Object displayUnitControllerLock = new Object();
    private final BaseCallbackManager callbackManager;
    private final CleverTapInstanceConfig config;
    private final ControllerManager controllerManager;
    private final Logger logger;

    public DisplayUnitResponse(CleverTapInstanceConfig config, BaseCallbackManager callbackManager, ControllerManager controllerManager) {
        this.config = config;
        this.logger = this.config.getLogger();
        this.callbackManager = callbackManager;
        this.controllerManager = controllerManager;
    }

    @Override
    public void processResponse(JSONObject response, String stringBody, Context context) {
        this.logger.verbose(this.config.getAccountId(), "Processing Display Unit items...");
        if (this.config.isAnalyticsOnly()) {
            this.logger.verbose(this.config.getAccountId(), "CleverTap instance is configured to analytics only, not processing Display Unit response");
            return;
        }
        if (response == null) {
            this.logger.verbose(this.config.getAccountId(), "DisplayUnit : Can't parse Display Unit Response, JSON response object is null");
            return;
        }
        if (!response.has("adUnit_notifs")) {
            this.logger.verbose(this.config.getAccountId(), "DisplayUnit : JSON object doesn't contain the Display Units key");
            return;
        }
        try {
            this.logger.verbose(this.config.getAccountId(), "DisplayUnit : Processing Display Unit response");
            this.parseDisplayUnits(response.getJSONArray("adUnit_notifs"));
        }
        catch (Throwable t) {
            this.logger.verbose(this.config.getAccountId(), "DisplayUnit : Failed to parse response", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseDisplayUnits(JSONArray messages) {
        if (messages == null || messages.length() == 0) {
            this.logger.verbose(this.config.getAccountId(), "DisplayUnit : Can't parse Display Units, jsonArray is either empty or null");
            return;
        }
        Object object = this.displayUnitControllerLock;
        synchronized (object) {
            if (this.controllerManager.getCTDisplayUnitController() == null) {
                this.controllerManager.setCTDisplayUnitController(new CTDisplayUnitController());
            }
        }
        ArrayList<CleverTapDisplayUnit> displayUnits = this.controllerManager.getCTDisplayUnitController().updateDisplayUnits(messages);
        this.callbackManager.notifyDisplayUnitsLoaded(displayUnits);
    }
}

