/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.variables;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.Task;
import com.clevertap.android.sdk.variables.CTVariableUtils;
import com.clevertap.android.sdk.variables.JsonUtil;
import com.clevertap.android.sdk.variables.Var;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;

public class VarCache {
    private final Map<String, Object> valuesFromClient = new HashMap<String, Object>();
    private final Map<String, Var<?>> vars = new ConcurrentHashMap();
    private final Map<String, String> defaultKinds = new HashMap<String, String>();
    private Runnable globalCallbacksRunnable = null;
    private Map<String, Object> diffs = new HashMap<String, Object>();
    public Object merged = null;
    private final Context variablesCtx;
    private final CleverTapInstanceConfig instanceConfig;

    private static void log(String msg) {
        Logger.d("variables", msg);
    }

    private static void log(String msg, Throwable t) {
        Logger.d("variables", msg, t);
    }

    public VarCache(CleverTapInstanceConfig config, Context ctx) {
        this.variablesCtx = ctx;
        this.instanceConfig = config;
    }

    private void storeDataInCache(@NonNull String data) {
        VarCache.log("storeDataInCache() called with: data = [" + data + "]");
        String cacheKey = StorageHelper.storageKeyWithSuffix(this.instanceConfig, "variablesKey");
        try {
            StorageHelper.putString(this.variablesCtx, cacheKey, data);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private String loadDataFromCache() {
        String cacheKey = StorageHelper.storageKeyWithSuffix(this.instanceConfig, "variablesKey");
        String cache = StorageHelper.getString(this.variablesCtx, cacheKey, "{}");
        VarCache.log("VarCache loaded cache data:\n" + cache);
        return cache;
    }

    @VisibleForTesting
    void mergeVariable(@NonNull Var<?> var) {
        boolean shouldMerge;
        if (this.merged == null) {
            VarCache.log("mergeVariable() called, but `merged` member is null.");
            return;
        }
        if (!(this.merged instanceof Map)) {
            VarCache.log("mergeVariable() called, but `merged` member is not of Map type.");
            return;
        }
        String firstComponent = var.nameComponents()[0];
        Object defaultValue = this.valuesFromClient.get(firstComponent);
        Map mergedMap = (Map)JsonUtil.uncheckedCast(this.merged);
        Object mergedValue = mergedMap.get(firstComponent);
        boolean bl = shouldMerge = defaultValue == null && mergedValue != null || defaultValue != null && !defaultValue.equals(mergedValue);
        if (shouldMerge) {
            Object newValue = CTVariableUtils.mergeHelper(defaultValue, mergedValue);
            mergedMap.put(firstComponent, newValue);
            StringBuilder name = new StringBuilder(firstComponent);
            for (int i = 1; i < var.nameComponents().length; ++i) {
                Var<?> existing = this.vars.get(name.toString());
                if (existing != null) {
                    existing.update();
                }
                name.append('.').append(var.nameComponents()[i]);
            }
        }
    }

    public synchronized void registerVariable(@NonNull Var<?> var) {
        VarCache.log("registerVariable() called with: var = [" + var + "]");
        this.vars.put(var.name(), var);
        Object defaultValue = var.defaultValue();
        if (defaultValue instanceof Map) {
            defaultValue = CTVariableUtils.deepCopyMap((Map)JsonUtil.uncheckedCast(defaultValue));
        }
        CTVariableUtils.updateValuesAndKinds(var.name(), var.nameComponents(), defaultValue, var.kind(), this.valuesFromClient, this.defaultKinds);
        this.mergeVariable(var);
    }

    public synchronized Object getMergedValue(String variableName) {
        Object[] components = CTVariableUtils.getNameComponents(variableName);
        Object mergedValue = this.getMergedValueFromComponentArray(components);
        if (mergedValue instanceof Map) {
            return CTVariableUtils.deepCopyMap((Map)JsonUtil.uncheckedCast(mergedValue));
        }
        return mergedValue;
    }

    public synchronized <T> T getMergedValueFromComponentArray(Object[] components) {
        return this.getMergedValueFromComponentArray(components, this.merged != null ? this.merged : this.valuesFromClient);
    }

    public synchronized <T> T getMergedValueFromComponentArray(Object[] components, Object values) {
        Object mergedPtr = values;
        for (Object component : components) {
            mergedPtr = CTVariableUtils.traverse(mergedPtr, component, false);
        }
        return JsonUtil.uncheckedCast(mergedPtr);
    }

    public synchronized void loadDiffs() {
        try {
            String variablesFromCache = this.loadDataFromCache();
            Map<String, Object> variablesAsMap = JsonUtil.fromJson(variablesFromCache);
            this.applyVariableDiffs(variablesAsMap);
        }
        catch (Exception e) {
            VarCache.log("Could not load variable diffs.\n", e);
        }
    }

    public synchronized void loadDiffsAndTriggerHandlers() {
        this.loadDiffs();
        this.triggerGlobalCallbacks();
    }

    public synchronized void updateDiffsAndTriggerHandlers(Map<String, Object> diffs) {
        this.applyVariableDiffs(diffs);
        this.saveDiffsAsync();
        this.triggerGlobalCallbacks();
    }

    private void saveDiffsAsync() {
        Task<Void> task = CTExecutorFactory.executors(this.instanceConfig).postAsyncSafelyTask();
        task.execute("VarCache#saveDiffsAsync", () -> {
            this.saveDiffs();
            return null;
        });
    }

    @WorkerThread
    private void saveDiffs() {
        VarCache.log("saveDiffs() called");
        String variablesCipher = JsonUtil.toJson(this.diffs);
        this.storeDataInCache(variablesCipher);
    }

    private void applyVariableDiffs(Map<String, Object> diffs) {
        VarCache.log("applyVariableDiffs() called with: diffs = [" + diffs + "]");
        if (diffs != null) {
            this.diffs = diffs;
            this.merged = CTVariableUtils.mergeHelper(this.valuesFromClient, this.diffs);
            VarCache.log("applyVariableDiffs: updated value of merged=[" + this.merged + "]");
            for (String name : new HashMap(this.vars).keySet()) {
                Var<?> var = this.vars.get(name);
                if (var == null) continue;
                var.update();
            }
        }
    }

    private synchronized void triggerGlobalCallbacks() {
        if (this.globalCallbacksRunnable != null) {
            this.globalCallbacksRunnable.run();
        }
    }

    public JSONObject getDefineVarsData() {
        return CTVariableUtils.getFlatVarsJson(this.valuesFromClient, this.defaultKinds);
    }

    public synchronized void clearUserContent() {
        VarCache.log("Clear user content in VarCache");
        for (String name : new HashMap(this.vars).keySet()) {
            Var<?> var = this.vars.get(name);
            if (var == null) continue;
            var.clearStartFlag();
        }
        this.applyVariableDiffs(new HashMap<String, Object>());
        this.saveDiffsAsync();
    }

    public synchronized <T> Var<T> getVariable(String name) {
        return (Var)JsonUtil.uncheckedCast(this.vars.get(name));
    }

    @VisibleForTesting
    int getVariablesCount() {
        return this.vars.size();
    }

    public synchronized void setGlobalCallbacksRunnable(Runnable runnable) {
        this.globalCallbacksRunnable = runnable;
    }
}

