/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp.store.preference;

import com.clevertap.android.sdk.StoreProvider;
import com.clevertap.android.sdk.login.ChangeUserCallback;
import com.clevertap.android.sdk.store.preference.ICTPreference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u000b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\bH\u0002J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0016J\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0016\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/clevertap/android/sdk/inapp/store/preference/ImpressionStore;", "Lcom/clevertap/android/sdk/login/ChangeUserCallback;", "ctPreference", "Lcom/clevertap/android/sdk/store/preference/ICTPreference;", "(Lcom/clevertap/android/sdk/store/preference/ICTPreference;)V", "clear", "", "campaignId", "", "getLongListFromPrefs", "", "", "key", "onChangeUser", "deviceId", "accountId", "read", "saveLongListToPrefs", "list", "write", "timestamp", "Companion", "clevertap-core_release"})
public final class ImpressionStore
implements ChangeUserCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ICTPreference ctPreference;
    @NotNull
    public static final String PREF_PREFIX = "__impressions";

    public ImpressionStore(@NotNull ICTPreference ctPreference) {
        Intrinsics.checkNotNullParameter((Object)ctPreference, (String)"ctPreference");
        this.ctPreference = ctPreference;
    }

    @NotNull
    public final List<Long> read(@NotNull String campaignId) {
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        return this.getLongListFromPrefs("__impressions_" + campaignId);
    }

    public final void write(@NotNull String campaignId, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        List records = CollectionsKt.toMutableList((Collection)this.read(campaignId));
        records.add(timestamp);
        this.saveLongListToPrefs("__impressions_" + campaignId, records);
    }

    public final void clear(@NotNull String campaignId) {
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        this.ctPreference.remove("__impressions_" + campaignId);
    }

    private final void saveLongListToPrefs(String key, List<Long> list) {
        String serialized = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        this.ctPreference.writeString(key, serialized);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Long> getLongListFromPrefs(String key) {
        void $this$mapNotNullTo$iv$iv;
        String serialized = this.ctPreference.readString(key, "");
        String[] stringArray = (String[])serialized;
        if (stringArray == null || StringsKt.isBlank((CharSequence)stringArray)) {
            return CollectionsKt.emptyList();
        }
        stringArray = new String[]{","};
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)serialized, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Long it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (StringsKt.toLongOrNull((String)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void onChangeUser(@NotNull String deviceId, @NotNull String accountId) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        String newPrefName = StoreProvider.Companion.getInstance().constructStorePreferenceName(2, deviceId, accountId);
        this.ctPreference.changePreferenceName(newPrefName);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/clevertap/android/sdk/inapp/store/preference/ImpressionStore$Companion;", "", "()V", "PREF_PREFIX", "", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

