/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.db;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.inbox.CTMessageDAO;
import java.io.File;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class DBAdapter {
    public static final int DB_UNDEFINED_CODE = -3;
    private static final String KEY_DATA = "data";
    private static final String KEY_CREATED_AT = "created_at";
    private static final long DATA_EXPIRATION = 432000000L;
    private static final String _ID = "_id";
    private static final String IS_READ = "isRead";
    private static final String EXPIRES = "expires";
    private static final String TAGS = "tags";
    private static final String USER_ID = "messageUser";
    private static final String CAMPAIGN = "campaignId";
    private static final String WZRKPARAMS = "wzrkParams";
    private static final int DB_UPDATE_ERROR = -1;
    private static final int DB_OUT_OF_MEMORY_ERROR = -2;
    private static final String DATABASE_NAME = "clevertap";
    private static final int DATABASE_VERSION = 3;
    private static final String CREATE_EVENTS_TABLE = "CREATE TABLE " + Table.EVENTS.getName() + " (_id INTEGER PRIMARY KEY AUTOINCREMENT, " + "data" + " STRING NOT NULL, " + "created_at" + " INTEGER NOT NULL);";
    private static final String CREATE_PROFILE_EVENTS_TABLE = "CREATE TABLE " + Table.PROFILE_EVENTS.getName() + " (_id INTEGER PRIMARY KEY AUTOINCREMENT, " + "data" + " STRING NOT NULL, " + "created_at" + " INTEGER NOT NULL);";
    private static final String CREATE_USER_PROFILES_TABLE = "CREATE TABLE " + Table.USER_PROFILES.getName() + " (_id STRING UNIQUE PRIMARY KEY, " + "data" + " STRING NOT NULL);";
    private static final String CREATE_INBOX_MESSAGES_TABLE = "CREATE TABLE " + Table.INBOX_MESSAGES.getName() + " (_id STRING NOT NULL, " + "data" + " TEXT NOT NULL, " + "wzrkParams" + " TEXT NOT NULL, " + "campaignId" + " STRING NOT NULL, " + "tags" + " TEXT NOT NULL, " + "isRead" + " INTEGER NOT NULL DEFAULT 0, " + "expires" + " INTEGER NOT NULL, " + "created_at" + " INTEGER NOT NULL, " + "messageUser" + " STRING NOT NULL);";
    private static final String INBOX_MESSAGES_COMP_ID_USERID_INDEX = "CREATE UNIQUE INDEX IF NOT EXISTS userid_id_idx ON " + Table.INBOX_MESSAGES.getName() + " (" + "messageUser" + "," + "_id" + ");";
    private static final String EVENTS_TIME_INDEX = "CREATE INDEX IF NOT EXISTS time_idx ON " + Table.EVENTS.getName() + " (" + "created_at" + ");";
    private static final String PROFILE_EVENTS_TIME_INDEX = "CREATE INDEX IF NOT EXISTS time_idx ON " + Table.PROFILE_EVENTS.getName() + " (" + "created_at" + ");";
    private static final String CREATE_PUSH_NOTIFICATIONS_TABLE = "CREATE TABLE " + Table.PUSH_NOTIFICATIONS.getName() + " (_id INTEGER PRIMARY KEY AUTOINCREMENT, " + "data" + " STRING NOT NULL, " + "created_at" + " INTEGER NOT NULL," + "isRead" + " INTEGER NOT NULL);";
    private static final String PUSH_NOTIFICATIONS_TIME_INDEX = "CREATE INDEX IF NOT EXISTS time_idx ON " + Table.PUSH_NOTIFICATIONS.getName() + " (" + "created_at" + ");";
    private static final String CREATE_UNINSTALL_TS_TABLE = "CREATE TABLE " + Table.UNINSTALL_TS.getName() + " (_id INTEGER PRIMARY KEY AUTOINCREMENT, " + "created_at" + " INTEGER NOT NULL);";
    private static final String UNINSTALL_TS_INDEX = "CREATE INDEX IF NOT EXISTS time_idx ON " + Table.UNINSTALL_TS.getName() + " (" + "created_at" + ");";
    private static final String CREATE_NOTIFICATION_VIEWED_TABLE = "CREATE TABLE " + Table.PUSH_NOTIFICATION_VIEWED.getName() + " (_id INTEGER PRIMARY KEY AUTOINCREMENT, " + "data" + " STRING NOT NULL, " + "created_at" + " INTEGER NOT NULL);";
    private static final String NOTIFICATION_VIEWED_INDEX = "CREATE INDEX IF NOT EXISTS time_idx ON " + Table.PUSH_NOTIFICATION_VIEWED.getName() + " (" + "created_at" + ");";
    private static final String DROP_TABLE_UNINSTALL_TS = "DROP TABLE IF EXISTS " + Table.UNINSTALL_TS.getName();
    private static final String DROP_TABLE_INBOX_MESSAGES = "DROP TABLE IF EXISTS " + Table.INBOX_MESSAGES.getName();
    private static final String DROP_TABLE_PUSH_NOTIFICATION_VIEWED = "DROP TABLE IF EXISTS " + Table.PUSH_NOTIFICATION_VIEWED.getName();
    private CleverTapInstanceConfig config;
    private final DatabaseHelper dbHelper;
    private boolean rtlDirtyFlag = true;

    public DBAdapter(Context context, CleverTapInstanceConfig config) {
        this(context, DBAdapter.getDatabaseName(config));
        this.config = config;
    }

    private DBAdapter(Context context, String dbName) {
        this.dbHelper = new DatabaseHelper(context, dbName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public synchronized boolean deleteMessageForId(String messageId, String userId) {
        if (messageId == null || userId == null) {
            return false;
        }
        String tName = Table.INBOX_MESSAGES.getName();
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            db.delete(tName, "_id = ? AND messageUser = ?", new String[]{messageId, userId});
            boolean bl = true;
            return bl;
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Error removing stale records from " + tName, e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public synchronized boolean deleteMessagesForIDs(ArrayList<String> messageIDs, String userId) {
        if (messageIDs == null || userId == null) {
            return false;
        }
        String tName = Table.INBOX_MESSAGES.getName();
        try {
            StringBuilder questionMarksBuilder = new StringBuilder();
            if (messageIDs.size() > 0) {
                questionMarksBuilder.append("?");
                for (int i = 0; i < messageIDs.size() - 1; ++i) {
                    questionMarksBuilder.append(", ?");
                }
            }
            String[] whereArgs = new String[messageIDs.size() + 1];
            whereArgs = messageIDs.toArray(whereArgs);
            whereArgs[messageIDs.size()] = userId;
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            db.delete(tName, "_id IN ( " + questionMarksBuilder + " ) AND " + USER_ID + " = ?", whereArgs);
            boolean bl = true;
            return bl;
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Error removing stale records from " + tName, e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.dbHelper.close();
        }
    }

    public synchronized boolean doesPushNotificationIdExist(String id2) {
        return id2.equals(this.fetchPushNotificationId(id2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String[] fetchPushNotificationIds() {
        if (!this.rtlDirtyFlag) {
            return new String[0];
        }
        String tName = Table.PUSH_NOTIFICATIONS.getName();
        Cursor cursor = null;
        ArrayList<String> pushIds = new ArrayList<String>();
        try {
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            cursor = db.query(tName, null, "isRead =?", new String[]{"0"}, null, null, null);
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    Logger.v("Fetching PID - " + cursor.getString(cursor.getColumnIndex(KEY_DATA)));
                    pushIds.add(cursor.getString(cursor.getColumnIndex(KEY_DATA)));
                }
                cursor.close();
            }
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Could not fetch records out of database " + tName + ".", e);
        }
        finally {
            this.dbHelper.close();
            if (cursor != null) {
                cursor.close();
            }
        }
        return pushIds.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JSONObject fetchUserProfileById(String id2) {
        if (id2 == null) {
            return null;
        }
        String tName = Table.USER_PROFILES.getName();
        JSONObject profile = null;
        Cursor cursor = null;
        try {
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            cursor = db.query(tName, null, "_id =?", new String[]{id2}, null, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                try {
                    profile = new JSONObject(cursor.getString(cursor.getColumnIndex(KEY_DATA)));
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Could not fetch records out of database " + tName + ".", e);
        }
        finally {
            this.dbHelper.close();
            if (cursor != null) {
                cursor.close();
            }
        }
        return profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getLastUninstallTimestamp() {
        String tName = Table.UNINSTALL_TS.getName();
        Cursor cursor = null;
        long timestamp = 0L;
        try {
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            cursor = db.query(tName, null, null, null, null, null, "created_at DESC", "1");
            if (cursor != null && cursor.moveToFirst()) {
                timestamp = cursor.getLong(cursor.getColumnIndex(KEY_CREATED_AT));
            }
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Could not fetch records out of database " + tName + ".", e);
        }
        finally {
            this.dbHelper.close();
            if (cursor != null) {
                cursor.close();
            }
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public synchronized ArrayList<CTMessageDAO> getMessages(String userId) {
        String tName = Table.INBOX_MESSAGES.getName();
        ArrayList<CTMessageDAO> messageDAOArrayList = new ArrayList<CTMessageDAO>();
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            Cursor cursor = db.query(tName, null, "messageUser =?", new String[]{userId}, null, null, "created_at DESC");
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    CTMessageDAO ctMessageDAO = new CTMessageDAO();
                    ctMessageDAO.setId(cursor.getString(cursor.getColumnIndex(_ID)));
                    ctMessageDAO.setJsonData(new JSONObject(cursor.getString(cursor.getColumnIndex(KEY_DATA))));
                    ctMessageDAO.setWzrkParams(new JSONObject(cursor.getString(cursor.getColumnIndex(WZRKPARAMS))));
                    ctMessageDAO.setDate(cursor.getLong(cursor.getColumnIndex(KEY_CREATED_AT)));
                    ctMessageDAO.setExpires(cursor.getLong(cursor.getColumnIndex(EXPIRES)));
                    ctMessageDAO.setRead(cursor.getInt(cursor.getColumnIndex(IS_READ)));
                    ctMessageDAO.setUserId(cursor.getString(cursor.getColumnIndex(USER_ID)));
                    ctMessageDAO.setTags(cursor.getString(cursor.getColumnIndex(TAGS)));
                    ctMessageDAO.setCampaignId(cursor.getString(cursor.getColumnIndex(CAMPAIGN)));
                    messageDAOArrayList.add(ctMessageDAO);
                }
                cursor.close();
            }
            ArrayList<CTMessageDAO> arrayList = messageDAOArrayList;
            return arrayList;
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Error retrieving records from " + tName, e);
            ArrayList<CTMessageDAO> arrayList = messageDAOArrayList;
            return arrayList;
        }
        catch (JSONException e) {
            this.getConfigLogger().verbose("Error retrieving records from " + tName, e.getMessage());
            ArrayList<CTMessageDAO> arrayList = messageDAOArrayList;
            return arrayList;
        }
        finally {
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public synchronized boolean markReadMessageForId(String messageId, String userId) {
        if (messageId == null || userId == null) {
            return false;
        }
        String tName = Table.INBOX_MESSAGES.getName();
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(IS_READ, Integer.valueOf(1));
            db.update(Table.INBOX_MESSAGES.getName(), cv, "_id = ? AND messageUser = ?", new String[]{messageId, userId});
            boolean bl = true;
            return bl;
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Error removing stale records from " + tName, e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public synchronized boolean markReadMessagesForIds(ArrayList<String> messageIDs, String userId) {
        if (messageIDs == null || userId == null) {
            return false;
        }
        String tName = Table.INBOX_MESSAGES.getName();
        try {
            StringBuilder questionMarksBuilder = new StringBuilder();
            if (messageIDs.size() > 0) {
                questionMarksBuilder.append("?");
                for (int i = 0; i < messageIDs.size() - 1; ++i) {
                    questionMarksBuilder.append(", ?");
                }
            }
            String[] whereArgs = new String[messageIDs.size() + 1];
            whereArgs = messageIDs.toArray(whereArgs);
            whereArgs[messageIDs.size()] = userId;
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(IS_READ, Integer.valueOf(1));
            db.update(Table.INBOX_MESSAGES.getName(), cv, "_id IN ( " + questionMarksBuilder + " ) AND " + USER_ID + " = ?", whereArgs);
            boolean bl = true;
            return bl;
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Error removing stale records from " + tName, e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeUserProfile(String id2) {
        if (id2 == null) {
            return;
        }
        String tableName = Table.USER_PROFILES.getName();
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            db.delete(tableName, "_id = ?", new String[]{id2});
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Error removing user profile from " + tableName + " Recreating DB");
            this.dbHelper.deleteDatabase();
        }
        finally {
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void storeUninstallTimestamp() {
        if (!this.belowMemThreshold()) {
            this.getConfigLogger().verbose("There is not enough space left on the device to store data, data discarded");
            return;
        }
        String tableName = Table.UNINSTALL_TS.getName();
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(KEY_CREATED_AT, Long.valueOf(System.currentTimeMillis()));
            db.insert(tableName, null, cv);
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Error adding data to table " + tableName + " Recreating DB");
            this.dbHelper.deleteDatabase();
        }
        finally {
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public synchronized long storeUserProfile(String id2, JSONObject obj) {
        if (id2 == null) {
            return -1L;
        }
        if (!this.belowMemThreshold()) {
            this.getConfigLogger().verbose("There is not enough space left on the device to store data, data discarded");
            return -2L;
        }
        String tableName = Table.USER_PROFILES.getName();
        long ret = -1L;
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(KEY_DATA, obj.toString());
            cv.put(_ID, id2);
            ret = db.insertWithOnConflict(tableName, null, cv, 5);
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Error adding data to table " + tableName + " Recreating DB");
            this.dbHelper.deleteDatabase();
        }
        finally {
            this.dbHelper.close();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public synchronized void upsertMessages(ArrayList<CTMessageDAO> inboxMessages) {
        if (!this.belowMemThreshold()) {
            Logger.v("There is not enough space left on the device to store data, data discarded");
            return;
        }
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            for (CTMessageDAO messageDAO : inboxMessages) {
                ContentValues cv = new ContentValues();
                cv.put(_ID, messageDAO.getId());
                cv.put(KEY_DATA, messageDAO.getJsonData().toString());
                cv.put(WZRKPARAMS, messageDAO.getWzrkParams().toString());
                cv.put(CAMPAIGN, messageDAO.getCampaignId());
                cv.put(TAGS, messageDAO.getTags());
                cv.put(IS_READ, Integer.valueOf(messageDAO.isRead()));
                cv.put(EXPIRES, Long.valueOf(messageDAO.getExpires()));
                cv.put(KEY_CREATED_AT, Long.valueOf(messageDAO.getDate()));
                cv.put(USER_ID, messageDAO.getUserId());
                db.insertWithOnConflict(Table.INBOX_MESSAGES.getName(), null, cv, 5);
            }
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Error adding data to table " + Table.INBOX_MESSAGES.getName());
        }
        finally {
            this.dbHelper.close();
        }
    }

    synchronized void cleanUpPushNotifications() {
        this.cleanInternal(Table.PUSH_NOTIFICATIONS, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    synchronized void cleanupEventsFromLastId(String lastId, Table table) {
        String tName = table.getName();
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            db.delete(tName, "_id <= " + lastId, null);
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Error removing sent data from table " + tName + " Recreating DB");
            this.deleteDB();
        }
        finally {
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void storePushNotificationId(String id2, long ttl) {
        if (id2 == null) {
            return;
        }
        if (!this.belowMemThreshold()) {
            this.getConfigLogger().verbose("There is not enough space left on the device to store data, data discarded");
            return;
        }
        String tableName = Table.PUSH_NOTIFICATIONS.getName();
        if (ttl <= 0L) {
            ttl = System.currentTimeMillis() + 345600000L;
        }
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(KEY_DATA, id2);
            cv.put(KEY_CREATED_AT, Long.valueOf(ttl));
            cv.put(IS_READ, Integer.valueOf(0));
            db.insert(tableName, null, cv);
            this.rtlDirtyFlag = true;
            Logger.v("Stored PN - " + id2 + " with TTL - " + ttl);
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Error adding data to table " + tableName + " Recreating DB");
            this.dbHelper.deleteDatabase();
        }
        finally {
            this.dbHelper.close();
        }
    }

    synchronized void cleanupStaleEvents(Table table) {
        this.cleanInternal(table, 432000000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized JSONObject fetchEvents(Table table, int limit) {
        String tName = table.getName();
        Cursor cursor = null;
        String lastId = null;
        JSONArray events = new JSONArray();
        try {
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            cursor = db.query(tName, null, null, null, null, null, "created_at ASC", String.valueOf(limit));
            while (cursor.moveToNext()) {
                if (cursor.isLast()) {
                    lastId = cursor.getString(cursor.getColumnIndex(_ID));
                }
                try {
                    JSONObject j = new JSONObject(cursor.getString(cursor.getColumnIndex(KEY_DATA)));
                    events.put((Object)j);
                }
                catch (JSONException jSONException) {}
            }
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Could not fetch records out of database " + tName + ".", e);
            lastId = null;
        }
        finally {
            this.dbHelper.close();
            if (cursor != null) {
                cursor.close();
            }
        }
        if (lastId != null) {
            try {
                JSONObject ret = new JSONObject();
                ret.put(lastId, (Object)events);
                return ret;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public synchronized void updatePushNotificationIds(String[] ids) {
        if (ids.length == 0) {
            return;
        }
        if (!this.belowMemThreshold()) {
            Logger.v("There is not enough space left on the device to store data, data discarded");
            return;
        }
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(IS_READ, Integer.valueOf(1));
            StringBuilder questionMarksBuilder = new StringBuilder();
            questionMarksBuilder.append("?");
            for (int i = 0; i < ids.length - 1; ++i) {
                questionMarksBuilder.append(", ?");
            }
            db.update(Table.PUSH_NOTIFICATIONS.getName(), cv, "data IN ( " + questionMarksBuilder.toString() + " )", ids);
            this.rtlDirtyFlag = false;
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Error adding data to table " + Table.PUSH_NOTIFICATIONS.getName() + " Recreating DB");
            this.dbHelper.deleteDatabase();
        }
        finally {
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    synchronized int storeObject(JSONObject obj, Table table) {
        if (!this.belowMemThreshold()) {
            Logger.v("There is not enough space left on the device to store data, data discarded");
            return -2;
        }
        String tableName = table.getName();
        long count = -1L;
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(KEY_DATA, obj.toString());
            cv.put(KEY_CREATED_AT, Long.valueOf(System.currentTimeMillis()));
            db.insert(tableName, null, cv);
            String sql = "SELECT COUNT(*) FROM " + tableName;
            SQLiteStatement statement = db.compileStatement(sql);
            count = statement.simpleQueryForLong();
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Error adding data to table " + tableName + " Recreating DB");
            this.dbHelper.deleteDatabase();
        }
        finally {
            this.dbHelper.close();
        }
        return (int)count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void removeEvents(Table table) {
        String tName = table.getName();
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            db.delete(tName, null, null);
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Error removing all events from table " + tName + " Recreating DB");
            this.deleteDB();
        }
        finally {
            this.dbHelper.close();
        }
    }

    @WorkerThread
    private boolean belowMemThreshold() {
        return this.dbHelper.belowMemThreshold();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanInternal(Table table, long expiration) {
        long time = (System.currentTimeMillis() - expiration) / 1000L;
        String tName = table.getName();
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            db.delete(tName, "created_at <= " + time, null);
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Error removing stale event records from " + tName + ". Recreating DB.", e);
            this.deleteDB();
        }
        finally {
            this.dbHelper.close();
        }
    }

    private void deleteDB() {
        this.dbHelper.deleteDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String fetchPushNotificationId(String id2) {
        String tName = Table.PUSH_NOTIFICATIONS.getName();
        Cursor cursor = null;
        String pushId = "";
        try {
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            cursor = db.query(tName, null, "data =?", new String[]{id2}, null, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                pushId = cursor.getString(cursor.getColumnIndex(KEY_DATA));
            }
            Logger.v("Fetching PID for check - " + pushId);
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Could not fetch records out of database " + tName + ".", e);
        }
        finally {
            this.dbHelper.close();
            if (cursor != null) {
                cursor.close();
            }
        }
        return pushId;
    }

    private Logger getConfigLogger() {
        return this.config.getLogger();
    }

    private static String getDatabaseName(CleverTapInstanceConfig config) {
        return config.isDefaultInstance() ? DATABASE_NAME : "clevertap_" + config.getAccountId();
    }

    public static enum Table {
        EVENTS("events"),
        PROFILE_EVENTS("profileEvents"),
        USER_PROFILES("userProfiles"),
        INBOX_MESSAGES("inboxMessages"),
        PUSH_NOTIFICATIONS("pushNotifications"),
        UNINSTALL_TS("uninstallTimestamp"),
        PUSH_NOTIFICATION_VIEWED("notificationViewed");

        private final String tableName;

        private Table(String name) {
            this.tableName = name;
        }

        public String getName() {
            return this.tableName;
        }
    }

    private static class DatabaseHelper
    extends SQLiteOpenHelper {
        private final int DB_LIMIT = 0x1400000;
        private final File databaseFile;

        DatabaseHelper(Context context, String dbName) {
            super(context, dbName, null, 3);
            this.databaseFile = context.getDatabasePath(dbName);
        }

        @SuppressLint(value={"SQLiteString"})
        public void onCreate(SQLiteDatabase db) {
            Logger.v("Creating CleverTap DB");
            SQLiteStatement sqLiteStatement = db.compileStatement(CREATE_EVENTS_TABLE);
            Logger.v("Executing - " + CREATE_EVENTS_TABLE);
            sqLiteStatement.execute();
            sqLiteStatement = db.compileStatement(CREATE_PROFILE_EVENTS_TABLE);
            Logger.v("Executing - " + CREATE_PROFILE_EVENTS_TABLE);
            sqLiteStatement.execute();
            sqLiteStatement = db.compileStatement(CREATE_USER_PROFILES_TABLE);
            Logger.v("Executing - " + CREATE_USER_PROFILES_TABLE);
            sqLiteStatement.execute();
            sqLiteStatement = db.compileStatement(CREATE_INBOX_MESSAGES_TABLE);
            Logger.v("Executing - " + CREATE_INBOX_MESSAGES_TABLE);
            sqLiteStatement.execute();
            sqLiteStatement = db.compileStatement(CREATE_PUSH_NOTIFICATIONS_TABLE);
            Logger.v("Executing - " + CREATE_PUSH_NOTIFICATIONS_TABLE);
            sqLiteStatement.execute();
            sqLiteStatement = db.compileStatement(CREATE_UNINSTALL_TS_TABLE);
            Logger.v("Executing - " + CREATE_UNINSTALL_TS_TABLE);
            sqLiteStatement.execute();
            sqLiteStatement = db.compileStatement(CREATE_NOTIFICATION_VIEWED_TABLE);
            Logger.v("Executing - " + CREATE_NOTIFICATION_VIEWED_TABLE);
            sqLiteStatement.execute();
            sqLiteStatement = db.compileStatement(EVENTS_TIME_INDEX);
            Logger.v("Executing - " + EVENTS_TIME_INDEX);
            sqLiteStatement.execute();
            sqLiteStatement = db.compileStatement(PROFILE_EVENTS_TIME_INDEX);
            Logger.v("Executing - " + PROFILE_EVENTS_TIME_INDEX);
            sqLiteStatement.execute();
            sqLiteStatement = db.compileStatement(UNINSTALL_TS_INDEX);
            Logger.v("Executing - " + UNINSTALL_TS_INDEX);
            sqLiteStatement.execute();
            sqLiteStatement = db.compileStatement(PUSH_NOTIFICATIONS_TIME_INDEX);
            Logger.v("Executing - " + PUSH_NOTIFICATIONS_TIME_INDEX);
            sqLiteStatement.execute();
            sqLiteStatement = db.compileStatement(INBOX_MESSAGES_COMP_ID_USERID_INDEX);
            Logger.v("Executing - " + INBOX_MESSAGES_COMP_ID_USERID_INDEX);
            sqLiteStatement.execute();
            sqLiteStatement = db.compileStatement(NOTIFICATION_VIEWED_INDEX);
            Logger.v("Executing - " + NOTIFICATION_VIEWED_INDEX);
            sqLiteStatement.execute();
        }

        @SuppressLint(value={"SQLiteString"})
        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            Logger.v("Upgrading CleverTap DB to version " + newVersion);
            switch (oldVersion) {
                case 1: {
                    SQLiteStatement sqLiteStatement = db.compileStatement(DROP_TABLE_UNINSTALL_TS);
                    Logger.v("Executing - " + DROP_TABLE_UNINSTALL_TS);
                    sqLiteStatement.execute();
                    sqLiteStatement = db.compileStatement(DROP_TABLE_INBOX_MESSAGES);
                    Logger.v("Executing - " + DROP_TABLE_INBOX_MESSAGES);
                    sqLiteStatement.execute();
                    sqLiteStatement = db.compileStatement(DROP_TABLE_PUSH_NOTIFICATION_VIEWED);
                    Logger.v("Executing - " + DROP_TABLE_PUSH_NOTIFICATION_VIEWED);
                    sqLiteStatement.execute();
                    sqLiteStatement = db.compileStatement(CREATE_INBOX_MESSAGES_TABLE);
                    Logger.v("Executing - " + CREATE_INBOX_MESSAGES_TABLE);
                    sqLiteStatement.execute();
                    sqLiteStatement = db.compileStatement(CREATE_PUSH_NOTIFICATIONS_TABLE);
                    Logger.v("Executing - " + CREATE_PUSH_NOTIFICATIONS_TABLE);
                    sqLiteStatement.execute();
                    sqLiteStatement = db.compileStatement(CREATE_UNINSTALL_TS_TABLE);
                    Logger.v("Executing - " + CREATE_UNINSTALL_TS_TABLE);
                    sqLiteStatement.execute();
                    sqLiteStatement = db.compileStatement(CREATE_NOTIFICATION_VIEWED_TABLE);
                    Logger.v("Executing - " + CREATE_NOTIFICATION_VIEWED_TABLE);
                    sqLiteStatement.execute();
                    sqLiteStatement = db.compileStatement(UNINSTALL_TS_INDEX);
                    Logger.v("Executing - " + UNINSTALL_TS_INDEX);
                    sqLiteStatement.execute();
                    sqLiteStatement = db.compileStatement(PUSH_NOTIFICATIONS_TIME_INDEX);
                    Logger.v("Executing - " + PUSH_NOTIFICATIONS_TIME_INDEX);
                    sqLiteStatement.execute();
                    sqLiteStatement = db.compileStatement(INBOX_MESSAGES_COMP_ID_USERID_INDEX);
                    Logger.v("Executing - " + INBOX_MESSAGES_COMP_ID_USERID_INDEX);
                    sqLiteStatement.execute();
                    sqLiteStatement = db.compileStatement(NOTIFICATION_VIEWED_INDEX);
                    Logger.v("Executing - " + NOTIFICATION_VIEWED_INDEX);
                    sqLiteStatement.execute();
                    break;
                }
                case 2: {
                    SQLiteStatement sqLiteStatement = db.compileStatement(DROP_TABLE_PUSH_NOTIFICATION_VIEWED);
                    Logger.v("Executing - " + DROP_TABLE_PUSH_NOTIFICATION_VIEWED);
                    sqLiteStatement.execute();
                    sqLiteStatement = db.compileStatement(CREATE_NOTIFICATION_VIEWED_TABLE);
                    Logger.v("Executing - " + CREATE_NOTIFICATION_VIEWED_TABLE);
                    sqLiteStatement.execute();
                    sqLiteStatement = db.compileStatement(NOTIFICATION_VIEWED_INDEX);
                    Logger.v("Executing - " + NOTIFICATION_VIEWED_INDEX);
                    sqLiteStatement.execute();
                }
            }
        }

        @SuppressLint(value={"UsableSpace"})
        boolean belowMemThreshold() {
            if (this.databaseFile.exists()) {
                return Math.max(this.databaseFile.getUsableSpace(), 0x1400000L) >= this.databaseFile.length();
            }
            return true;
        }

        void deleteDatabase() {
            this.close();
            this.databaseFile.delete();
        }
    }
}

