/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.cryption;

import android.content.Context;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Constants;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.cryption.CryptHandler;
import com.clevertap.android.sdk.db.DBAdapter;
import com.clevertap.android.sdk.utils.CTJsonConverter;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J(\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J8\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010\u0013\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J(\u0010\u0014\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\u0016"}, d2={"Lcom/clevertap/android/sdk/cryption/CryptUtils;", "", "()V", "migrateCachedGuidsKeyPref", "", "encrypt", "", "config", "Lcom/clevertap/android/sdk/CleverTapInstanceConfig;", "context", "Landroid/content/Context;", "cryptHandler", "Lcom/clevertap/android/sdk/cryption/CryptHandler;", "migrateDBProfile", "dbAdapter", "Lcom/clevertap/android/sdk/db/DBAdapter;", "migrateEncryption", "", "encryptionFlagStatus", "migrateEncryptionLevel", "updateEncryptionFlagOnFailure", "failedFlag", "clevertap-core_release"})
public final class CryptUtils {
    @NotNull
    public static final CryptUtils INSTANCE = new CryptUtils();

    private CryptUtils() {
    }

    @JvmStatic
    public static final void migrateEncryptionLevel(@NotNull Context context, @NotNull CleverTapInstanceConfig config, @NotNull CryptHandler cryptHandler, @NotNull DBAdapter dbAdapter) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)cryptHandler, (String)"cryptHandler");
        Intrinsics.checkNotNullParameter((Object)dbAdapter, (String)"dbAdapter");
        int encryptionFlagStatus = 0;
        int configEncryptionLevel = config.getEncryptionLevel();
        int storedEncryptionLevel = StorageHelper.getInt(context, StorageHelper.storageKeyWithSuffix(config, "encryptionLevel"), -1);
        if (storedEncryptionLevel == -1 && configEncryptionLevel == 0) {
            return;
        }
        encryptionFlagStatus = storedEncryptionLevel != configEncryptionLevel ? 0 : StorageHelper.getInt(context, StorageHelper.storageKeyWithSuffix(config, "encryptionFlagStatus"), 0);
        StorageHelper.putInt(context, StorageHelper.storageKeyWithSuffix(config, "encryptionLevel"), configEncryptionLevel);
        if (encryptionFlagStatus == 3) {
            config.getLogger().verbose(config.getAccountId(), "Encryption flag status is 100% success, no need to migrate");
            cryptHandler.setEncryptionFlagStatus(3);
            return;
        }
        config.getLogger().verbose(config.getAccountId(), "Migrating encryption level from " + storedEncryptionLevel + " to " + configEncryptionLevel + " with current flag status " + encryptionFlagStatus);
        INSTANCE.migrateEncryption(configEncryptionLevel == 1, context, config, cryptHandler, encryptionFlagStatus, dbAdapter);
    }

    private final void migrateEncryption(boolean encrypt, Context context, CleverTapInstanceConfig config, CryptHandler cryptHandler, int encryptionFlagStatus, DBAdapter dbAdapter) {
        int dbFlag;
        int cgkFlag = encryptionFlagStatus & 1;
        if (cgkFlag == 0) {
            cgkFlag = this.migrateCachedGuidsKeyPref(encrypt, config, context, cryptHandler);
        }
        if ((dbFlag = encryptionFlagStatus & 2) == 0) {
            dbFlag = this.migrateDBProfile(encrypt, config, cryptHandler, dbAdapter);
        }
        int updatedFlagStatus = cgkFlag | dbFlag;
        config.getLogger().verbose(config.getAccountId(), "Updating encryption flag status to " + updatedFlagStatus);
        StorageHelper.putInt(context, StorageHelper.storageKeyWithSuffix(config, "encryptionFlagStatus"), updatedFlagStatus);
        cryptHandler.setEncryptionFlagStatus(updatedFlagStatus);
    }

    private final int migrateCachedGuidsKeyPref(boolean encrypt, CleverTapInstanceConfig config, Context context, CryptHandler cryptHandler) {
        config.getLogger().verbose(config.getAccountId(), "Migrating encryption level for cachedGUIDsKey prefs");
        String json = StorageHelper.getStringFromPrefs(context, config, "cachedGUIDsKey", null);
        JSONObject cachedGuidJsonObj = CTJsonConverter.toJsonObject(json, config.getLogger(), config.getAccountId());
        JSONObject newGuidJsonObj = new JSONObject();
        int migrationStatus = 1;
        try {
            Iterator i = cachedGuidJsonObj.keys();
            while (i.hasNext()) {
                String crypted;
                String nextJSONObjKey = (String)i.next();
                Intrinsics.checkNotNullExpressionValue((Object)nextJSONObjKey, (String)"nextJSONObjKey");
                String key = StringsKt.substringBefore$default((String)nextJSONObjKey, (String)"_", null, (int)2, null);
                String identifier = StringsKt.substringAfter$default((String)nextJSONObjKey, (String)"_", null, (int)2, null);
                String string2 = crypted = encrypt ? cryptHandler.encrypt(identifier, key) : cryptHandler.decrypt(identifier, "encryptionmigration");
                if (crypted == null) {
                    config.getLogger().verbose(config.getAccountId(), "Error migrating " + identifier + " in Cached Guid Key Pref");
                    crypted = identifier;
                    migrationStatus = 0;
                }
                String cryptedKey = key + '_' + crypted;
                newGuidJsonObj.put(cryptedKey, cachedGuidJsonObj.get(nextJSONObjKey));
            }
            if (cachedGuidJsonObj.length() > 0) {
                String string3 = newGuidJsonObj.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"newGuidJsonObj.toString()");
                String cachedGuid = string3;
                StorageHelper.putString(context, StorageHelper.storageKeyWithSuffix(config, "cachedGUIDsKey"), cachedGuid);
                config.getLogger().verbose(config.getAccountId(), "setCachedGUIDs after migration:[" + cachedGuid + ']');
            }
        }
        catch (Throwable t) {
            config.getLogger().verbose(config.getAccountId(), "Error migrating cached guids: " + t);
            migrationStatus = 0;
        }
        return migrationStatus;
    }

    private final int migrateDBProfile(boolean encrypt, CleverTapInstanceConfig config, CryptHandler cryptHandler, DBAdapter dbAdapter) {
        config.getLogger().verbose(config.getAccountId(), "Migrating encryption level for user profile in DB");
        int migrationStatus = 2;
        JSONObject jSONObject = dbAdapter.fetchUserProfileById(config.getAccountId());
        if (jSONObject == null) {
            return 2;
        }
        JSONObject profile = jSONObject;
        try {
            for (String piiKey : Constants.piiDBKeys) {
                String crypted;
                String string2;
                Object value;
                if (!profile.has(piiKey) || !((value = profile.get(piiKey)) instanceof String)) continue;
                if (encrypt) {
                    String string3 = (String)value;
                    Intrinsics.checkNotNullExpressionValue((Object)piiKey, (String)"piiKey");
                    string2 = cryptHandler.encrypt(string3, piiKey);
                } else {
                    string2 = crypted = cryptHandler.decrypt((String)value, "encryptionmigration");
                }
                if (crypted == null) {
                    config.getLogger().verbose(config.getAccountId(), "Error migrating " + piiKey + " entry in db profile");
                    crypted = (String)value;
                    migrationStatus = 0;
                }
                profile.put(piiKey, (Object)crypted);
            }
            if (dbAdapter.storeUserProfile(config.getAccountId(), profile) <= -1L) {
                migrationStatus = 0;
            }
        }
        catch (Exception e) {
            config.getLogger().verbose(config.getAccountId(), "Error migrating local DB profile: " + e);
            migrationStatus = 0;
        }
        return migrationStatus;
    }

    @JvmStatic
    public static final void updateEncryptionFlagOnFailure(@NotNull Context context, @NotNull CleverTapInstanceConfig config, int failedFlag, @NotNull CryptHandler cryptHandler) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)cryptHandler, (String)"cryptHandler");
        int updatedEncryptionFlag = (failedFlag ^ cryptHandler.getEncryptionFlagStatus()) & cryptHandler.getEncryptionFlagStatus();
        config.getLogger().verbose(config.getAccountId(), "Updating encryption flag status after error in " + failedFlag + " to " + updatedEncryptionFlag);
        StorageHelper.putInt(context, StorageHelper.storageKeyWithSuffix(config, "encryptionFlagStatus"), updatedEncryptionFlag);
        cryptHandler.setEncryptionFlagStatus(updatedEncryptionFlag);
    }
}

