/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Base64;
import android.util.LruCache;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ImageCache {
    private static final int MIN_CACHE_SIZE = 20480;
    private static final int maxMemory = (int)Runtime.getRuntime().maxMemory() / 1024;
    private static final int cacheSize = Math.max(maxMemory / 32, 20480);
    private static final int MAX_BITMAP_SIZE = 10000000;
    private static final String DIRECTORY_NAME = "CleverTap.Images.";
    private static final String FILE_PREFIX = "CT_IMAGE_";
    private static LruCache<String, Bitmap> memoryCache;
    private static File imageFileDirectory;
    private static MessageDigest messageDigest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean addBitmap(String key, Bitmap bitmap) {
        if (memoryCache == null) {
            return false;
        }
        if (ImageCache.getBitmapFromMemCache(key) != null) return true;
        Class<ImageCache> clazz = ImageCache.class;
        synchronized (ImageCache.class) {
            int imageSize = ImageCache.getImageSizeInKB(bitmap);
            int available = ImageCache.getAvailableMemory();
            Logger.v("CleverTap.ImageCache: image size: " + imageSize + "KB. Available mem: " + available + "KB.");
            if (imageSize > ImageCache.getAvailableMemory()) {
                Logger.v("CleverTap.ImageCache: insufficient memory to add image: " + key);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            memoryCache.put((Object)key, (Object)bitmap);
            Logger.v("CleverTap.ImageCache: added image for key: " + key);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap getBitmap(String key) {
        Class<ImageCache> clazz = ImageCache.class;
        synchronized (ImageCache.class) {
            if (key != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return memoryCache == null ? null : (Bitmap)memoryCache.get((Object)key);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    public static Bitmap getOrFetchBitmap(String url) {
        Bitmap bitmap = ImageCache.getBitmap(url);
        if (bitmap == null) {
            File imageFile = ImageCache.getOrFetchAndWriteImageFile(url);
            if (imageFile != null) {
                bitmap = ImageCache.decodeImageFromFile(imageFile);
                ImageCache.addBitmap(url, bitmap);
            } else {
                return null;
            }
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        Class<ImageCache> clazz = ImageCache.class;
        synchronized (ImageCache.class) {
            if (memoryCache == null) {
                Logger.v("CleverTap.ImageCache: init with max device memory: " + maxMemory + "KB and allocated cache size: " + cacheSize + "KB");
                try {
                    memoryCache = new LruCache<String, Bitmap>(cacheSize){

                        protected int sizeOf(String key, Bitmap bitmap) {
                            int size = ImageCache.getImageSizeInKB(bitmap);
                            Logger.v("CleverTap.ImageCache: have image of size: " + size + "KB for key: " + key);
                            return size;
                        }
                    };
                }
                catch (Throwable t) {
                    Logger.v("CleverTap.ImageCache: unable to initialize cache: ", t.getCause());
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initWithPersistence(Context context) {
        Class<ImageCache> clazz = ImageCache.class;
        synchronized (ImageCache.class) {
            if (imageFileDirectory == null) {
                imageFileDirectory = context.getDir(DIRECTORY_NAME, 0);
            }
            if (messageDigest == null) {
                try {
                    messageDigest = MessageDigest.getInstance("SHA256");
                }
                catch (NoSuchAlgorithmException e) {
                    Logger.d("CleverTap.ImageCache: image file system caching unavailable as SHA1 hash function not available on platform");
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            ImageCache.init();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeBitmap(String key, boolean isPersisted) {
        Class<ImageCache> clazz = ImageCache.class;
        synchronized (ImageCache.class) {
            if (isPersisted) {
                ImageCache.removeFromFileSystem(key);
            }
            if (memoryCache == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            memoryCache.remove((Object)key);
            Logger.v("CleverTap.ImageCache: removed image for key: " + key);
            ImageCache.cleanup();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanup() {
        Class<ImageCache> clazz = ImageCache.class;
        synchronized (ImageCache.class) {
            if (ImageCache.isEmpty()) {
                Logger.v("CTInAppNotification.ImageCache: cache is empty, removing it");
                memoryCache = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static Bitmap decodeImageFromFile(File file) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = false;
        BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)options);
        float imageSize = (float)options.outHeight * (float)options.outWidth * 4.0f;
        float imageSizeKb = imageSize / 1024.0f;
        if (imageSizeKb > (float)ImageCache.getAvailableMemory()) {
            Logger.v("CleverTap.ImageCache: image too large to decode");
            return null;
        }
        Bitmap bitmap = BitmapFactory.decodeFile((String)file.getAbsolutePath());
        if (bitmap == null) {
            file.delete();
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getAvailableMemory() {
        Class<ImageCache> clazz = ImageCache.class;
        synchronized (ImageCache.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return memoryCache == null ? 0 : cacheSize - memoryCache.size();
        }
    }

    private static Bitmap getBitmapFromMemCache(String key) {
        if (key != null) {
            return memoryCache == null ? null : (Bitmap)memoryCache.get((Object)key);
        }
        return null;
    }

    private static File getFile(String url) {
        if (messageDigest == null) {
            return null;
        }
        byte[] hashed = messageDigest.digest(url.getBytes());
        String safeName = FILE_PREFIX + Base64.encodeToString((byte[])hashed, (int)10);
        return new File(imageFileDirectory, safeName);
    }

    private static int getImageSizeInKB(Bitmap bitmap) {
        return bitmap.getByteCount() / 1024;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getOrFetchAndWriteImageFile(String url) {
        byte[] bytes;
        File file = ImageCache.getFile(url);
        if (!(file != null && file.exists() || (bytes = Utils.getByteArrayFromImageURL(url)) == null || file == null || bytes.length >= 10000000)) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(file);
                ((OutputStream)out).write(bytes);
            }
            catch (FileNotFoundException e) {
                Logger.v("CleverTap.ImageCache: error writing image file", e);
                File file2 = null;
                return file2;
            }
            catch (IOException e) {
                Logger.v("CleverTap.ImageCache: error writing image file", e);
                File file3 = null;
                return file3;
            }
            finally {
                if (out != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException e) {
                        Logger.v("CleverTap.ImageCache: error closing image output file", e);
                    }
                }
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isEmpty() {
        Class<ImageCache> clazz = ImageCache.class;
        synchronized (ImageCache.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return memoryCache.size() <= 0;
        }
    }

    private static void removeFromFileSystem(String url) {
        File file = ImageCache.getFile(url);
        if (file != null && file.exists()) {
            file.delete();
        }
    }
}

