/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import androidx.annotation.RequiresApi;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.clevertap.android.sdk.CTPreferenceCache;
import com.clevertap.android.sdk.CTXtensions;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.InAppNotificationActivity;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.inapp.AlertDialogPromptForSettings;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;

public class PushPermissionManager {
    private final CleverTapInstanceConfig config;
    private boolean isFallbackSettingsEnabled;
    public static final String ANDROID_PERMISSION_STRING = "android.permission.POST_NOTIFICATIONS";
    private final Activity activity;
    private boolean isFromNotificationSettingsActivity;

    public PushPermissionManager(Activity activity, CleverTapInstanceConfig config) {
        this.activity = activity;
        this.config = config;
        this.isFromNotificationSettingsActivity = false;
    }

    public boolean isFromNotificationSettingsActivity() {
        return this.isFromNotificationSettingsActivity;
    }

    @SuppressLint(value={"NewApi"})
    public void showHardPermissionPrompt(boolean isFallbackSettingsEnabled, InAppNotificationActivity.PushPermissionResultCallback pushPermissionResultCallback) {
        if (CTXtensions.isPackageAndOsTargetsAbove((Context)this.activity, 32)) {
            this.isFallbackSettingsEnabled = isFallbackSettingsEnabled;
            this.requestPermission(pushPermissionResultCallback);
        }
    }

    @RequiresApi(api=33)
    public void requestPermission(InAppNotificationActivity.PushPermissionResultCallback pushPermissionResultCallback) {
        int permissionStatus = ContextCompat.checkSelfPermission((Context)this.activity, (String)ANDROID_PERMISSION_STRING);
        if (permissionStatus == -1) {
            boolean isFirstTimeRequest = CTPreferenceCache.getInstance((Context)this.activity, this.config).isFirstTimeRequest();
            Activity currentActivity = CoreMetaData.getCurrentActivity();
            if (currentActivity == null) {
                Logger.d("CurrentActivity reference is null. SDK can't prompt the user with Notification Permission! Ensure the following things:\n1. Calling ActivityLifecycleCallback.register(this) in your custom application class before super.onCreate().\n   Alternatively, register CleverTap SDK's Application class in the manifest using com.clevertap.android.sdk.Application.\n2. Ensure that the promptPushPrimer() API is called from the onResume() lifecycle method, not onCreate().");
                return;
            }
            boolean shouldShowRequestPermissionRationale = ActivityCompat.shouldShowRequestPermissionRationale((Activity)currentActivity, (String)ANDROID_PERMISSION_STRING);
            if (!isFirstTimeRequest && shouldShowRequestPermissionRationale && this.shouldShowFallbackAlertDialog()) {
                this.showFallbackAlertDialog();
                return;
            }
            ActivityCompat.requestPermissions((Activity)this.activity, (String[])new String[]{ANDROID_PERMISSION_STRING}, (int)102);
        } else {
            pushPermissionResultCallback.onPushPermissionAccept();
            if (this.activity instanceof InAppNotificationActivity) {
                ((InAppNotificationActivity)this.activity).didDismiss(null);
            }
        }
    }

    private boolean shouldShowFallbackAlertDialog() {
        return this.isFallbackSettingsEnabled;
    }

    public void showFallbackAlertDialog() {
        AlertDialogPromptForSettings.show(this.activity, (Function0<Unit>)((Function0)() -> {
            Utils.navigateToAndroidSettingsForNotifications((Context)this.activity);
            this.isFromNotificationSettingsActivity = true;
            return Unit.INSTANCE;
        }), (Function0<Unit>)((Function0)() -> {
            if (this.activity instanceof InAppNotificationActivity) {
                ((InAppNotificationActivity)this.activity).didDismiss(null);
            }
            return Unit.INSTANCE;
        }));
    }
}

