/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import androidx.annotation.AnyThread;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.BaseCallbackManager;
import com.clevertap.android.sdk.CTLockManager;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.InAppFCManager;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.db.BaseDatabaseManager;
import com.clevertap.android.sdk.displayunits.CTDisplayUnitController;
import com.clevertap.android.sdk.featureFlags.CTFeatureFlagsController;
import com.clevertap.android.sdk.inapp.InAppController;
import com.clevertap.android.sdk.inbox.CTInboxController;
import com.clevertap.android.sdk.product_config.CTProductConfigController;
import com.clevertap.android.sdk.pushnotification.PushProviders;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.Task;
import com.clevertap.android.sdk.variables.CTVariables;
import com.clevertap.android.sdk.variables.callbacks.FetchVariablesCallback;
import java.util.concurrent.Callable;

public class ControllerManager {
    private InAppFCManager inAppFCManager;
    private final BaseDatabaseManager baseDatabaseManager;
    private CTDisplayUnitController ctDisplayUnitController;
    @Deprecated
    private CTFeatureFlagsController ctFeatureFlagsController;
    private CTInboxController ctInboxController;
    private final CTLockManager ctLockManager;
    @Deprecated
    private CTProductConfigController ctProductConfigController;
    private final BaseCallbackManager callbackManager;
    private final CleverTapInstanceConfig config;
    private final Context context;
    private final DeviceInfo deviceInfo;
    private InAppController inAppController;
    private PushProviders pushProviders;
    private CTVariables ctVariables;

    public ControllerManager(Context context, CleverTapInstanceConfig config, CTLockManager ctLockManager, BaseCallbackManager callbackManager, DeviceInfo deviceInfo, BaseDatabaseManager databaseManager) {
        this.config = config;
        this.ctLockManager = ctLockManager;
        this.callbackManager = callbackManager;
        this.deviceInfo = deviceInfo;
        this.context = context;
        this.baseDatabaseManager = databaseManager;
    }

    public CTDisplayUnitController getCTDisplayUnitController() {
        return this.ctDisplayUnitController;
    }

    public void setCTDisplayUnitController(CTDisplayUnitController CTDisplayUnitController2) {
        this.ctDisplayUnitController = CTDisplayUnitController2;
    }

    @Deprecated
    public CTFeatureFlagsController getCTFeatureFlagsController() {
        return this.ctFeatureFlagsController;
    }

    @Deprecated
    public void setCTFeatureFlagsController(CTFeatureFlagsController CTFeatureFlagsController2) {
        this.ctFeatureFlagsController = CTFeatureFlagsController2;
    }

    public CTInboxController getCTInboxController() {
        return this.ctInboxController;
    }

    public void setCTInboxController(CTInboxController CTInboxController2) {
        this.ctInboxController = CTInboxController2;
    }

    @Deprecated
    public CTProductConfigController getCTProductConfigController() {
        return this.ctProductConfigController;
    }

    @Deprecated
    public void setCTProductConfigController(CTProductConfigController CTProductConfigController2) {
        this.ctProductConfigController = CTProductConfigController2;
    }

    public CTVariables getCtVariables() {
        return this.ctVariables;
    }

    public void setCtVariables(CTVariables ctVariables) {
        this.ctVariables = ctVariables;
    }

    public CleverTapInstanceConfig getConfig() {
        return this.config;
    }

    public InAppController getInAppController() {
        return this.inAppController;
    }

    public void setInAppController(InAppController inAppController) {
        this.inAppController = inAppController;
    }

    public InAppFCManager getInAppFCManager() {
        return this.inAppFCManager;
    }

    public void setInAppFCManager(InAppFCManager inAppFCManager) {
        this.inAppFCManager = inAppFCManager;
    }

    public PushProviders getPushProviders() {
        return this.pushProviders;
    }

    public void setPushProviders(PushProviders pushProviders) {
        this.pushProviders = pushProviders;
    }

    @AnyThread
    public void initializeInbox() {
        if (this.config.isAnalyticsOnly()) {
            this.config.getLogger().debug(this.config.getAccountId(), "Instance is analytics only, not initializing Notification Inbox");
            return;
        }
        Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
        task.execute("initializeInbox", new Callable<Void>(){

            @Override
            public Void call() {
                ControllerManager.this._initializeInbox();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void _initializeInbox() {
        Object object = this.ctLockManager.getInboxControllerLock();
        synchronized (object) {
            if (this.getCTInboxController() != null) {
                this.callbackManager._notifyInboxInitialized();
                return;
            }
            if (this.deviceInfo.getDeviceID() != null) {
                this.setCTInboxController(new CTInboxController(this.config, this.deviceInfo.getDeviceID(), this.baseDatabaseManager.loadDBAdapter(this.context), this.ctLockManager, this.callbackManager, Utils.haveVideoPlayerSupport));
                this.callbackManager._notifyInboxInitialized();
            } else {
                this.config.getLogger().info("CRITICAL : No device ID found!");
            }
        }
    }

    public void invokeCallbacksForNetworkError() {
        if (this.ctVariables != null) {
            FetchVariablesCallback fetchCallback = this.callbackManager.getFetchVariablesCallback();
            this.callbackManager.setFetchVariablesCallback(null);
            this.ctVariables.handleVariableResponseError(fetchCallback);
        }
    }
}

