/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.RemoteException;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.android.installreferrer.api.ReferrerDetails;
import com.clevertap.android.sdk.AnalyticsManager;
import com.clevertap.android.sdk.BaseCallbackManager;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.SessionManager;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.events.BaseEventQueueManager;
import com.clevertap.android.sdk.inapp.InAppController;
import com.clevertap.android.sdk.pushnotification.PushProviders;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.Task;
import java.util.concurrent.Callable;

class ActivityLifeCycleManager {
    private final AnalyticsManager analyticsManager;
    private final BaseEventQueueManager baseEventQueueManager;
    private final BaseCallbackManager callbackManager;
    private final CleverTapInstanceConfig config;
    private final Context context;
    private final CoreMetaData coreMetaData;
    private final InAppController inAppController;
    private final PushProviders pushProviders;
    private final SessionManager sessionManager;

    ActivityLifeCycleManager(Context context, CleverTapInstanceConfig config, AnalyticsManager analyticsManager, CoreMetaData coreMetaData, SessionManager sessionManager, PushProviders pushProviders, BaseCallbackManager callbackManager, InAppController inAppController, BaseEventQueueManager baseEventQueueManager) {
        this.context = context;
        this.config = config;
        this.analyticsManager = analyticsManager;
        this.coreMetaData = coreMetaData;
        this.sessionManager = sessionManager;
        this.pushProviders = pushProviders;
        this.callbackManager = callbackManager;
        this.inAppController = inAppController;
        this.baseEventQueueManager = baseEventQueueManager;
    }

    public void activityPaused() {
        CoreMetaData.setAppForeground(false);
        this.sessionManager.setAppLastSeen(System.currentTimeMillis());
        this.config.getLogger().verbose(this.config.getAccountId(), "App in background");
        Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
        task.execute("activityPaused", new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                int now = (int)(System.currentTimeMillis() / 1000L);
                if (ActivityLifeCycleManager.this.coreMetaData.inCurrentSession()) {
                    try {
                        StorageHelper.putInt(ActivityLifeCycleManager.this.context, StorageHelper.storageKeyWithSuffix(ActivityLifeCycleManager.this.config, "sexe"), now);
                        ActivityLifeCycleManager.this.config.getLogger().verbose(ActivityLifeCycleManager.this.config.getAccountId(), "Updated session time: " + now);
                    }
                    catch (Throwable t) {
                        ActivityLifeCycleManager.this.config.getLogger().verbose(ActivityLifeCycleManager.this.config.getAccountId(), "Failed to update session time time: " + t.getMessage());
                    }
                }
                return null;
            }
        });
    }

    public void activityResumed(Activity activity) {
        this.config.getLogger().verbose(this.config.getAccountId(), "App in foreground");
        this.sessionManager.checkTimeoutSession();
        if (!this.coreMetaData.isAppLaunchPushed()) {
            this.analyticsManager.pushAppLaunchedEvent();
            this.analyticsManager.fetchFeatureFlags();
            this.pushProviders.onTokenRefresh();
            Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
            task.execute("HandlingInstallReferrer", new Callable<Void>(){

                @Override
                public Void call() {
                    if (!ActivityLifeCycleManager.this.coreMetaData.isInstallReferrerDataSent() && ActivityLifeCycleManager.this.coreMetaData.isFirstSession()) {
                        ActivityLifeCycleManager.this.handleInstallReferrerOnFirstInstall();
                    }
                    return null;
                }
            });
            try {
                if (this.callbackManager.getGeofenceCallback() != null) {
                    this.callbackManager.getGeofenceCallback().triggerLocation();
                }
            }
            catch (IllegalStateException e) {
                this.config.getLogger().verbose(this.config.getAccountId(), e.getLocalizedMessage());
            }
            catch (Exception e) {
                this.config.getLogger().verbose(this.config.getAccountId(), "Failed to trigger location");
            }
        }
        this.baseEventQueueManager.pushInitialEventsAsync();
        this.inAppController.checkExistingInAppNotifications(activity);
        this.inAppController.checkPendingInAppNotifications(activity);
    }

    public void onActivityCreated(Bundle notification, Uri deepLink, String accountId) {
        try {
            boolean shouldProcess;
            boolean bl = shouldProcess = accountId == null && this.config.isDefaultInstance() || this.config.getAccountId().equals(accountId);
            if (shouldProcess) {
                if (notification != null && !notification.isEmpty() && notification.containsKey("wzrk_pn")) {
                    this.analyticsManager.pushNotificationClickedEvent(notification);
                }
                if (deepLink != null) {
                    try {
                        this.analyticsManager.pushDeepLink(deepLink, false);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        catch (Throwable t) {
            Logger.v("Throwable - " + t.getLocalizedMessage());
        }
    }

    private void handleInstallReferrerOnFirstInstall() {
        this.config.getLogger().verbose(this.config.getAccountId(), "Starting to handle install referrer");
        try {
            final InstallReferrerClient referrerClient = InstallReferrerClient.newBuilder((Context)this.context).build();
            referrerClient.startConnection(new InstallReferrerStateListener(){

                public void onInstallReferrerServiceDisconnected() {
                    if (!ActivityLifeCycleManager.this.coreMetaData.isInstallReferrerDataSent()) {
                        ActivityLifeCycleManager.this.handleInstallReferrerOnFirstInstall();
                    }
                }

                public void onInstallReferrerSetupFinished(int responseCode) {
                    switch (responseCode) {
                        case 0: {
                            Task<ReferrerDetails> task = CTExecutorFactory.executors(ActivityLifeCycleManager.this.config).postAsyncSafelyTask();
                            task.addOnSuccessListener(response -> {
                                try {
                                    String referrerUrl = response.getInstallReferrer();
                                    ActivityLifeCycleManager.this.coreMetaData.setReferrerClickTime(response.getReferrerClickTimestampSeconds());
                                    ActivityLifeCycleManager.this.coreMetaData.setAppInstallTime(response.getInstallBeginTimestampSeconds());
                                    ActivityLifeCycleManager.this.analyticsManager.pushInstallReferrer(referrerUrl);
                                    ActivityLifeCycleManager.this.coreMetaData.setInstallReferrerDataSent(true);
                                    ActivityLifeCycleManager.this.config.getLogger().debug(ActivityLifeCycleManager.this.config.getAccountId(), "Install Referrer data set [Referrer URL-" + referrerUrl + "]");
                                }
                                catch (NullPointerException npe) {
                                    ActivityLifeCycleManager.this.config.getLogger().debug(ActivityLifeCycleManager.this.config.getAccountId(), "Install referrer client null pointer exception caused by Google Play Install Referrer library - " + npe.getMessage());
                                    referrerClient.endConnection();
                                    ActivityLifeCycleManager.this.coreMetaData.setInstallReferrerDataSent(false);
                                }
                            });
                            task.execute("ActivityLifeCycleManager#getInstallReferrer", () -> {
                                ReferrerDetails response = null;
                                try {
                                    response = referrerClient.getInstallReferrer();
                                }
                                catch (RemoteException e) {
                                    ActivityLifeCycleManager.this.config.getLogger().debug(ActivityLifeCycleManager.this.config.getAccountId(), "Remote exception caused by Google Play Install Referrer library - " + e.getMessage());
                                    referrerClient.endConnection();
                                    ActivityLifeCycleManager.this.coreMetaData.setInstallReferrerDataSent(false);
                                }
                                return response;
                            });
                            break;
                        }
                        case 2: {
                            ActivityLifeCycleManager.this.config.getLogger().debug(ActivityLifeCycleManager.this.config.getAccountId(), "Install Referrer data not set, API not supported by Play Store on device");
                            break;
                        }
                        case 1: {
                            ActivityLifeCycleManager.this.config.getLogger().debug(ActivityLifeCycleManager.this.config.getAccountId(), "Install Referrer data not set, connection to Play Store unavailable");
                        }
                    }
                }
            });
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Google Play Install Referrer's InstallReferrerClient Class not found - " + t.getLocalizedMessage() + " \n Please add implementation 'com.android.installreferrer:installreferrer:2.1' to your build.gradle");
        }
    }
}

