/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inbox;

import androidx.annotation.AnyThread;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.BaseCallbackManager;
import com.clevertap.android.sdk.CTLockManager;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.db.DBAdapter;
import com.clevertap.android.sdk.inbox.CTInboxMessage;
import com.clevertap.android.sdk.inbox.CTMessageDAO;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.Task;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.json.JSONArray;
import org.json.JSONException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class CTInboxController {
    private final DBAdapter dbAdapter;
    private ArrayList<CTMessageDAO> messages;
    private final Object messagesLock = new Object();
    private final String userId;
    private final boolean videoSupported;
    private final CTLockManager ctLockManager;
    private final BaseCallbackManager callbackManager;
    private final CleverTapInstanceConfig config;

    @WorkerThread
    public CTInboxController(CleverTapInstanceConfig config, String guid, DBAdapter adapter, CTLockManager ctLockManager, BaseCallbackManager callbackManager, boolean videoSupported) {
        this.userId = guid;
        this.dbAdapter = adapter;
        this.messages = this.dbAdapter.getMessages(this.userId);
        this.videoSupported = videoSupported;
        this.ctLockManager = ctLockManager;
        this.callbackManager = callbackManager;
        this.config = config;
    }

    public int count() {
        return this.getMessages().size();
    }

    @AnyThread
    public void deleteInboxMessage(final CTInboxMessage message) {
        Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
        task.execute("deleteInboxMessage", new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() {
                Object object = CTInboxController.this.ctLockManager.getInboxControllerLock();
                synchronized (object) {
                    boolean update = CTInboxController.this._deleteMessageWithId(message.getMessageId());
                    if (update) {
                        CTInboxController.this.callbackManager._notifyInboxMessagesDidUpdate();
                    }
                }
                return null;
            }
        });
    }

    @AnyThread
    public CTMessageDAO getMessageForId(String messageId) {
        return this.findMessageById(messageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public ArrayList<CTMessageDAO> getMessages() {
        Object object = this.messagesLock;
        synchronized (object) {
            this.trimMessages();
            return this.messages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public ArrayList<CTMessageDAO> getUnreadMessages() {
        ArrayList<CTMessageDAO> unread = new ArrayList<CTMessageDAO>();
        Object object = this.messagesLock;
        synchronized (object) {
            ArrayList<CTMessageDAO> messages = this.getMessages();
            for (CTMessageDAO message : messages) {
                if (message.isRead() != 0) continue;
                unread.add(message);
            }
        }
        return unread;
    }

    @AnyThread
    public void markReadInboxMessage(final CTInboxMessage message) {
        Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
        task.execute("markReadInboxMessage", new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() {
                Object object = CTInboxController.this.ctLockManager.getInboxControllerLock();
                synchronized (object) {
                    boolean read = CTInboxController.this._markReadForMessageWithId(message.getMessageId());
                    if (read) {
                        CTInboxController.this.callbackManager._notifyInboxMessagesDidUpdate();
                    }
                }
                return null;
            }
        });
    }

    @AnyThread
    public int unreadCount() {
        return this.getUnreadMessages().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public boolean updateMessages(JSONArray inboxMessages) {
        Logger.v("CTInboxController:updateMessages() called");
        boolean haveUpdates = false;
        ArrayList<CTMessageDAO> newMessages = new ArrayList<CTMessageDAO>();
        for (int i = 0; i < inboxMessages.length(); ++i) {
            try {
                CTMessageDAO messageDAO = CTMessageDAO.initWithJSON(inboxMessages.getJSONObject(i), this.userId);
                if (messageDAO == null) continue;
                if (!this.videoSupported && messageDAO.containsVideoOrAudio()) {
                    Logger.d("Dropping inbox message containing video/audio as app does not support video. For more information checkout CleverTap documentation.");
                    continue;
                }
                newMessages.add(messageDAO);
                Logger.v("Inbox Message for message id - " + messageDAO.getId() + " added");
                continue;
            }
            catch (JSONException e) {
                Logger.d("Unable to update notification inbox messages - " + e.getLocalizedMessage());
            }
        }
        if (newMessages.size() > 0) {
            this.dbAdapter.upsertMessages(newMessages);
            haveUpdates = true;
            Logger.v("New Notification Inbox messages added");
            Object object = this.messagesLock;
            synchronized (object) {
                this.messages = this.dbAdapter.getMessages(this.userId);
                this.trimMessages();
            }
        }
        return haveUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    boolean _deleteMessageWithId(final String messageId) {
        CTMessageDAO messageDAO = this.findMessageById(messageId);
        if (messageDAO == null) {
            return false;
        }
        Object object = this.messagesLock;
        synchronized (object) {
            this.messages.remove(messageDAO);
        }
        Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
        task.execute("RunDeleteMessage", new Callable<Void>(){

            @Override
            @WorkerThread
            public Void call() {
                CTInboxController.this.dbAdapter.deleteMessageForId(messageId, CTInboxController.this.userId);
                return null;
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    boolean _markReadForMessageWithId(final String messageId) {
        CTMessageDAO messageDAO = this.findMessageById(messageId);
        if (messageDAO == null) {
            return false;
        }
        Object object = this.messagesLock;
        synchronized (object) {
            messageDAO.setRead(1);
        }
        Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
        task.addOnSuccessListener(unused -> this.callbackManager._notifyInboxMessagesDidUpdate());
        task.addOnFailureListener(e -> Logger.d("Failed to update message read state for id:" + messageId, e));
        task.execute("RunMarkMessageRead", new Callable<Void>(){

            @Override
            @WorkerThread
            public Void call() {
                CTInboxController.this.dbAdapter.markReadMessageForId(messageId, CTInboxController.this.userId);
                return null;
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    private CTMessageDAO findMessageById(String id2) {
        Object object = this.messagesLock;
        synchronized (object) {
            for (CTMessageDAO message : this.messages) {
                if (!message.getId().equals(id2)) continue;
                return message;
            }
        }
        Logger.v("Inbox Message for message id - " + id2 + " not found");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    private void trimMessages() {
        Logger.v("CTInboxController:trimMessages() called");
        ArrayList<CTMessageDAO> toDelete = new ArrayList<CTMessageDAO>();
        Object object = this.messagesLock;
        synchronized (object) {
            for (CTMessageDAO message : this.messages) {
                if (!this.videoSupported && message.containsVideoOrAudio()) {
                    Logger.d("Removing inbox message containing video/audio as app does not support video. For more information checkout CleverTap documentation.");
                    toDelete.add(message);
                    continue;
                }
                long expires = message.getExpires();
                boolean expired = expires > 0L && System.currentTimeMillis() / 1000L > expires;
                if (!expired) continue;
                Logger.v("Inbox Message: " + message.getId() + " is expired - removing");
                toDelete.add(message);
            }
            if (toDelete.size() <= 0) {
                return;
            }
            for (CTMessageDAO message : toDelete) {
                this._deleteMessageWithId(message.getId());
            }
        }
    }
}

