/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inbox;

import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.clevertap.android.sdk.CTInboxStyleConfig;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.R;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.customviews.MediaPlayerRecyclerView;
import com.clevertap.android.sdk.customviews.VerticalSpaceItemDecoration;
import com.clevertap.android.sdk.inbox.CTInboxActivity;
import com.clevertap.android.sdk.inbox.CTInboxMessage;
import com.clevertap.android.sdk.inbox.CTInboxMessageAdapter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class CTInboxListViewFragment
extends Fragment {
    CleverTapInstanceConfig config;
    boolean haveVideoPlayerSupport = Utils.haveVideoPlayerSupport;
    ArrayList<CTInboxMessage> inboxMessages = new ArrayList();
    LinearLayout linearLayout;
    MediaPlayerRecyclerView mediaRecyclerView;
    RecyclerView recyclerView;
    private CTInboxMessageAdapter inboxMessageAdapter;
    CTInboxStyleConfig styleConfig;
    private boolean firstTime = true;
    private WeakReference<InboxListener> listenerWeakReference;
    private int tabPosition;

    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.config = (CleverTapInstanceConfig)bundle.getParcelable("config");
            this.styleConfig = (CTInboxStyleConfig)bundle.getParcelable("styleConfig");
            this.tabPosition = bundle.getInt("position", -1);
            this.updateInboxMessages();
            if (context instanceof CTInboxActivity) {
                this.setListener((InboxListener)this.getActivity());
            }
        }
    }

    private void updateInboxMessages() {
        Bundle bundle = this.getArguments();
        if (bundle == null) {
            return;
        }
        String filter = bundle.getString("filter", null);
        CleverTapAPI cleverTapAPI = CleverTapAPI.instanceWithConfig((Context)this.getActivity(), this.config);
        if (cleverTapAPI != null) {
            Logger.v("CTInboxListViewFragment:onAttach() called with: tabPosition = [" + this.tabPosition + "], filter = [" + filter + "]");
            ArrayList<CTInboxMessage> allMessages = cleverTapAPI.getAllInboxMessages();
            this.inboxMessages = filter != null ? this.filterMessages(allMessages, filter) : allMessages;
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View allView = inflater.inflate(R.layout.inbox_list_view, container, false);
        this.linearLayout = (LinearLayout)allView.findViewById(R.id.list_view_linear_layout);
        this.linearLayout.setBackgroundColor(Color.parseColor((String)this.styleConfig.getInboxBackgroundColor()));
        TextView noMessageView = (TextView)allView.findViewById(R.id.list_view_no_message_view);
        if (this.inboxMessages.size() <= 0) {
            noMessageView.setVisibility(0);
            noMessageView.setText((CharSequence)this.styleConfig.getNoMessageViewText());
            noMessageView.setTextColor(Color.parseColor((String)this.styleConfig.getNoMessageViewTextColor()));
            return allView;
        }
        noMessageView.setVisibility(8);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager((Context)this.getActivity());
        this.inboxMessageAdapter = new CTInboxMessageAdapter(this.inboxMessages, this);
        if (this.haveVideoPlayerSupport) {
            this.mediaRecyclerView = new MediaPlayerRecyclerView((Context)this.getActivity());
            this.setMediaRecyclerView(this.mediaRecyclerView);
            this.mediaRecyclerView.setVisibility(0);
            this.mediaRecyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
            this.mediaRecyclerView.addItemDecoration(new VerticalSpaceItemDecoration(18));
            this.mediaRecyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
            this.mediaRecyclerView.setAdapter(this.inboxMessageAdapter);
            this.inboxMessageAdapter.notifyDataSetChanged();
            this.linearLayout.addView((View)this.mediaRecyclerView);
            if (this.firstTime && this.shouldAutoPlayOnFirstLaunch()) {
                new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        CTInboxListViewFragment.this.mediaRecyclerView.playVideo();
                    }
                }, 1000L);
                this.firstTime = false;
            }
        } else {
            this.recyclerView = (RecyclerView)allView.findViewById(R.id.list_view_recycler_view);
            this.recyclerView.setVisibility(0);
            this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
            this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new VerticalSpaceItemDecoration(18));
            this.recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
            this.recyclerView.setAdapter((RecyclerView.Adapter)this.inboxMessageAdapter);
            this.inboxMessageAdapter.notifyDataSetChanged();
        }
        return allView;
    }

    public void onViewStateRestored(@Nullable Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
        if (savedInstanceState != null) {
            Parcelable savedRecyclerLayoutState = savedInstanceState.getParcelable("recyclerLayoutState");
            if (this.mediaRecyclerView != null && this.mediaRecyclerView.getLayoutManager() != null) {
                this.mediaRecyclerView.getLayoutManager().onRestoreInstanceState(savedRecyclerLayoutState);
            }
            if (this.recyclerView != null && this.recyclerView.getLayoutManager() != null) {
                this.recyclerView.getLayoutManager().onRestoreInstanceState(savedRecyclerLayoutState);
            }
        }
    }

    public void onResume() {
        super.onResume();
        if (this.mediaRecyclerView != null) {
            this.mediaRecyclerView.onRestartPlayer();
        }
    }

    public void onPause() {
        super.onPause();
        if (this.mediaRecyclerView != null) {
            this.mediaRecyclerView.onPausePlayer();
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.mediaRecyclerView != null && this.mediaRecyclerView.getLayoutManager() != null) {
            outState.putParcelable("recyclerLayoutState", this.mediaRecyclerView.getLayoutManager().onSaveInstanceState());
        }
        if (this.recyclerView != null && this.recyclerView.getLayoutManager() != null) {
            outState.putParcelable("recyclerLayoutState", this.recyclerView.getLayoutManager().onSaveInstanceState());
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mediaRecyclerView != null) {
            this.mediaRecyclerView.release();
        }
    }

    void didClick(Bundle data, int position, int viewPagerPosition, HashMap<String, String> keyValuePayload, int buttonIndex) {
        InboxListener listener = this.getListener();
        if (listener != null) {
            listener.messageDidClick(this.getActivity().getBaseContext(), viewPagerPosition, this.inboxMessages.get(position), data, keyValuePayload, buttonIndex);
        }
    }

    void didShow(Bundle data, int position) {
        InboxListener listener = this.getListener();
        if (listener != null) {
            Logger.v("CTInboxListViewFragment:didShow() called with: data = [" + data + "], position = [" + position + "]");
            listener.messageDidShow(this.getActivity().getBaseContext(), this.inboxMessages.get(position), data);
        }
    }

    void fireUrlThroughIntent(String url) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url.replace("\n", "").replace("\r", "")));
            if (this.getActivity() != null) {
                Utils.setPackageNameFromResolveInfoList((Context)this.getActivity(), intent);
            }
            this.startActivity(intent);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    InboxListener getListener() {
        InboxListener listener = null;
        try {
            listener = (InboxListener)this.listenerWeakReference.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (listener == null) {
            Logger.v("InboxListener is null for messages");
        }
        return listener;
    }

    void setListener(InboxListener listener) {
        this.listenerWeakReference = new WeakReference<InboxListener>(listener);
    }

    MediaPlayerRecyclerView getMediaRecyclerView() {
        return this.mediaRecyclerView;
    }

    void setMediaRecyclerView(MediaPlayerRecyclerView mediaRecyclerView) {
        this.mediaRecyclerView = mediaRecyclerView;
    }

    void handleClick(int position, int viewPagerPosition, String buttonText, JSONObject jsonObject, HashMap<String, String> keyValuePayload, int buttonIndex) {
        boolean isInboxMessageButtonClick = jsonObject != null;
        try {
            if (isInboxMessageButtonClick) {
                String actionUrl;
                String linkType = this.inboxMessages.get(position).getInboxMessageContents().get(0).getLinktype(jsonObject);
                if (linkType.equalsIgnoreCase("url") && (actionUrl = this.inboxMessages.get(position).getInboxMessageContents().get(0).getLinkUrl(jsonObject)) != null) {
                    this.fireUrlThroughIntent(actionUrl);
                }
            } else {
                String actionUrl = this.inboxMessages.get(position).getInboxMessageContents().get(0).getActionUrl();
                if (actionUrl != null) {
                    this.fireUrlThroughIntent(actionUrl);
                }
            }
            Bundle data = new Bundle();
            JSONObject wzrkParams = this.inboxMessages.get(position).getWzrkParams();
            Iterator iterator = wzrkParams.keys();
            while (iterator.hasNext()) {
                String keyName = (String)iterator.next();
                if (!keyName.startsWith("wzrk_")) continue;
                data.putString(keyName, wzrkParams.getString(keyName));
            }
            if (buttonText != null && !buttonText.isEmpty()) {
                data.putString("wzrk_c2a", buttonText);
            }
            this.didClick(data, position, viewPagerPosition, keyValuePayload, buttonIndex);
        }
        catch (Throwable t) {
            Logger.d("Error handling notification button click: " + t.getCause());
        }
    }

    void handleViewPagerClick(int position, int viewPagerPosition) {
        try {
            Bundle data = new Bundle();
            JSONObject wzrkParams = this.inboxMessages.get(position).getWzrkParams();
            Iterator iterator = wzrkParams.keys();
            while (iterator.hasNext()) {
                String keyName = (String)iterator.next();
                if (!keyName.startsWith("wzrk_")) continue;
                data.putString(keyName, wzrkParams.getString(keyName));
            }
            this.didClick(data, position, viewPagerPosition, null, -1);
            String actionUrl = this.inboxMessages.get(position).getInboxMessageContents().get(viewPagerPosition).getActionUrl();
            this.fireUrlThroughIntent(actionUrl);
        }
        catch (Throwable t) {
            Logger.d("Error handling notification button click: " + t.getCause());
        }
    }

    private ArrayList<CTInboxMessage> filterMessages(ArrayList<CTInboxMessage> messages, String filter) {
        ArrayList<CTInboxMessage> filteredMessages = new ArrayList<CTInboxMessage>();
        for (CTInboxMessage inboxMessage : messages) {
            if (inboxMessage.getTags() == null || inboxMessage.getTags().size() <= 0) continue;
            for (String stringTag : inboxMessage.getTags()) {
                if (!stringTag.equalsIgnoreCase(filter)) continue;
                filteredMessages.add(inboxMessage);
            }
        }
        return filteredMessages;
    }

    private boolean shouldAutoPlayOnFirstLaunch() {
        return this.tabPosition <= 0;
    }

    static interface InboxListener {
        public void messageDidClick(Context var1, int var2, CTInboxMessage var3, Bundle var4, HashMap<String, String> var5, int var6);

        public void messageDidShow(Context var1, CTInboxMessage var2, Bundle var3);
    }
}

