/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inbox;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.view.View;
import android.widget.Toast;
import androidx.viewpager.widget.ViewPager;
import com.clevertap.android.sdk.inbox.CTInboxListViewFragment;
import com.clevertap.android.sdk.inbox.CTInboxMessage;
import java.util.HashMap;
import org.json.JSONObject;

class CTInboxButtonClickListener
implements View.OnClickListener {
    private JSONObject buttonObject;
    private final String buttonText;
    private final CTInboxListViewFragment fragment;
    private final CTInboxMessage inboxMessage;
    private final int position;
    private ViewPager viewPager;
    private final boolean isBodyClick;
    private final int buttonIndex;

    CTInboxButtonClickListener(int position, CTInboxMessage inboxMessage, String buttonText, JSONObject jsonObject, CTInboxListViewFragment fragment, boolean isInboxMessageBodyClick, int buttonIndex) {
        this.position = position;
        this.inboxMessage = inboxMessage;
        this.buttonText = buttonText;
        this.fragment = fragment;
        this.buttonObject = jsonObject;
        this.isBodyClick = isInboxMessageBodyClick;
        this.buttonIndex = buttonIndex;
    }

    CTInboxButtonClickListener(int position, CTInboxMessage inboxMessage, String buttonText, CTInboxListViewFragment fragment, ViewPager viewPager, boolean isInboxMessageBodyClick, int buttonIndex) {
        this.position = position;
        this.inboxMessage = inboxMessage;
        this.buttonText = buttonText;
        this.fragment = fragment;
        this.viewPager = viewPager;
        this.isBodyClick = isInboxMessageBodyClick;
        this.buttonIndex = buttonIndex;
    }

    public void onClick(View v) {
        if (this.viewPager != null) {
            if (this.fragment != null) {
                this.fragment.handleViewPagerClick(this.position, this.viewPager.getCurrentItem(), this.isBodyClick);
            }
        } else if (this.buttonText != null && this.buttonObject != null) {
            if (this.fragment != null) {
                if (this.inboxMessage.getInboxMessageContents().get(0).getLinktype(this.buttonObject).equalsIgnoreCase("copy") && this.fragment.getActivity() != null) {
                    this.copyToClipboard((Context)this.fragment.getActivity());
                }
                this.fragment.handleClick(this.position, this.buttonText, this.buttonObject, this.getKeyValues(this.inboxMessage), this.buttonIndex);
            }
        } else if (this.fragment != null) {
            this.fragment.handleClick(this.position, null, null, null, this.buttonIndex);
        }
    }

    private void copyToClipboard(Context context) {
        ClipboardManager clipboardManager = (ClipboardManager)context.getSystemService("clipboard");
        ClipData clipData = ClipData.newPlainText((CharSequence)this.buttonText, (CharSequence)this.inboxMessage.getInboxMessageContents().get(0).getLinkCopyText(this.buttonObject));
        if (clipboardManager != null) {
            clipboardManager.setPrimaryClip(clipData);
            Toast.makeText((Context)context, (CharSequence)"Text Copied to Clipboard", (int)0).show();
        }
    }

    private HashMap<String, String> getKeyValues(CTInboxMessage inboxMessage) {
        if (inboxMessage != null && inboxMessage.getInboxMessageContents() != null && inboxMessage.getInboxMessageContents().get(0) != null && "kv".equalsIgnoreCase(inboxMessage.getInboxMessageContents().get(0).getLinktype(this.buttonObject))) {
            return inboxMessage.getInboxMessageContents().get(0).getLinkKeyValue(this.buttonObject);
        }
        return null;
    }
}

