/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.LruCache;
import androidx.annotation.RestrictTo;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.inapp.CTInAppNotificationButton;
import com.clevertap.android.sdk.inapp.CTInAppNotificationMedia;
import com.clevertap.android.sdk.inapp.CTInAppType;
import com.clevertap.android.sdk.utils.ImageCache;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class CTInAppNotification
implements Parcelable {
    public static final Parcelable.Creator<CTInAppNotification> CREATOR = new Parcelable.Creator<CTInAppNotification>(){

        public CTInAppNotification createFromParcel(Parcel in) {
            return new CTInAppNotification(in);
        }

        public CTInAppNotification[] newArray(int size) {
            return new CTInAppNotification[size];
        }
    };
    CTInAppNotificationListener listener;
    private String _landscapeImageCacheKey;
    private JSONObject actionExtras;
    private String backgroundColor;
    private int buttonCount;
    private ArrayList<CTInAppNotificationButton> buttons = new ArrayList();
    private String campaignId;
    private JSONObject customExtras;
    private String customInAppUrl;
    private boolean darkenScreen;
    private String error;
    private boolean excludeFromCaps;
    private int height;
    private int heightPercentage;
    private boolean hideCloseButton;
    private String html;
    private String id;
    private CTInAppType inAppType;
    private boolean isLandscape;
    private boolean isPortrait;
    private boolean isTablet;
    private boolean jsEnabled;
    private JSONObject jsonDescription;
    private String landscapeImageUrl;
    private int maxPerSession;
    private ArrayList<CTInAppNotificationMedia> mediaList = new ArrayList();
    private String message;
    private String messageColor;
    private char position;
    private boolean showClose;
    private long timeToLive;
    private String title;
    private String titleColor;
    private int totalDailyCount;
    private int totalLifetimeCount;
    private String type;
    private boolean videoSupported;
    private int width;
    private int widthPercentage;

    CTInAppNotification() {
    }

    private CTInAppNotification(Parcel in) {
        try {
            this.id = in.readString();
            this.campaignId = in.readString();
            this.inAppType = (CTInAppType)((Object)in.readValue(CTInAppType.class.getClassLoader()));
            this.html = in.readString();
            this.excludeFromCaps = in.readByte() != 0;
            this.showClose = in.readByte() != 0;
            this.darkenScreen = in.readByte() != 0;
            this.maxPerSession = in.readInt();
            this.totalLifetimeCount = in.readInt();
            this.totalDailyCount = in.readInt();
            this.position = ((Character)in.readValue(Character.TYPE.getClassLoader())).charValue();
            this.height = in.readInt();
            this.heightPercentage = in.readInt();
            this.width = in.readInt();
            this.widthPercentage = in.readInt();
            this.jsonDescription = in.readByte() == 0 ? null : new JSONObject(in.readString());
            this.error = in.readString();
            this.customExtras = in.readByte() == 0 ? null : new JSONObject(in.readString());
            this.actionExtras = in.readByte() == 0 ? null : new JSONObject(in.readString());
            this.type = in.readString();
            this.title = in.readString();
            this.titleColor = in.readString();
            this.backgroundColor = in.readString();
            this.message = in.readString();
            this.messageColor = in.readString();
            try {
                this.buttons = in.createTypedArrayList(CTInAppNotificationButton.CREATOR);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.mediaList = in.createTypedArrayList(CTInAppNotificationMedia.CREATOR);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.hideCloseButton = in.readByte() != 0;
            this.buttonCount = in.readInt();
            this.isTablet = in.readByte() != 0;
            this.customInAppUrl = in.readString();
            this.jsEnabled = in.readByte() != 0;
            this.isPortrait = in.readByte() != 0;
            this.isLandscape = in.readByte() != 0;
            this.landscapeImageUrl = in.readString();
            this._landscapeImageCacheKey = in.readString();
            this.timeToLive = in.readLong();
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public int describeContents() {
        return 0;
    }

    public JSONObject getActionExtras() {
        return this.actionExtras;
    }

    public String getId() {
        return this.id;
    }

    public CTInAppType getInAppType() {
        return this.inAppType;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public boolean isExcludeFromCaps() {
        return this.excludeFromCaps;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeString(this.campaignId);
        dest.writeValue((Object)this.inAppType);
        dest.writeString(this.html);
        dest.writeByte((byte)(this.excludeFromCaps ? 1 : 0));
        dest.writeByte((byte)(this.showClose ? 1 : 0));
        dest.writeByte((byte)(this.darkenScreen ? 1 : 0));
        dest.writeInt(this.maxPerSession);
        dest.writeInt(this.totalLifetimeCount);
        dest.writeInt(this.totalDailyCount);
        dest.writeValue((Object)Character.valueOf(this.position));
        dest.writeInt(this.height);
        dest.writeInt(this.heightPercentage);
        dest.writeInt(this.width);
        dest.writeInt(this.widthPercentage);
        if (this.jsonDescription == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeString(this.jsonDescription.toString());
        }
        dest.writeString(this.error);
        if (this.customExtras == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeString(this.customExtras.toString());
        }
        if (this.actionExtras == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeString(this.actionExtras.toString());
        }
        dest.writeString(this.type);
        dest.writeString(this.title);
        dest.writeString(this.titleColor);
        dest.writeString(this.backgroundColor);
        dest.writeString(this.message);
        dest.writeString(this.messageColor);
        dest.writeTypedList(this.buttons);
        dest.writeTypedList(this.mediaList);
        dest.writeByte((byte)(this.hideCloseButton ? 1 : 0));
        dest.writeInt(this.buttonCount);
        dest.writeByte((byte)(this.isTablet ? 1 : 0));
        dest.writeString(this.customInAppUrl);
        dest.writeByte((byte)(this.jsEnabled ? 1 : 0));
        dest.writeByte((byte)(this.isPortrait ? 1 : 0));
        dest.writeByte((byte)(this.isLandscape ? 1 : 0));
        dest.writeString(this.landscapeImageUrl);
        dest.writeString(this._landscapeImageCacheKey);
        dest.writeLong(this.timeToLive);
    }

    void didDismiss() {
        this.removeImageOrGif();
    }

    String getBackgroundColor() {
        return this.backgroundColor;
    }

    int getButtonCount() {
        return this.buttonCount;
    }

    public ArrayList<CTInAppNotificationButton> getButtons() {
        return this.buttons;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    JSONObject getCustomExtras() {
        return this.customExtras;
    }

    String getCustomInAppUrl() {
        return this.customInAppUrl;
    }

    String getError() {
        return this.error;
    }

    byte[] getGifByteArray(CTInAppNotificationMedia inAppMedia) {
        return GifCache.getByteArray(inAppMedia.getCacheKey());
    }

    int getHeight() {
        return this.height;
    }

    int getHeightPercentage() {
        return this.heightPercentage;
    }

    String getHtml() {
        return this.html;
    }

    Bitmap getImage(CTInAppNotificationMedia inAppMedia) {
        return ImageCache.getBitmap(inAppMedia.getCacheKey());
    }

    CTInAppNotificationMedia getInAppMediaForOrientation(int orientation) {
        CTInAppNotificationMedia returningMedia = null;
        for (CTInAppNotificationMedia inAppNotificationMedia : this.mediaList) {
            if (orientation != inAppNotificationMedia.getOrientation()) continue;
            returningMedia = inAppNotificationMedia;
            break;
        }
        return returningMedia;
    }

    public JSONObject getJsonDescription() {
        return this.jsonDescription;
    }

    public int getMaxPerSession() {
        return this.maxPerSession;
    }

    ArrayList<CTInAppNotificationMedia> getMediaList() {
        return this.mediaList;
    }

    public String getMessage() {
        return this.message;
    }

    String getMessageColor() {
        return this.messageColor;
    }

    char getPosition() {
        return this.position;
    }

    public String getTitle() {
        return this.title;
    }

    String getTitleColor() {
        return this.titleColor;
    }

    public int getTotalDailyCount() {
        return this.totalDailyCount;
    }

    public int getTotalLifetimeCount() {
        return this.totalLifetimeCount;
    }

    String getType() {
        return this.type;
    }

    int getWidth() {
        return this.width;
    }

    int getWidthPercentage() {
        return this.widthPercentage;
    }

    CTInAppNotification initWithJSON(JSONObject jsonObject, boolean videoSupported) {
        this.videoSupported = videoSupported;
        this.jsonDescription = jsonObject;
        try {
            String string = this.type = jsonObject.has("type") ? jsonObject.getString("type") : null;
            if (this.type == null || this.type.equals("custom-html")) {
                this.legacyConfigureWithJson(jsonObject);
            } else {
                this.configureWithJson(jsonObject);
            }
        }
        catch (JSONException e) {
            this.error = "Invalid JSON : " + e.getLocalizedMessage();
        }
        return this;
    }

    boolean isDarkenScreen() {
        return this.darkenScreen;
    }

    boolean isHideCloseButton() {
        return this.hideCloseButton;
    }

    boolean isJsEnabled() {
        return this.jsEnabled;
    }

    public boolean isLandscape() {
        return this.isLandscape;
    }

    public boolean isPortrait() {
        return this.isPortrait;
    }

    boolean isShowClose() {
        return this.showClose;
    }

    boolean isTablet() {
        return this.isTablet;
    }

    void prepareForDisplay() {
        for (CTInAppNotificationMedia media : this.mediaList) {
            if (media.isGIF()) {
                GifCache.init();
                if (this.getGifByteArray(media) != null) {
                    this.listener.notificationReady(this);
                    return;
                }
                if (media.getMediaUrl() == null) continue;
                Logger.v("CTInAppNotification: downloading GIF :" + media.getMediaUrl());
                byte[] gifByteArray = Utils.getByteArrayFromImageURL(media.getMediaUrl());
                if (gifByteArray == null) continue;
                Logger.v("GIF Downloaded from url: " + media.getMediaUrl());
                if (GifCache.addByteArray(media.getCacheKey(), gifByteArray)) continue;
                this.error = "Error processing GIF";
                continue;
            }
            if (media.isImage()) {
                ImageCache.init();
                if (this.getImage(media) != null) {
                    this.listener.notificationReady(this);
                    return;
                }
                if (media.getMediaUrl() == null) continue;
                Logger.v("CTInAppNotification: downloading Image :" + media.getMediaUrl());
                Bitmap imageBitmap = Utils.getBitmapFromURL(media.getMediaUrl());
                if (imageBitmap != null) {
                    Logger.v("Image Downloaded from url: " + media.getMediaUrl());
                    if (ImageCache.addBitmap(media.getCacheKey(), imageBitmap)) continue;
                    this.error = "Error processing image";
                    continue;
                }
                Logger.d("Image Bitmap is null");
                this.error = "Error processing image as bitmap was NULL";
                continue;
            }
            if (!media.isVideo() && !media.isAudio() || this.videoSupported) continue;
            this.error = "InApp Video/Audio is not supported";
        }
        this.listener.notificationReady(this);
    }

    private void configureWithJson(JSONObject jsonObject) {
        try {
            JSONArray buttonArray;
            CTInAppNotificationMedia landscapeMedia;
            JSONObject media_landscape;
            CTInAppNotificationMedia portraitMedia;
            JSONObject media;
            JSONObject msgObject;
            JSONObject titleObject;
            this.id = jsonObject.has("ti") ? jsonObject.getString("ti") : "";
            this.campaignId = jsonObject.has("wzrk_id") ? jsonObject.getString("wzrk_id") : "";
            this.type = jsonObject.getString("type");
            this.excludeFromCaps = jsonObject.has("efc") && jsonObject.getInt("efc") == 1;
            this.totalLifetimeCount = jsonObject.has("tlc") ? jsonObject.getInt("tlc") : -1;
            this.totalDailyCount = jsonObject.has("tdc") ? jsonObject.getInt("tdc") : -1;
            this.inAppType = CTInAppType.fromString(this.type);
            this.isTablet = jsonObject.has("tablet") && jsonObject.getBoolean("tablet");
            this.backgroundColor = jsonObject.has("bg") ? jsonObject.getString("bg") : "#FFFFFF";
            this.isPortrait = !jsonObject.has("hasPortrait") || jsonObject.getBoolean("hasPortrait");
            this.isLandscape = jsonObject.has("hasLandscape") && jsonObject.getBoolean("hasLandscape");
            this.timeToLive = jsonObject.has("wzrk_ttl") ? jsonObject.getLong("wzrk_ttl") : System.currentTimeMillis() + 172800000L;
            JSONObject jSONObject = titleObject = jsonObject.has("title") ? jsonObject.getJSONObject("title") : null;
            if (titleObject != null) {
                this.title = titleObject.has("text") ? titleObject.getString("text") : "";
                this.titleColor = titleObject.has("color") ? titleObject.getString("color") : "#000000";
            }
            JSONObject jSONObject2 = msgObject = jsonObject.has("message") ? jsonObject.getJSONObject("message") : null;
            if (msgObject != null) {
                this.message = msgObject.has("text") ? msgObject.getString("text") : "";
                this.messageColor = msgObject.has("color") ? msgObject.getString("color") : "#000000";
            }
            this.hideCloseButton = jsonObject.has("close") && jsonObject.getBoolean("close");
            JSONObject jSONObject3 = media = jsonObject.has("media") ? jsonObject.getJSONObject("media") : null;
            if (media != null && (portraitMedia = new CTInAppNotificationMedia().initWithJSON(media, 1)) != null) {
                this.mediaList.add(portraitMedia);
            }
            JSONObject jSONObject4 = media_landscape = jsonObject.has("mediaLandscape") ? jsonObject.getJSONObject("mediaLandscape") : null;
            if (media_landscape != null && (landscapeMedia = new CTInAppNotificationMedia().initWithJSON(media_landscape, 2)) != null) {
                this.mediaList.add(landscapeMedia);
            }
            JSONArray jSONArray = buttonArray = jsonObject.has("buttons") ? jsonObject.getJSONArray("buttons") : null;
            if (buttonArray != null) {
                for (int i = 0; i < buttonArray.length(); ++i) {
                    CTInAppNotificationButton inAppNotificationButton = new CTInAppNotificationButton().initWithJSON(buttonArray.getJSONObject(i));
                    if (inAppNotificationButton == null || inAppNotificationButton.getError() != null) continue;
                    this.buttons.add(inAppNotificationButton);
                    ++this.buttonCount;
                }
            }
            switch (this.inAppType) {
                case CTInAppTypeFooter: 
                case CTInAppTypeHeader: 
                case CTInAppTypeCover: 
                case CTInAppTypeHalfInterstitial: {
                    for (CTInAppNotificationMedia inAppMedia : this.mediaList) {
                        if (!inAppMedia.isGIF() && !inAppMedia.isAudio() && !inAppMedia.isVideo()) continue;
                        inAppMedia.setMediaUrl(null);
                        Logger.d("Unable to download to media. Wrong media type for template");
                    }
                    break;
                }
                case CTInAppTypeCoverImageOnly: 
                case CTInAppTypeHalfInterstitialImageOnly: 
                case CTInAppTypeInterstitialImageOnly: {
                    if (!this.mediaList.isEmpty()) {
                        for (CTInAppNotificationMedia inAppMedia : this.mediaList) {
                            if (!inAppMedia.isGIF() && !inAppMedia.isAudio() && !inAppMedia.isVideo() && inAppMedia.isImage()) continue;
                            this.error = "Wrong media type for template";
                        }
                        break;
                    }
                    this.error = "No media type for template";
                }
            }
        }
        catch (JSONException e) {
            this.error = "Invalid JSON" + e.getLocalizedMessage();
        }
    }

    private boolean isKeyValid(Bundle b, String key, Class<?> type) {
        return b.containsKey(key) && b.get(key).getClass().equals(type);
    }

    private void legacyConfigureWithJson(JSONObject jsonObject) {
        Bundle b = CTInAppNotification.getBundleFromJsonObject(jsonObject);
        if (!this.validateNotifBundle(b)) {
            this.error = "Invalid JSON";
            return;
        }
        try {
            JSONObject data;
            this.id = jsonObject.has("ti") ? jsonObject.getString("ti") : "";
            this.campaignId = jsonObject.has("wzrk_id") ? jsonObject.getString("wzrk_id") : "";
            this.excludeFromCaps = jsonObject.has("efc") && jsonObject.getInt("efc") == 1;
            this.totalLifetimeCount = jsonObject.has("tlc") ? jsonObject.getInt("tlc") : -1;
            this.totalDailyCount = jsonObject.has("tdc") ? jsonObject.getInt("tdc") : -1;
            this.jsEnabled = jsonObject.has("isJsEnabled") && jsonObject.getBoolean("isJsEnabled");
            this.timeToLive = jsonObject.has("wzrk_ttl") ? jsonObject.getLong("wzrk_ttl") : (System.currentTimeMillis() + 172800000L) / 1000L;
            JSONObject jSONObject = data = jsonObject.has("d") ? jsonObject.getJSONObject("d") : null;
            if (data != null) {
                JSONObject displayParams;
                this.html = data.getString("html");
                this.customInAppUrl = data.has("url") ? data.getString("url") : "";
                JSONObject jSONObject2 = this.customExtras = data.has("kv") ? data.getJSONObject("kv") : null;
                if (this.customExtras == null) {
                    this.customExtras = new JSONObject();
                }
                if ((displayParams = jsonObject.getJSONObject("w")) != null) {
                    this.darkenScreen = displayParams.getBoolean("dk");
                    this.showClose = displayParams.getBoolean("sc");
                    this.position = displayParams.getString("pos").charAt(0);
                    this.width = displayParams.has("xdp") ? displayParams.getInt("xdp") : 0;
                    this.widthPercentage = displayParams.has("xp") ? displayParams.getInt("xp") : 0;
                    this.height = displayParams.has("ydp") ? displayParams.getInt("ydp") : 0;
                    this.heightPercentage = displayParams.has("yp") ? displayParams.getInt("yp") : 0;
                    int n = this.maxPerSession = displayParams.has("mdc") ? displayParams.getInt("mdc") : -1;
                }
                if (this.html != null) {
                    if (this.position == 't' && this.widthPercentage == 100 && this.heightPercentage <= 30) {
                        this.inAppType = CTInAppType.CTInAppTypeHeaderHTML;
                    } else if (this.position == 'b' && this.widthPercentage == 100 && this.heightPercentage <= 30) {
                        this.inAppType = CTInAppType.CTInAppTypeFooterHTML;
                    } else if (this.position == 'c' && this.widthPercentage == 90 && this.heightPercentage == 85) {
                        this.inAppType = CTInAppType.CTInAppTypeInterstitialHTML;
                    } else if (this.position == 'c' && this.widthPercentage == 100 && this.heightPercentage == 100) {
                        this.inAppType = CTInAppType.CTInAppTypeCoverHTML;
                    } else if (this.position == 'c' && this.widthPercentage == 90 && this.heightPercentage == 50) {
                        this.inAppType = CTInAppType.CTInAppTypeHalfInterstitialHTML;
                    }
                }
            }
        }
        catch (JSONException e) {
            this.error = "Invalid JSON";
        }
    }

    private void removeImageOrGif() {
        for (CTInAppNotificationMedia inAppMedia : this.mediaList) {
            if (inAppMedia.getMediaUrl() == null || inAppMedia.getCacheKey() == null) continue;
            if (!inAppMedia.getContentType().equals("image/gif")) {
                ImageCache.removeBitmap(inAppMedia.getCacheKey(), false);
                Logger.v("Deleted image - " + inAppMedia.getCacheKey());
                continue;
            }
            GifCache.removeByteArray(inAppMedia.getCacheKey());
            Logger.v("Deleted GIF - " + inAppMedia.getCacheKey());
        }
    }

    private boolean validateNotifBundle(Bundle notif) {
        try {
            Bundle w = notif.getBundle("w");
            Bundle d = notif.getBundle("d");
            if (w == null || d == null) {
                return false;
            }
            if (!this.isKeyValid(w, "xdp", Integer.class) && !this.isKeyValid(w, "xp", Integer.class)) {
                return false;
            }
            if (!this.isKeyValid(w, "ydp", Integer.class) && !this.isKeyValid(w, "yp", Integer.class)) {
                return false;
            }
            if (!this.isKeyValid(w, "dk", Boolean.class)) {
                return false;
            }
            if (!this.isKeyValid(w, "sc", Boolean.class)) {
                return false;
            }
            if (!this.isKeyValid(d, "html", String.class)) {
                return false;
            }
            if (this.isKeyValid(w, "pos", String.class)) {
                char pos = w.getString("pos").charAt(0);
                switch (pos) {
                    case 't': {
                        break;
                    }
                    case 'r': {
                        break;
                    }
                    case 'b': {
                        break;
                    }
                    case 'l': {
                        break;
                    }
                    case 'c': {
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            } else {
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            Logger.v("Failed to parse in-app notification!", t);
            return false;
        }
    }

    private static Bundle getBundleFromJsonObject(JSONObject notif) {
        Bundle b = new Bundle();
        Iterator iterator = notif.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            try {
                Object value = notif.get(key);
                if (value instanceof String) {
                    b.putString(key, (String)value);
                    continue;
                }
                if (value instanceof Character) {
                    b.putChar(key, ((Character)value).charValue());
                    continue;
                }
                if (value instanceof Integer) {
                    b.putInt(key, ((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Float) {
                    b.putFloat(key, ((Float)value).floatValue());
                    continue;
                }
                if (value instanceof Double) {
                    b.putDouble(key, ((Double)value).doubleValue());
                    continue;
                }
                if (value instanceof Long) {
                    b.putLong(key, ((Long)value).longValue());
                    continue;
                }
                if (value instanceof Boolean) {
                    b.putBoolean(key, ((Boolean)value).booleanValue());
                    continue;
                }
                if (!(value instanceof JSONObject)) continue;
                b.putBundle(key, CTInAppNotification.getBundleFromJsonObject((JSONObject)value));
            }
            catch (JSONException e) {
                Logger.v("Key had unknown object. Discarding");
            }
        }
        return b;
    }

    static interface CTInAppNotificationListener {
        public void notificationReady(CTInAppNotification var1);
    }

    private static class GifCache {
        private static final int MIN_CACHE_SIZE = 5120;
        private static final int maxMemory = (int)Runtime.getRuntime().maxMemory() / 1024;
        private static final int cacheSize = Math.max(maxMemory / 32, 5120);
        private static LruCache<String, byte[]> mMemoryCache;

        private GifCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static boolean addByteArray(String key, byte[] byteArray) {
            if (mMemoryCache == null) {
                return false;
            }
            if (GifCache.getByteArray(key) != null) return true;
            Class<GifCache> clazz = GifCache.class;
            synchronized (GifCache.class) {
                int arraySize = GifCache.getByteArraySizeInKB(byteArray);
                int available = GifCache.getAvailableMemory();
                Logger.v("CTInAppNotification.GifCache: gif size: " + arraySize + "KB. Available mem: " + available + "KB.");
                if (arraySize > GifCache.getAvailableMemory()) {
                    Logger.v("CTInAppNotification.GifCache: insufficient memory to add gif: " + key);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return false;
                }
                mMemoryCache.put((Object)key, (Object)byteArray);
                Logger.v("CTInAppNotification.GifCache: added gif for key: " + key);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static byte[] getByteArray(String key) {
            Class<GifCache> clazz = GifCache.class;
            synchronized (GifCache.class) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return mMemoryCache == null ? null : (byte[])mMemoryCache.get((Object)key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void init() {
            Class<GifCache> clazz = GifCache.class;
            synchronized (GifCache.class) {
                if (mMemoryCache == null) {
                    Logger.v("CTInAppNotification.GifCache: init with max device memory: " + maxMemory + "KB and allocated cache size: " + cacheSize + "KB");
                    try {
                        mMemoryCache = new LruCache<String, byte[]>(cacheSize){

                            protected int sizeOf(String key, byte[] byteArray) {
                                int size = GifCache.getByteArraySizeInKB(byteArray);
                                Logger.v("CTInAppNotification.GifCache: have gif of size: " + size + "KB for key: " + key);
                                return size;
                            }
                        };
                    }
                    catch (Throwable t) {
                        Logger.v("CTInAppNotification.GifCache: unable to initialize cache: ", t.getCause());
                    }
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void removeByteArray(String key) {
            Class<GifCache> clazz = GifCache.class;
            synchronized (GifCache.class) {
                if (mMemoryCache == null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                mMemoryCache.remove((Object)key);
                Logger.v("CTInAppNotification.GifCache: removed gif for key: " + key);
                GifCache.cleanup();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void cleanup() {
            Class<GifCache> clazz = GifCache.class;
            synchronized (GifCache.class) {
                if (GifCache.isEmpty()) {
                    Logger.v("CTInAppNotification.GifCache: cache is empty, removing it");
                    mMemoryCache = null;
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static int getAvailableMemory() {
            Class<GifCache> clazz = GifCache.class;
            synchronized (GifCache.class) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return mMemoryCache == null ? 0 : cacheSize - mMemoryCache.size();
            }
        }

        private static int getByteArraySizeInKB(byte[] byteArray) {
            return byteArray.length / 1024;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean isEmpty() {
            Class<GifCache> clazz = GifCache.class;
            synchronized (GifCache.class) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return mMemoryCache.size() <= 0;
            }
        }
    }
}

